/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IconUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class QualifiedSelectorCompletionContributor
extends OCCompletionContributorBase {
    public QualifiedSelectorCompletionContributor() {
        class QualifiedSelectorCompletionProvider
        extends OCCompletionProvider {
            @NonNls
            private static final String NSOBJECT = "NSObject";

            QualifiedSelectorCompletionProvider() {
            }

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                int attemptNum;
                OCQualifiedExpression expr = (OCQualifiedExpression)parameters.getPosition().getParent();
                OCObjectTypeContext typeContext = expr.getQualifier().getTypeContext();
                int invocationCount = parameters.getInvocationCount();
                int n = attemptNum = invocationCount < 2 ? 1 : 2;
                while (attemptNum <= 2) {
                    boolean hasResults = false;
                    for (OCPunctuatorElementType qt : expr.qualifyingTokensForCompletion()) {
                        hasResults = this.addCompletions(qt, parameters, result, expr, typeContext, attemptNum > 1) || hasResults;
                    }
                    if (hasResults) break;
                    ++attemptNum;
                }
                result.addLookupAdvertisement(OCBundle.message("completion.press.keyboard.shortcut.to.filter.results.by.type", KeymapUtil.getFirstKeyboardShortcutText((String)"SmartTypeCompletion")));
                if (invocationCount <= 1) {
                    String shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion");
                    String advertisement = typeContext == null ? OCBundle.message("completion.press.shortcut.again.for.non.public.members", shortcut, invocationCount == 0 ? 0 : 1) : OCBundle.message("completion.press.shortcut.again.for.non.imported.members", shortcut, invocationCount == 0 ? 0 : 1);
                    result.addLookupAdvertisement(advertisement);
                }
            }

            private boolean isNotAvailable(@NotNull OCSymbol symbol, @NotNull OCType type) {
                if (!(symbol instanceof OCSymbolWithQualifiedName)) {
                    return true;
                }
                OCSymbolWithQualifiedName qualNameSymbol = (OCSymbolWithQualifiedName)symbol;
                return qualNameSymbol.getVisibility() != OCVisibility.PUBLIC || type.toString().contains("const ") && !qualNameSymbol.isConst();
            }

            protected boolean addCompletions(@NotNull OCPunctuatorElementType qualifyingToken, final @NotNull OCCompletionParameters parameters, CompletionResultSet result, OCQualifiedExpression expr, OCObjectTypeContext typeContext, boolean includeNonImported) {
                CommonProcessors.CollectProcessor<OCSymbol> symbols = new CommonProcessors.CollectProcessor<OCSymbol>(){
                    private final Set<String> names = new HashSet<String>();
                    private final Map<String, OCSymbol> members = new HashMap<String, OCSymbol>();

                    public boolean process(OCSymbol symbol) {
                        OCFile file;
                        PsiElement fragmentContext;
                        if (symbol.getKind().isType() || symbol.isUnnamed()) {
                            return true;
                        }
                        PsiFile original = parameters.getOriginalFile();
                        Project project = original.getProject();
                        if (original instanceof OCCodeFragment && (fragmentContext = original.getContext()) != null) {
                            original = fragmentContext.getContainingFile().getOriginalFile();
                        }
                        if (!(original instanceof OCFile && OCFileSymbols.isSymbolImported((OCFile)original, symbol) || (file = symbol.getContainingOCFile(project)) == null || file.isHeader())) {
                            return true;
                        }
                        if (symbol.getKind().isConstructorOrDestructor()) {
                            return true;
                        }
                        if (symbol instanceof OCFunctionSymbol || symbol.getKind() == OCSymbolKind.STRUCT_FIELD) {
                            String name = symbol.getName();
                            OCSymbolWithQualifiedName symbolParent = ((OCSymbolWithQualifiedName)symbol).getParent();
                            if (symbolParent == null) {
                                return super.process((Object)symbol);
                            }
                            if (this.members.containsKey(name)) {
                                OCSymbol parent = this.members.get(name);
                                if (parent.equals(symbolParent)) {
                                    return super.process((Object)symbol);
                                }
                                return true;
                            }
                            this.members.put(name, symbolParent);
                            return super.process((Object)symbol);
                        }
                        if (this.names.add(symbol.getSignature(project))) {
                            return super.process((Object)symbol);
                        }
                        return true;
                    }
                };
                OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>((Processor<OCSymbol>)symbols, (Condition<? super T>[])new Condition[]{symbol -> symbol.getKind() == OCSymbolKind.PROPERTY, symbol -> symbol instanceof OCMethodSymbol && symbol.isPredeclaration(), symbol -> symbol.getKind().isFunction(), symbol -> !symbol.getKind().isConstructorOrDestructor(), symbol -> symbol instanceof OCSymbolWithQualifiedName && ((OCSymbolWithQualifiedName)symbol).isFromUsing(), OCSymbol.NON_FANTOM_SYMBOL_CONDITION});
                Ref qualifierType = new Ref();
                expr.processTargets(null, orderedProcessor, false, qualifyingToken, false, includeNonImported, (Ref<OCType>)qualifierType, OCResolveContext.forPsi(expr));
                orderedProcessor.finish();
                if (qualifierType.isNull()) {
                    qualifierType.set((Object)expr.getQualifier().getResolvedType());
                }
                boolean hasResults = false;
                ArrayList<LookupElement> hiddenElements = new ArrayList<LookupElement>();
                for (OCSymbol symbol2 : symbols.getResults()) {
                    Icon baseIcon;
                    boolean isFromCurClass = false;
                    boolean isHidden = false;
                    if (symbol2 instanceof OCMemberSymbol) {
                        OCClassSymbol parent = ((OCMemberSymbol)symbol2).getParent();
                        if (parameters.getInvocationCount() <= 1 && NSOBJECT.equals(parent.getName()) && parent.getCategoryName() != null) continue;
                        boolean bl = isFromCurClass = typeContext != null && Objects.equals(parent.getName(), typeContext.getType().getClassName());
                    }
                    if (symbol2.isUnavailable() || symbol2.isForbiddenByARC(expr)) continue;
                    if (parameters.getInvocationCount() <= 1 && !OCVisibility.isVisible(symbol2, expr, (OCType)qualifierType.get(), expr.getProject())) {
                        isHidden = true;
                    }
                    if (symbol2 instanceof OCMethodSymbol && symbol2.isSynthetic() && !((OCMethodSymbol)symbol2).isAccessorWithAliasedName(expr.getProject()) || ContainerUtil.find(hiddenElements, lookup -> lookup.getLookupString().equals(symbol2.getName())) != null) continue;
                    LookupElement lookup2 = SymbolLookupBuilderUtil.lookup(symbol2, null, typeContext != null ? typeContext.getType() : null, expr, isFromCurClass, null, expr.getProject());
                    if (parameters.isCompleteOnlyNotImported() && lookup2 instanceof LookupElementBuilder && (baseIcon = symbol2.getIcon(expr.getProject())) != null && this.isNotAvailable(symbol2, (OCType)qualifierType.get())) {
                        lookup2 = ((LookupElementBuilder)lookup2).withIcon(IconUtil.desaturate((Icon)baseIcon));
                    }
                    if (!result.getPrefixMatcher().prefixMatches(lookup2)) continue;
                    OCQualifiedExpression.COMPLETION_QUALIFYING_TOKEN_KEY.set((UserDataHolder)lookup2, (Object)qualifyingToken);
                    if (isHidden) {
                        hiddenElements.add(lookup2);
                        continue;
                    }
                    result.addElement(lookup2);
                    hasResults = true;
                }
                if (!hasResults && !hiddenElements.isEmpty()) {
                    result.addAllElements(hiddenElements);
                    return true;
                }
                return hasResults;
            }
        }
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement().withParent(OCQualifiedExpression.class), new QualifiedSelectorCompletionProvider());
        class QualifiedSelectorNonImportedCompletionProvider
        extends QualifiedSelectorCompletionProvider {
            QualifiedSelectorNonImportedCompletionProvider() {
            }

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                OCQualifiedExpression expr = (OCQualifiedExpression)parameters.getPosition().getParent();
                OCObjectTypeContext typeContext = expr.getQualifier().getTypeContext();
                OCExpression qualifier = OCParenthesesUtils.diveIntoParentheses(expr.getQualifier());
                if (qualifier == null) {
                    return;
                }
                OCType qualifierType = qualifier.getResolvedType(OCResolveContext.forPsi(expr));
                if (qualifierType instanceof OCPointerType) {
                    qualifierType = ((OCPointerType)qualifierType).getRefType();
                }
                if (qualifierType instanceof OCReferenceType || qualifierType instanceof OCStructType && ((OCStructType)qualifierType).isPredeclaration()) {
                    for (OCPunctuatorElementType qt : expr.qualifyingTokensForCompletion()) {
                        this.addCompletions(qt, parameters, result, expr, typeContext, true);
                    }
                }
            }
        }
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement().withParent(OCQualifiedExpression.class), new QualifiedSelectorNonImportedCompletionProvider(), true);
    }

    @NlsContexts.HintText
    public String handleEmptyLookup(@NotNull CompletionParameters parameters, Editor editor) {
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (parent instanceof OCQualifiedExpression) {
            OCQualifiedExpression expr = (OCQualifiedExpression)parent;
            OCType resolve = expr.getQualifier().getResolvedType(OCResolveContext.forPsi(expr));
            if (resolve.getTerminalType() instanceof OCObjectType) {
                return OCInspectionsBundle.message("no.suggestions.for.properties.of.class", resolve.getTerminalType().getName(expr));
            }
            return OCInspectionsBundle.message("no.suggestions.for.members", resolve.getName(expr));
        }
        return super.handleEmptyLookup(parameters, editor);
    }
}

