/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.OCSmartCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodSelectorCompletionContributor
extends OCCompletionContributorBase {
    @NonNls
    public static final String CIDR_RULE_ZZZ = "CIDR_RULE_ZZZ";
    @NonNls
    public static final String NSOBJECT = "NSObject";
    public static final ElementPattern<PsiElement> PLACE = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withParent(OCArgumentSelector.class), ((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).withParent(PsiErrorElement.class)).withSuperParent(2, OCMessageArgument.class)});
    public static final Key<PsiElement> POSSIBLE_RECEIVER_KEY = new Key("POSSIBLE_SELECTOR");
    public static final PsiElementPattern.Capture<PsiElement> POSSIBLE_PLACE = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().andNot((ElementPattern)PlatformPatterns.psiComment())).afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.IDENTIFIER, OCTokenTypes.RBRACKET, OCTokenTypes.RPAR, OCTokenTypes.RBRACE}))).save(POSSIBLE_RECEIVER_KEY));
    private static final InsertHandler<LookupElement> REMOVE_EXTRA_COLON_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Document document = context.getDocument();
            int offset = context.getEditor().getCaretModel().getOffset();
            if (document.getCharsSequence().charAt(offset) == ':') {
                document.deleteString(offset, offset + 1);
            }
        }
    };
    public static final Key<Context> CONTEXT = new Key("CONTEXT");

    public MethodSelectorCompletionContributor() {
        OCCompletionProvider provider2 = new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                SendMessagePlace place = MethodSelectorCompletionContributor.findSendMessageCompletionPlace(parameters.getPosition());
                if (place == null) {
                    return;
                }
                StringBuilder exactSelectorPrefixBuilder = new StringBuilder();
                OCSendMessageExpression expr = place.expression;
                for (OCMessageArgument arg : expr.getArguments()) {
                    if (arg == place.argument) break;
                    exactSelectorPrefixBuilder.append(arg.getArgumentSelector().getSelectorName());
                }
                String exactSelectorPrefix = exactSelectorPrefixBuilder.toString();
                OCExpression receiver = expr.getReceiverExpression();
                Condition<OCMethodSymbol> condition = MethodSelectorCompletionContributor.getTypeFilter(expr, parameters.getCompletionType());
                MethodSelectorCompletionContributor.addCompletionsForReceiver(receiver, exactSelectorPrefix, parameters, result, condition);
            }
        };
        this.register(CompletionType.BASIC, PLACE, provider2);
        this.register(CompletionType.SMART, PLACE, provider2);
        OCCompletionProvider provider22 = new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                SendMessagePlace place;
                PsiElement element = parameters.getPosition();
                OCExpression expr = MethodSelectorCompletionContributor.getMethodReceiverExpression(element);
                if (expr == null) {
                    return;
                }
                if (PLACE.accepts((Object)element) && (place = MethodSelectorCompletionContributor.findSendMessageCompletionPlace(element)) != null && place.expression == expr.getParent()) {
                    return;
                }
                MethodSelectorCompletionContributor.addMethodCompletionsForExpression(expr, parameters, result);
            }
        };
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)POSSIBLE_PLACE, provider22);
        this.register(CompletionType.SMART, (ElementPattern<? extends PsiElement>)POSSIBLE_PLACE, provider22);
    }

    @Nullable
    private static SendMessagePlace findSendMessageCompletionPlace(PsiElement position) {
        OCMessageArgument arg = (OCMessageArgument)PsiTreeUtil.getParentOfType((PsiElement)position, OCMessageArgument.class);
        return arg != null ? new SendMessagePlace(arg) : null;
    }

    public static void addCompletionsForReceiver(OCExpression receiver, String exactSelectorPrefix, OCCompletionParameters parameters, CompletionResultSet result, Condition<OCMethodSymbol> condition) {
        if (receiver == null) {
            return;
        }
        OCObjectTypeContext receiverContext = receiver.getTypeContext(true, true);
        OCLanguageKind languageKind = receiver.getContainingOCFile().getKind();
        if (receiverContext == null || receiverContext.getOriginalType().isUnknown()) {
            if (receiver instanceof OCReferenceExpression) {
                OCType type;
                OCSymbol symbol;
                OCReferenceElement referenceElement = ((OCReferenceExpression)receiver).getReferenceElement();
                OCSymbol oCSymbol = symbol = referenceElement != null ? referenceElement.resolveToSymbol(OCSymbolGroupContext.typeContext(languageKind)) : null;
                if (symbol != null && (type = symbol.getEffectiveResolvedType(OCResolveContext.forPsi(receiver))) instanceof OCObjectType) {
                    receiverContext = new OCObjectTypeContext(OCObjectTypeContext.StaticMode.STATIC, (OCObjectType)type, symbol.getType());
                }
            }
            if (receiverContext == null) {
                return;
            }
        }
        Context context = new Context(exactSelectorPrefix, receiver, receiverContext, condition);
        MethodSelectorCompletionContributor.addCompletionForReceiverContext(parameters, result, context);
    }

    public static void addCompletionForReceiverContext(@NotNull OCCompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull Context context) {
        if (context.getExactSelectorPrefix().length() > 0 && result.getPrefixMatcher().getPrefix().length() == 0 && !(PsiTreeUtil.prevLeaf((PsiElement)parameters.getPosition(), (boolean)true) instanceof PsiWhiteSpace)) {
            return;
        }
        MethodSelectorCompletionContributor.doAddCompletions(result, parameters, context);
    }

    private static int doAddCompletions(@NotNull CompletionResultSet result, @NotNull OCCompletionParameters parameters, @NotNull Context context) {
        int[] addedCnt = new int[]{0};
        OCObjectTypeContext receiverContext = context.getReceiverContext();
        Condition<OCMethodSymbol> condition = context.getCondition();
        Processor<OCMethodSymbol> processor = MethodSelectorCompletionContributor.getProcessor(parameters, result, addedCnt, context);
        if (receiverContext.getType().getName().equals(NSOBJECT)) {
            if (condition instanceof OCSmartCompletionContributor.TypeMatchingCondition) {
                ((OCSmartCompletionContributor.TypeMatchingCondition)condition).avoidNSObjectMethods(false);
            }
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(parameters.getOriginalFile().getProject(), new OCCommonProcessors.TypeFilteredProcessor(processor, OCMethodSymbol.class), null);
        } else {
            if (condition instanceof OCSmartCompletionContributor.TypeMatchingCondition) {
                ((OCSmartCompletionContributor.TypeMatchingCondition)condition).setReceiverContext(receiverContext);
            }
            receiverContext.getType().processMembers(OCMethodSymbol.class, processor);
        }
        return addedCnt[0];
    }

    public static Processor<OCMethodSymbol> getProcessor(final @NotNull OCCompletionParameters parameters, final @NotNull CompletionResultSet result, final int[] addedCnt, final @NotNull Context context) {
        final OCObjectTypeContext receiverContext = context.getReceiverContext();
        final String exactSelectorPrefix = context.getExactSelectorPrefix();
        final Icon icon = OCIcons.getMethodIcon(receiverContext.getStaticMode() == OCObjectTypeContext.StaticMode.STATIC, false, false);
        final boolean completeFullSelector = exactSelectorPrefix.length() == 0;
        Processor<OCMethodSymbol> processor = new Processor<OCMethodSymbol>(){
            private Set<String> names = new HashSet<String>();

            public boolean process(OCMethodSymbol symbol) {
                String tail;
                OCFile file;
                String name = symbol.getName();
                if (!receiverContext.fitsStaticness(symbol)) {
                    return true;
                }
                if (symbol.isUnavailable() || symbol.isForbiddenByARC((PsiElement)parameters.getOriginalFile())) {
                    return true;
                }
                PsiFile original = parameters.getOriginalFile();
                if (!(original instanceof OCFile && OCFileSymbols.isSymbolImported((OCFile)original, symbol) || (file = symbol.getContainingOCFile(original.getProject())) == null || file.isHeader())) {
                    return true;
                }
                if (!this.names.add(name)) {
                    return true;
                }
                if (completeFullSelector) {
                    LookupElement lookup;
                    boolean isFromCurClass = Objects.equals(symbol.getParent().getName(), receiverContext.getType().getClassName());
                    PsiElement position = parameters.getPosition();
                    LookupElement l = lookup = SymbolLookupBuilderUtil.lookup((OCSymbol)symbol, null, receiverContext.getType(), position, isFromCurClass, null, original.getProject());
                    CONTEXT.set((UserDataHolder)l, (Object)context);
                    while (l instanceof LookupElementDecorator) {
                        l = ((LookupElementDecorator)l).getDelegate();
                        CONTEXT.set((UserDataHolder)l, (Object)context);
                    }
                    if (result.getPrefixMatcher().prefixMatches(lookup)) {
                        result.addElement(lookup);
                        addedCnt[0] = addedCnt[0] + 1;
                    }
                } else if (name.startsWith(exactSelectorPrefix) && !(tail = name.substring(exactSelectorPrefix.length())).isEmpty()) {
                    int colonIndex = tail.indexOf(58);
                    String lookup = colonIndex >= 0 ? tail.substring(0, colonIndex + 1) : tail;
                    result.addElement((LookupElement)LookupElementBuilder.create((String)lookup).withIcon(icon).withInsertHandler(REMOVE_EXTRA_COLON_HANDLER));
                    addedCnt[0] = addedCnt[0] + 1;
                }
                return true;
            }
        };
        return new FilteringProcessor(context.getCondition(), (Processor)processor);
    }

    public static void addMethodCompletionsIfAppropriate(@NotNull OCCompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull PsiElement element) {
        OCExpression expr = MethodSelectorCompletionContributor.getMethodReceiverExpression(element);
        if (expr != null) {
            MethodSelectorCompletionContributor.addMethodCompletionsForExpression(expr, parameters, result);
        }
    }

    private static void addMethodCompletionsForExpression(OCExpression expr, @NotNull OCCompletionParameters parameters, @NotNull CompletionResultSet result) {
        Condition<OCMethodSymbol> condition = MethodSelectorCompletionContributor.getTypeFilter(expr, parameters.getCompletionType());
        MethodSelectorCompletionContributor.addCompletionsForReceiver(expr, "", parameters, result, condition);
    }

    @NotNull
    private static Condition<OCMethodSymbol> getTypeFilter(@NotNull OCExpression expr, @NotNull CompletionType completionType) {
        OCSmartCompletionContributor.TypeMatchingCondition condition = Conditions.alwaysTrue();
        if (completionType == CompletionType.SMART) {
            OCDeclarator declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)expr, OCDeclarator.class);
            OCSymbol ownSymbol = declarator != null ? declarator.getSymbol() : null;
            OCResolveContext context = OCResolveContext.forPsi(expr);
            OCType expectedType = OCExpectedTypeUtil.getExpectedType(expr, context).resolve(context);
            if (expectedType != OCUnknownType.INSTANCE) {
                condition = new OCSmartCompletionContributor.TypeMatchingCondition(expr, expectedType, false, ownSymbol);
            }
        }
        return condition;
    }

    public static OCExpression getMethodReceiverExpression(@NotNull PsiElement element) {
        OCReferenceElement ref;
        ProcessingContext match = new ProcessingContext();
        if (!POSSIBLE_PLACE.accepts((Object)element, match)) {
            return null;
        }
        PsiElement receiver = (PsiElement)match.get(POSSIBLE_RECEIVER_KEY);
        ASTNode receiverLeaf = receiver.getNode();
        OCLanguageKind languageKind = ((OCFile)receiver.getContainingFile()).getKind();
        IElementType type = receiverLeaf.getElementType();
        OCExpression expr = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)receiverLeaf.getPsi(), OCExpression.class);
        if (type == OCTokenTypes.RPAR && expr instanceof OCCastExpression) {
            return null;
        }
        if (expr == null) {
            return null;
        }
        if (expr instanceof OCBlockExpression && PsiTreeUtil.isAncestor((PsiElement)expr, (PsiElement)element, (boolean)true)) {
            return null;
        }
        OCExpression result = null;
        if (expr.getResolvedType().isPointerToObjectCompatible()) {
            result = expr;
        } else if (expr instanceof OCReferenceExpression && (ref = ((OCReferenceExpression)expr).getReferenceElement()) != null && ref.resolveToSymbol(OCSymbolGroupContext.typeContext(languageKind)) != null) {
            result = expr;
        }
        while (result != null && result.getParent() instanceof OCUnaryExpression) {
            result = (OCExpression)result.getParent();
        }
        return result;
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement element;
        int endRegion;
        int offset = context.getStartOffset();
        String docText = context.getEditor().getDocument().getText();
        if (docText.regionMatches(offset, "<#", 0, 2) && (endRegion = docText.indexOf("#>", offset)) > offset) {
            context.setReplacementOffset(endRegion + 2);
        }
        Object dummy = CIDR_RULE_ZZZ;
        PsiElement id = context.getFile().findElementAt(offset - 1);
        if (id != null && id.getNode().getElementType() == OCTokenTypes.IDENTIFIER) {
            dummy = id.getText().substring(offset - id.getTextOffset()) + CIDR_RULE_ZZZ;
        }
        if (MethodSelectorCompletionContributor.isPartOfMacroCall(element = context.getFile().findElementAt(offset)) || MethodSelectorCompletionContributor.isAtRPar(element) || MethodSelectorCompletionContributor.isInsideSendMessage(context)) {
            context.setDummyIdentifier((String)dummy);
        } else if (context.getCompletionType() == CompletionType.SMART) {
            context.setDummyIdentifier((String)dummy + ")");
        } else {
            context.setDummyIdentifier((String)dummy + ";");
        }
    }

    private static boolean isPartOfMacroCall(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, OCMacroCall.class) != null;
    }

    private static boolean isAtRPar(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        ASTNode node = TreeUtil.skipElements((ASTNode)element.getNode(), (TokenSet)OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        return node != null && node.getElementType() == OCTokenTypes.RPAR;
    }

    private static boolean isInsideSendMessage(@NotNull CompletionInitializationContext context) {
        OCSendMessageExpression message = (OCSendMessageExpression)PsiTreeUtil.findElementOfClassAtOffsetWithStopSet((PsiFile)context.getFile(), (int)context.getStartOffset(), OCSendMessageExpression.class, (boolean)false, (Class[])new Class[]{OCCallable.class});
        if (message != null && message.getTextRange().getStartOffset() == context.getStartOffset()) {
            message = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)message, OCSendMessageExpression.class, (boolean)true, (Class[])new Class[]{OCCallable.class});
        }
        return message != null;
    }

    public static class Context {
        @NotNull
        private final String myExactSelectorPrefix;
        @NotNull
        private final OCObjectTypeContext myReceiverContext;
        @NotNull
        private final Condition<OCMethodSymbol> myCondition;
        @Nullable
        private final PsiElement myReceiver;

        public Context(@NotNull String prefix, @Nullable PsiElement receiver, @NotNull OCObjectTypeContext context, @NotNull Condition<OCMethodSymbol> condition) {
            this.myExactSelectorPrefix = prefix;
            this.myReceiver = receiver;
            this.myReceiverContext = context;
            this.myCondition = condition;
        }

        @NotNull
        public String getExactSelectorPrefix() {
            return this.myExactSelectorPrefix;
        }

        @NotNull
        public OCObjectTypeContext getReceiverContext() {
            return this.myReceiverContext;
        }

        @NotNull
        public Condition<OCMethodSymbol> getCondition() {
            return this.myCondition;
        }

        @Nullable
        public PsiElement getReceiver() {
            return this.myReceiver;
        }
    }

    private static class SendMessagePlace {
        @NotNull
        public final OCSendMessageExpression expression;
        @NotNull
        public final OCMessageArgument argument;

        SendMessagePlace(@NotNull OCMessageArgument argument) {
            this.expression = (OCSendMessageExpression)argument.getParent();
            this.argument = argument;
        }
    }
}

