/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.DefaultTypingActionsExtension;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProviderEP;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.formatting.OCMultilineNodeFormatter;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import org.jetbrains.annotations.NotNull;

public class OCTypingActionsExtension
extends DefaultTypingActionsExtension {
    public static final Key<Boolean> INSIDE_TYPING_ACTION_HINT = Key.create((String)"INSIDE_TYPING_ACTION_HINT");
    public static final Key<Boolean> INDENTATION_ONLY_HINT = Key.create((String)"INDENTATION_ONLY_HINT");
    private static final String CLION_CF_ID = "ClangFormat";

    public void startCopy(@NotNull Project project, @NotNull Editor editor) {
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
    }

    public boolean isSuitableContext(@NotNull Project project, @NotNull Editor editor) {
        return Registry.is((String)"cidr.enable.typingActionsExtension") && PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) instanceof OCPsiFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(@NotNull Project project, @NotNull Editor editor, int howtoReformat, int startOffset, int endOffset, int anchorColumn, boolean indentBeforeReformat) {
        boolean skipCommitMode;
        Document document = editor.getDocument();
        boolean bl = skipCommitMode = INSIDE_TYPING_ACTION_HINT.get((UserDataHolder)editor.getDocument()) == Boolean.TRUE;
        if (!skipCommitMode) {
            INSIDE_TYPING_ACTION_HINT.set((UserDataHolder)editor.getDocument(), (Object)Boolean.TRUE);
        }
        try {
            super.format(project, editor, howtoReformat, startOffset, endOffset, anchorColumn, indentBeforeReformat);
        }
        finally {
            if (!skipCommitMode) {
                INSIDE_TYPING_ACTION_HINT.set((UserDataHolder)editor.getDocument(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustLineIndent(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset) {
        ExternalFormatProcessor efp;
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file != null && (efp = ExternalFormatProcessor.activeExternalFormatProcessor((PsiFile)file)) != null && CLION_CF_ID.equals(efp.getId())) {
            RangeMarker bounds = document.createRangeMarker(startOffset, endOffset);
            try {
                INDENTATION_ONLY_HINT.set((UserDataHolder)document, (Object)Boolean.TRUE);
                efp.format(file, TextRange.create((int)startOffset, (int)endOffset), true, true, true, -1);
                OCTypingActionsExtension.indentCorrection(file, document, efp, bounds);
                return;
            }
            finally {
                INDENTATION_ONLY_HINT.set((UserDataHolder)document, null);
                bounds.dispose();
            }
        }
        super.adjustLineIndent(project, editor, startOffset, endOffset);
    }

    protected void adjustLineIndentWithLexer(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset) {
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        OCLanguage language = OCLanguage.getInstance();
        LineIndentProvider lineIndentProvider = LineIndentProviderEP.findLineIndentProvider((Language)language);
        if (lineIndentProvider != null && file != null) {
            HighlighterIterator it = editor.getHighlighter().createIterator(startOffset);
            OCMultilineNodeFormatter multilineNodeFormatter = OCMultilineNodeFormatter.create(file);
            CharSequence fileText = document.getCharsSequence();
            int currentLine = -1;
            RangeMarker actionRange = document.createRangeMarker(startOffset, endOffset);
            while (!it.atEnd() && it.getStart() <= actionRange.getEndOffset()) {
                int startLine;
                if (it.getTokenType() != TokenType.WHITE_SPACE && (startLine = document.getLineNumber(it.getStart())) > currentLine) {
                    currentLine = startLine;
                    int startIndent = document.getLineStartOffset(startLine);
                    int endIndent = CharArrayUtil.shiftForward((CharSequence)fileText, (int)startIndent, (String)" \t");
                    String newIndentString = lineIndentProvider.getLineIndent(project, editor, (Language)language, startIndent);
                    if (newIndentString != null && newIndentString != LineIndentProvider.DO_NOT_ADJUST) {
                        int shiftMultilineToken = 0;
                        RangeMarker marker = document.createRangeMarker(it.getStart(), it.getEnd());
                        if (it.getTokenType() == OCTokenTypes.BLOCK_COMMENT && startLine != document.getLineNumber(it.getEnd())) {
                            shiftMultilineToken = multilineNodeFormatter.indent(newIndentString) - multilineNodeFormatter.indent(fileText.subSequence(startIndent, endIndent));
                        }
                        document.replaceString(startIndent, endIndent, (CharSequence)newIndentString);
                        if (shiftMultilineToken != 0) {
                            document.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)multilineNodeFormatter.getShiftedLeafText(shiftMultilineToken, fileText.subSequence(marker.getStartOffset(), marker.getEndOffset())));
                        }
                        it = editor.getHighlighter().createIterator(marker.getEndOffset());
                        marker.dispose();
                        continue;
                    }
                }
                it.advance();
            }
            actionRange.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustLineIndent(@NotNull Project project, @NotNull Editor editor, int offset) {
        ExternalFormatProcessor efp;
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file != null && (efp = ExternalFormatProcessor.activeExternalFormatProcessor((PsiFile)file)) != null && CLION_CF_ID.equals(efp.getId())) {
            try {
                INDENTATION_ONLY_HINT.set((UserDataHolder)document, (Object)Boolean.TRUE);
                int lineStartOffset = document.getLineStartOffset(document.getLineNumber(offset));
                String indent = efp.indent(file, offset);
                if (indent != null) {
                    document.replaceString(lineStartOffset, offset, (CharSequence)indent);
                } else {
                    efp.format(file, TextRange.create((int)lineStartOffset, (int)offset), true, false, true, -1);
                }
                return;
            }
            finally {
                INDENTATION_ONLY_HINT.set((UserDataHolder)document, null);
            }
        }
        super.adjustLineIndent(project, editor, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reformatRange(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset) {
        ExternalFormatProcessor efp;
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file != null && (efp = ExternalFormatProcessor.activeExternalFormatProcessor((PsiFile)file)) != null && CLION_CF_ID.equals(efp.getId())) {
            RangeMarker bounds = document.createRangeMarker(startOffset, endOffset);
            try {
                efp.format(file, TextRange.create((int)startOffset, (int)endOffset), true, false, true, -1);
                OCTypingActionsExtension.indentCorrection(file, document, efp, bounds);
            }
            finally {
                bounds.dispose();
            }
            return;
        }
        super.reformatRange(project, editor, startOffset, endOffset);
    }

    private static void indentCorrection(@NotNull PsiFile file, @NotNull Document document, @NotNull ExternalFormatProcessor efp, @NotNull RangeMarker range) {
        char ch;
        int i;
        CharSequence text = document.getCharsSequence();
        int startAnchorIndent = -1;
        for (i = range.getStartOffset() - 1; i >= 0; --i) {
            ch = text.charAt(i);
            if (ch == '\n') {
                startAnchorIndent = i;
                break;
            }
            if ("\t ".indexOf(ch) < 0) break;
        }
        if (startAnchorIndent < 0) {
            for (i = range.getStartOffset(); i < range.getEndOffset(); ++i) {
                ch = text.charAt(i);
                if (ch == '\n') {
                    startAnchorIndent = i;
                    continue;
                }
                if (startAnchorIndent >= 0 && "\t ".indexOf(ch) < 0) break;
            }
        }
        if (startAnchorIndent < 0) {
            return;
        }
        int endAnchorIndent = CharArrayUtil.shiftForward((CharSequence)text, (int)(++startAnchorIndent), (String)" \t");
        String origIndent = text.subSequence(startAnchorIndent, endAnchorIndent).toString();
        String relativeIndent = efp.indent(file, endAnchorIndent);
        if (relativeIndent == null) {
            return;
        }
        OCMultilineNodeFormatter multilineNodeFormatter = OCMultilineNodeFormatter.create(file);
        int shift = multilineNodeFormatter.indent(relativeIndent) - multilineNodeFormatter.indent(origIndent);
        if (shift != 0) {
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)multilineNodeFormatter.getShiftedLeafText(shift, text.subSequence(range.getStartOffset(), range.getEndOffset())));
        }
    }
}

