/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.cidr.cpp.lexer.OCLexerWithDirectives;
import com.intellij.lexer.Lexer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.lexer.OCTokenTypeProvider;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTodoIndexPatternBuilder
implements IndexPatternBuilder {
    public static final TokenSet LEXER_COMMENTS = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.BLOCK_COMMENT, OCTokenTypes.EOL_COMMENT});

    @Nullable
    public Lexer getIndexingLexer(@NotNull PsiFile file) {
        if (OCLanguageUtils.isSupported(file)) {
            return OCLexerWithDirectives.createDefault((CidrTokenTypeProvider)OCTokenTypeProvider.INSTANCE);
        }
        return null;
    }

    @Nullable
    public TokenSet getCommentTokenSet(@NotNull PsiFile file) {
        if (OCLanguageUtils.isSupported(file)) {
            return LEXER_COMMENTS;
        }
        return null;
    }

    public int getCommentStartDelta(@NotNull IElementType tokenType) {
        if (tokenType == OCTokenTypes.BLOCK_COMMENT || tokenType == OCTokenTypes.EOL_COMMENT) {
            return 2;
        }
        return 0;
    }

    public int getCommentEndDelta(IElementType tokenType) {
        return tokenType == OCTokenTypes.BLOCK_COMMENT ? 2 : 0;
    }

    @NotNull
    public String getCharsAllowedInContinuationPrefix(@NotNull IElementType tokenType) {
        return tokenType == OCTokenTypes.BLOCK_COMMENT ? "*|" : "/";
    }
}

