/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCArgumentListCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCCompoundInitializerCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallOption;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionParameterInfo;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCParameterListCallPlace;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCDocUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<PsiElement, FunctionInfoWrapper, OCExpression> {
    public static final Logger LOG = Logger.getInstance(OCFunctionParameterInfoHandler.class);
    private static final Condition<String> IS_UNNAMED = s -> "<unnamed>".equals(s);

    public PsiElement findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        int startOffset;
        int offset;
        if (Registry.is((String)"clang.parameter.info")) {
            return null;
        }
        PsiFile file = context.getFile();
        OCFunctionCallPlace<?> callPlace = OCFunctionParameterInfoHandler.findCallPlace(file, offset = context.getOffset(), startOffset = context.getParameterListStart());
        if (callPlace != null) {
            ArrayList<OCFunctionCallOption> callOptions = new ArrayList<OCFunctionCallOption>();
            callPlace.collectCallOptions(callOptions);
            callOptions.sort((o1, o2) -> Comparing.compare((int)o1.getOffset(), (int)o2.getOffset()));
            ArrayList<FunctionInfoWrapper> overloads = new ArrayList<FunctionInfoWrapper>();
            OCResolveContext resolveContext = OCResolveContext.forPsi(callPlace.getElement());
            block0: for (OCFunctionCallOption option : callOptions) {
                OCFunctionParameterInfo info = option.getParameterInfo();
                OCFunctionType funcType = info.getType();
                for (int i = 0; i < overloads.size(); ++i) {
                    FunctionInfoWrapper other = (FunctionInfoWrapper)overloads.get(i);
                    OCFunctionType otherType = other.getInfo().getType();
                    if (!otherType.equalsAfterResolving(funcType, resolveContext)) continue;
                    if (!OCFunctionParameterInfoHandler.hasUnnamedParam(otherType) || OCFunctionParameterInfoHandler.hasUnnamedParam(funcType)) continue block0;
                    overloads.set(i, new FunctionInfoWrapper(info));
                    continue block0;
                }
                overloads.add(new FunctionInfoWrapper(info));
            }
            context.setItemsToShow(overloads.toArray());
        }
        return callPlace == null ? null : (PsiElement)callPlace.getElement();
    }

    private static boolean hasUnnamedParam(@NotNull OCFunctionType funcType) {
        List<String> names = funcType.getParameterNames();
        if (names == null) {
            return funcType.getParameterTypes().size() > 0;
        }
        return ContainerUtil.find(names, IS_UNNAMED) != null;
    }

    @Nullable
    private static OCFunctionCallPlace<?> findCallPlace(PsiFile file, int offset, int startOffset) {
        if (file == null) {
            return null;
        }
        if (startOffset == -1) {
            startOffset = offset;
        }
        PsiElement e1 = file.findElementAt(offset);
        PsiElement e2 = file.findElementAt(startOffset);
        if (e1 == null || e2 == null) {
            return null;
        }
        PsiElement element = PsiTreeUtil.findCommonContext((PsiElement)e1, (PsiElement)e2);
        if (element == null) {
            return null;
        }
        while (element != null) {
            OCFunctionCallPlace<? extends PsiElement> place = OCFunctionParameterInfoHandler.callPlace(element);
            if (place != null) {
                return place;
            }
            if (element instanceof OCBlockExpression || element instanceof OCLambdaExpression) {
                return null;
            }
            element = element.getContext();
        }
        return null;
    }

    @Nullable
    private static OCFunctionCallPlace<? extends PsiElement> callPlace(@NotNull PsiElement element) {
        if (element instanceof OCArgumentList) {
            return new OCArgumentListCallPlace((OCArgumentList)element);
        }
        if (!(element instanceof OCElement)) {
            return null;
        }
        if (!((OCElement)element).getContainingOCFile().isCpp()) {
            return null;
        }
        if (element instanceof OCParameterList) {
            return new OCParameterListCallPlace((OCParameterList)element);
        }
        if (element instanceof OCCompoundInitializer) {
            return new OCCompoundInitializerCallPlace((OCCompoundInitializer)element);
        }
        return null;
    }

    public void showParameterInfo(@NotNull PsiElement element, @NotNull CreateParameterInfoContext context) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.parameterInfo");
        context.showHint(element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public PsiElement findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        OCFunctionCallPlace<?> place = OCFunctionParameterInfoHandler.findCallPlace(context.getFile(), context.getOffset(), context.getParameterListStart());
        return place == null ? null : (PsiElement)place.getElement();
    }

    public void updateParameterInfo(@NotNull PsiElement parameterOwner, @NotNull UpdateParameterInfoContext context) {
        OCFunctionCallPlace<? extends PsiElement> callPlace = OCFunctionParameterInfoHandler.callPlace(parameterOwner);
        OCLog.LOG.assertTrue(callPlace != null);
        int offset = context.getOffset();
        if (!parameterOwner.getTextRange().contains(offset)) {
            context.removeHint();
            return;
        }
        int index = 0;
        for (ASTNode child = parameterOwner.getNode().getFirstChildNode(); child != null && child.getStartOffset() < offset; child = child.getTreeNext()) {
            if (child.getElementType() != OCTokenTypes.COMMA) continue;
            ++index;
        }
        context.setCurrentParameter(index);
        Object[] methods = context.getObjectsToView();
        List<OCExpression> argExpressions = callPlace.getArgumentExpressions();
        for (int i = 0; i < methods.length; ++i) {
            FunctionInfoWrapper wrapper = (FunctionInfoWrapper)methods[i];
            OCFunctionType funcType = wrapper.getInfo().getType();
            boolean isEnabled = OCFunctionParameterInfoHandler.isApplicableBeforeIndex(funcType, argExpressions, index);
            context.setUIComponentEnabled(i, isEnabled);
            wrapper.ui = OCFunctionParameterInfoHandler.calcUI(wrapper.getInfo(), index, isEnabled, parameterOwner);
        }
    }

    public static boolean isApplicableBeforeIndex(@NotNull OCFunctionType funcType, @NotNull List<OCExpression> argExpressions, int index) {
        List<OCType> paramTypes = funcType.getParameterTypes();
        return (index == 0 || paramTypes.size() > index || funcType.isVararg()) && OCFunctionParameterInfoHandler.isAssignableParametersBeforeGivenIndex(paramTypes, argExpressions, index + 1);
    }

    private static boolean isAssignableParametersBeforeGivenIndex(@NotNull List<? extends OCType> params, @NotNull List<OCExpression> args, int length) {
        int min = Math.min(length, Math.min(args.size(), params.size()));
        for (int j = 0; j < min; ++j) {
            OCType argType;
            OCType paramType = params.get(j);
            OCExpression arg = args.get(j);
            if (arg == null || !paramType.checkCompatible(argType = arg.getResolvedType(), arg, arg, OCResolveContext.forPsi(arg)).getState().isError(arg)) continue;
            return false;
        }
        return true;
    }

    public void updateUI(@NotNull FunctionInfoWrapper wrapper, @NotNull ParameterInfoUIContext context) {
        PsiElement owner = context.getParameterOwner();
        if (owner != null) {
            OCFunctionParameterInfoHandler.updateFunctionUI(wrapper.ui, context);
        }
    }

    private static FunctionInfoWrapper.UI calcUI(@NotNull OCFunctionParameterInfo info, int currentParameter, boolean isEnabled, @NotNull PsiElement context) {
        int commaStart;
        StringBuilder buffer = new StringBuilder();
        OCFunctionType type = info.getType();
        List<String> defParamValues = info.getDefaultParameterValues();
        List<OCType> paramTypes = type.getParameterTypes();
        @Nullable List<String> paramNames = type.getParameterNames();
        String paramTypeHint = null;
        if ((context instanceof OCArgumentList || context instanceof OCParameterList) && context.getParent() instanceof OCDeclarator && (paramTypeHint = ((OCDeclarator)context.getParent()).getType().getBestNameInContext(context)) != null && (commaStart = paramTypeHint.indexOf(40)) != -1) {
            paramTypeHint = paramTypeHint.substring(0, commaStart);
        }
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (paramTypes.isEmpty()) {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        } else {
            int numParams = paramTypes.size();
            for (int i = 0; i < numParams; ++i) {
                int startOffset = buffer.length();
                String typeText = paramTypes.get(i).getBestNameInContext(context, paramTypeHint);
                String paramName = paramNames == null ? "<unnamed>" : paramNames.get(i);
                String defValue = defParamValues == null ? null : defParamValues.get(i);
                buffer.append(OCDocUtil.parameterSignature(typeText, paramName, defValue));
                int endOffset = buffer.length();
                if (i < numParams - 1) {
                    buffer.append(", ");
                }
                if (!isEnabled || i != currentParameter && (i != numParams - 1 || !type.isVararg() || currentParameter < numParams)) continue;
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        }
        return new FunctionInfoWrapper.UI(buffer.toString(), highlightStartOffset, highlightEndOffset);
    }

    public static String updateFunctionUI(@NotNull FunctionInfoWrapper.UI ui, ParameterInfoUIContext context) {
        return context.setupUIComponentPresentation(ui.text, ui.highlightStartOffset, ui.highlightEndOffset, !context.isUIComponentEnabled(), false, false, context.getDefaultParameterColor());
    }

    public OCExpression @NotNull [] getActualParameters(@NotNull PsiElement parameterOwner) {
        OCFunctionCallPlace<? extends PsiElement> callPlace = OCFunctionParameterInfoHandler.callPlace(parameterOwner);
        OCLog.LOG.assertTrue(callPlace != null);
        return callPlace.getArgumentExpressions().toArray(new OCExpression[0]);
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        return OCTokenTypes.COMMA;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        return OCTokenTypes.RBRACE;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        return ContainerUtil.newHashSet((Object[])new Class[]{OCCallExpression.class, OCDeclarator.class, OCArgumentList.class});
    }

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        return Collections.singleton(PsiFile.class);
    }

    @NotNull
    public Class<PsiElement> getArgumentListClass() {
        return PsiElement.class;
    }

    public static class FunctionInfoWrapper {
        @NotNull
        private final OCFunctionParameterInfo myInfo;
        @NotNull
        private UI ui = new UI("", -1, -1);

        public FunctionInfoWrapper(@NotNull OCFunctionParameterInfo info) {
            this.myInfo = info;
        }

        @NotNull
        public OCFunctionParameterInfo getInfo() {
            return this.myInfo;
        }

        @NotNull
        public UI getUi() {
            return this.ui;
        }

        public void setUi(@NotNull UI ui) {
            this.ui = ui;
        }

        public static final class UI {
            @NotNull
            public final String text;
            public final int highlightStartOffset;
            public final int highlightEndOffset;

            private UI(@NotNull String text, int highlightStartOffset, int highlightEndOffset) {
                this.text = text;
                this.highlightStartOffset = highlightStartOffset;
                this.highlightEndOffset = highlightEndOffset;
            }
        }
    }
}

