/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.contextSensitive;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.contextSensitive.RmlDslScriptLoader;
import com.jetbrains.cidr.lang.dfa.contextSensitive.RmlScriptLoader;
import com.jetbrains.cidr.lang.legacy.dfa.OCContextSensitiveControlFlowBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.contextSensitive.OCContextSensitiveBuilderKt;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.scripts.Script;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ConsoleUI;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UICallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.ui.console.Console;
import com.jetbrains.sourceglider.ui.console.EmptyConsole;
import com.jetbrains.sourceglider.ui.console.SystemConsole;
import com.jetbrains.sourceglider.visitors.Visitor;
import com.jetbrains.sourceglider.visitors.VisitorImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSourceGliderService {
    private static final RmlScriptLoader scriptLoader = new RmlDslScriptLoader();
    private static final int PROVIDERS_CNT = 4;
    private final List<ManagerInstancesProvider> myProviders = new ArrayList<ManagerInstancesProvider>();
    private final List<VisitorImpl> myVisitors = new ArrayList<VisitorImpl>();
    private final MultiMap<Integer, VisitorRunner> myVisitorRunners = new MultiMap();

    public static OCSourceGliderService getInstance() {
        return (OCSourceGliderService)ApplicationManager.getApplication().getService(OCSourceGliderService.class);
    }

    private static int getIndex(boolean legacy, boolean contextSensitive) {
        return (legacy ? 2 : 0) + (contextSensitive ? 1 : 0);
    }

    private static boolean isLegacy(int index) {
        return (index & 2) != 0;
    }

    public ManagerInstancesProvider getProvider(boolean legacy, boolean contextSensitive) {
        return this.myProviders.get(OCSourceGliderService.getIndex(legacy, contextSensitive));
    }

    public List<ManagerInstancesProvider> getAllProviders() {
        return this.myProviders;
    }

    public void addVisitorRunner(boolean legacy, boolean contextSensitive, VisitorRunner visitorRunner) {
        this.myVisitorRunners.putValue((Object)OCSourceGliderService.getIndex(legacy, contextSensitive), (Object)visitorRunner);
    }

    public void clearVisitorRunners() {
        this.myVisitorRunners.clear();
    }

    public VisitorImpl getVisitor(boolean legacy, boolean contextSensitive) {
        return this.myVisitors.get(OCSourceGliderService.getIndex(legacy, contextSensitive));
    }

    public OCSourceGliderService() {
        for (int i = 0; i < 4; ++i) {
            int index = i;
            this.myProviders.add(OCSourceGliderService.createProvider(OCSourceGliderService.isLegacy(i), OCSourceGliderService.logEnabled(), (symbolTable, visitor, options, threadCallback) -> {
                for (VisitorRunner runner : this.myVisitorRunners.get((Object)index)) {
                    runner.run(options, threadCallback);
                }
            }, this.myVisitors, new HashMap<Object, Object>()));
        }
    }

    @NotNull
    public static ManagerInstancesProvider createProvider(final boolean isLegacy, final boolean isLogEnabled, final VisitorRunnerEX visitorRunner, final List<VisitorImpl> visitors, Map<Object, Object> options) {
        ManagerInstancesProvider provider2 = new ManagerInstancesProvider(){

            protected UIInstancesProvider createUIInstancesProvider() {
                return isLogEnabled ? new UIInstancesProvider(OCSourceGliderService.getLogConsole(), (UICallback)new ConsoleUI()) : new UIInstancesProvider((Console)new EmptyConsole(), (UICallback)new ConsoleUI(true));
            }

            protected void registerVisitors() {
                VisitorImpl visitor = new VisitorImpl(this.symbolTable){

                    public RelationSignature[] getOutputRelations() {
                        return isLegacy ? new OCContextSensitiveControlFlowBuilder(symbolTable, null).getOutputRelations() : OCContextSensitiveBuilderKt.getRelationSignatures((SymbolTable)symbolTable).toArray(new RelationSignature[0]);
                    }

                    public void run(Map options, ThreadCallback threadCallback) {
                        visitorRunner.run(symbolTable, this, options, threadCallback);
                    }
                };
                this.visitorsManager.addVisitor((Visitor)visitor);
                visitors.add(visitor);
            }

            protected void registerScripts() {
                List<Script> scripts = scriptLoader.loadScripts(this, isLegacy);
                for (Script script : scripts) {
                    this.scriptManager.addScript(script);
                }
            }
        };
        provider2.startInit(options);
        provider2.getSymbolTable().setAllowDomainsResize(true);
        return provider2;
    }

    public static boolean logEnabled() {
        return Registry.is((String)"clion.dfa.log");
    }

    public static boolean isGlobalMode(@Nullable PsiFile file) {
        return !(!Registry.is((String)"clion.dfa.global") && !ApplicationManager.getApplication().isUnitTestMode() || file != null && file.getVirtualFile() != null && OCImportGraph.getInstance(file.getProject()).isFileIncluded(file.getVirtualFile()));
    }

    public static boolean isCollectResultForQuickDoc() {
        return Registry.is((String)"cidr.clion.clang.documentation.provider.dfa", (boolean)false);
    }

    private static Console getLogConsole() {
        Iterator iterator;
        if (ApplicationManager.getApplication() != null && !ApplicationManager.getApplication().isUnitTestMode() && (iterator = Console.EP_NAME.getExtensionList().iterator()).hasNext()) {
            Console c = (Console)iterator.next();
            return c;
        }
        return new SystemConsole();
    }

    @FunctionalInterface
    public static interface VisitorRunnerEX {
        public void run(SymbolTable var1, VisitorImpl var2, Map var3, ThreadCallback var4);
    }

    @FunctionalInterface
    public static interface VisitorRunner {
        public void run(Map var1, ThreadCallback var2);
    }
}

