/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAlgorithm;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCMultiSymbolAlgorithm
extends OCDataFlowAlgorithm {
    private final Map<OCSymbol, boolean[]> myVisitedNodes = new HashMap<OCSymbol, boolean[]>();
    private final Stack<OCInstruction> myStack = new Stack();
    private final Set<OCInstruction> myGoodReads = new HashSet<OCInstruction>();
    private final Set<OCSymbol> myReferencedSymbols = new HashSet<OCSymbol>();

    protected OCMultiSymbolAlgorithm(OCControlFlowGraph cfg) {
        super(cfg);
    }

    @Override
    public void process() {
        this.myStack.addAll(this.getStartInstructions());
        if (this.processClosureSymbols()) {
            for (OCSymbol symbol : this.myCfg.getClosureSymbols()) {
                if (!this.myCfg.hasInstructionsInParentGraph(symbol, OCInstruction.InstructionKind.WRITE, OCInstruction.InstructionKind.WRITE_IN_BLOCK, OCInstruction.InstructionKind.REFERENCE)) continue;
                this.traverseFromStart(symbol);
            }
        }
        while (!this.myStack.isEmpty()) {
            OCInstruction instruction = (OCInstruction)this.myStack.pop();
            this.traverse(instruction, instruction.getSymbol(), true);
        }
    }

    @Override
    protected boolean acceptsInstruction(@NotNull OCInstruction instruction) {
        if (this.myReferencedSymbols.contains(instruction.getSymbol())) {
            return true;
        }
        switch (instruction.getKind()) {
            case KILL: {
                return false;
            }
            case WRITE: {
                return this.isStartInstruction(instruction);
            }
        }
        return true;
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        switch (instruction.getKind()) {
            case REFERENCE: 
            case WRITE_IN_BLOCK: {
                return this.treatReferencesAsStartInstructions();
            }
            case WRITE: {
                break;
            }
            default: {
                return false;
            }
        }
        OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
        if (associatedInstruction != null && associatedInstruction.getKind() == OCInstruction.InstructionKind.READ) {
            return this.isGoodRead(associatedInstruction);
        }
        return this.isGoodWrite(instruction.getRValue());
    }

    protected boolean isGoodRead(@NotNull OCInstruction instruction) {
        return this.myGoodReads.contains(instruction);
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        return instruction.getKind() == OCInstruction.InstructionKind.READ;
    }

    protected boolean treatReferencesAsStartInstructions() {
        return true;
    }

    @Override
    protected boolean processInstruction(@NotNull OCInstruction instruction) {
        if (instruction.getKind() == OCInstruction.InstructionKind.READ) {
            OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
            if (associatedInstruction != null && associatedInstruction.getKind() == OCInstruction.InstructionKind.WRITE) {
                this.myGoodReads.add(instruction);
                this.myStack.push((Object)associatedInstruction);
            }
        } else if (instruction.getKind() == OCInstruction.InstructionKind.WRITE_IN_BLOCK || instruction.getKind() == OCInstruction.InstructionKind.REFERENCE) {
            this.myReferencedSymbols.add(instruction.getSymbol());
        }
        return this.acceptsInstruction(instruction);
    }

    protected boolean processClosureSymbols() {
        return true;
    }

    @Override
    protected boolean isNodeProcessed(@NotNull OCNode node, @Nullable OCSymbol symbol) {
        boolean[] set = symbol != null ? this.myVisitedNodes.get(symbol) : null;
        return set != null && set[node.getIndex()];
    }

    @Override
    protected void markNodeAsProcessed(@NotNull OCNode node, @Nullable OCSymbol symbol) {
        if (symbol != null) {
            boolean[] set = this.myVisitedNodes.computeIfAbsent(symbol, k -> new boolean[this.myCfg.getNumOfNodes()]);
            set[node.getIndex()] = true;
        }
    }

    @NotNull
    protected List<Pair<OCSymbol, PsiElement>> getReachableElements(boolean nonReachable) {
        ArrayList<Pair<OCSymbol, PsiElement>> result = new ArrayList<Pair<OCSymbol, PsiElement>>();
        for (OCSymbol symbol : this.myCfg.getLocalSymbols()) {
            for (PsiElement element : this.getReachableElements(true, symbol, nonReachable)) {
                result.add((Pair<OCSymbol, PsiElement>)Pair.create((Object)symbol, (Object)element));
            }
        }
        if (this.processClosureSymbols()) {
            for (OCSymbol symbol : this.myCfg.getClosureSymbols()) {
                for (PsiElement element : this.getReachableElements(true, symbol, nonReachable)) {
                    result.add((Pair<OCSymbol, PsiElement>)Pair.create((Object)symbol, (Object)element));
                }
            }
        }
        return result;
    }

    @NotNull
    protected List<Pair<OCSymbol, PsiElement>> getReachableElements() {
        return this.getReachableElements(false);
    }

    protected abstract boolean isGoodWrite(@Nullable PsiElement var1);
}

