/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInstruction {
    private final InstructionKind myKind;
    private final OCNode myNode;
    @Nullable
    private OCInstruction myAssociatedInstruction;
    @NotNull
    private final OCSymbol mySymbol;
    private final PsiElement myLValue;
    private final PsiElement myRValue;
    private boolean myTransparentRead;

    OCInstruction(@NotNull InstructionKind kind, @NotNull OCNode node, @Nullable PsiElement lValue, @NotNull OCSymbol symbol) {
        this(kind, node, lValue, null, symbol);
    }

    OCInstruction(@NotNull InstructionKind kind, @NotNull OCNode node, @Nullable PsiElement lValue, @Nullable PsiElement rValue, @NotNull OCSymbol symbol) {
        this.myKind = kind;
        this.myNode = node;
        this.myLValue = lValue;
        this.mySymbol = symbol;
        this.myRValue = rValue;
    }

    @Nullable
    public PsiElement getLValue() {
        return this.myLValue;
    }

    @Nullable
    public PsiElement getRValue() {
        return this.myRValue;
    }

    @NotNull
    public InstructionKind getKind() {
        return this.myKind;
    }

    @NotNull
    public OCNode getNode() {
        return this.myNode;
    }

    @NotNull
    public OCSymbol getSymbol() {
        return this.mySymbol;
    }

    public long getSymbolOffset() {
        long offset = this.mySymbol.getComplexOffset();
        return offset != 0L ? offset : (long)this.mySymbol.hashCode();
    }

    public void setAssociatedInstruction(@Nullable OCInstruction associatedInstruction) {
        this.myAssociatedInstruction = associatedInstruction;
    }

    @Nullable
    public OCInstruction getAssociatedInstruction() {
        return this.myAssociatedInstruction;
    }

    public boolean isTransparentRead() {
        return this.myTransparentRead;
    }

    public void setTransparentRead(boolean transparentRead) {
        this.myTransparentRead = transparentRead;
    }

    public static enum InstructionKind {
        DECLARATOR,
        READ,
        WRITE,
        KILL,
        REFERENCE,
        READ_IN_BLOCK,
        WRITE_IN_BLOCK;

    }
}

