/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.jetbrains.cidr.lang.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInputOutputVariablesFinder;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDataFlowAnalyzer {
    private PsiElement[] myCodeFragments;
    private OCControlFlowGraph myGraph;
    private OCControlFlowBuilder myGraphBuilder;
    private OCUnreachableCodeFinder myUnreachableCodeFinder;
    private OCDataFlowAnalyzer myParentAnalyzer;
    private List<OCDataFlowAnalyzer> myChildAnalyzers = new ArrayList<OCDataFlowAnalyzer>();
    private TextRange mySelection;
    private List<OCSymbol> myInputVariables;
    private List<OCSymbol> myOutputVariables;
    private List<OCSymbol> myWrittenVariables;
    private List<OCSymbol> myEscapedDeclarators;
    private Map<OCSymbol, List<PsiReference>> myVariableUsages;

    public OCDataFlowAnalyzer(@NotNull PsiElement codeFragment, @Nullable OCDataFlowAnalyzer parentAnalyzer) {
        this(new PsiElement[]{codeFragment}, parentAnalyzer, parentAnalyzer != null ? parentAnalyzer.mySelection : null);
        if (parentAnalyzer != null) {
            parentAnalyzer.myChildAnalyzers.add(this);
        }
    }

    public OCDataFlowAnalyzer(PsiElement @NotNull [] codeFragments, @Nullable TextRange selection) {
        this(codeFragments, null, selection);
    }

    public OCDataFlowAnalyzer(@NotNull PsiElement codeFragment, @Nullable TextRange selection) {
        this(new PsiElement[]{codeFragment}, null, selection);
    }

    private OCDataFlowAnalyzer(PsiElement @NotNull [] codeFragments, @Nullable OCDataFlowAnalyzer parentAnalyzer, @Nullable TextRange selection) {
        this.myCodeFragments = codeFragments;
        this.mySelection = selection;
        this.myParentAnalyzer = parentAnalyzer;
        this.myInputVariables = new ArrayList<OCSymbol>();
        this.myOutputVariables = new ArrayList<OCSymbol>();
        this.myWrittenVariables = new ArrayList<OCSymbol>();
        this.myEscapedDeclarators = new ArrayList<OCSymbol>();
        this.myVariableUsages = new HashMap<OCSymbol, List<PsiReference>>();
    }

    @NotNull
    public OCControlFlowGraph getGraph() {
        return this.myGraph;
    }

    @Nullable
    public OCControlFlowGraph findGraph(@NotNull PsiElement element) {
        if (!this.myGraph.getCodeFragment().getTextRange().contains(element.getTextOffset())) {
            return null;
        }
        for (OCDataFlowAnalyzer analyzer : this.myChildAnalyzers) {
            OCControlFlowGraph graph = analyzer.findGraph(element);
            if (graph == null) continue;
            return graph;
        }
        return this.myGraph;
    }

    @NotNull
    public OCUnreachableCodeFinder getUnreachableCodeFinder() {
        return this.myUnreachableCodeFinder;
    }

    @NotNull
    public List<OCSymbol> getInputVariables() {
        return this.myInputVariables;
    }

    @NotNull
    public List<OCSymbol> getOutputVariables() {
        return this.myOutputVariables;
    }

    @NotNull
    public List<OCSymbol> getWrittenVariables() {
        return this.myWrittenVariables;
    }

    @NotNull
    public List<OCSymbol> getEscapedDeclarators() {
        return this.myEscapedDeclarators;
    }

    public void buildControlFlowGraph() {
        this.myGraph = new OCControlFlowGraph(this.myCodeFragments[0], this.myParentAnalyzer != null ? this.myParentAnalyzer.getGraph() : null);
        this.myGraphBuilder = new OCControlFlowBuilder(this, this.myGraph, this.mySelection);
        boolean isFirst = true;
        for (PsiElement codeFragment : this.myCodeFragments) {
            if (isFirst) {
                this.myGraphBuilder.processFirstCodeFragment(codeFragment);
            } else {
                this.myGraphBuilder.processNextCodeFragment(codeFragment);
            }
            isFirst = false;
        }
        this.myUnreachableCodeFinder = new OCUnreachableCodeFinder(this.myGraph);
        this.myUnreachableCodeFinder.process();
    }

    public void analyze() {
        for (OCSymbol symbol : this.myGraph.getLocalSymbols()) {
            if (symbol.isUnnamed()) continue;
            this.analyzeInputOutput(symbol);
        }
        for (OCSymbol symbol : this.myGraph.getClosureSymbols()) {
            if (symbol.isUnnamed()) continue;
            this.analyzeInputOutput(symbol);
        }
        for (OCDataFlowAnalyzer kid : this.myChildAnalyzers) {
            kid.analyze();
            this.myInputVariables.addAll(kid.getInputVariables());
            this.myOutputVariables.addAll(kid.getOutputVariables());
            this.myEscapedDeclarators.addAll(kid.getEscapedDeclarators());
            this.myWrittenVariables.addAll(kid.getWrittenVariables());
            for (OCSymbol symbol : kid.myVariableUsages.keySet()) {
                if (this.myVariableUsages.containsKey(symbol)) continue;
                this.myVariableUsages.put(symbol, kid.myVariableUsages.get(symbol));
            }
        }
        if (this.mySelection != null) {
            Comparator<OCSymbol> comparator = Comparator.comparingInt(OCSymbol::getOffset);
            this.myInputVariables.sort(comparator);
            this.myOutputVariables.sort(comparator);
            this.myWrittenVariables.sort(comparator);
            this.myEscapedDeclarators.sort(comparator);
        }
    }

    private void analyzeInputOutput(@NotNull OCSymbol symbol) {
        if (this.mySelection == null) {
            return;
        }
        OCInputOutputVariablesFinder finder = new OCInputOutputVariablesFinder(this.myGraph, symbol, this.mySelection);
        finder.process();
        boolean needUsages = false;
        if (finder.isInputVariable()) {
            this.myInputVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isOutputVariable()) {
            this.myOutputVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isWrittenVariable()) {
            this.myWrittenVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isEscapedDeclarator()) {
            this.myEscapedDeclarators.add(symbol);
            needUsages = true;
        }
        if (needUsages) {
            this.myVariableUsages.put(symbol, finder.getVariableUsages());
        }
    }

    public List<PsiReference> getVariableUsages(@NotNull OCSymbol symbol) {
        return this.myVariableUsages.get(symbol);
    }

    public boolean hasCrossSelectionJumps() {
        return this.myGraphBuilder.hasCrossSelectionJumps();
    }

    public boolean hasDanglingJumps() {
        return this.myGraphBuilder.hasDanglingJumps();
    }
}

