/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCDataFlowAlgorithm {
    protected OCControlFlowGraph myCfg;
    protected boolean[] myProcessedNodes;

    protected OCDataFlowAlgorithm(OCControlFlowGraph cfg) {
        this.myCfg = cfg;
        this.myProcessedNodes = new boolean[this.myCfg.getNumOfNodes()];
    }

    public abstract void process();

    protected void traverse(@NotNull OCNode node, @Nullable OCSymbol symbol, @Nullable OCInstruction endInstruction, boolean isForward) {
        if (this.isNodeProcessed(node, symbol)) {
            return;
        }
        this.markNodeAsProcessed(node, symbol);
        if (!this.processNode(node, symbol, isForward, null, endInstruction)) {
            return;
        }
        List<OCNode> jumpTargets = this.getJumpTargets(node, isForward);
        if (jumpTargets != null) {
            for (OCNode target : jumpTargets) {
                this.traverse(target, symbol, endInstruction, isForward);
            }
        } else if (!this.myCfg.getExitNodes().contains(node)) {
            this.processDeadEnd(node);
        }
        this.nodeProcessed(node);
    }

    protected void traverse(@NotNull OCInstruction instruction, @Nullable OCSymbol symbol, boolean isForward) {
        OCNode node = instruction.getNode();
        if (!this.processNode(node, symbol, isForward, instruction, null)) {
            return;
        }
        List<OCNode> jumpTargets = this.getJumpTargets(node, isForward);
        if (jumpTargets != null) {
            for (OCNode targetNode : jumpTargets) {
                this.traverse(targetNode, symbol, instruction, isForward);
            }
        }
    }

    protected void traverseFromStart(@Nullable OCSymbol symbol) {
        this.traverse(this.myCfg.getStartNode(), symbol, null, true);
    }

    @NotNull
    protected Collection<OCInstruction> getStartInstructions() {
        ArrayList<OCInstruction> result = new ArrayList<OCInstruction>();
        for (OCInstruction instruction : this.myCfg.getAllInstructions()) {
            if (!this.isStartInstruction(instruction)) continue;
            result.add(instruction);
        }
        return result;
    }

    protected boolean acceptsInstruction(@NotNull OCInstruction instruction) {
        return instruction.getKind() != OCInstruction.InstructionKind.KILL;
    }

    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        return false;
    }

    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        return false;
    }

    protected boolean processInstruction(@NotNull OCInstruction instruction) {
        return this.acceptsInstruction(instruction);
    }

    protected boolean processNode(@NotNull OCNode node, @Nullable OCSymbol symbol, boolean isForward, @Nullable OCInstruction startInstruction, @Nullable OCInstruction endInstruction) {
        List instructions = node.getInstructions();
        if (instructions == null || symbol == null) {
            return true;
        }
        boolean afterInstruction = startInstruction == null;
        for (OCInstruction instruction : isForward ? instructions : ContainerUtil.reverse(instructions)) {
            if (instruction.getSymbolOffset() == symbol.getComplexOffset()) {
                if (startInstruction == instruction) {
                    afterInstruction = true;
                } else if (afterInstruction && !this.processInstruction(instruction)) {
                    return false;
                }
            }
            if (instruction != endInstruction) continue;
            break;
        }
        return true;
    }

    protected boolean isProcessed(@NotNull OCInstruction instruction, boolean isForward) {
        OCNode node = instruction.getNode();
        List instructions = node.getInstructions();
        if (instructions == null) {
            return this.isNodeProcessed(node, instruction.getSymbol());
        }
        boolean beforeInstruction = false;
        for (OCInstruction prevInstruction : isForward ? ContainerUtil.reverse(instructions) : instructions) {
            if (prevInstruction.getSymbolOffset() != instruction.getSymbolOffset()) continue;
            if (prevInstruction == instruction) {
                beforeInstruction = true;
                continue;
            }
            if (!beforeInstruction) continue;
            if (this.isStartInstruction(prevInstruction)) {
                return true;
            }
            if (this.acceptsInstruction(prevInstruction)) continue;
            return false;
        }
        return this.isNodeProcessed(node, instruction.getSymbol());
    }

    @NotNull
    protected List<PsiElement> getReachableElements(boolean isForward, @NotNull OCSymbol symbol, boolean nonReachable) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(symbol);
        if (instructions == null) {
            return result;
        }
        for (OCInstruction instruction : instructions.values()) {
            PsiElement element;
            if (!this.isEndInstruction(instruction) || !(nonReachable ^ this.isProcessed(instruction, isForward)) || (element = this.getElementFromInstruction(instruction)) == null) continue;
            result.add(element);
        }
        return result;
    }

    @Nullable
    protected PsiElement getElementFromInstruction(@NotNull OCInstruction instruction) {
        return instruction.getRValue();
    }

    @Nullable
    protected List<OCNode> getJumpTargets(@NotNull OCNode node, boolean isForward) {
        return isForward ? node.getJumpTargets() : node.getJumpSources();
    }

    protected void nodeProcessed(@NotNull OCNode node) {
    }

    protected void processDeadEnd(@NotNull OCNode node) {
    }

    protected boolean isNodeProcessed(@NotNull OCNode node, @Nullable OCSymbol symbol) {
        return this.myProcessedNodes[node.getIndex()];
    }

    protected void markNodeAsProcessed(@NotNull OCNode node, @Nullable OCSymbol symbol) {
        this.myProcessedNodes[node.getIndex()] = true;
    }

    protected void clearProcessedNodes() {
        for (int i = 0; i < this.myCfg.getNumOfNodes(); ++i) {
            this.myProcessedNodes[i] = false;
        }
    }

    protected static List<OCElementsRange> getRanges(@NotNull List<OCNode> nodes, boolean mergeRanges) {
        List<OCElementsRange> rawRanges = ContainerUtil.mapNotNull(nodes, node -> node.getRange());
        return mergeRanges ? OCElementsRange.mergeRanges(rawRanges, true, true) : rawRanges;
    }
}

