/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.psi.OCFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCLegacyAnnotator
extends OCAnnotator {
    private static final OCAnnotatorEnabler DEFAULT_ENABLER = new OCAnnotatorEnabler(true, true);
    private static final Key<OCAnnotatorEnabler> CLANGD_ANNOTATOR_ENABLER = Key.create((String)"CLANGD_ANNOTATOR_ENABLER");

    public static void enable(@NotNull Project project, boolean enabledIfLegacy, boolean legacyIfObjC) {
        project.putUserData(CLANGD_ANNOTATOR_ENABLER, (Object)new OCAnnotatorEnabler(enabledIfLegacy, legacyIfObjC));
    }

    public static void stopEnabling(@NotNull Project project) {
        project.putUserData(CLANGD_ANNOTATOR_ENABLER, null);
    }

    public static boolean isEnabledFor(@NotNull PsiFile file) {
        OCAnnotatorEnabler enabler = (OCAnnotatorEnabler)file.getProject().getUserData(CLANGD_ANNOTATOR_ENABLER);
        return enabler == null || enabler.isEnabled(file);
    }

    @Override
    protected boolean isEnabled(@NotNull PsiFile file) {
        return super.isEnabled(file) && OCLegacyAnnotator.getEnabler(file.getProject(), this.getHolder()).isEnabled(file);
    }

    @NotNull
    private static OCAnnotatorEnabler getEnabler(@NotNull Project project, @Nullable AnnotationHolder holder) {
        OCAnnotatorEnabler projectEnabler = (OCAnnotatorEnabler)project.getUserData(CLANGD_ANNOTATOR_ENABLER);
        if (projectEnabler != null) {
            return projectEnabler;
        }
        return DEFAULT_ENABLER;
    }

    private static final class OCAnnotatorEnabler {
        private final boolean myIsLegacyEnabled;
        private final boolean myLegacyIfObjc;

        private OCAnnotatorEnabler(boolean isLegacyEnabled, boolean legacyIfObjc) {
            this.myIsLegacyEnabled = isLegacyEnabled;
            this.myLegacyIfObjc = legacyIfObjc;
        }

        private boolean isEnabled(@NotNull PsiFile file) {
            if (this.myLegacyIfObjc && file instanceof OCFile && ((OCFile)file).getKind().isObjC()) {
                return true;
            }
            return this.myIsLegacyEnabled;
        }
    }
}

