/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.FileWideHighlighterPass;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableHelper;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileWideHighlighterFactory
implements TextEditorHighlightingPassFactory {
    private final int myPassId;

    public FileWideHighlighterFactory(@NotNull Project project) {
        this.myPassId = TextEditorHighlightingPassRegistrar.getInstance((Project)project).registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    public static void clearHighlightings(@NotNull Project project, @NotNull Document document) {
        int passId = ((FileWideHighlighterFactory)project.getComponent(FileWideHighlighterFactory.class)).myPassId;
        UpdateHighlightersUtil.setHighlightersToEditor((Project)project, (Document)document, (int)0, (int)document.getTextLength(), Collections.emptyList(), null, (int)passId);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (FileSymbolTableHelper.isSourceFile(file)) {
            return new FileWideHighlighterPass(file, editor.getDocument());
        }
        return null;
    }
}

