/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.autoImport;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.hmap.OCHeaderMap;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapManager;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.settings.OCCodeInsightSettings;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderMapRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoots;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.SurrogateSearchRoot;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDefaultAutoImportHelper
implements OCAutoImportHelper {
    @Override
    public boolean supports(@NotNull OCResolveRootAndConfiguration rootAndConfiguration) {
        return true;
    }

    @Override
    public boolean processPathSpecificationToInclude(@NotNull Project project, @Nullable VirtualFile targetFile, @NotNull VirtualFile fileToImport, @NotNull OCResolveRootAndConfiguration rootAndConfig, @NotNull Processor<OCAutoImportHelper.ImportSpecification> processor) {
        VirtualFile targetFileParent;
        VirtualFile virtualFile = targetFileParent = targetFile != null ? targetFile.getParent() : null;
        if (targetFileParent != null && targetFileParent.equals(fileToImport.getParent()) && !processor.process((Object)new OCAutoImportHelper.ImportSpecification(fileToImport.getName(), OCAutoImportHelper.ImportSpecification.Kind.PROJECT_HEADER))) {
            return false;
        }
        boolean isUnderSearchPaths = false;
        OCResolveConfiguration config = rootAndConfig.getConfiguration();
        HeadersSearchRoots searchRoots = config != null ? config.getCompilerSettings(rootAndConfig.getKind(), rootAndConfig.getRootFile()).getHeadersSearchRoots() : HeadersSearchRoots.EMPTY;
        for (HeadersSearchRoot root : searchRoots.getAllRoots()) {
            VirtualFile rootBase = root.getVirtualFile();
            if (root instanceof HeaderMapRoot) {
                if (OCDefaultAutoImportHelper.processHeaderMapRoot(project, fileToImport, (HeaderMapRoot)root, rootAndConfig, processor)) continue;
                return false;
            }
            if (!(root instanceof SurrogateSearchRoot)) {
                if (rootBase == null || !VfsUtilCore.isAncestor((VirtualFile)rootBase, (VirtualFile)fileToImport, (boolean)true)) continue;
                isUnderSearchPaths = true;
                if (root instanceof IncludedHeadersRoot) {
                    boolean recursive = ((IncludedHeadersRoot)root).isRecursive();
                    boolean preferQuotes = ((IncludedHeadersRoot)root).preferQuotes();
                    if (OCDefaultAutoImportHelper.processIncludedHeadersRoot(fileToImport, root.getVirtualFile(), recursive, root.getKind(), preferQuotes, processor)) continue;
                    return false;
                }
            }
            if (!(root instanceof FrameworksSearchRoot)) continue;
            FrameworksSearchRoot frameworksRoot = (FrameworksSearchRoot)root;
            Ref found = new Ref();
            frameworksRoot.processChildren(element -> {
                if (!(element instanceof AppleFramework)) {
                    return true;
                }
                if (((AppleFramework)element).containsHeader(fileToImport)) {
                    found.set((Object)((AppleFramework)element));
                    return false;
                }
                return true;
            });
            AppleFramework framework = (AppleFramework)found.get();
            if (framework == null) continue;
            VirtualFile frameworkHeader = ModuleMapUtil.getMainFile(framework);
            if (frameworkHeader == null) {
                frameworkHeader = fileToImport;
            }
            if (OCDefaultAutoImportHelper.processImportSpecification(framework.getName() + "/" + frameworkHeader.getName(), HeadersSearchPath.Kind.FRAMEWORK, processor)) continue;
            return false;
        }
        if (!isUnderSearchPaths) {
            String relativePath;
            String string = relativePath = targetFileParent != null ? FileUtil.getRelativePath((String)targetFileParent.getPath(), (String)fileToImport.getPath(), (char)'/') : null;
            if (relativePath != null && !processor.process((Object)new OCAutoImportHelper.ImportSpecification(relativePath, OCAutoImportHelper.ImportSpecification.Kind.fromHeaderSearchPathKind(HeadersSearchPath.Kind.USER), false, false))) {
                return false;
            }
        }
        return true;
    }

    public static boolean processHeaderMapRoot(@NotNull Project project, @NotNull VirtualFile fileToImport, @NotNull HeaderMapRoot root, @NotNull OCResolveRootAndConfiguration rootAndConfig, @NotNull Processor<? super OCAutoImportHelper.ImportSpecification> processor) {
        OCHeaderMap headerMap = OCHeaderMapManager.getInstance(project).getHeaderMap(root);
        if (headerMap == null) {
            return true;
        }
        for (Map.Entry mapping : headerMap.entrySet()) {
            if (!FileUtil.namesEqual((String)fileToImport.getName(), (String)PathUtil.getFileName((String)((String)mapping.getValue())))) continue;
            OCIncludeSymbol.IncludePath includePath = new OCIncludeSymbol.IncludePath((String)mapping.getKey(), root.getKind().isSystem());
            VirtualFile mappedFile = OCIncludeHelpers.resolveIncludedFile(rootAndConfig, rootAndConfig.getRootFile(), includePath, project);
            if (!Objects.equals(mappedFile, fileToImport) || OCDefaultAutoImportHelper.processImportSpecification((String)mapping.getKey(), root.getKind(), processor)) continue;
            return false;
        }
        return true;
    }

    public static boolean processIncludedHeadersRoot(@NotNull VirtualFile fileToImport, @NotNull VirtualFile rootBase, boolean recursive, @NotNull HeadersSearchPath.Kind kind, boolean preferQuotes, @NotNull Processor<? super OCAutoImportHelper.ImportSpecification> processor) {
        String path;
        String string = path = recursive ? fileToImport.getName() : VfsUtilCore.getRelativePath((VirtualFile)fileToImport, (VirtualFile)rootBase);
        if (path == null) {
            OCLog.LOG.error("Cannot calculate relative path: \n\tbase: " + rootBase + "\n\tchild: " + fileToImport);
        }
        if (preferQuotes && kind == HeadersSearchPath.Kind.SYSTEM && OCCodeInsightSettings.getInstance().LOCAL_FILES_WITH_QUOTES) {
            kind = HeadersSearchPath.Kind.USER;
        }
        return OCDefaultAutoImportHelper.processImportSpecification(Objects.requireNonNull(path), kind, processor);
    }

    public static boolean processImportSpecification(@NotNull String path, @NotNull HeadersSearchPath.Kind kind, @NotNull Processor<? super OCAutoImportHelper.ImportSpecification> processor) {
        return processor.process((Object)new OCAutoImportHelper.ImportSpecification(path, OCAutoImportHelper.ImportSpecification.Kind.fromHeaderSearchPathKind(kind)));
    }

    @Override
    public void addHeaderSearchPath(@NotNull Project project, @Nullable VirtualFile targetFile, @NotNull VirtualFile fileToImport) {
    }

    @Override
    @NotNull
    public Iterable<IntentionAction> getAddHeaderSearchPathFixes(@NotNull Project project, @NotNull VirtualFile targetFile, @NotNull String fileNameToImport) {
        return Collections.emptyList();
    }
}

