/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.asm;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.asm.AsmLanguage;
import com.jetbrains.cidr.lang.asm.AsmLexer;
import com.jetbrains.cidr.lang.asm.parser.AsmParser;
import com.jetbrains.cidr.lang.asm.psi.AsmFile;
import com.jetbrains.cidr.lang.asm.psi.AsmTypes;
import org.jetbrains.annotations.NotNull;

public class AsmParserDefinition
implements ParserDefinition {
    public static final TokenSet WHITE_SPACES = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
    public static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{AsmTypes.LINE_COMMENT, AsmTypes.BLOCK_COMMENT});
    public static final IFileElementType FILE = new IFileElementType(Language.findInstance(AsmLanguage.class));

    @NotNull
    public Lexer createLexer(Project project) {
        return new AsmLexer();
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return WHITE_SPACES;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new AsmParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return FILE;
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        return new AsmFile(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        return AsmTypes.Factory.createElement(node);
    }
}

