/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ClassMap;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.lang.OCTestLineMarkInfo;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCTestFramework {
    public static final ExtensionPointName<OCTestFramework> EP_NAME = ExtensionPointName.create((String)"cidr.lang.testFramework");
    private static final ClassMap<OCTestFramework> frameworksCache = new ClassMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends OCTestFramework> T getInstance(Class<T> clazz) {
        OCTestFramework framework = (OCTestFramework)frameworksCache.get(clazz);
        if (framework == null) {
            ClassMap<OCTestFramework> classMap = frameworksCache;
            synchronized (classMap) {
                framework = (OCTestFramework)frameworksCache.get(clazz);
                if (framework == null) {
                    framework = (OCTestFramework)EP_NAME.findExtension(clazz);
                    frameworksCache.put(clazz, (Object)framework);
                }
            }
        }
        return (T)framework;
    }

    @Contract(value="null -> true")
    public abstract boolean isAvailable(@Nullable PsiFile var1);

    public boolean hasSuspendedTestIndex(@NotNull PsiFile file) {
        return false;
    }

    public void resumeTestIndex(@NotNull PsiFile file) {
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestClassOrStruct(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        return false;
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestMethodOrFunction(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        return false;
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestNamespace(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        return false;
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestGlobalVar(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        return false;
    }

    @Contract(value="null -> null")
    public abstract OCTestLineMarkInfo getTestLineMarkInfo(@Nullable PsiElement var1);

    @Nullable
    public CidrTestScopeElement generateVirtualTestScopeElement(String suitePath, String testPath, @NotNull String testSource) {
        return null;
    }

    @Nullable
    public String generateTestPath(String suitePath, String testPath, @NotNull String testSource) {
        CidrTestScopeElement Elem = this.generateVirtualTestScopeElement(suitePath, testPath, testSource);
        if (Elem != null) {
            return Elem.getTestPath();
        }
        return null;
    }
}

