/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class OCQualifiedNameProvider
implements QualifiedNameProvider {
    public PsiElement adjustElementToCopy(@NotNull PsiElement element) {
        return null;
    }

    public String getQualifiedName(@NotNull PsiElement element) {
        if (element instanceof OCSymbolDeclarator) {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            if (symbol instanceof OCSymbolWithParent) {
                return ((OCSymbolWithParent)symbol).getNameWithParent(OCResolveContext.forPsi(element));
            }
            if (symbol != null) {
                return symbol.getName();
            }
        }
        return null;
    }

    public PsiElement qualifiedNameToElement(@NotNull String fqn, @NotNull Project project) {
        OCSymbol clazz;
        if (!FileSymbolTablesCache.areSymbolsLoaded(project)) {
            return null;
        }
        Pattern pattern = Pattern.compile(".\\[([^ ]*) ([^ ]*)\\]");
        Matcher matcher = pattern.matcher(fqn);
        if (!matcher.matches()) {
            pattern = Pattern.compile("([^.]*).([^.]*)]");
            matcher = pattern.matcher(fqn);
        }
        if (matcher.matches() && (clazz = OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project, matcher.group(1), null, null)) instanceof OCClassSymbol) {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            ((OCClassSymbol)clazz).processMembersInAllCategories(matcher.group(2), OCMemberSymbol.class, finder, false, project);
            return finder.isFound() ? ((OCMemberSymbol)finder.getFoundValue()).locateDefinition(project) : null;
        }
        OCSymbol symbol = OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project, fqn, null, null);
        return symbol != null ? symbol.locateDefinition(project) : null;
    }

    public void insertQualifiedName(@NotNull String fqn, @NotNull PsiElement element, @NotNull Editor editor, @NotNull Project project) {
        Object string = fqn;
        if (element instanceof OCSymbolDeclarator) {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            if (symbol instanceof OCMethodSymbol) {
                string = "@selector(" + symbol.getName() + ")";
            } else if (symbol instanceof OCPropertySymbol) {
                string = ((OCPropertySymbol)symbol).getParent() + "." + symbol.getName();
            } else if (symbol instanceof OCInstanceVariableSymbol) {
                string = ((OCInstanceVariableSymbol)symbol).getParent() + "->" + symbol.getName();
            }
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)string);
    }
}

