/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.lang.OCLanguageKindContributor;
import com.jetbrains.cidr.lang.OCLanguageUtilsBase;
import com.jetbrains.cidr.lang.lexer.OCTokenTypeProvider;
import com.jetbrains.cidr.lang.light.psi.OCLightFile;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCLanguageUtils
extends OCLanguageUtilsBase {
    private OCLanguageUtils() {
    }

    @NotNull
    public static Language getConfigLanguage() {
        return OCLanguageUtilsBase.getConfigLanguage();
    }

    @NotNull
    public static Language getLightLanguage() {
        return OCLanguageUtilsBase.getLightLanguage();
    }

    @NotNull
    public static Language getSlowLanguage() {
        return OCLanguageUtilsBase.getSlowLanguage();
    }

    @NotNull
    public static FileType getBaseFileType() {
        return OCLanguageUtilsBase.getBaseFileType();
    }

    public static boolean isSupported(@Nullable Language language) {
        return OCLanguageUtilsBase.isSupported((Language)language);
    }

    @Contract(value="null -> false")
    public static boolean isSupported(@Nullable PsiFile file) {
        return file instanceof OCFile || file instanceof OCLightFile && OCLanguageUtils.assertLightPsiOn((Object)file);
    }

    public static boolean isSupported(@NotNull VirtualFile virtualFile) {
        return OCLanguageUtilsBase.isSupported((VirtualFile)virtualFile);
    }

    public static boolean isSupported(@NotNull FileType fileType) {
        return OCLanguageUtilsBase.isSupported((FileType)fileType);
    }

    @Contract(value="null -> false")
    public static boolean supportsResolve(@Nullable PsiFile file) {
        if (file instanceof OCPsiFile) {
            return true;
        }
        return file != null && OCLanguageKindContributor.isSupported(file);
    }

    @Contract(value="null -> null")
    public static OCPsiFile asOCPsiFile(@Nullable PsiFile file) {
        if (file instanceof OCPsiFile) {
            return (OCPsiFile)file;
        }
        return null;
    }

    @Contract(value="_, null -> null")
    public static OCPsiFile asOCPsiFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        return OCLanguageUtils.asOCPsiFile(PsiManager.getInstance((Project)project).findFile(file));
    }

    @Contract(value="null -> null")
    public static OCFile asOCFile(@Nullable PsiFile file) {
        OCPsiFile opf = OCLanguageUtils.asOCPsiFile(file);
        return opf == null ? null : opf.getOCFile();
    }

    @Contract(value="_, null -> null")
    public static OCFile asOCFile(@NotNull Project project, @Nullable VirtualFile file) {
        return OCLanguageUtils.asOCFile(OCLanguageUtils.asOCPsiFile(project, file));
    }

    @Contract(value="!null -> !null; null -> null")
    public static PsiFile tryGetOCFile(@Nullable PsiFile file) {
        OCFile ocFile = OCLanguageUtils.asOCFile(file);
        return ocFile == null ? file : ocFile;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiFile asFileWithOCResolve(@Nullable PsiFile file) {
        OCFile ocFile = OCLanguageUtils.asOCFile(file);
        return ocFile != null ? ocFile : (OCLanguageUtils.supportsResolve(file) ? file : null);
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static PsiFile asFileWithOCResolve(@NotNull Project project, @Nullable VirtualFile file) {
        return file != null ? OCLanguageUtils.asFileWithOCResolve(PsiManager.getInstance((Project)project).findFile(file)) : null;
    }

    @NotNull
    public static CidrLexerSettings createLexerSettingsForContext(@NotNull OCInclusionContext context) {
        CidrLexerSettings.Builder builder2 = new CidrLexerSettings.Builder((CidrTokenTypeProvider)OCTokenTypeProvider.INSTANCE, context.getLanguageKind());
        if (OCCompilerFeaturesHelper.supportsNullability(context)) {
            builder2.allowNullabilityKeywords();
        }
        if (OCCompilerFeaturesHelper.supportsNullabilityNullableResult(context)) {
            builder2.allowNullabilityNullableResultKeywords();
        }
        if (OCCompilerFeaturesHelper.supportsGccAutoType(context)) {
            builder2.allowGccAutoType();
        }
        if (OCCompilerFeaturesHelper.supportsAvailableExpression(context)) {
            builder2.allowAvailabilityExpression();
        }
        if (OCCompilerFeaturesHelper.supportsMsvcExtensions(context)) {
            builder2.allowMsvcExtensions();
        }
        builder2.setLanguageStandard(OCCompilerFeaturesHelper.getLanguageStandard(context, null));
        return builder2.build();
    }
}

