/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestInfoForFile;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.lang.OCTestLineMarkInfo;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class CidrTestWithScopeElementsFramework<TEST_OBJECT extends CidrTestScopeElement>
extends CidrTestFrameworkBase<TEST_OBJECT>
implements CidrTestRunConfigurationLanguageSupport {
    protected final Class<? extends PsiElement>[] myTestHolderClassWithoutMacroCall;
    protected final boolean myCanHaveMacroAsTest;
    protected final boolean myCanHaveNamespaceAsTest;
    protected final boolean myCanHaveClassAsTest;
    protected final boolean myCanHaveFunctionAsTest;
    protected final boolean myCanHaveDeclaratorAsTest;
    protected OCSymbolKind[] myDeclaratorKinds = new OCSymbolKind[]{OCSymbolKind.GLOBAL_VARIABLE};
    protected final Key<Map<String, TEST_OBJECT>> myObjects = Key.create((String)(this.myFrameworkId + " objects"));
    protected final Key<Boolean> myIsDirty = Key.create((String)(this.myFrameworkId + " dirty"));
    protected final Key<Boolean> myIsProcessing = Key.create((String)(this.myFrameworkId + " processing"));
    protected final Key<Boolean> myIsProcessingCanceled = Key.create((String)(this.myFrameworkId + " processing canceled"));
    private final Key<Pair<TEST_OBJECT, Long>> myTestScopeInElementWithVersion = Key.create((String)(this.myFrameworkId + "Test Scope With Version"));

    @SafeVarargs
    protected CidrTestWithScopeElementsFramework(@NonNls @NotNull String testFrameworkId, Class<? extends PsiElement> ... testHolderClass) {
        super(testFrameworkId, testHolderClass);
        this.myTestHolderClassWithoutMacroCall = ContainerUtil.filter((Collection)this.myTestHolderClass, clazz -> !clazz.equals(OCMacroCall.class)).toArray(ArrayUtil.EMPTY_CLASS_ARRAY);
        this.myCanHaveMacroAsTest = this.myTestHolderClass.contains(OCMacroCall.class);
        this.myCanHaveNamespaceAsTest = this.myTestHolderClass.contains(OCCppNamespace.class);
        this.myCanHaveClassAsTest = this.myTestHolderClass.contains(OCStruct.class);
        this.myCanHaveFunctionAsTest = this.myTestHolderClass.contains(OCFunctionDefinition.class);
        this.myCanHaveDeclaratorAsTest = this.myTestHolderClass.contains(OCDeclarator.class);
    }

    @TestOnly
    @NotNull
    public Map<String, TEST_OBJECT> collectTestObjects(@NotNull PsiFile file) {
        Map testObjs;
        HashMap<VirtualFile, CidrTestInfoForFile> indexedTests = this.getIndexedTests(file.getProject());
        CidrTestInfoForFile testInfo = indexedTests.get(file.getVirtualFile());
        if (testInfo != null && (testObjs = (Map)this.myObjects.get((UserDataHolder)testInfo)) != null) {
            return testObjs;
        }
        return Collections.emptyMap();
    }

    @Override
    public void prepareTestIndexLookup(@NotNull PsiFile file) {
        this.getTestObjects(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, TEST_OBJECT> getOrCreateObjects(@NotNull PsiFile actualFile, @NotNull CidrTestInfoForFile infoForFile) {
        boolean isDirty;
        if (infoForFile.getFrameworkVersion() == CidrTestFrameworkVersion.NOT_AVAILABLE) {
            return Collections.emptyMap();
        }
        Map objects = (Map)this.myObjects.get((UserDataHolder)infoForFile);
        boolean bl = isDirty = this.myIsDirty.get((UserDataHolder)infoForFile) == Boolean.TRUE;
        if (objects != null && !isDirty) {
            return objects;
        }
        CidrTestListUpdater updater = this.getUpdater(actualFile.getProject());
        if (!OCTestExecution.canWaitInThisThread()) {
            updater.scheduleUpdate(actualFile.getVirtualFile());
            return Objects.requireNonNullElse(objects, Collections.emptyMap());
        }
        CidrTestInfoForFile cidrTestInfoForFile = infoForFile;
        synchronized (cidrTestInfoForFile) {
            block33: {
                boolean first = true;
                while (this.myIsProcessing.get((UserDataHolder)infoForFile) == Boolean.TRUE) {
                    block32: {
                        if (first) {
                            first = false;
                        }
                        ProgressManager.checkCanceled();
                        try {
                            ((Object)((Object)infoForFile)).wait(250L);
                            if (this.myIsProcessingCanceled.get((UserDataHolder)infoForFile) != Boolean.TRUE) break block32;
                            ProgressManager.checkCanceled();
                            break block33;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.myIsProcessing.get((UserDataHolder)infoForFile) == Boolean.TRUE) continue;
                    return Objects.requireNonNullElse((Map)this.myObjects.get((UserDataHolder)infoForFile), Collections.emptyMap());
                }
                this.myIsProcessing.set((UserDataHolder)infoForFile, (Object)true);
                this.myIsProcessingCanceled.set((UserDataHolder)infoForFile, null);
            }
        }
        try {
            Map<String, TEST_OBJECT> objectsDirectly = this.createTestObjectsDirectly(actualFile);
            Object object = infoForFile;
            synchronized (object) {
                this.myIsDirty.set((UserDataHolder)infoForFile, null);
                this.myObjects.set((UserDataHolder)infoForFile, objectsDirectly);
                updater.incTestInfoVersion();
            }
            object = objectsDirectly;
            return object;
        }
        catch (ProcessCanceledException e) {
            CidrTestInfoForFile cidrTestInfoForFile2 = infoForFile;
            synchronized (cidrTestInfoForFile2) {
                this.myIsProcessingCanceled.set((UserDataHolder)infoForFile, (Object)Boolean.TRUE);
                updater.incTestInfoVersion();
            }
            updater.scheduleUpdate(actualFile.getVirtualFile());
            throw e;
        }
        catch (IndexNotReadyException e) {
            updater.scheduleUpdate(actualFile.getVirtualFile());
            Map map2 = Objects.requireNonNullElse(objects, Collections.emptyMap());
            return map2;
        }
        finally {
            CidrTestInfoForFile cidrTestInfoForFile3 = infoForFile;
            synchronized (cidrTestInfoForFile3) {
                if (this.myIsProcessing.get((UserDataHolder)infoForFile) == Boolean.TRUE) {
                    this.myIsProcessing.set((UserDataHolder)infoForFile, (Object)false);
                    ((Object)((Object)infoForFile)).notifyAll();
                }
            }
        }
    }

    @Override
    protected void initInfo(@NotNull PsiFile file, @NotNull CidrTestInfoForFile newTestInfo) {
        this.getOrCreateObjects(file, newTestInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void copyDirty(@NotNull CidrTestInfoForFile dst, @Nullable CidrTestInfoForFile src) {
        if (src != null) {
            CidrTestInfoForFile cidrTestInfoForFile = dst;
            synchronized (cidrTestInfoForFile) {
                this.myIsDirty.set((UserDataHolder)dst, (Object)Boolean.TRUE);
                this.myObjects.set((UserDataHolder)dst, (Object)((Map)this.myObjects.get((UserDataHolder)src)));
            }
        }
    }

    @NotNull
    public Map<String, TEST_OBJECT> getTestObjects(@NotNull PsiFile file) {
        return this.getOrCreateObjects(file, this.getTestInfo(file));
    }

    public void updateTestsListOrScheduleUpdateIfCannotWait(@NotNull PsiFile file) {
        this.getTestObjects(file);
    }

    @Override
    @Nullable
    protected TEST_OBJECT createFileTestObjectIfPossible(@NotNull PsiFile file) {
        CidrTestScopeElement scope = CidrTestScopeElementImpl.createTestScopeElementForFile((PsiFile)file, () -> CidrTestUtil.createFilePattern(this, () -> CidrTestScope.createEmptyTestScope((String)this.getPatternSeparatorInCommandLine()), file, this::shouldAddToFileScope));
        return (TEST_OBJECT)scope;
    }

    protected boolean shouldAddToFileScope(@NotNull CidrTestScopeElement testScopeElement) {
        return testScopeElement.isTest();
    }

    @NotNull
    protected abstract Map<String, TEST_OBJECT> createTestObjectsDirectly(@NotNull PsiFile var1);

    @NonNls
    @NotNull
    public abstract String getProtocolPrefix();

    public CidrTestScopeElement createTestScopeElementForSuiteAndTest(@Nullable String suite, @Nullable String test) {
        throw new RuntimeException("Not implemented");
    }

    protected TEST_OBJECT getTestObjectFromTestHolder(@NotNull PsiElement maybeTestHolder, @NotNull Set<String> macroNames) {
        Pair pair = (Pair)this.myTestScopeInElementWithVersion.get((UserDataHolder)maybeTestHolder);
        Project project = maybeTestHolder.getProject();
        long modificationCount = this.getPsiFileVersion(maybeTestHolder.getContainingFile());
        if (pair != null && (Long)pair.second == modificationCount) {
            return (TEST_OBJECT)((CidrTestScopeElement)pair.first);
        }
        TEST_OBJECT ret = null;
        boolean saveResultToCache = false;
        if (this.isTestMacroCandidate(maybeTestHolder, macroNames)) {
            ret = this.findTestObjectFromMacro(maybeTestHolder, macroNames);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveNamespaceAsTest && maybeTestHolder instanceof OCCppNamespace) {
            ret = this.extractTestObject(((OCCppNamespace)maybeTestHolder).getSymbol(), project, OCSymbolKind.NAMESPACE);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveClassAsTest && maybeTestHolder instanceof OCStruct) {
            ret = this.extractTestObject(((OCStruct)maybeTestHolder).getSymbol(), project, OCSymbolKind.STRUCT);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveFunctionAsTest && maybeTestHolder instanceof OCFunctionDefinition) {
            ret = this.extractTestObject(((OCFunctionDefinition)maybeTestHolder).getSymbol(), project, OCSymbolKind.FUNCTION_DECLARATION);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveDeclaratorAsTest && maybeTestHolder instanceof OCDeclarator) {
            ret = this.extractTestObject(((OCDeclarator)maybeTestHolder).getSymbol(), project, this.myDeclaratorKinds);
            saveResultToCache = true;
        }
        if (saveResultToCache) {
            this.cacheResultForTestHolder(maybeTestHolder, ret, modificationCount);
        }
        return ret;
    }

    private long getPsiFileVersion(@NotNull PsiFile psiFile) {
        CidrTestInfoForFile info = this.getTestInfo(psiFile);
        long version = info.getFileVersion();
        if (this.myIsDirty.get((UserDataHolder)info) == Boolean.TRUE) {
            version *= -1L;
        }
        return version;
    }

    protected void cacheResultForTestHolder(@NotNull PsiElement maybeTestHolder, @Nullable TEST_OBJECT ret) {
        this.cacheResultForTestHolder(maybeTestHolder, ret, this.getFileVersion(maybeTestHolder.getContainingFile()));
    }

    protected void cacheResultForTestHolder(@NotNull PsiElement maybeTestHolder, @Nullable TEST_OBJECT ret, long version) {
        this.myTestScopeInElementWithVersion.set((UserDataHolder)maybeTestHolder, (Object)Pair.create(ret, (Object)version));
    }

    @Contract(value="null, _, _ -> null")
    protected TEST_OBJECT extractTestObject(@Nullable OCSymbol symbol, @NotNull Project project, OCSymbolKind ... kinds) {
        if (symbol == null) {
            return null;
        }
        PsiFile file = symbol.getContainingPsiFile(project);
        if (file != null && this.isAvailable(file)) {
            for (OCSymbolKind canBe : kinds) {
                if (symbol.getKind() != canBe) continue;
                OCResolveContext context = OCResolveContext.forSymbol(symbol, project);
                String key = this.getTestObjectKeyForSymbol(symbol, context);
                return (TEST_OBJECT)((CidrTestScopeElement)this.getTestObjects(file).get(key));
            }
        }
        return null;
    }

    @Nullable
    protected String getTestObjectKeyForSymbol(@NotNull OCSymbol symbol, OCResolveContext context) {
        if (!(symbol instanceof OCSymbolWithQualifiedName)) {
            return null;
        }
        return CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)symbol, context);
    }

    @Contract(value="null, null, _, _, _ -> false")
    protected boolean standardProbe(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Class<?> clazz, @NotNull Project project, OCSymbolKind ... symbolKind) {
        if (symbol == null && clazz.isInstance(element)) {
            symbol = ((OCSymbolDeclarator)element).getSymbol();
        }
        return this.extractTestObject(symbol, project, symbolKind) != null;
    }

    protected TEST_OBJECT findTestObjectFromMacro(@NotNull PsiElement maybeMacro, @NotNull Set<String> testMacroNames) {
        Ref ref = new Ref();
        ((OCMacroCall)maybeMacro).processExpansionLeaves((Processor<? super PsiElement>)((Processor)leaf -> {
            TEST_OBJECT ret;
            OCElement testHolder = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)leaf, (Class[])this.myTestHolderClassWithoutMacroCall);
            if (testHolder != null && testHolder.getComplexOffset() > ((OCMacroCall)maybeMacro).getComplexOffset() && (ret = this.getTestObjectFromTestHolder(testHolder, testMacroNames)) != null) {
                ref.set(ret);
                return false;
            }
            return true;
        }));
        return (TEST_OBJECT)((CidrTestScopeElement)ref.get());
    }

    @Contract(pure=true)
    public boolean isTestMacroCandidate(@NotNull PsiElement element, @NotNull Set<String> testMacroNames) {
        return element instanceof OCMacroCall;
    }

    @Nullable
    public TEST_OBJECT findTestObject(@NotNull String pathToFind, @NotNull Project project, @Nullable GlobalSearchScope scope) throws IndexNotReadyException {
        Ref result = new Ref();
        this.consumeTestObjects(project, (SearchScope)scope, testInfo -> {
            if (pathToFind.equals(testInfo.getTestPath())) {
                result.set(testInfo);
                return false;
            }
            return true;
        });
        return (TEST_OBJECT)((CidrTestScopeElement)result.get());
    }

    @NotNull
    public Collection<TEST_OBJECT> collectTestObjects(@Nullable String pathToFind, @NotNull Project project, @Nullable GlobalSearchScope scope) throws IndexNotReadyException {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.consumeTestObjects(pathToFind, project, scope, (Processor<? super TEST_OBJECT>)processor);
        return processor.getResults();
    }

    public void consumeTestObjects(@Nullable String pathToFind, @NotNull Project project, @Nullable GlobalSearchScope scope, @NotNull Processor<? super TEST_OBJECT> processor) {
        this.consumeTestObjects(project, (SearchScope)scope, testInfo -> {
            if (pathToFind == null) {
                processor.process(testInfo);
                return true;
            }
            int pathToFindLength = pathToFind.length();
            String infoTestPath = testInfo.getTestPath();
            if (infoTestPath.startsWith(pathToFind) && (pathToFindLength == infoTestPath.length() || infoTestPath.charAt(pathToFindLength) == '/')) {
                processor.process(testInfo);
            }
            return true;
        });
    }

    public void consumeTestObjects(@NotNull Project project, @Nullable SearchScope scope, @NotNull Processor<? super TEST_OBJECT> processor) throws IndexNotReadyException {
        LinkedList<VirtualFile> testFirstCollection = new LinkedList<VirtualFile>();
        CidrTestListUpdater.fillCollectionWithTestFirst(this.getPotentialTestHolderRoots(project), testFirstCollection);
        this.consumeTestInfo(project, testFirstCollection.iterator(), scope, (Processor<Pair<PsiFile, CidrTestInfoForFile>>)((Processor)fileAndFileInfo -> {
            for (CidrTestScopeElement testScope : this.getOrCreateObjects((PsiFile)fileAndFileInfo.first, (CidrTestInfoForFile)((Object)((Object)fileAndFileInfo.second))).values()) {
                if (processor.process((Object)testScope)) continue;
                return false;
            }
            return true;
        }));
    }

    @Override
    @Contract(value="null -> null")
    public OCTestLineMarkInfo getTestLineMarkInfo(@Nullable PsiElement testElement) {
        if (testElement == null || CidrTestWithScopeElementsFramework.isMacroInjectedIdOwner(testElement)) {
            return null;
        }
        final CidrTestScopeElement testObject = (CidrTestScopeElement)this.getTestObject(testElement);
        if (testObject != null) {
            return new OCTestLineMarkInfo(){

                @Override
                @NotNull
                public String getUrlInTestTree() {
                    return CidrTestWithScopeElementsFramework.this.getTestUrl(testObject);
                }

                @Override
                public boolean isSuite() {
                    return !testObject.isTest();
                }
            };
        }
        return null;
    }

    @NotNull
    protected String getTestUrl(@NotNull TEST_OBJECT testObject) {
        return this.getProtocolPrefix() + testObject.getTestPath();
    }

    @NotNull
    public GlobalSearchScope getProjectSourcesScope(@NotNull Project project) {
        return OCSearchScope.getProjectSourcesScope(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTestInfo(@NotNull Kryo kryo, @NotNull Output output2, @NotNull CidrTestInfoForFile testInfo) {
        CidrTestScopeSerializer serializer = this.getTestSerializer();
        if (serializer == null) {
            return;
        }
        CidrTestInfoForFile cidrTestInfoForFile = testInfo;
        synchronized (cidrTestInfoForFile) {
            Map map2 = (Map)this.myObjects.get((UserDataHolder)testInfo);
            if (map2 == null) {
                output2.writeInt(0);
            } else {
                output2.writeInt(map2.size());
                map2.forEach((name, testScopeElement) -> {
                    output2.writeString(name);
                    serializer.write(kryo, output2, testScopeElement);
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTestInfo(@NotNull Kryo kryo, @NotNull Input input2, @NotNull CidrTestInfoForFile initTestInfo, @NotNull PsiFile fileWithTest) {
        CidrTestScopeSerializer<TEST_OBJECT> serializer = this.getTestSerializer();
        if (serializer == null) {
            return;
        }
        CidrTestInfoForFile cidrTestInfoForFile = initTestInfo;
        synchronized (cidrTestInfoForFile) {
            HashMap<String, TEST_OBJECT> links = new HashMap<String, TEST_OBJECT>();
            int testCount = input2.readInt();
            for (int i = 0; i < testCount; ++i) {
                String name = input2.readString();
                TEST_OBJECT scopeElement = serializer.read(kryo, input2, fileWithTest);
                if (scopeElement == null) continue;
                links.put(name, scopeElement);
            }
            this.myObjects.set((UserDataHolder)initTestInfo, links);
        }
    }

    @Nullable
    protected CidrTestScopeSerializer<TEST_OBJECT> getTestSerializer() {
        return null;
    }

    public static interface CidrTestScopeSerializer<TEST_OBJECT extends CidrTestScopeElement> {
        public void write(@NotNull Kryo var1, @NotNull Output var2, @NotNull TEST_OBJECT var3);

        @Nullable
        public TEST_OBJECT read(@NotNull Kryo var1, @NotNull Input var2, @NotNull PsiFile var3);
    }
}

