/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.execution.Location;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.MathUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.execution.testing.CTestingBundle;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestIndexingTask;
import com.jetbrains.cidr.execution.testing.CidrTestInfoForFile;
import com.jetbrains.cidr.execution.testing.CidrTestInfoSerializer;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CidrTestListUpdater
implements Disposable,
ModificationTracker {
    public static final int TEST_DETECTION_PASS_RETRY_TIMEOUT = 100;
    public static final int TEST_DETECTION_PASS_RETRY_AFTER_WA_TIMEOUT = 1000;
    public static final int TEST_DETECTION_PASS_RETRY_TIMEOUT_MAX = 30000;
    public static final String SHOW_INDEXING_AS_TASK_ID = "cidr.test.framework.showIndexingAsTask";
    public final Ref<Task.Backgroundable> myFrameworkIndexingTask = new Ref();
    public final HashMap<VirtualFile, CidrTestInfoForFile> myIndexedTests = new HashMap();
    public final LinkedList<VirtualFile> myScheduledFiles = new LinkedList();
    public final MergingUpdateQueue myUpdateQueue;
    public final Project myProject;
    public final CidrTestFrameworkBase<?> myFramework;
    private final Deque<Runnable> myRunWhenIndexed = new ArrayDeque<Runnable>();
    private final Object myRunAfterIndexedLock = new Object();
    private volatile int myMergingTimeSpan;
    private volatile boolean mySkipReadingSerializedTestInfo = false;
    private final AtomicBoolean myFirstScanPending = new AtomicBoolean(true);
    private final AtomicBoolean myNeedSaveFirstScanResults = new AtomicBoolean(true);
    private final AtomicBoolean myLockScheduledFiles = new AtomicBoolean(false);
    private final CidrTestIndexingTask myIndexingTask;
    private volatile ProgressIndicator myFrameworkProgressIndicator;
    private volatile int myTestInfoVersion = 1;
    private volatile int myLocationResolveCount = 0;
    private volatile int mySize = 0;
    private volatile int myIndex = 0;
    private static volatile Boolean ourSchedulingDisabledInTests = null;
    private static volatile boolean ourTaskExecutionDisabledInTests = false;

    CidrTestListUpdater(@NotNull CidrTestFrameworkBase<?> framework, @NotNull Project project) {
        this.myFramework = framework;
        this.myProject = project;
        this.myFrameworkProgressIndicator = null;
        this.myIndexingTask = CidrTestIndexingTask.getInstance(this.myProject);
        this.myIndexingTask.subscribe(this);
        Disposer.register((Disposable)project, (Disposable)this);
        this.myMergingTimeSpan = 100;
        this.myUpdateQueue = new MergingUpdateQueue(this.myFramework.getFrameworkId() + " update", this.myMergingTimeSpan, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this, null, true);
        ApplicationListener postponeIndexingOnWrite = new ApplicationListener(){

            public void beforeWriteActionStart(@NotNull Object action) {
                CidrTestListUpdater.this.myUpdateQueue.suspend();
            }

            public void afterWriteActionFinished(@NotNull Object action) {
                CidrTestListUpdater.this.myUpdateQueue.resume();
                CidrTestListUpdater.this.myUpdateQueue.restartTimer();
            }
        };
        ApplicationManager.getApplication().addApplicationListener(postponeIndexingOnWrite, (Disposable)this);
    }

    public void dispose() {
        this.myIndexingTask.unsubscribe(this);
        this.filterTestHoldersAndWriteIndexedTestInfo(true);
        this.myFramework.dropUpdater(this.myProject);
    }

    @NotNull
    public String getId() {
        return this.myFramework.getFrameworkId();
    }

    public void scheduleUpdate(@NotNull VirtualFile fileToScan) {
        if (this.myFramework.markOnlyNotScheduleForUpdate(fileToScan)) {
            return;
        }
        this.doScheduleUpdate(fileToScan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doScheduleUpdate(@Nullable VirtualFile fileToScan) {
        if (ourSchedulingDisabledInTests == Boolean.TRUE) {
            return;
        }
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            this.initFirstScanUnderSyncIfNeed();
            if (fileToScan != null) {
                CidrTestLog.LOG.assertTrue(!this.myLockScheduledFiles.getPlain());
                this.myScheduledFiles.remove(fileToScan);
                this.myScheduledFiles.addFirst(fileToScan);
            }
            this.mySize = this.myIndex + this.myScheduledFiles.size();
        }
        this.myMergingTimeSpan = 100;
        this.scheduleUpdatePass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIndexing() {
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            return !this.myScheduledFiles.isEmpty();
        }
    }

    public boolean isIndexed() {
        return !this.isIndexing() && !this.myFirstScanPending.get();
    }

    public boolean isSuspended() {
        return this.myIndexingTask.isSuspended();
    }

    public boolean isVisible() {
        return this.myIndexingTask.isVisible();
    }

    public void resume() {
        this.myIndexingTask.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleBulkUpdate(@NotNull HashSet<VirtualFile> mutableForUpdate) {
        boolean needUpdate;
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            this.initFirstScanUnderSyncIfNeed();
            CidrTestLog.LOG.assertTrue(!this.myLockScheduledFiles.getPlain());
            this.myScheduledFiles.forEach(file -> mutableForUpdate.remove(file));
            this.mySize = this.myIndex + this.myScheduledFiles.size();
            this.myScheduledFiles.addAll(mutableForUpdate);
            needUpdate = !this.myScheduledFiles.isEmpty();
        }
        if (needUpdate) {
            this.scheduleUpdatePass();
        }
    }

    private void initFirstScanUnderSyncIfNeed() {
        if (this.myFirstScanPending.compareAndSet(true, false)) {
            CidrTestLog.LOG.assertTrue(!this.myLockScheduledFiles.getPlain());
            CidrTestListUpdater.fillCollectionWithTestFirst(this.myFramework.getPotentialTestHolderRoots(this.myProject), this.myScheduledFiles);
            ReadAction.run(() -> this.filterTestHoldersAndReadTestInfoForScheduledFiles());
        }
    }

    static void fillCollectionWithTestFirst(@NotNull Collection<VirtualFile> holders, @NotNull LinkedList<VirtualFile> collector) {
        holders.forEach(file -> {
            String lowName = StringUtil.toLowerCase((String)file.getName());
            if (StringUtil.contains((CharSequence)lowName, (CharSequence)"test") || StringUtil.endsWith((CharSequence)lowName, (CharSequence)".unit.cc")) {
                collector.addFirst((VirtualFile)file);
            } else {
                collector.addLast((VirtualFile)file);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleUpdatePass() {
        if (this.myIndexingTask.isSuspended()) {
            return;
        }
        Ref<Task.Backgroundable> ref = this.myFrameworkIndexingTask;
        synchronized (ref) {
            if (!this.myUpdateQueue.isEmpty() || this.myFrameworkIndexingTask.get() != null || ourSchedulingDisabledInTests == Boolean.TRUE) {
                return;
            }
            this.myUpdateQueue.setMergingTimeSpan(this.myMergingTimeSpan);
            this.myFrameworkIndexingTask.set((Object)this.getScanTask());
            CidrTestListUpdater.log(this.getId(), " schedule scan");
            this.myUpdateQueue.queue(new Update(this.getId() + " scan"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Ref<Task.Backgroundable> ref = CidrTestListUpdater.this.myFrameworkIndexingTask;
                    synchronized (ref) {
                        Task.Backgroundable task = (Task.Backgroundable)CidrTestListUpdater.this.myFrameworkIndexingTask.get();
                        if (task == null) {
                            CidrTestLog.LOG.warn(CidrTestListUpdater.this.getId() + " Warning: lost update");
                            return;
                        }
                        if (!CidrTestListUpdater.this.myFramework.canStartIndexing(CidrTestListUpdater.this.myProject)) {
                            CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " postpone");
                            CidrTestListUpdater.this.increaseTimeForNextAttempt();
                            CidrTestListUpdater.this.myUpdateQueue.restartTimer();
                            CidrTestListUpdater.this.myUpdateQueue.queue((Update)this);
                            return;
                        }
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            if (!ourTaskExecutionDisabledInTests) {
                                CidrTestListUpdater.this.executeIndexingInBackground(false, task);
                            }
                            return;
                        }
                        CidrTestListUpdater.this.executeIndexingInBackground(Registry.is((String)"cidr.test.framework.debug.mode"), task);
                    }
                }
            });
        }
    }

    private void executeIndexingInBackground(boolean asVerboseFlickeringDebugBackgroundTask, @NotNull Task.Backgroundable task) {
        if (asVerboseFlickeringDebugBackgroundTask) {
            ProgressManager.getInstance().run((Task)task);
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> task.run((ProgressIndicator)(CidrTestListUpdater.showTestIndexingProgress() ? new CidrProgressIndicatorBase() : new ProgressIndicatorBase())));
        }
    }

    public static boolean showTestIndexingProgress() {
        return AdvancedSettings.getBoolean((String)SHOW_INDEXING_AS_TASK_ID);
    }

    @NotNull
    @Contract(value=" -> new")
    private Task.Backgroundable getScanTask() {
        this.myFramework.indexingScheduled(this.myProject);
        return new Task.Backgroundable(this.myProject, CTestingBundle.message("test.indexing.tests", this.myFramework.getFrameworkId()), false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                boolean taskIsFinished;
                Ref<Task.Backgroundable> ref = CidrTestListUpdater.this.myFrameworkIndexingTask;
                synchronized (ref) {
                    CidrTestListUpdater.this.myFrameworkProgressIndicator = indicator;
                }
                indicator.setIndeterminate(false);
                indicator.setFraction(CidrTestListUpdater.this.mySize == 0 ? 0.0 : (double)CidrTestListUpdater.this.myIndex / (double)CidrTestListUpdater.this.mySize);
                Iterator<VirtualFile> iterator = CidrTestListUpdater.this.getScheduledFilesIterator(indicator);
                try {
                    CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " start");
                    ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> CidrTestListUpdater.this.processTestInfo(iterator), (ProgressIndicator)new SensitiveProgressWrapper(indicator));
                    taskIsFinished = false;
                }
                catch (Throwable throwable) {
                    boolean taskIsFinished2 = false;
                    try {
                        Ref<Task.Backgroundable> ref2 = CidrTestListUpdater.this.myFrameworkIndexingTask;
                        synchronized (ref2) {
                            CidrTestListUpdater.this.myFrameworkProgressIndicator = null;
                            if (CidrTestListUpdater.this.myFrameworkIndexingTask.get() == this) {
                                CidrTestListUpdater.this.myFrameworkIndexingTask.set(null);
                            }
                            if (iterator.hasNext()) {
                                CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " re-run scheduled");
                                CidrTestListUpdater.this.increaseTimeForNextAttempt();
                                CidrTestListUpdater.this.scheduleUpdatePass();
                            } else {
                                CidrTestListUpdater.this.myIndex = 0;
                                taskIsFinished2 = true;
                            }
                        }
                    }
                    finally {
                        if (taskIsFinished2 && this.myProject != null) {
                            CidrTestListUpdater.this.myFramework.indexingFinished(this.myProject);
                            ApplicationManager.getApplication().executeOnPooledThread(() -> CidrTestListUpdater.this.runAfterIndexing());
                            CidrTestListUpdater.this.myIndexingTask.updateVisibilityStatus(false, true);
                        }
                    }
                    throw throwable;
                }
                try {
                    Ref<Task.Backgroundable> ref3 = CidrTestListUpdater.this.myFrameworkIndexingTask;
                    synchronized (ref3) {
                        CidrTestListUpdater.this.myFrameworkProgressIndicator = null;
                        if (CidrTestListUpdater.this.myFrameworkIndexingTask.get() == this) {
                            CidrTestListUpdater.this.myFrameworkIndexingTask.set(null);
                        }
                        if (iterator.hasNext()) {
                            CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " re-run scheduled");
                            CidrTestListUpdater.this.increaseTimeForNextAttempt();
                            CidrTestListUpdater.this.scheduleUpdatePass();
                        } else {
                            CidrTestListUpdater.this.myIndex = 0;
                            taskIsFinished = true;
                        }
                    }
                }
                finally {
                    if (taskIsFinished && this.myProject != null) {
                        CidrTestListUpdater.this.myFramework.indexingFinished(this.myProject);
                        ApplicationManager.getApplication().executeOnPooledThread(() -> CidrTestListUpdater.this.runAfterIndexing());
                        CidrTestListUpdater.this.myIndexingTask.updateVisibilityStatus(false, true);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendedUpdatePass() {
        Ref<Task.Backgroundable> ref = this.myFrameworkIndexingTask;
        synchronized (ref) {
            if (this.myFrameworkProgressIndicator != null) {
                this.myFrameworkProgressIndicator.cancel();
            }
        }
    }

    private void increaseTimeForNextAttempt() {
        this.myMergingTimeSpan = MathUtil.clamp((int)(this.myMergingTimeSpan * 2), (int)1000, (int)30000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAfterIndexing() {
        Object object = this.myRunAfterIndexedLock;
        synchronized (object) {
            while (true) {
                Runnable runnable;
                Deque<Runnable> deque = this.myRunWhenIndexed;
                synchronized (deque) {
                    if (this.myRunWhenIndexed.isEmpty()) {
                        break;
                    }
                    runnable = this.myRunWhenIndexed.peekFirst();
                }
                runnable.run();
                deque = this.myRunWhenIndexed;
                synchronized (deque) {
                    this.myRunWhenIndexed.removeFirst();
                }
            }
        }
    }

    protected void processTestInfo(@NotNull Iterator<VirtualFile> iterator) {
        if (this.myFramework.consumeTestInfo(this.myProject, iterator, null, (Processor<Pair<PsiFile, CidrTestInfoForFile>>)((Processor)fileTestInfoPair -> {
            this.myFramework.initInfo((PsiFile)fileTestInfoPair.first, (CidrTestInfoForFile)((Object)((Object)fileTestInfoPair.second)));
            return true;
        }))) {
            CidrTestListUpdater.log(this.getId(), " scan finished");
            this.filterTestHoldersAndWriteIndexedTestInfo(this.myNeedSaveFirstScanResults.compareAndSet(true, false));
        }
    }

    @NotNull
    protected Iterator<VirtualFile> getScheduledFilesIterator(final @NotNull ProgressIndicator indicator) {
        return new Iterator<VirtualFile>(){
            private VirtualFile myProcessingFile = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                LinkedList<VirtualFile> linkedList = CidrTestListUpdater.this.myScheduledFiles;
                synchronized (linkedList) {
                    CidrTestLog.LOG.assertTrue(!CidrTestListUpdater.this.myLockScheduledFiles.getPlain());
                    if (this.myProcessingFile != null) {
                        if (!CidrTestListUpdater.this.myScheduledFiles.remove(this.myProcessingFile)) {
                            CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " Warning: lost processing file:", this.myProcessingFile);
                        } else {
                            CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " Processed:", this.myProcessingFile);
                        }
                        this.myProcessingFile = null;
                    }
                    return !CidrTestListUpdater.this.myScheduledFiles.isEmpty();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VirtualFile next() {
                String textInfo = null;
                try {
                    LinkedList<VirtualFile> linkedList = CidrTestListUpdater.this.myScheduledFiles;
                    synchronized (linkedList) {
                        CidrTestLog.LOG.assertTrue(!CidrTestListUpdater.this.myLockScheduledFiles.getPlain());
                        this.myProcessingFile = !CidrTestListUpdater.this.myScheduledFiles.isEmpty() ? CidrTestListUpdater.this.myScheduledFiles.peek() : null;
                        CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " Processing file:", this.myProcessingFile == null ? "(null)" : this.myProcessingFile);
                        if (CidrTestListUpdater.this.mySize > 0 && this.myProcessingFile != null) {
                            indicator.setFraction(CidrTestListUpdater.this.getFraction());
                            ++CidrTestListUpdater.this.myIndex;
                            textInfo = this.myProcessingFile.getPresentableUrl();
                            indicator.setText2(textInfo);
                        }
                        VirtualFile virtualFile = this.myProcessingFile;
                        return virtualFile;
                    }
                }
                finally {
                    if (textInfo != null) {
                        CidrTestListUpdater.this.myIndexingTask.updateTextInfo(CidrTestListUpdater.this.myFramework.getFrameworkId(), textInfo);
                    }
                }
            }
        };
    }

    public double getFraction() {
        return this.mySize == 0 ? 1.0 : (double)this.myIndex / (double)this.mySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterTestHoldersAndWriteIndexedTestInfo(boolean saveTestInfo) {
        CidrTestLog.LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        Condition<VirtualFile> potentialValidTestHolder = this.myFramework.isPotentialValidTestHolder(this.myProject);
        HashMap<VirtualFile, CidrTestInfoForFile> hashMap = this.myIndexedTests;
        synchronized (hashMap) {
            ArrayList<Map.Entry<VirtualFile, CidrTestInfoForFile>> entries = new ArrayList<Map.Entry<VirtualFile, CidrTestInfoForFile>>(this.myIndexedTests.entrySet());
            CidrTestInfoSerializer serializer = new CidrTestInfoSerializer(this.myProject, this.myFramework);
            entries.forEach((Consumer<Map.Entry<VirtualFile, CidrTestInfoForFile>>)((Consumer<Map.Entry>)entry -> {
                VirtualFile virtualFile = (VirtualFile)entry.getKey();
                if (!potentialValidTestHolder.value((Object)virtualFile)) {
                    CidrTestListUpdater.log(this.getId(), " remove info about ", virtualFile);
                    this.myIndexedTests.remove(virtualFile);
                } else if (saveTestInfo) {
                    CidrTestListUpdater.log(this.getId(), " save info about ", virtualFile);
                    serializer.writeTestInfo(virtualFile, (CidrTestInfoForFile)((Object)((Object)entry.getValue())));
                }
            }));
        }
    }

    public void incTestInfoVersion() {
        ++this.myTestInfoVersion;
    }

    public long getModificationCount() {
        return this.myTestInfoVersion;
    }

    @NotNull
    public List<Location> getLocation(@NotNull Computable<List<Location>> findLocationsInScope) {
        ++this.myLocationResolveCount;
        return CidrTestFrameworkBase.getFromSymbols(Collections.emptyList(), this.myProject, findLocationsInScope);
    }

    public static void log(@NonNls @NotNull String message, Object ... details) {
        CidrTestLog.LOG.debug(message, details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenIndexed(Runnable runnable) {
        Deque<Runnable> deque = this.myRunWhenIndexed;
        synchronized (deque) {
            if (this.myFirstScanPending.get()) {
                this.doScheduleUpdate(null);
            }
            if (this.isIndexing()) {
                this.myRunWhenIndexed.addLast(runnable);
                return;
            }
        }
        runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterTestHoldersAndReadTestInfoForScheduledFiles() {
        CidrTestLog.LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            if (this.mySkipReadingSerializedTestInfo) {
                this.mySkipReadingSerializedTestInfo = false;
                return;
            }
            HashSet filesWithActualTestInfo = new HashSet();
            CidrTestInfoSerializer serializer = new CidrTestInfoSerializer(this.myProject, this.myFramework);
            CidrTestLog.LOG.assertTrue(this.myLockScheduledFiles.compareAndSet(false, true));
            try {
                this.myScheduledFiles.forEach(vf -> {
                    Pair<Boolean, CidrTestInfoForFile> actualAndTestInfo = serializer.filterTestHoldersAndReadTestInfo((VirtualFile)vf);
                    if (actualAndTestInfo != null) {
                        if (actualAndTestInfo.second != null) {
                            this.myIndexedTests.put((VirtualFile)vf, (CidrTestInfoForFile)((Object)((Object)actualAndTestInfo.second)));
                        }
                        if (((Boolean)actualAndTestInfo.first).booleanValue()) {
                            filesWithActualTestInfo.add(vf);
                        }
                    }
                });
            }
            finally {
                CidrTestLog.LOG.assertTrue(this.myLockScheduledFiles.compareAndSet(true, false));
            }
            this.myScheduledFiles.removeAll(filesWithActualTestInfo);
        }
    }

    public void dropTestInfo(boolean blockReadingSerializedTestInfo) {
        this.cancelTestIndexing(true, blockReadingSerializedTestInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTestIndexing(boolean dropCollectedInfo, boolean blockReadingSerializedTestInfo) {
        Object object = this.myFrameworkIndexingTask;
        synchronized (object) {
            this.myUpdateQueue.cancelAllUpdates();
            this.myFrameworkIndexingTask.set(null);
        }
        object = this.myScheduledFiles;
        synchronized (object) {
            CidrTestLog.LOG.assertTrue(!this.myLockScheduledFiles.getPlain());
            if (dropCollectedInfo) {
                this.myIndexedTests.clear();
                this.myFirstScanPending.set(true);
            }
            this.myScheduledFiles.clear();
            this.mySize = 0;
            this.myIndex = 0;
            this.mySkipReadingSerializedTestInfo = blockReadingSerializedTestInfo;
        }
    }

    @TestOnly
    public Iterator<VirtualFile> getScheduledFilesIterator() {
        return this.getScheduledFilesIterator((ProgressIndicator)new EmptyProgressIndicator());
    }

    @TestOnly
    public Collection<VirtualFile> getProcessingQueue() {
        CidrTestLog.LOG.assertTrue(!this.myLockScheduledFiles.getPlain());
        return this.myScheduledFiles;
    }

    @TestOnly
    public void processTestInfoDirectly(@NotNull Iterator<VirtualFile> iterator) {
        this.processTestInfo(iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void initFirstScanIfNeedDirectly() {
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            this.initFirstScanUnderSyncIfNeed();
        }
    }

    @TestOnly
    public long getLocationResolveCount() {
        return this.myLocationResolveCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public boolean waitForIndexingToFinish() throws TimeoutException {
        if (ourSchedulingDisabledInTests == Boolean.TRUE) {
            return true;
        }
        Semaphore s = new Semaphore(1);
        Deque<Runnable> deque = this.myRunWhenIndexed;
        synchronized (deque) {
            if (!this.isIndexing() && this.myRunWhenIndexed.isEmpty()) {
                if (!this.myFirstScanPending.get()) {
                    return true;
                }
                this.doScheduleUpdate(null);
            }
            this.myRunWhenIndexed.addLast(() -> ((Semaphore)s).up());
        }
        long limit = 900000L;
        int step = 100;
        while (!s.waitFor((long)step)) {
            DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> FileSymbolTablesCache.getInstance(this.myProject).ensurePendingFilesProcessed());
            if (ApplicationManager.getApplication().isDispatchThread()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            if ((limit -= (long)step) > 0L) continue;
            PerformanceWatcher.dumpThreadsToConsole((String)"Thread dump:");
            throw new TimeoutException();
        }
        Deque<Runnable> deque2 = this.myRunWhenIndexed;
        synchronized (deque2) {
            return this.myRunWhenIndexed.isEmpty();
        }
    }

    public String toString() {
        return "CidrTestListUpdater{" + this.myFramework.getFrameworkId() + "}";
    }

    @TestOnly
    public static void setSchedulingDisabledInTests(Boolean schedulingDisabledInTests) {
        ourSchedulingDisabledInTests = schedulingDisabledInTests;
    }

    @TestOnly
    public static Boolean getSchedulingDisabledInTests() {
        return ourSchedulingDisabledInTests;
    }

    @TestOnly
    public static void setTaskExecutionDisabledInTests(boolean taskExecutionDisabledInTests) {
        ourTaskExecutionDisabledInTests = taskExecutionDisabledInTests;
    }

    class CidrProgressIndicatorBase
    extends AbstractProgressIndicatorExBase
    implements StandardProgressIndicator {
        boolean myFirst = true;
        private final long myStartTimeMs = System.currentTimeMillis();
        private final int myTimeoutBeforeShowTestIndexingUI = AdvancedSettings.getInt((String)"cidr.test.framework.showIndexingAsTask.before.visible.ms");

        CidrProgressIndicatorBase() {
        }

        public final boolean isCanceled() {
            long timeoutMS = System.currentTimeMillis() - this.myStartTimeMs;
            if (timeoutMS > (long)this.myTimeoutBeforeShowTestIndexingUI && this.myFirst) {
                this.myFirst = false;
                CidrTestListUpdater.this.myIndexingTask.showSuspendableTestIndexingTask();
            }
            return super.isCanceled();
        }
    }
}

