/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.FastInput;
import com.esotericsoftware.kryo.io.FastOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestInfoForFile;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.OCSerializer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class CidrTestInfoSerializer
extends OCSerializer {
    private static final int TEST_SERIALIZATION_VERSION = 23;
    private static final int CHUNK_SIZE = 256;
    private static final ConcurrentMap<String, FileAttribute> ourFileAttributeCache = new ConcurrentHashMap<String, FileAttribute>();
    private final FileAttribute myFileTestsAttribute;
    private final CidrTestFrameworkBase<?> myFramework;
    private final PsiManager myPsiManager;
    private PsiFile myPsiFile;

    public CidrTestInfoSerializer(@NotNull Project project, @NotNull CidrTestFrameworkBase<?> framework) {
        this.myFramework = framework;
        this.myFileTestsAttribute = ourFileAttributeCache.computeIfAbsent("file_test_scopes" + this.myFramework.getFrameworkId(), attrName -> new FileAttribute(attrName, 23, false));
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.myFramework.registerSerializers(this);
    }

    public void writeTestInfo(@NotNull VirtualFile vfValidWithTests, @NotNull CidrTestInfoForFile testInfoForFile) {
        try (AttributeOutputStream dos = this.myFileTestsAttribute.writeFileAttribute(vfValidWithTests);
             FastOutput output2 = new FastOutput((OutputStream)dos, 256);){
            output2.writeLong(vfValidWithTests.getTimeStamp());
            this.getKryo().writeObject((Output)output2, (Object)testInfoForFile);
            CidrTestLog.LOG.debug("write:", new Object[]{vfValidWithTests.getName(), " OK"});
        }
        catch (Throwable serializationProblem) {
            CidrTestLog.LOG.warn("Kryo error test write " + vfValidWithTests.getName() + ":" + serializationProblem.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Pair<Boolean, CidrTestInfoForFile> filterTestHoldersAndReadTestInfo(@NotNull VirtualFile vfAny) {
        block14: {
            if (!this.validPotentialTestHolder(vfAny)) {
                return Pair.create((Object)true, null);
            }
            try (AttributeInputStream dis = this.myFileTestsAttribute.readFileAttribute(vfAny);){
                Pair pair;
                if (dis == null) break block14;
                Kryo kryo = this.getKryo();
                try (FastInput input2 = new FastInput((InputStream)dis, 256);){
                    boolean isActual = vfAny.getTimeStamp() == input2.readLong();
                    CidrTestInfoForFile ti = (CidrTestInfoForFile)((Object)kryo.readObject((Input)input2, CidrTestInfoForFile.class));
                    CidrTestLog.LOG.debug("read:", new Object[]{vfAny.getName(), " OK"});
                    pair = Pair.create((Object)isActual, (Object)((Object)ti));
                }
                return pair;
            }
            catch (Throwable serializationProblem) {
                CidrTestLog.LOG.warn("Kryo error test read " + vfAny.getName() + ":" + serializationProblem.getMessage());
            }
        }
        return null;
    }

    private boolean validPotentialTestHolder(@NotNull VirtualFile vfToCheck) {
        if (!vfToCheck.isValid()) {
            return false;
        }
        this.myPsiFile = this.myPsiManager.findFile(vfToCheck);
        return this.myPsiFile != null && this.myFramework.isPotentialTestHolderFile(this.myPsiFile);
    }

    protected void registerSerializers() {
        Kryo kryo = this.getKryo();
        kryo.register(CidrTestFrameworkVersion.class);
        kryo.register(CidrTestInfoForFile.class, (Serializer)new Serializer<CidrTestInfoForFile>(){

            public void write(Kryo kryo, Output output2, CidrTestInfoForFile testInfo) {
                CidrTestFrameworkVersion version = testInfo.getFrameworkVersion();
                kryo.writeObject(output2, (Object)version);
                if (version != CidrTestFrameworkVersion.NOT_AVAILABLE) {
                    CidrTestInfoSerializer.this.myFramework.writeTestInfo(kryo, output2, testInfo);
                }
            }

            public CidrTestInfoForFile read(Kryo kryo, Input input2, Class<CidrTestInfoForFile> type) {
                CidrTestFrameworkVersion version = (CidrTestFrameworkVersion)((Object)kryo.readObject(input2, CidrTestFrameworkVersion.class));
                CidrTestInfoForFile ret = new CidrTestInfoForFile(-1L, version);
                if (version != CidrTestFrameworkVersion.NOT_AVAILABLE) {
                    CidrTestInfoSerializer.this.myFramework.readTestInfo(kryo, input2, ret, CidrTestInfoSerializer.this.myPsiFile);
                }
                return ret;
            }
        });
    }
}

