/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.CTestingBundle;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestIndexProvider;
import com.jetbrains.cidr.execution.testing.CidrTestInfoForFile;
import com.jetbrains.cidr.execution.testing.CidrTestInfoSerializer;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.OCTestFramework;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.preprocessor.OCRootUtil;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.ui.OCLongActionUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestFrameworkBase<TEST_OBJECT>
extends OCTestFramework {
    private final Key<CidrTestListUpdater> myFrameworkKeyForVFUpdater;
    private final Key<Boolean> myUpdateMarker;
    protected final Collection<Class<? extends PsiElement>> myTestHolderClass;
    @NonNls
    @NotNull
    protected final String myFrameworkId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CidrTestListUpdater getUpdater(@NotNull Project project) {
        CidrTestListUpdater updater = (CidrTestListUpdater)this.myFrameworkKeyForVFUpdater.get((UserDataHolder)project);
        if (updater == null) {
            Key<CidrTestListUpdater> key = this.myFrameworkKeyForVFUpdater;
            synchronized (key) {
                updater = (CidrTestListUpdater)this.myFrameworkKeyForVFUpdater.get((UserDataHolder)project);
                if (updater == null) {
                    updater = this.createUpdater(project);
                    this.myFrameworkKeyForVFUpdater.set((UserDataHolder)project, (Object)updater);
                }
            }
        }
        return updater;
    }

    @Override
    public boolean hasSuspendedTestIndex(@NotNull PsiFile file) {
        CidrTestListUpdater updater = this.getUpdater(file.getProject());
        return updater.isSuspended() && !updater.isVisible();
    }

    @Override
    public void resumeTestIndex(@NotNull PsiFile file) {
        this.getUpdater(file.getProject()).resume();
    }

    @NotNull
    protected CidrTestListUpdater createUpdater(@NotNull Project project) {
        return new CidrTestListUpdater(this, project);
    }

    public boolean canStartIndexing(@NotNull Project project) {
        return FileSymbolTablesCache.getInstance(project).isUpToDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropUpdater(@NotNull Project project) {
        Key<CidrTestListUpdater> key = this.myFrameworkKeyForVFUpdater;
        synchronized (key) {
            this.myFrameworkKeyForVFUpdater.set((UserDataHolder)project, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CidrTestInfoForFile getTestInfo(@NotNull PsiFile file) {
        CidrTestInfoForFile infoForFile;
        HashMap<VirtualFile, CidrTestInfoForFile> vf2info;
        Project project = file.getProject();
        if (!this.isPotentialTestHolderFile(file) || !FileSymbolTablesCache.areSymbolsLoaded(project)) {
            return CidrTestInfoForFile.EMPTY_FILE_INFO;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (!this.isPotentialValidTestHolder(project).value((Object)virtualFile)) {
            return CidrTestInfoForFile.EMPTY_FILE_INFO;
        }
        HashMap<VirtualFile, CidrTestInfoForFile> hashMap = vf2info = this.getIndexedTests(project);
        synchronized (hashMap) {
            infoForFile = vf2info.get(virtualFile);
        }
        long fileVersion = this.getFileVersion(file);
        if (infoForFile == null || fileVersion != infoForFile.getFileVersion()) {
            CidrTestListUpdater updater = this.getUpdater(project);
            if (!OCTestExecution.canWaitInThisThread()) {
                updater.scheduleUpdate(virtualFile);
                return infoForFile == null ? CidrTestInfoForFile.EMPTY_FILE_INFO : infoForFile;
            }
            CidrTestInfoForFile newInfoForFile = new CidrTestInfoForFile(fileVersion, this.createFrameworkVersionDirectly(file));
            HashMap<VirtualFile, CidrTestInfoForFile> hashMap2 = vf2info;
            synchronized (hashMap2) {
                this.copyDirty(newInfoForFile, infoForFile);
                vf2info.put(virtualFile, newInfoForFile);
                updater.incTestInfoVersion();
            }
            return newInfoForFile;
        }
        return infoForFile;
    }

    protected abstract long getFileVersion(@NotNull PsiFile var1);

    protected void copyDirty(@NotNull CidrTestInfoForFile dst, @Nullable CidrTestInfoForFile src) {
    }

    protected void initInfo(@NotNull PsiFile file, @NotNull CidrTestInfoForFile newTestInfo) {
    }

    protected void indexingScheduled(@NotNull Project project) {
    }

    protected void indexingFinished(@NotNull Project project) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean consumeTestInfo(@NotNull Project project, @NotNull Iterator<VirtualFile> pfile, @Nullable SearchScope scope, @NotNull Processor<? super Pair<PsiFile, CidrTestInfoForFile>> processor) throws IndexNotReadyException {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        boolean needBulkUpdate = !OCTestExecution.canWaitInThisThread();
        HashSet<VirtualFile> updateList = needBulkUpdate ? new HashSet<VirtualFile>() : null;
        try {
            while (pfile.hasNext()) {
                PsiFile psiFile;
                ProgressManager.checkCanceled();
                VirtualFile file = pfile.next();
                if (!file.isValid() || scope != null && !scope.contains(file) || (psiFile = OCLanguageUtils.tryGetOCFile(psiManager.findFile(file))) == null) continue;
                try {
                    CidrTestInfoForFile info;
                    if (needBulkUpdate) {
                        this.myUpdateMarker.set((UserDataHolder)file, (Object)Boolean.FALSE);
                    }
                    if ((info = this.getTestInfo(psiFile)).getFrameworkVersion() == CidrTestFrameworkVersion.NOT_AVAILABLE || processor.process((Object)Pair.create((Object)psiFile, (Object)((Object)info)))) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (ProcessCanceledException ce) {
                    if (needBulkUpdate) throw ce;
                    pfile.hasNext();
                    CidrTestListUpdater.log("re-schedule after pause/write-action cancel: ", file);
                    this.getUpdater(project).scheduleUpdate(file);
                    throw ce;
                }
                finally {
                    if (!needBulkUpdate) continue;
                    Boolean needUpdate = (Boolean)this.myUpdateMarker.get((UserDataHolder)file);
                    if (needUpdate == Boolean.TRUE) {
                        updateList.add(file);
                    }
                    this.myUpdateMarker.set((UserDataHolder)file, null);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (needBulkUpdate) {
                this.getUpdater(project).scheduleBulkUpdate(updateList);
            }
        }
    }

    public boolean markOnlyNotScheduleForUpdate(@NotNull VirtualFile fileWithOutdatedTestInfo) {
        if (this.myUpdateMarker.get((UserDataHolder)fileWithOutdatedTestInfo) != null) {
            this.myUpdateMarker.set((UserDataHolder)fileWithOutdatedTestInfo, (Object)Boolean.TRUE);
            return true;
        }
        return false;
    }

    public boolean isPotentialTestHolderFile(@NotNull PsiFile file) {
        return OCLanguageUtils.isSupported(file);
    }

    @NotNull
    protected Collection<VirtualFile> getPotentialTestHolderRoots(@NotNull Project project) {
        return (Collection)ReadAction.compute(() -> OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(project));
    }

    protected Condition<VirtualFile> isPotentialValidTestHolder(@NotNull Project project) {
        GlobalSearchScope projectSourcesScope = OCSearchScope.getProjectSourcesScope(project);
        return sourceOrHeader -> sourceOrHeader != null && sourceOrHeader.isValid() && projectSourcesScope.contains(sourceOrHeader);
    }

    public Condition<VirtualFile> isPotentialTestHolderRoot(@NotNull Project project) {
        return maybeSource -> !OCRootUtil.isNeedToFindRoot(maybeSource, project);
    }

    public HashMap<VirtualFile, CidrTestInfoForFile> getIndexedTests(@NotNull Project project) {
        return this.getUpdater((Project)project).myIndexedTests;
    }

    @NotNull
    public String getFrameworkId() {
        return this.myFrameworkId;
    }

    public String toString() {
        return this.getFrameworkId();
    }

    public void prepareTestIndexLookup(@NotNull PsiFile file) {
    }

    @SafeVarargs
    protected CidrTestFrameworkBase(@NonNls @NotNull String testFrameworkId, Class<? extends PsiElement> ... testHolderClass) {
        this.myFrameworkId = testFrameworkId;
        this.myTestHolderClass = Arrays.asList(testHolderClass);
        this.myFrameworkKeyForVFUpdater = Key.create((String)(this.getFrameworkId() + " updater"));
        this.myUpdateMarker = Key.create((String)(this.getFrameworkId() + " marker"));
    }

    @Contract(value="null -> null")
    public TEST_OBJECT getTestObject(@Nullable PsiElement element) {
        if (element != null && this.isAvailable(element.getContainingFile()) && this.canBeTestHolder(element)) {
            this.prepareTestIndexLookup(element.getContainingFile());
            return (TEST_OBJECT)CidrTestIndexProvider.INSTANCE.findTestObject(element, (Function0<? extends CidrTestScopeElement>)((Function0)() -> (CidrTestScopeElement)this.extractTest(element)));
        }
        return null;
    }

    @Nullable
    public TEST_OBJECT findTestObject(@NotNull PsiElement element) {
        PsiElement prev = element;
        for (PsiElement current = element; current != null; current = current.getParent()) {
            TEST_OBJECT testObject;
            OCMacroRange call;
            if (current instanceof PsiFile) {
                return (TEST_OBJECT)(prev instanceof PsiWhiteSpace || prev instanceof PsiComment || prev instanceof PsiFile || this.isNeutralNode(prev) ? this.createFileTestObjectIfPossible((PsiFile)current) : null);
            }
            PsiElement id = CidrTestFrameworkBase.getId(current);
            if (id instanceof OCMacroForeignLeafElement && (call = OCElementUtil.getRangeInMacroCall(id)) != null) {
                current = call.getMacroCall();
            }
            if ((testObject = this.getTestObject(current)) != null) {
                return testObject;
            }
            if (this.isScopeDelimiter(current)) continue;
            prev = current;
        }
        return null;
    }

    @Contract(pure=true)
    protected boolean isScopeDelimiter(@NotNull PsiElement element) {
        return element instanceof OCCppNamespace;
    }

    @Contract(pure=true)
    protected boolean isNeutralNode(@NotNull PsiElement element) {
        return element instanceof OCDirective || element.getParent() instanceof OCCppNamespace && (element == ((OCCppNamespace)element.getParent()).getNameIdentifier() || PsiTreeUtil.findSiblingBackward((PsiElement)element, (IElementType)OCTokenTypes.LBRACE, (boolean)true, null) == null);
    }

    @Nullable
    protected abstract TEST_OBJECT createFileTestObjectIfPossible(@NotNull PsiFile var1);

    public static void checkPrecalculatedSymbols(@NotNull Project project) {
        if (FileSymbolTablesCache.areSymbolsLoaded(project)) {
            return;
        }
        throw IndexNotReadyException.create();
    }

    @Contract(pure=true)
    private boolean canBeTestHolder(@NotNull PsiElement element) {
        for (Class<? extends PsiElement> aClass : this.myTestHolderClass) {
            if (!aClass.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected abstract TEST_OBJECT extractTest(@NotNull PsiElement var1);

    @Override
    @Contract(value="null->true")
    public boolean isAvailable(@Nullable PsiFile file) {
        return file == null || this.getFrameworkVersion(file) != CidrTestFrameworkVersion.NOT_AVAILABLE;
    }

    @NotNull
    public CidrTestFrameworkVersion getFrameworkVersion(@NotNull PsiFile file) {
        return this.getTestInfo(file).getFrameworkVersion();
    }

    @NotNull
    protected abstract CidrTestFrameworkVersion createFrameworkVersionDirectly(@NotNull PsiFile var1);

    @NotNull
    protected static CidrTestFrameworkVersion getFrameworkVersionUsingImportedMacro(@NotNull PsiFile file, @NonNls @NotNull String macroName) {
        Project project = file.getProject();
        CidrTestFrameworkBase.checkPrecalculatedSymbols(project);
        Ref symbolFromFrameworkWasFound = new Ref((Object)CidrTestFrameworkVersion.NOT_AVAILABLE);
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, (Processor<? super OCSymbol>)((Processor)symbol -> {
            ProgressManager.checkCanceled();
            if (symbol instanceof OCMacroSymbol && OCFileSymbols.isSymbolImported(OCLanguageUtils.asOCFile(file), symbol)) {
                symbolFromFrameworkWasFound.set((Object)CidrTestFrameworkVersion.DEFAULT);
                return false;
            }
            return true;
        }), macroName, true);
        return (CidrTestFrameworkVersion)((Object)symbolFromFrameworkWasFound.get());
    }

    @NonNls
    @NotNull
    public abstract String getPatternSeparatorInCommandLine();

    @NotNull
    public static <T extends OCTestFramework> T findExtension(@NotNull Class<T> extClass) {
        return (T)((OCTestFramework)OCTestFramework.EP_NAME.findExtensionOrFail(extClass));
    }

    public static boolean isMacroInjectedIdOwner(@NotNull PsiElement element) {
        if (element.getTextLength() == 0) {
            return true;
        }
        PsiElement identifier = CidrTestFrameworkBase.getId(element);
        return identifier == null || identifier.getTextLength() == 0;
    }

    @Nullable
    public static PsiElement getId(@NotNull PsiElement element) {
        if (element instanceof OCFunctionDeclaration) {
            return ((OCFunctionDeclaration)element).getNameIdentifier();
        }
        if (element instanceof PsiNameIdentifierOwner) {
            return ((PsiNameIdentifierOwner)element).getNameIdentifier();
        }
        if (element instanceof OCMacroCall) {
            return element.getFirstChild();
        }
        return null;
    }

    @Contract(value="!null,_,_->!null")
    public static <T> T getFromSymbols(@Nullable T defaultIfSymbolsNotReady, Project project, @NotNull Computable<? extends T> computable) {
        ProgressIndicator upperIndicator = ProgressManager.getInstance().getProgressIndicator();
        try {
            CidrTestFrameworkBase.checkPrecalculatedSymbols(project);
            if (ApplicationManager.getApplication().isDispatchThread()) {
                return OCLongActionUtil.execWithTimeoutProgressInDispatch(CTestingBundle.message("test.ui.progress", new Object[0]), project, computable);
            }
            Ref result = new Ref();
            if (!ProgressIndicatorUtils.runWithWriteActionPriority(() -> result.set(computable.compute()), (ProgressIndicator)(upperIndicator == null ? new EmptyProgressIndicator() : new SensitiveProgressWrapper(upperIndicator)))) {
                throw new ProcessCanceledException();
            }
            return (T)result.get();
        }
        catch (ProcessCanceledException pce) {
            if (upperIndicator != null) {
                throw pce;
            }
            return defaultIfSymbolsNotReady;
        }
        catch (IndexNotReadyException ignore) {
            if (upperIndicator != null) {
                upperIndicator.cancel();
            }
            return defaultIfSymbolsNotReady;
        }
    }

    public void writeTestInfo(@NotNull Kryo kryo, @NotNull Output output2, @NotNull CidrTestInfoForFile testInfo) {
    }

    public void readTestInfo(@NotNull Kryo kryo, @NotNull Input input2, @NotNull CidrTestInfoForFile initTestInfo, @NotNull PsiFile fileWithTest) {
    }

    public void registerSerializers(@NotNull CidrTestInfoSerializer serializer) {
    }
}

