/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.execution.testing.CTestingBundle;
import com.jetbrains.cidr.lang.OCTestFramework;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.daemon.FileWideHighlighter;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrFileTestHighlighter
implements FileWideHighlighter {
    @Override
    @Nullable
    public HighlightInfo annotate(@NotNull Project project, @NotNull PsiFile file, @NotNull ProgressIndicator progress) {
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        final OCTestFramework fw = OCTestFrameworks.getFrameworkWithSuspendedTestIndex(file);
        if (fw == null) {
            return null;
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range((PsiElement)file).fileLevelAnnotation().description(CTestingBundle.message("inspections.fileChecks.testIndexIsSuspended", fw)).create();
        if (info == null) {
            return null;
        }
        AbstractIntentionAction fix = new AbstractIntentionAction(){

            @Nls
            @NotNull
            public String getText() {
                return CTestingBundle.message("inspections.fileChecks.testIndexIsSuspended.fix", new Object[0]);
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                return CTestingBundle.message("inspections.fileChecks.testIndexIsSuspended.fix.family", new Object[0]);
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                fw.resumeTestIndex(file);
            }
        };
        info.registerFix((IntentionAction)fix, Collections.emptyList(), fix.getText(), file.getTextRange(), null);
        return info;
    }
}

