/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.OCDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCProtocolExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCEvaluatorHelper
extends CidrEvaluatorHelper {
    @NotNull
    private static Pair<OCType, String> convertExpressionPrivate(CidrDebugProcess process2, String originalExpression, @Nullable XSourcePosition position) throws CidrEvaluatorHelper.ConversionException {
        String text;
        PsiFile psiFile;
        OCExpression expression;
        OCType resolvedType = null;
        if (position == null) {
            throw new CidrEvaluatorHelper.ConversionException(OCDebuggerBundle.message("debug.evaluate.error.noExecutionPoint", new Object[0]));
        }
        PsiElement context = process2.getDebuggerContext(position);
        if (context == null) {
            throw new CidrEvaluatorHelper.ConversionException(OCDebuggerBundle.message("debug.evaluate.error.debugInfoIsOutdated", new Object[0]));
        }
        OCFile fragment = OCElementFactory.expressionCodeFragment(originalExpression, context.getProject(), context, false, false);
        if (PsiTreeUtil.hasErrorElements((PsiElement)fragment.getContainingFile())) {
            fragment = OCElementFactory.expressionCodeFragmentCpp(originalExpression, context.getProject(), context, false, false);
        }
        if ((expression = (OCExpression)PsiTreeUtil.findChildOfType((PsiElement)(fragment = OCEvaluatorHelper.preConvertExpression(fragment)), OCExpression.class)) != null && !(expression instanceof OCCastExpression) && (psiFile = PsiManager.getInstance((Project)process2.getProject()).findFile(position.getFile())) != null) {
            if (!OCLanguageUtils.isSupported(psiFile)) {
                throw new CidrEvaluatorHelper.ConversionException(OCDebuggerBundle.message("debug.evaluate.error.cannotEvaluateExpressionForLanguage", psiFile.getLanguage().getDisplayName()));
            }
            resolvedType = expression.getResolvedType(OCResolveContext.forPsi((PsiElement)psiFile));
        }
        if ((text = (fragment = OCEvaluatorHelper.postConvertExpression(fragment)).getText()) == null) {
            CidrDebuggerLog.LOG.error("Fragment text is 'null'" + fragment + "\noriginal expression: " + originalExpression);
            throw new CidrEvaluatorHelper.ConversionException(OCDebuggerBundle.message("debug.evaluate.error.invalidExpression", new Object[0]));
        }
        return Pair.create(resolvedType, (Object)text);
    }

    @NotNull
    private static OCFile preConvertExpression(@NotNull OCFile original) throws CidrEvaluatorHelper.ConversionException {
        OCMacroCall macro;
        LinkedHashSet<String> recursionGuard = new LinkedHashSet<String>();
        while ((macro = (OCMacroCall)PsiTreeUtil.findChildOfType((PsiElement)original, OCMacroCall.class)) != null) {
            Pair<String, TextRange> subst = macro.getReplacementTextAndRange();
            String originalText = original.getText();
            if (!recursionGuard.add(originalText) || recursionGuard.size() > 1000) {
                CidrDebuggerLog.LOG.info("Cannot expands macros. Recursion guard (" + recursionGuard.size() + "):\n" + StringUtil.join(recursionGuard, (String)"\n"));
                throw new CidrEvaluatorHelper.ConversionException(OCDebuggerBundle.message("debug.evaluate.error.cannotSubstituteMacros", new Object[0]));
            }
            String newText = StringUtil.replaceSubstring((String)originalText, (TextRange)((TextRange)subst.second), (String)((String)subst.first));
            original = OCElementFactory.expressionCodeFragment(newText, original.getProject(), original.getContext(), false, false);
        }
        original.accept(new PreConverter());
        return original;
    }

    @NotNull
    private static OCFile postConvertExpression(@NotNull OCFile original) {
        original.accept(new PostConverter());
        return original;
    }

    public String convertExpression(@NotNull CidrDebugProcess process2, String originalExpression, @Nullable XSourcePosition position) throws CidrEvaluatorHelper.ConversionException {
        return (String)OCEvaluatorHelper.convertExpressionPrivate((CidrDebugProcess)process2, (String)originalExpression, (XSourcePosition)position).second;
    }

    public Pair<LLValue, String> convertAndEvaluate(@NotNull CidrDebugProcess process2, @NotNull DebuggerDriver driver, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @NotNull CidrStackFrame frame) throws ExecutionException, DebuggerCommandException {
        LinkedHashSet<String> expressions = new LinkedHashSet<String>(3);
        Ref lastException = new Ref();
        LLValue invalidResult = null;
        DebuggerDriver.DebuggerLanguage language = frame.getFrame().getLanguage();
        if (this.shouldTryOriginalExpressionFirst(expression, sourcePosition, language)) {
            try {
                LLValue value = driver.evaluate(frame.getThread(), frame.getFrame(), expression.getExpression());
                if (value.isValid()) {
                    return Pair.create((Object)value, (Object)expression.getExpression());
                }
                invalidResult = value;
            }
            catch (DebuggerCommandException e) {
                lastException.set((Object)e);
            }
        } else {
            expressions.add(expression.getExpression());
        }
        Ref convertedExpression = new Ref();
        Ref resolvedType = new Ref();
        WriteAction.runAndWait(() -> {
            try {
                Pair<OCType, String> converted = OCEvaluatorHelper.convertExpressionPrivate(process2, expression.getExpression(), sourcePosition);
                convertedExpression.set((Object)((String)converted.second));
                resolvedType.set((Object)((OCType)converted.first));
            }
            catch (CidrEvaluatorHelper.ConversionException e) {
                lastException.setIfNull((Object)new DebuggerCommandException((Throwable)e));
                return;
            }
            expressions.add((String)convertedExpression.get());
            OCType type = (OCType)resolvedType.get();
            PsiElement debuggerContext = process2.getDebuggerContext(sourcePosition);
            if (!resolvedType.isNull() && !type.isUnknown()) {
                PsiFile file;
                PsiFile psiFile = file = debuggerContext != null ? debuggerContext.getContainingFile() : null;
                if (file != null) {
                    if (process2.driverSupportsArrayEvaluation() && type instanceof OCArrayType) {
                        type = OCTypeUtils.decayType(type, file.getProject());
                    }
                    if (type instanceof OCCppReferenceType && ((OCCppReferenceType)type).isRvalueRef()) {
                        type = ((OCCppReferenceType)type).getRefType();
                    }
                    if (!(type instanceof OCArrayType)) {
                        OCType baseType = type;
                        while (baseType instanceof OCPointerType) {
                            baseType = ((OCPointerType)baseType).getRefType();
                        }
                        if (baseType instanceof OCStructType) {
                            expressions.add("((" + type.getCanonicalName(OCResolveContext.forPsi((PsiElement)file)) + ")(" + (String)convertedExpression.get() + "))");
                            return;
                        }
                    }
                    expressions.add("((" + type.getCanonicalName(OCResolveContext.forPsi((PsiElement)file)) + ")(" + (String)convertedExpression.get() + "))");
                } else {
                    CidrDebuggerLog.LOG.warn("Cannot get PsiFile for " + (sourcePosition != null ? sourcePosition.toString() : "UNKNOWN POSITION"));
                }
                expressions.add("((" + type.getBestNameInContext(debuggerContext) + ")(" + (String)convertedExpression.get() + "))");
            }
        });
        if (expressions.isEmpty()) {
            if (invalidResult != null) {
                return Pair.create((Object)invalidResult, (Object)expression.getExpression());
            }
            DebuggerCommandException exception = (DebuggerCommandException)((Object)lastException.get());
            if (exception == null) {
                CidrDebuggerLog.LOG.error("exception is null for: " + expression);
                throw new DebuggerCommandException(OCDebuggerBundle.message("debug.evaluate.error.invalidExpression", new Object[0]));
            }
            throw exception;
        }
        LLValue result = null;
        String actualExpression = null;
        for (String each : ContainerUtil.iterateBackward(new ArrayList(expressions))) {
            try {
                result = driver.evaluate(frame.getThread(), frame.getFrame(), each);
                actualExpression = each;
                break;
            }
            catch (DebuggerCommandException e) {
                lastException.set((Object)e);
            }
        }
        CidrDebuggerLog.LOG.assertTrue(result != null || !lastException.isNull());
        if (result == null) {
            CidrDebuggerLog.LOG.debug((Throwable)lastException.get());
            throw (DebuggerCommandException)((Object)lastException.get());
        }
        return Pair.create(result, actualExpression);
    }

    protected boolean shouldTryOriginalExpressionFirst(@NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @Nullable DebuggerDriver.DebuggerLanguage language) {
        return language != DebuggerDriver.StandardDebuggerLanguage.OBJC && language != DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS;
    }

    private static class PostConverter
    extends MyVisitor {
        private PostConverter() {
        }

        @Override
        public void visitReferenceExpression(OCReferenceExpression expression) {
            OCSymbolKind kind;
            OCSymbol symbol = expression.resolveToSymbol();
            OCSymbolKind oCSymbolKind = kind = symbol == null ? null : symbol.getKind();
            if (kind == OCSymbolKind.INTERFACE || kind == OCSymbolKind.IMPLEMENTATION ? this.replaceAndVisitClass(expression, symbol.getName()) : kind == OCSymbolKind.PROTOCOL && this.replaceAndVisitProtocol(expression, symbol.getName())) {
                return;
            }
            super.visitReferenceExpression(expression);
        }

        @Override
        public void visitProtocolExpression(OCProtocolExpression expression) {
            OCTypeElement type = expression.getTypeElement();
            if (type != null && this.replaceAndVisitProtocol(expression, type.getText())) {
                return;
            }
            super.visitProtocolExpression(expression);
        }

        private boolean replaceAndVisitClass(OCReferenceExpression expression, String name) {
            return this.replaceAndVisit(expression, "(id)NSClassFromString(@\"" + name + "\")");
        }

        private boolean replaceAndVisitProtocol(OCExpression expression, String name) {
            return this.replaceAndVisit(expression, "(id)NSProtocolFromString(@\"" + name + "\")");
        }
    }

    private static class PreConverter
    extends MyVisitor {
        private PreConverter() {
        }

        @Override
        public void visitReferenceExpression(OCReferenceExpression expression) {
            Integer value;
            String converted;
            OCParenthesizedExpression result;
            String name;
            OCSymbolKind kind;
            OCSymbol symbol = expression.resolveToSymbol();
            OCSymbolKind oCSymbolKind = kind = symbol == null ? null : symbol.getKind();
            if (kind == OCSymbolKind.INSTANCE_VARIABLE ? !"self".equals(name = symbol.getName()) && this.replaceAndVisit(expression, "self->" + name) : kind == OCSymbolKind.ENUM_CONST && (result = MyVisitor.replace(expression, converted = "((int)" + ((value = OCExpressionEvaluator.evaluateEnumConst(symbol, expression.getContainingFile())) == null ? expression.getText() : String.valueOf(value)) + ")")) != null) {
                return;
            }
            super.visitReferenceExpression(expression);
        }

        @Override
        public void visitQualifiedExpression(OCQualifiedExpression expression) {
            Prop prop = PreConverter.getProp(expression);
            if (prop != null && prop.getter != null && this.replaceAndVisit(expression, "[" + prop.receiver + " " + prop.getter + "]")) {
                return;
            }
            super.visitQualifiedExpression(expression);
        }

        @Override
        public void visitAssignmentExpression(OCAssignmentExpression expression) {
            Prop prop = PreConverter.getProp(expression.getReceiverExpression());
            OCExpression argExp = expression.getSourceExpression();
            if (prop != null && prop.isReadWrite() && argExp != null) {
                Object arg = argExp.getText();
                String sign = expression.getOperationSign().getName();
                if (sign.endsWith("=") && sign.length() == 2) {
                    arg = "([" + prop.receiver + " " + prop.getter + "]" + sign.charAt(0) + (String)arg + ")";
                }
                if (this.replaceAndVisit(expression, "[" + prop.receiver + " " + prop.setter + " " + (String)arg + "]")) {
                    return;
                }
            }
            super.visitAssignmentExpression(expression);
        }

        @Override
        public void visitPrefixExpression(OCPrefixExpression expression) {
            if (this.doVisitXFixExpression(expression, true)) {
                return;
            }
            super.visitPrefixExpression(expression);
        }

        @Override
        public void visitPostfixExpression(OCPostfixExpression expression) {
            if (this.doVisitXFixExpression(expression, false)) {
                return;
            }
            super.visitPostfixExpression(expression);
        }

        private boolean doVisitXFixExpression(OCExpression expression, boolean isPrefix) {
            Prop prop = PreConverter.getProp(isPrefix ? ((OCPrefixExpression)expression).getOperand() : ((OCPostfixExpression)expression).getOperand());
            if (prop == null || !prop.isReadWrite()) {
                return false;
            }
            String sign = (isPrefix ? ((OCPrefixExpression)expression).getOperationSign() : ((OCPostfixExpression)expression).getOperationSign()).getName();
            String fix = sign.equals("--") ? "-1" : "+1";
            String getExpr = "[" + prop.receiver + " " + prop.getter + "]" + fix;
            return this.replaceAndVisit(expression, "[" + prop.receiver + " " + prop.setter + " " + getExpr + "]");
        }

        @Nullable
        private static Prop getProp(@Nullable OCExpression exp) {
            if (exp instanceof OCQualifiedExpression) {
                OCSymbol symbol = ((OCQualifiedExpression)exp).resolveToSymbol();
                String receiver = ((OCQualifiedExpression)exp).getQualifier().getText();
                if (symbol instanceof OCPropertySymbol) {
                    return new Prop(receiver, ((OCPropertySymbol)symbol).getGetterName(), ((OCPropertySymbol)symbol).getSetterName());
                }
                if (symbol instanceof OCMethodSymbol) {
                    OCMethodSymbol method = (OCMethodSymbol)symbol;
                    String name = symbol.getName();
                    OCResolveContext context = OCResolveContext.forPsi(exp);
                    return new Prop(receiver, method.isGetter(context) ? name : OCNameSuggester.getObjCGetterFromSetter(name), method.isSetter(context) ? name : OCNameSuggester.getObjCSetterFromGetter(name));
                }
            }
            return null;
        }

        private static final class Prop {
            @NotNull
            public final String receiver;
            @Nullable
            public final String getter;
            @Nullable
            public final String setter;

            private Prop(@NotNull String receiver, @Nullable String getter, @Nullable String setter) {
                this.receiver = receiver;
                this.getter = getter;
                this.setter = setter;
            }

            public boolean isReadWrite() {
                return this.getter != null && this.setter != null;
            }
        }
    }

    private static abstract class MyVisitor
    extends OCRecursiveVisitor {
        private MyVisitor() {
        }

        protected boolean replaceAndVisit(@NotNull OCExpression expression, @NotNull String converted) {
            super.visitParenthesizedExpression(MyVisitor.replace(expression, converted));
            return true;
        }

        @Nullable
        protected static OCParenthesizedExpression replace(@NotNull OCExpression expression, @NotNull String converted) {
            OCExpression replacement = OCElementFactory.expressionFromText("(" + converted + ")", expression, false);
            if (replacement == null) {
                return null;
            }
            return (OCParenthesizedExpression)expression.replace(replacement);
        }
    }
}

