/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCResolvesToSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCEvaluator
extends CidrEvaluator {
    private static final Class<? extends PsiElement>[] REFERENCE_LIKE_CLASSES = OCEvaluator.arrayOf(OCReferenceExpression.class, OCQualifiedExpression.class);

    private static <T> T[] arrayOf(T ... elements) {
        return elements;
    }

    public OCEvaluator(@NotNull CidrStackFrame frame) {
        super(frame);
    }

    public TextRange getExpressionRangeAtOffset(Project project, Document document, int offset, boolean sideEffectsAllowed) {
        return (TextRange)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
            OCFile file = OCLanguageUtils.asOCFile(PsiDocumentManager.getInstance((Project)project).getPsiFile(document));
            if (file == null) {
                return null;
            }
            PsiElement el = OCEvaluator.findSuitableExpression(file, offset, sideEffectsAllowed);
            return el == null ? null : el.getTextRange();
        }));
    }

    @Nullable
    private static PsiElement findSuitableExpression(OCFile file, int offset, boolean sideEffectsAllowed) {
        OCSymbol s;
        OCReference ref;
        PsiElement result = null;
        if (sideEffectsAllowed) {
            PsiElement macro;
            result = file.findElementAt(offset);
            if (result == null || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(result))) {
                if (offset > 0) {
                    result = file.findElementAt(offset - 1);
                }
                if (result == null || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(result))) {
                    return null;
                }
            }
            if ((macro = OCEvaluator.getIfMacroCall(result)) != null) {
                result = macro;
            } else {
                PsiElement call = OCEvaluator.getIfFunctionCall(result = PsiTreeUtil.getParentOfType((PsiElement)result, OCExpression.class, (boolean)false));
                if (call != null) {
                    result = call;
                }
            }
        }
        if (result == null && (ref = OCEvaluator.getIfReference(file.findReferenceAt(offset))) != null) {
            result = PsiTreeUtil.getNonStrictParentOfType((PsiElement)ref.getElement(), (Class[])REFERENCE_LIKE_CLASSES);
            if (result != null) {
                OCSymbol symbol = OCEvaluator.tryResolveToSymbol(result);
                if (symbol == null || symbol instanceof OCMacroSymbol) {
                    return null;
                }
            } else {
                result = PsiTreeUtil.getParentOfType((PsiElement)ref.getElement(), OCDeclarator.class, (boolean)false, (Class[])new Class[]{OCDeclaration.class});
                if (result != null) {
                    if (PsiTreeUtil.findChildOfType((PsiElement)result, OCParameterList.class) != null) {
                        return null;
                    }
                    result = ((PsiNameIdentifierOwner)result).getNameIdentifier();
                }
            }
            if (OCEvaluator.getIfFunctionCall(result) != null) {
                return null;
            }
        }
        if (PsiTreeUtil.instanceOf((Object)result, (Class[])REFERENCE_LIKE_CLASSES) && (s = OCEvaluator.tryResolveToSymbol(result)) instanceof OCClassSymbol) {
            return null;
        }
        PsiElement slice = OCEvaluator.getIfArraySlice(result, sideEffectsAllowed);
        if (slice != null) {
            result = slice;
        }
        return result;
    }

    @Nullable
    private static OCSymbol tryResolveToSymbol(@Nullable PsiElement result) {
        if (result instanceof OCResolvesToSymbol) {
            return ((OCResolvesToSymbol)result).resolveToSymbol();
        }
        return null;
    }

    @Nullable
    private static OCReference getIfReference(@Nullable PsiReference ref) {
        if (ref instanceof OCReference) {
            return (OCReference)ref;
        }
        if (ref instanceof PsiMultiReference) {
            for (PsiReference eachRef : ((PsiMultiReference)ref).getReferences()) {
                OCReference ocReference = OCEvaluator.getIfReference(eachRef);
                if (ocReference == null) continue;
                return ocReference;
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement getIfFunctionCall(@Nullable PsiElement el) {
        PsiElement parent;
        if (PsiTreeUtil.instanceOf((Object)el, (Class[])REFERENCE_LIKE_CLASSES) && (parent = el.getParent()) instanceof OCCallExpression) {
            return parent;
        }
        return null;
    }

    @Nullable
    private static PsiElement getIfMacroCall(@Nullable PsiElement el) {
        PsiElement parent;
        PsiElement psiElement = parent = el == null ? null : el.getParent();
        if (parent != null) {
            if (el.getNode().getElementType() instanceof OCPunctuatorElementType && parent instanceof OCMacroCall) {
                return parent;
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof OCMacroCall) {
                return grandParent;
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement getIfArraySlice(@Nullable PsiElement el, boolean sideEffectsAllowed) {
        if (el == null) {
            return null;
        }
        PsiElement parent = el.getParent();
        OCArraySelectionExpression slice = null;
        if (el instanceof OCArraySelectionExpression) {
            slice = (OCArraySelectionExpression)el;
        } else if (parent instanceof OCArraySelectionExpression) {
            slice = (OCArraySelectionExpression)parent;
        }
        if (slice == null) {
            return null;
        }
        if (!sideEffectsAllowed) {
            OCExpression index = slice.getIndexExpression();
            Condition filter = each -> each instanceof OCExpression && !PsiTreeUtil.instanceOf((Object)each, (Class[])REFERENCE_LIKE_CLASSES) && !(each instanceof OCLiteralExpression) && !(each instanceof OCCastExpression) && !(each instanceof OCParenthesizedExpression);
            if (SyntaxTraverser.psiTraverser((PsiElement)index).traverse().filter(filter).isNotEmpty()) {
                return null;
            }
        }
        return slice;
    }
}

