/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.comment;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.doxygen.comment.ComplexItemBuilder;
import com.jetbrains.cidr.doxygen.comment.DoxygenCommentGroupImpl;
import com.jetbrains.cidr.doxygen.comment.DoxygenCommentTagImpl;
import com.jetbrains.cidr.doxygen.comment.DxCommentProcessorUtil;
import com.jetbrains.cidr.doxygen.psi.DxDocComment;
import com.jetbrains.cidr.doxygen.psi.DxDocTag;
import com.jetbrains.cidr.doxygen.psi.DxTypes;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCmd;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DxCommentProcessor {
    public static final Set<String> PLAIN_TAGS = Set.of(DoxygenCmd.BRIEF.toString());
    final PsiElement element;
    private static final Result NONE = new Result(null, true);

    public DxCommentProcessor(@Nullable PsiElement element) {
        this.element = element;
    }

    @NotNull
    public DoxygenCommentGroupImpl getCommentGroup() {
        List<PsiNamedElement> params;
        List<PsiComment> comments = DxCommentProcessorUtil.findOCCommentFor(this.element);
        DoxygenCommentGroupImpl.Builder builder2 = DxCommentProcessor.process(comments);
        PsiElement curElement = this.element;
        if (curElement instanceof OCDeclarator) {
            curElement = curElement.getParent();
        }
        if (curElement instanceof OCCallable && (params = ((OCCallable)curElement).getParameters()) != null) {
            for (PsiNamedElement param : params) {
                List<PsiComment> paramComments;
                DoxygenCommentGroupImpl paramGroup;
                String name = param.getName();
                if ("<unnamed>".equals(name) || (paramGroup = DxCommentProcessor.process(paramComments = DxCommentProcessorUtil.findOCCommentFor((PsiElement)param)).build()).isEmpty()) continue;
                builder2.addTag(new DoxygenCommentTagImpl("param", paramGroup.getOptions(), name, paramGroup.getDescription()));
            }
        }
        return builder2.build();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static DoxygenCommentGroupImpl.Builder process(@NotNull List<PsiComment> comments) {
        boolean isOptionFound = false;
        DoxygenCommentGroupImpl.Builder builder2 = new DoxygenCommentGroupImpl.Builder();
        Comment comment = new Comment(comments);
        PsiElement element = comment.getFistChild();
        while (true) {
            block9: {
                if (element == null) {
                    return builder2;
                }
                IElementType type = element.getNode().getElementType();
                if (type == DxTypes.EOF_DOC_COMMENT_START || type == DxTypes.DOC_COMMENT_START) {
                    builder2.addText("");
                } else {
                    Result result;
                    StringBuilder description;
                    if (type == DxTypes.DOC_COMMENT_DATA) {
                        description = new StringBuilder();
                        result = DxCommentProcessor.processDocData(comment, element, description);
                        element = result.element;
                        builder2.addText(description.toString());
                        continue;
                    }
                    if (type == DxTypes.TAG_OPTION) {
                        if (!isOptionFound) {
                            isOptionFound = true;
                            builder2.addOptions(element.getNode());
                            break block9;
                        } else {
                            description = new StringBuilder();
                            result = DxCommentProcessor.processDocData(comment, element, description);
                            element = result.element;
                            builder2.addText(description.toString());
                            continue;
                        }
                    }
                    if (type == DxTypes.DOC_TAG) {
                        Result result2 = DxCommentProcessor.processTag(comment, element, builder2);
                        element = result2.element;
                        continue;
                    }
                }
            }
            element = comment.nextSibling(element);
        }
    }

    @NotNull
    private static Result processDocData(@NotNull Comment comment, @Nullable PsiElement element, @NotNull StringBuilder description) {
        if (element == null) {
            return NONE;
        }
        IElementType type = element.getNode().getElementType();
        if (type == DxTypes.DOC_COMMENT_DATA || type == DxTypes.TAG_OPTION) {
            String text = element.getText().trim();
            description.append(text);
            return DxCommentProcessor.processDocData(comment, comment.nextSibling(element), description);
        }
        while (element != null) {
            type = element.getNode().getElementType();
            if (type == DxTypes.DOC_TAG) {
                return new Result(element, true);
            }
            if (type == DxTypes.DOC_COMMENT_DATA || type == DxTypes.TAG_OPTION) {
                return DxCommentProcessor.processDocData(comment, element, description);
            }
            if (type == DxTypes.EOF_DOC_COMMENT_START || type == DxTypes.DOC_COMMENT_START || type == TokenType.WHITE_SPACE) {
                if (description.length() == 0 || !StringUtil.isWhiteSpace((char)description.charAt(description.length() - 1))) {
                    description.append(" ");
                }
                Result result = DxCommentProcessor.processWS(comment, element);
                if (!result.proceed) {
                    return result;
                }
                element = result.element;
                continue;
            }
            element = comment.nextSibling(element);
        }
        return NONE;
    }

    @NotNull
    private static Result processTag(@NotNull Comment comment, @NotNull PsiElement element, @NotNull DoxygenCommentGroupImpl.Builder builder2) {
        DxDocTag tag = (DxDocTag)element;
        String name = tag.getName();
        if (DoxygenCmd.SURROUND_TAGS.containsKey(name)) {
            element = DxCommentProcessor.processSurroundTag(comment, element, builder2);
            return new Result(element, true);
        }
        if (DoxygenCmd.SURROUND_TAGS.containsValue(name)) {
            element = comment.nextSibling(element);
            return new Result(element, true);
        }
        DoxygenCommentTagImpl curTag = new DoxygenCommentTagImpl(tag);
        builder2.addTag(curTag);
        element = comment.nextSibling(element);
        while (element != null) {
            Result result;
            CharSequence description;
            IElementType type = element.getNode().getElementType();
            if (type == DxTypes.DOC_COMMENT_DATA || type == DxTypes.TAG_OPTION) {
                description = new StringBuilder();
                result = DxCommentProcessor.processDocData(comment, element, (StringBuilder)description);
                curTag.addText(((StringBuilder)description).toString());
                element = result.element;
                if (result.proceed) continue;
                return result;
            }
            if (type == DxTypes.DOC_TAG) {
                if (!PLAIN_TAGS.contains(name) && DoxygenCmd.SURROUND_TAGS.containsKey(((DxDocTag)element).getName())) {
                    element = DxCommentProcessor.processSurroundTag(comment, element, curTag);
                    continue;
                }
                return new Result(element, true);
            }
            if (type == DxTypes.EOF_DOC_COMMENT_START || type == DxTypes.DOC_COMMENT_START || type == TokenType.WHITE_SPACE) {
                description = curTag.getDescription();
                if (((String)description).length() == 0 || !StringUtil.isWhiteSpace((char)((String)description).charAt(((String)description).length() - 1))) {
                    curTag.addText(" ");
                }
                result = DxCommentProcessor.processWS(comment, element);
                element = result.element;
                if (result.proceed) continue;
                return result;
            }
            element = comment.nextSibling(element);
        }
        return NONE;
    }

    @Nullable
    private static PsiElement processSurroundTag(@NotNull Comment comment, @NotNull PsiElement element, @NotNull ComplexItemBuilder builder2) {
        DoxygenCommentTagImpl tag = new DoxygenCommentTagImpl((DxDocTag)element);
        String stopName = DoxygenCmd.SURROUND_TAGS.get(tag.getName());
        builder2.addTag(tag);
        StringBuilder description = new StringBuilder();
        element = comment.nextSibling(element);
        while (element != null) {
            String text = element.getText();
            IElementType type = element.getNode().getElementType();
            if (type == TokenType.WHITE_SPACE) {
                int count = StringUtil.getLineBreakCount((CharSequence)text);
                if (count > 0 && text.contains("*")) {
                    for (int i = 0; i < count; ++i) {
                        if (description.length() <= 0) continue;
                        description.append("\n");
                    }
                } else {
                    description.append(text);
                }
            } else if (type == DxTypes.EOF_DOC_COMMENT_START || type == DxTypes.DOC_COMMENT_START) {
                if (description.length() > 0) {
                    description.append("\n");
                }
            } else {
                if (type == DxTypes.DOC_TAG && stopName.equals(((DxDocTag)element).getName()) || type == DxTypes.DOC_COMMENT_END) break;
                description.append(text);
            }
            element = comment.nextSibling(element);
        }
        String descriptionText = StringUtil.trimTrailing((String)description.toString());
        tag.addText(StringUtil.trimStart((String)descriptionText, (String)"\n"));
        if (element != null) {
            return comment.nextSibling(element);
        }
        return null;
    }

    @NotNull
    private static Result processWS(@NotNull Comment comment, @NotNull PsiElement element) {
        int breaks = 0;
        while (element != null) {
            IElementType type = element.getNode().getElementType();
            if (type == TokenType.WHITE_SPACE) {
                breaks += StringUtil.getLineBreakCount((CharSequence)element.getText());
            } else {
                if (type != DxTypes.DOC_COMMENT_START && type != DxTypes.EOF_DOC_COMMENT_START) break;
                ++breaks;
            }
            element = comment.nextSibling(element);
        }
        boolean proceed = breaks <= 1;
        return new Result(element, proceed);
    }

    private static class Comment {
        private int idx = 0;
        private final List<PsiComment> comments;

        Comment(@NotNull List<PsiComment> comments) {
            this.comments = comments;
        }

        @Nullable
        public PsiElement getFistChild() {
            return this.getFirstElementChild(0);
        }

        @Nullable
        private PsiElement getFirstElementChild(int index) {
            DxDocComment docComment;
            if (index < this.comments.size() && (docComment = DoxygenUtil.convertToDoxygen(this.comments.get(index))) != null) {
                return docComment.getFirstChild();
            }
            return null;
        }

        public PsiElement nextSibling(@NotNull PsiElement element) {
            PsiElement next = element.getNextSibling();
            if (next == null) {
                return this.getFirstElementChild(++this.idx);
            }
            return next;
        }
    }

    private static class Result {
        public final PsiElement element;
        public final boolean proceed;

        Result(PsiElement element, boolean proceed) {
            this.element = element;
            this.proceed = proceed;
        }
    }
}

