/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.resources;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.gct.idea.resources.ProjectSelectorCredentialedUser;
import com.google.gct.idea.resources.UserSelectorGoogleLogin;
import com.google.gct.idea.ui.CustomizableComboBox;
import com.google.gct.idea.ui.CustomizableComboBoxPopup;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.IGoogleLoginCompletedCallback;
import com.google.gct.login.ui.GoogleLoginEmptyPanel;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

public class UserSelector
extends CustomizableComboBox
implements CustomizableComboBoxPopup {
    private static final int PREFERRED_HEIGHT = 240;
    private static final int POPUP_HEIGHTFRAMESIZE = 50;
    private static final int MIN_WIDTH = 450;
    private JBPopup myPopup;

    public UserSelector() {
        this.getTextField().setCursor(Cursor.getDefaultCursor());
        this.getTextField().getEmptyText().setText(GctBundle.message("select.user.emptytext", new Object[0]));
    }

    @Nullable
    public CredentialedUser getSelectedUser() {
        if (Strings.isNullOrEmpty((String)this.getText())) {
            return null;
        }
        for (CredentialedUser user : GoogleLogin.getInstance().getAllUsers().values()) {
            if (user.getEmail() == null || !user.getEmail().equalsIgnoreCase(this.getText())) continue;
            return user;
        }
        return null;
    }

    @Override
    protected int getPreferredPopupHeight() {
        return !UserSelector.needsToSignIn() ? 240 : 200;
    }

    @Override
    protected CustomizableComboBoxPopup getPopup() {
        return this;
    }

    private static boolean needsToSignIn() {
        Map users = GoogleLogin.getInstance().getAllUsers();
        return users.isEmpty();
    }

    @Override
    public void showPopup(RelativePoint showTarget) {
        if (this.myPopup == null || this.myPopup.isDisposed()) {
            PopupPanel popupPanel = new PopupPanel();
            popupPanel.initializeContent(this.getText());
            ComponentPopupBuilder popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)popupPanel), popupPanel.getInitialFocus());
            this.myPopup = popup.createPopup();
        }
        if (!this.myPopup.isVisible()) {
            this.myPopup.show(showTarget);
        }
    }

    @Override
    public void hidePopup() {
        if (this.isPopupVisible()) {
            this.myPopup.closeOk(null);
        }
    }

    @Override
    public boolean isPopupVisible() {
        return this.myPopup != null && !this.myPopup.isDisposed() && this.myPopup.isVisible();
    }

    private class PopupPanel
    extends GoogleLoginEmptyPanel
    implements ListCellRenderer {
        private JBList myJList;
        private ProjectSelectorCredentialedUser myProjectSelectorCredentialedUser = new ProjectSelectorCredentialedUser();
        private UserSelectorGoogleLogin myUserSelectorGoogleLogin;
        private int myHoverIndex = -1;

        public PopupPanel() {
            this.myProjectSelectorCredentialedUser.setOpaque(true);
            this.myUserSelectorGoogleLogin = new UserSelectorGoogleLogin();
        }

        public JComponent getInitialFocus() {
            return this.myJList;
        }

        public void initializeContent(@Nullable String selectedItem) {
            DefaultListModel<Object> model = new DefaultListModel<Object>();
            this.myJList = new JBList(model);
            this.myJList.setOpaque(false);
            this.myJList.getSelectionModel().setSelectionMode(0);
            this.myJList.setCellRenderer((ListCellRenderer)this);
            for (CredentialedUser user : GoogleLogin.getInstance().getAllUsers().values()) {
                model.addElement(user);
                if (user.getEmail() == null || !user.getEmail().equalsIgnoreCase(selectedItem)) continue;
                this.myJList.setSelectedValue((Object)user, true);
            }
            if (model.getSize() == 0) {
                model.addElement(new EmptyMarker());
            }
            this.getContentPane().setHorizontalScrollBarPolicy(31);
            this.getContentPane().setViewportView((Component)this.myJList);
            this.myJList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Object user = PopupPanel.this.myJList.getSelectedValue();
                    if (user != null && user instanceof CredentialedUser) {
                        UserSelector.this.setText(((CredentialedUser)user).getEmail());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UserSelector.this.hidePopup();
                            }
                        });
                    }
                }
            });
            this.myJList.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent me) {
                    Point p = new Point(me.getX(), me.getY());
                    int index = PopupPanel.this.myJList.locationToIndex(p);
                    if (index != PopupPanel.this.myHoverIndex) {
                        int oldIndex = PopupPanel.this.myHoverIndex;
                        PopupPanel.this.myHoverIndex = index;
                        if (oldIndex >= 0) {
                            PopupPanel.this.myJList.repaint(PopupPanel.this.myJList.getUI().getCellBounds((JList<?>)PopupPanel.this.myJList, oldIndex, oldIndex));
                        }
                        if (PopupPanel.this.myHoverIndex >= 0) {
                            if (PopupPanel.this.myJList.getSelectedIndex() >= 0) {
                                PopupPanel.this.myJList.clearSelection();
                            }
                            PopupPanel.this.myJList.repaint(PopupPanel.this.myJList.getUI().getCellBounds((JList<?>)PopupPanel.this.myJList, PopupPanel.this.myHoverIndex, PopupPanel.this.myHoverIndex));
                        }
                    }
                }
            });
            this.myJList.requestFocusInWindow();
            int preferredWidth = UserSelector.this.getWidth();
            this.setPreferredSize(new Dimension(Math.max(450, preferredWidth), UserSelector.this.getPreferredPopupHeight()));
        }

        protected void doLogin() {
            GoogleLogin.getInstance().logIn(null, new IGoogleLoginCompletedCallback(){

                public void onLoginCompleted() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (GoogleLogin.getInstance().getActiveUser() != null) {
                                UserSelector.this.setText(GoogleLogin.getInstance().getActiveUser().getEmail());
                            }
                        }
                    });
                }
            });
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof EmptyMarker) {
                return this.myUserSelectorGoogleLogin;
            }
            CredentialedUser targetUser = (CredentialedUser)value;
            if (targetUser != null) {
                this.myProjectSelectorCredentialedUser.initialize(targetUser.getPicture(), targetUser.getName(), targetUser.getEmail());
            } else {
                this.myProjectSelectorCredentialedUser.initialize(null, "", null);
            }
            if (isSelected || cellHasFocus || index == this.myHoverIndex) {
                this.myProjectSelectorCredentialedUser.setBackground(list.getSelectionBackground());
                this.myProjectSelectorCredentialedUser.setForeground(list.getSelectionForeground());
            } else {
                this.myProjectSelectorCredentialedUser.setBackground(list.getBackground());
                this.myProjectSelectorCredentialedUser.setForeground(list.getForeground());
            }
            return this.myProjectSelectorCredentialedUser;
        }

        class EmptyMarker {
            EmptyMarker() {
            }
        }
    }
}

