/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.resources;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.gct.idea.resources.GoogleSignOnModelItem;
import com.google.gct.idea.resources.GoogleUserModelItem;
import com.google.gct.idea.resources.ProjectSelectorRenderer;
import com.google.gct.idea.resources.ResourceProjectModelItem;
import com.google.gct.idea.ui.CustomizableComboBox;
import com.google.gct.idea.ui.CustomizableComboBoxPopup;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.IGoogleLoginCompletedCallback;
import com.google.gct.login.ui.GoogleLoginEmptyPanel;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import icons.GoogleCloudToolsIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class ProjectSelector
extends CustomizableComboBox
implements CustomizableComboBoxPopup {
    private static final String EMPTY_MARKER = "(empty)";
    private static final String EMPTY_VALUE = "";
    private static final int PREFERRED_HEIGHT = 240;
    private static final int POPUP_HEIGHTFRAMESIZE = 50;
    private final DefaultMutableTreeNode myModelRoot;
    private final SelectorTreeModel myTreeModel;
    private final boolean myQueryOnExpand;
    private JBPopup myJBPopup;
    private PopupPanel myPopupPanel;
    private List<ProjectSelectionListener> projectSelectionListeners;

    public ProjectSelector() {
        this(false);
    }

    public ProjectSelector(boolean queryOnExpand) {
        this.myQueryOnExpand = queryOnExpand;
        this.myModelRoot = new DefaultMutableTreeNode("root");
        this.myTreeModel = new SelectorTreeModel(this.myModelRoot);
        this.projectSelectionListeners = new ArrayList<ProjectSelectionListener>();
        this.myTreeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                if (!Strings.isNullOrEmpty((String)ProjectSelector.this.getText()) && ProjectSelector.this.myJBPopup != null && !ProjectSelector.this.myJBPopup.isDisposed() && ProjectSelector.this.myPopupPanel != null && e.getTreePath() != null && e.getTreePath().getLastPathComponent() instanceof GoogleUserModelItem) {
                    GoogleUserModelItem userItem = (GoogleUserModelItem)e.getTreePath().getLastPathComponent();
                    for (int index = 0; index < userItem.getChildCount(); ++index) {
                        DefaultMutableTreeNode loadedItem = (DefaultMutableTreeNode)userItem.getChildAt(index);
                        if (!(loadedItem instanceof ResourceProjectModelItem) || !ProjectSelector.this.getText().equals(((ResourceProjectModelItem)loadedItem).getProjectId())) continue;
                        ProjectSelector.this.myPopupPanel.myJTree.setSelectionPath(new TreePath(loadedItem.getPath()));
                    }
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ProjectSelector.this.synchronize(false);
                if (ProjectSelector.EMPTY_MARKER.equals(ProjectSelector.this.getText())) {
                    ProjectSelector.this.setText(ProjectSelector.EMPTY_VALUE);
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                if (ProjectSelector.EMPTY_VALUE.equals(ProjectSelector.this.getText())) {
                    ProjectSelector.this.setText(ProjectSelector.EMPTY_MARKER);
                }
            }
        });
        this.getTextField().setCursor(Cursor.getDefaultCursor());
        this.getTextField().getEmptyText().setText("Enter a cloud project ID...");
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ProjectSelector.this.isVisible()) {
                                ProjectSelector.this.synchronize(false);
                            }
                        }
                    });
                }
            }
        });
    }

    public void addModelListener(TreeModelListener listener) {
        this.myTreeModel.addTreeModelListener(listener);
    }

    public void removeModelListener(TreeModelListener listener) {
        this.myTreeModel.removeTreeModelListener(listener);
    }

    @Nullable
    public CredentialedUser getSelectedUser() {
        if (Strings.isNullOrEmpty((String)this.getText())) {
            return null;
        }
        for (int i = 0; i < this.myModelRoot.getChildCount(); ++i) {
            TreeNode node = this.myModelRoot.getChildAt(i);
            if (!(node instanceof GoogleUserModelItem)) continue;
            for (int j = 0; j < node.getChildCount(); ++j) {
                TreeNode projectNode = node.getChildAt(j);
                if (!(projectNode instanceof ResourceProjectModelItem) || !this.getText().equals(((ResourceProjectModelItem)projectNode).getProjectId())) continue;
                return ((GoogleUserModelItem)node).getCredentialedUser();
            }
        }
        return null;
    }

    @Nullable
    public String getProjectDescription() {
        ResourceProjectModelItem modelItem = this.getCurrentModelItem();
        return modelItem != null ? modelItem.getDescription() : null;
    }

    @Nullable
    public Long getProjectNumber() {
        ResourceProjectModelItem modelItem = this.getCurrentModelItem();
        return modelItem != null ? modelItem.getNumber() : null;
    }

    @Nullable
    public Project getProject() {
        ResourceProjectModelItem modelItem = this.getCurrentModelItem();
        return modelItem != null ? modelItem.getProject() : null;
    }

    @Nullable
    private ResourceProjectModelItem getCurrentModelItem() {
        if (Strings.isNullOrEmpty((String)this.getText())) {
            return null;
        }
        for (int i = 0; i < this.myModelRoot.getChildCount(); ++i) {
            TreeNode userNode = this.myModelRoot.getChildAt(i);
            if (!(userNode instanceof GoogleUserModelItem)) continue;
            for (int j = 0; j < userNode.getChildCount(); ++j) {
                TreeNode projectNode = userNode.getChildAt(j);
                if (!(projectNode instanceof ResourceProjectModelItem) || !this.getText().equals(((ResourceProjectModelItem)projectNode).getProjectId())) continue;
                return (ResourceProjectModelItem)projectNode;
            }
        }
        return null;
    }

    @Override
    protected int getPreferredPopupHeight() {
        return !ProjectSelector.needsToSignIn() ? 240 : 200;
    }

    @Override
    protected CustomizableComboBoxPopup getPopup() {
        return this;
    }

    @Nullable
    private GoogleUserModelItem getNodeForUser(@Nullable CredentialedUser user) {
        if (user == null) {
            return null;
        }
        for (int index = 0; index < this.myModelRoot.getChildCount(); ++index) {
            String currentNodeEmail;
            TreeNode node = this.myModelRoot.getChildAt(index);
            if (!(node instanceof GoogleUserModelItem) || Strings.isNullOrEmpty((String)(currentNodeEmail = ((GoogleUserModelItem)node).getCredentialedUser().getEmail())) || !currentNodeEmail.equals(user.getEmail())) continue;
            return (GoogleUserModelItem)node;
        }
        GoogleUserModelItem newUser = new GoogleUserModelItem(user, this.myTreeModel);
        this.myTreeModel.insertNodeInto(newUser, this.myModelRoot, this.myModelRoot.getChildCount());
        return newUser;
    }

    private static boolean needsToSignIn() {
        Map users = GoogleLogin.getInstance().getAllUsers();
        return users.isEmpty();
    }

    private void synchronize(boolean forceUpdate) {
        HashSet<String> emailUsers = new HashSet<String>();
        if (!ProjectSelector.needsToSignIn()) {
            for (CredentialedUser user : GoogleLogin.getInstance().getAllUsers().values()) {
                emailUsers.add(user.getEmail());
            }
        }
        int index = 0;
        while (index < this.myModelRoot.getChildCount()) {
            TreeNode node = this.myModelRoot.getChildAt(index);
            if (node instanceof GoogleUserModelItem) {
                CredentialedUser user = ((GoogleUserModelItem)node).getCredentialedUser();
                if (user == null || !emailUsers.contains(user.getEmail())) {
                    this.myTreeModel.removeNodeFromParent((GoogleUserModelItem)node);
                    continue;
                }
            } else {
                this.myTreeModel.removeNodeFromParent((MutableTreeNode)node);
                continue;
            }
            ++index;
        }
        if (!ProjectSelector.needsToSignIn()) {
            GoogleUserModelItem node = this.getNodeForUser(GoogleLogin.getInstance().getActiveUser());
            if (node != null) {
                if (forceUpdate) {
                    node.setNeedsSynchronizing();
                }
                node.synchronize();
            }
            for (CredentialedUser user : GoogleLogin.getInstance().getAllUsers().values()) {
                if (user == GoogleLogin.getInstance().getActiveUser() || (node = this.getNodeForUser(user)) == null) continue;
                if (forceUpdate) {
                    node.setNeedsSynchronizing();
                }
                if (this.myQueryOnExpand && (this.myPopupPanel == null || !this.myPopupPanel.myJTree.isExpanded(new TreePath(node.getPath())))) continue;
                node.synchronize();
            }
        } else {
            this.myTreeModel.insertNodeInto(new GoogleSignOnModelItem(), this.myModelRoot, 0);
        }
    }

    @Override
    public void showPopup(RelativePoint showTarget) {
        if (this.myJBPopup == null || this.myJBPopup.isDisposed()) {
            this.myPopupPanel = new PopupPanel();
            this.myPopupPanel.initializeContent(this.getText());
            ComponentPopupBuilder popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)this.myPopupPanel), this.myPopupPanel.getInitialFocus());
            this.myJBPopup = popup.createPopup();
        }
        if (!this.myJBPopup.isVisible()) {
            this.myJBPopup.show(showTarget);
        }
    }

    @Override
    public void hidePopup() {
        if (this.isPopupVisible()) {
            this.myJBPopup.closeOk(null);
        }
    }

    @Override
    public boolean isPopupVisible() {
        return this.myJBPopup != null && !this.myJBPopup.isDisposed() && this.myJBPopup.isVisible();
    }

    public void addProjectSelectionListener(ProjectSelectionListener projectSelectionListener) {
        this.projectSelectionListeners.add(projectSelectionListener);
    }

    public void removeProjectSelectionListener(ProjectSelectionListener projectSelectionListener) {
        this.projectSelectionListeners.remove(projectSelectionListener);
    }

    public static class ProjectSelectionChangedEvent {
        private final Project selectedProject;
        private final CredentialedUser user;

        public ProjectSelectionChangedEvent(Project selectedProject, CredentialedUser user) {
            this.selectedProject = selectedProject;
            this.user = user;
        }

        public Project getSelectedProject() {
            return this.selectedProject;
        }

        public CredentialedUser getUser() {
            return this.user;
        }
    }

    public static interface ProjectSelectionListener {
        public void selectionChanged(ProjectSelectionChangedEvent var1);
    }

    static class SelectorTreeModel
    extends DefaultTreeModel {
        private boolean myModelNeedsRefresh;

        public SelectorTreeModel(TreeNode root) {
            super(root);
        }

        public boolean isModelNeedsRefresh() {
            return this.myModelNeedsRefresh;
        }

        public void setModelNeedsRefresh(boolean modelNeedsRefresh) {
            this.myModelNeedsRefresh = modelNeedsRefresh;
        }
    }

    private class PopupPanel
    extends GoogleLoginEmptyPanel {
        private JTree myJTree;

        private PopupPanel() {
        }

        @Nullable
        private TreePath find(DefaultMutableTreeNode root, String s) {
            Enumeration<TreeNode> e = root.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                if (!(node instanceof ResourceProjectModelItem) || !s.equalsIgnoreCase(((ResourceProjectModelItem)node).getProjectId())) continue;
                return new TreePath(node.getPath());
            }
            return null;
        }

        public JComponent getInitialFocus() {
            return this.myJTree;
        }

        public void initializeContent(String selectedProjectId) {
            TreePath path;
            this.myJTree = new Tree((TreeModel)ProjectSelector.this.myTreeModel);
            this.myJTree.setRowHeight(0);
            if (!Strings.isNullOrEmpty((String)selectedProjectId) && (path = this.find(ProjectSelector.this.myModelRoot, selectedProjectId)) != null) {
                this.myJTree.setSelectionPath(path);
            }
            this.myJTree.setRootVisible(false);
            this.myJTree.setOpaque(false);
            this.myJTree.getSelectionModel().setSelectionMode(1);
            ProjectSelectorRenderer renderer = new ProjectSelectorRenderer(this.myJTree);
            this.myJTree.addMouseListener(renderer);
            this.myJTree.addMouseMotionListener(renderer);
            this.myJTree.setCellRenderer(renderer);
            this.getContentPane().setHorizontalScrollBarPolicy(31);
            this.getContentPane().setViewportView((Component)this.myJTree);
            this.myJTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)PopupPanel.this.myJTree.getLastSelectedPathComponent();
                    if (node != null) {
                        if (node instanceof ResourceProjectModelItem) {
                            if (Strings.isNullOrEmpty((String)ProjectSelector.this.getText()) || !ProjectSelector.this.getText().equals(((ResourceProjectModelItem)node).getProjectId())) {
                                ProjectSelector.this.setText(((ResourceProjectModelItem)node).getProjectId());
                                PopupPanel.this.onSelectionChanged((ResourceProjectModelItem)node);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ProjectSelector.this.hidePopup();
                                    }
                                });
                            }
                        } else {
                            PopupPanel.this.myJTree.clearSelection();
                        }
                    }
                }
            });
            if (ProjectSelector.this.myQueryOnExpand) {
                this.myJTree.addTreeExpansionListener(new TreeExpansionListener(){

                    @Override
                    public void treeExpanded(TreeExpansionEvent event) {
                        TreePath expandedPath = event.getPath();
                        if (expandedPath != null && expandedPath.getLastPathComponent() instanceof GoogleUserModelItem) {
                            ((GoogleUserModelItem)expandedPath.getLastPathComponent()).synchronize();
                        }
                    }

                    @Override
                    public void treeCollapsed(TreeExpansionEvent event) {
                    }
                });
            }
            for (int i = 0; i < this.myJTree.getRowCount(); ++i) {
                this.myJTree.expandRow(i);
                TreePath path2 = this.myJTree.getPathForRow(i);
                if (path2.getLastPathComponent() instanceof GoogleUserModelItem) break;
            }
            this.myJTree.requestFocusInWindow();
            Insets thisInsets = this.getInsets();
            Insets contentInset = this.getContentPane().getInsets();
            Insets treeInset = this.myJTree.getInsets();
            int preferredWidth = renderer.getMaximumWidth() + UIUtil.getTreeLeftChildIndent() * 2 + UIUtil.getTreeExpandedIcon().getIconWidth() * 2 + UIUtil.getScrollBarWidth() + (thisInsets != null ? thisInsets.left + thisInsets.right : 0) + (contentInset != null ? contentInset.left + contentInset.right : 0) + (treeInset != null ? treeInset.left + treeInset.right : 0);
            preferredWidth = Math.max(preferredWidth, ProjectSelector.this.getWidth());
            this.setPreferredSize(new Dimension(Math.max(450, preferredWidth), ProjectSelector.this.getPreferredPopupHeight()));
            this.getBottomPane().setLayout(new BorderLayout());
            if (!ProjectSelector.needsToSignIn()) {
                JButton synchronizeButton = new JButton();
                synchronizeButton.setIcon(GoogleCloudToolsIcons.REFRESH);
                synchronizeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!ProjectSelector.needsToSignIn()) {
                            ProjectSelector.this.synchronize(true);
                        }
                    }
                });
                this.getBottomPane().add((Component)synchronizeButton, "East");
            }
            if (ProjectSelector.this.myTreeModel.isModelNeedsRefresh()) {
                ProjectSelector.this.myTreeModel.setModelNeedsRefresh(false);
                ProjectSelector.this.synchronize(true);
            }
        }

        private void onSelectionChanged(ResourceProjectModelItem newSelection) {
            CredentialedUser user = null;
            if (newSelection.getParent() instanceof GoogleUserModelItem) {
                user = ((GoogleUserModelItem)newSelection.getParent()).getCredentialedUser();
            }
            ProjectSelectionChangedEvent event = new ProjectSelectionChangedEvent(newSelection.getProject(), user);
            for (ProjectSelectionListener listener : ProjectSelector.this.projectSelectionListeners) {
                listener.selectionChanged(event);
            }
        }

        protected void doLogin() {
            GoogleLogin.getInstance().logIn(null, new IGoogleLoginCompletedCallback(){

                public void onLoginCompleted() {
                    ProjectSelector.this.synchronize(true);
                }
            });
        }
    }
}

