/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.git;

import com.google.gct.idea.resources.ProjectSelector;
import com.google.gct.idea.resources.RepositoryRemotePanel;
import com.google.gct.idea.resources.RepositorySelector;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.CredentialedUser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.repo.GitRepository;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetupCloudRepositoryDialog
extends DialogWrapper {
    private JPanel rootPanel;
    private ProjectSelector projectSelector;
    private RepositorySelector repositorySelector;
    private RepositoryRemotePanel remoteNameSelector;
    private String projectId;
    private String repositoryId;
    private String remoteName;
    private CredentialedUser credentialedUser;
    private GitRepository gitRepository;

    public SetupCloudRepositoryDialog(@NotNull Project project, @Nullable GitRepository gitRepository, @NotNull String title, @NotNull String okText) {
        super(project, true);
        this.gitRepository = gitRepository;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(title);
        this.setOKButtonText(okText);
        this.setOKActionEnabled(false);
    }

    @NotNull
    public String getProjectId() {
        return this.projectId;
    }

    @NotNull
    String getRepositoryId() {
        return this.repositoryId;
    }

    @NotNull
    public String getRemoteName() {
        return this.remoteName;
    }

    @Nullable
    public CredentialedUser getCredentialedUser() {
        return this.credentialedUser;
    }

    protected String getDimensionServiceKey() {
        return "SetupCloudRepositoryDialog";
    }

    private void createUIComponents() {
        this.projectSelector = new ProjectSelector();
        this.projectSelector.setMinimumSize(new Dimension(300, 0));
        this.repositorySelector = new RepositorySelector(this.projectSelector.getText(), this.projectSelector.getSelectedUser(), true);
        this.remoteNameSelector = new RepositoryRemotePanel(this.gitRepository);
        this.projectSelector.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent event) {
                SetupCloudRepositoryDialog.this.repositorySelector.setCloudProject(SetupCloudRepositoryDialog.this.projectSelector.getText());
                SetupCloudRepositoryDialog.this.repositorySelector.setUser(SetupCloudRepositoryDialog.this.projectSelector.getSelectedUser());
                SetupCloudRepositoryDialog.this.repositorySelector.setText("");
                SetupCloudRepositoryDialog.this.repositorySelector.loadRepositories();
                SetupCloudRepositoryDialog.this.updateButtons();
            }
        });
        this.repositorySelector.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent event) {
                SetupCloudRepositoryDialog.this.remoteNameSelector.update(SetupCloudRepositoryDialog.this.repositorySelector.getSelectedRepository());
                SetupCloudRepositoryDialog.this.updateButtons();
            }
        });
        this.remoteNameSelector.getRemoteNameField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent event) {
                SetupCloudRepositoryDialog.this.updateButtons();
            }
        });
    }

    private void updateButtons() {
        if (!StringUtil.isEmpty((String)this.projectSelector.getText()) && this.projectSelector.getSelectedUser() == null) {
            this.setErrorText(GctBundle.message("cloud.repository.dialog.invalid.project", new Object[0]));
            this.setOKActionEnabled(false);
            return;
        }
        if (!StringUtil.isEmpty((String)this.repositorySelector.getText()) && StringUtil.isEmpty((String)this.repositorySelector.getSelectedRepository())) {
            this.setErrorText(GctBundle.message("cloud.repository.dialog.invalid.repository", new Object[0]));
            this.setOKActionEnabled(false);
            return;
        }
        if (this.projectSelector.getSelectedUser() == null || StringUtil.isEmpty((String)this.repositorySelector.getSelectedRepository())) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        if (StringUtil.isEmpty((String)this.remoteNameSelector.getText())) {
            this.setErrorText(GctBundle.message("uploadtogcp.dialog.missing.remote", new Object[0]));
            this.setOKActionEnabled(false);
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.projectSelector;
    }

    protected JComponent createCenterPanel() {
        return this.rootPanel;
    }

    protected void doOKAction() {
        this.projectId = this.projectSelector.getText();
        this.repositoryId = this.repositorySelector.getText();
        this.remoteName = this.remoteNameSelector.getText();
        this.credentialedUser = this.projectSelector.getSelectedUser();
        super.doOKAction();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.rootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("cloud.repository.dialog.project.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 1, 1, 3, 0, 1, 6, 1, null, null, null));
        ProjectSelector projectSelector = this.projectSelector;
        jPanel.add((Component)projectSelector, new GridConstraints(0, 1, 1, 3, 0, 3, 2, 2, new Dimension(260, -1), null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("cloud.repository.dialog.repository.label"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        RepositorySelector repositorySelector = this.repositorySelector;
        jPanel.add((Component)repositorySelector, new GridConstraints(1, 1, 1, 3, 0, 1, 3, 3, null, null, null));
        RepositoryRemotePanel repositoryRemotePanel = this.remoteNameSelector;
        JComponent jComponent = repositoryRemotePanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("cloud.repository.dialog.remote.label"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.rootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

