/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger.actions;

import com.google.gct.idea.debugger.CloudDebugRunConfiguration;
import com.google.gct.idea.debugger.CloudLineBreakpointType;
import com.google.gct.idea.util.GctBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import icons.GoogleCloudToolsIcons;
import java.awt.event.MouseEvent;

public class ToggleSnapshotLocationAction
extends AnAction {
    public static final Key<Integer> POPUP_LINE = Key.create((String)"SnapshotTargetLine");
    private static final Logger LOG = Logger.getInstance(ToggleSnapshotLocationAction.class);

    public ToggleSnapshotLocationAction() {
        super(GctBundle.getString("clouddebug.snapshot.location", new Object[0]), GctBundle.getString("clouddebug.adds.snapshot.location", new Object[0]), GoogleCloudToolsIcons.CLOUD);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor instanceof EditorEx && e.getInputEvent() instanceof MouseEvent && editor.getUserData(POPUP_LINE) != null) {
            EditorEx exEditor = (EditorEx)editor;
            if (exEditor.getProject() == null) {
                LOG.error("could not add a snapshot location as the target editor was unexpectedly null.");
                return;
            }
            if (editor.getUserData(POPUP_LINE) == null) {
                LOG.error("could not add a snapshot location as the target line was unexpectedly null.");
                return;
            }
            XDebuggerUtil.getInstance().toggleLineBreakpoint(exEditor.getProject(), (XLineBreakpointType)CloudLineBreakpointType.getInstance(), exEditor.getVirtualFile(), ((Integer)editor.getUserData(POPUP_LINE)).intValue());
        }
    }

    public void update(AnActionEvent e) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor == null) {
            return;
        }
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)editor.getProject());
        for (RunConfiguration runConfiguration : runManager.getAllConfigurations()) {
            if (!(runConfiguration instanceof CloudDebugRunConfiguration)) continue;
            e.getPresentation().setVisible(true);
            return;
        }
        e.getPresentation().setVisible(false);
    }
}

