/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.gct.idea.debugger.CloudBreakpointListener;
import com.google.gct.idea.debugger.CloudDebugGlobalPoller;
import com.google.gct.idea.debugger.CloudDebugProcessState;
import com.google.gct.idea.debugger.CloudDebugRunConfiguration;
import com.google.gct.idea.util.GctBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class CloudDebugProcessWatcher
implements CloudBreakpointListener {
    private static final CloudDebugProcessWatcher ourInstance = new CloudDebugProcessWatcher();
    private CloudDebugGlobalPoller myPoller = null;

    private CloudDebugProcessWatcher() {
    }

    @NotNull
    public static CloudDebugProcessWatcher getInstance() {
        return ourInstance;
    }

    public synchronized void ensureWatcher() {
        if (this.myPoller == null) {
            this.myPoller = new CloudDebugGlobalPoller();
            this.myPoller.addListener(this);
            this.myPoller.startBackgroundListening();
        }
    }

    @Override
    public void onBreakpointListChanged(final CloudDebugProcessState state) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotificationGroup notificationGroup = NotificationGroup.balloonGroup((String)"Cloud Debugger watcher", (PluginId)PluginId.getId((String)"com.google.gct.core"));
                String message = GctBundle.getString("clouddebug.balloonnotification.message", state.getProjectName());
                notificationGroup.createNotification("", message, NotificationType.INFORMATION).setListener(new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        notification.expire();
                        RunnerAndConfigurationSettings targetConfig = null;
                        RunManager manager = RunManager.getInstance((Project)state.getProject());
                        for (RunnerAndConfigurationSettings config : manager.getAllSettings()) {
                            if (!(config.getConfiguration() instanceof CloudDebugRunConfiguration) || ((CloudDebugRunConfiguration)config.getConfiguration()).getProcessState() != state) continue;
                            targetConfig = config;
                        }
                        if (targetConfig != null) {
                            Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
                            ProgramRunnerUtil.executeConfiguration((Project)state.getProject(), targetConfig, (Executor)executor);
                        }
                    }
                }).notify(state.getProject());
            }
        });
    }
}

