/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.services.debugger.model.SourceLocation;
import com.google.gct.idea.debugger.CloudDebugProcess;
import com.google.gct.idea.debugger.CloudDebugProcessStateController;
import com.google.gct.idea.debugger.CloudLineBreakpointProperties;
import com.google.gct.idea.debugger.CloudLineBreakpointType;
import com.google.gct.idea.debugger.JavaUtil;
import com.google.gct.idea.util.GctBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudBreakpointHandler
extends XBreakpointHandler<XLineBreakpoint<CloudLineBreakpointProperties>> {
    private static final Key<String> CLOUD_ID = Key.create((String)"CloudId");
    private static final Logger LOG = Logger.getInstance(CloudBreakpointHandler.class);
    private final Map<String, XBreakpoint> myIdeBreakpoints = new ConcurrentHashMap<String, XBreakpoint>();
    private final CloudDebugProcess myProcess;
    private PsiManager myPsiManager;

    public CloudBreakpointHandler(@NotNull CloudDebugProcess process) {
        super(CloudLineBreakpointType.class);
        this.myProcess = process;
        this.setPsiManager(PsiManager.getInstance((Project)this.myProcess.getXDebugSession().getProject()));
    }

    public void cloneToNewBreakpoints(@NotNull List<com.google.api.services.debugger.model.Breakpoint> serverBreakpoints) {
        for (com.google.api.services.debugger.model.Breakpoint serverBreakpoint : serverBreakpoints) {
            if (serverBreakpoint.getIsFinalState() != Boolean.TRUE) continue;
            Project currentProject = this.myProcess.getXDebugSession().getProject();
            final XBreakpointManager manager = XDebuggerManager.getInstance((Project)this.myProcess.getXDebugSession().getProject()).getBreakpointManager();
            if (serverBreakpoint.getLocation() == null) {
                LOG.warn("attempted to clone a breakpoint without a source location: " + StringUtil.notNullize((String)serverBreakpoint.getId()));
                continue;
            }
            final VirtualFile file = JavaUtil.getFileFromCloudPath(currentProject, serverBreakpoint.getLocation().getPath());
            final int line = serverBreakpoint.getLocation().getLine() - 1;
            if (file == null) {
                LOG.warn("attempted to clone a breakpoint whose file doesn't exist locally: " + StringUtil.notNullize((String)serverBreakpoint.getLocation().getPath()));
                continue;
            }
            final XLineBreakpoint existing = manager.findBreakpointAtLine((XLineBreakpointType)CloudLineBreakpointType.getInstance(), file, line);
            if (existing != null) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        manager.removeBreakpoint((XBreakpoint)existing);
                    }
                });
            }
            final CloudLineBreakpointProperties properties = new CloudLineBreakpointProperties();
            final com.google.api.services.debugger.model.Breakpoint finalserverBreakpoint = serverBreakpoint;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    if (finalserverBreakpoint.getExpressions() != null && !finalserverBreakpoint.getExpressions().isEmpty()) {
                        properties.setWatchExpressions(finalserverBreakpoint.getExpressions().toArray(new String[finalserverBreakpoint.getExpressions().size()]));
                    }
                    XLineBreakpoint newxIdeBreakpoint = manager.addLineBreakpoint((XLineBreakpointType)CloudLineBreakpointType.getInstance(), file.getUrl(), line, (XBreakpointProperties)properties);
                    if (!Strings.isNullOrEmpty((String)finalserverBreakpoint.getCondition())) {
                        newxIdeBreakpoint.setCondition(finalserverBreakpoint.getCondition());
                    }
                }
            });
        }
    }

    public void createIdeRepresentationsIfNecessary(@NotNull List<com.google.api.services.debugger.model.Breakpoint> serverBreakpoints) {
        boolean addedBreakpoint = false;
        for (final com.google.api.services.debugger.model.Breakpoint serverBreakpoint : serverBreakpoints) {
            XLineBreakpoint existingXIdeBreakpoint;
            if (serverBreakpoint.getIsFinalState() == Boolean.TRUE || this.myIdeBreakpoints.containsKey(serverBreakpoint.getId())) continue;
            Project currentProject = this.myProcess.getXDebugSession().getProject();
            final XBreakpointManager manager = XDebuggerManager.getInstance((Project)this.myProcess.getXDebugSession().getProject()).getBreakpointManager();
            if (serverBreakpoint.getLocation() == null) continue;
            final VirtualFile file = JavaUtil.getFileFromCloudPath(currentProject, serverBreakpoint.getLocation().getPath());
            final int line = serverBreakpoint.getLocation().getLine() - 1;
            if (file == null || (existingXIdeBreakpoint = manager.findBreakpointAtLine((XLineBreakpointType)CloudLineBreakpointType.getInstance(), file, line)) != null && existingXIdeBreakpoint.isEnabled()) continue;
            if (existingXIdeBreakpoint != null) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        manager.removeBreakpoint((XBreakpoint)existingXIdeBreakpoint);
                    }
                });
            }
            final CloudLineBreakpointProperties properties = new CloudLineBreakpointProperties();
            properties.setCreatedByServer(true);
            addedBreakpoint = true;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    XLineBreakpoint newXIdeBreakpoint = manager.addLineBreakpoint((XLineBreakpointType)CloudLineBreakpointType.getInstance(), file.getUrl(), line, (XBreakpointProperties)properties);
                    newXIdeBreakpoint.putUserData(CLOUD_ID, (Object)serverBreakpoint.getId());
                    CloudBreakpointHandler.this.myIdeBreakpoints.put(serverBreakpoint.getId(), (XBreakpoint)newXIdeBreakpoint);
                    if (!Strings.isNullOrEmpty((String)serverBreakpoint.getCondition())) {
                        newXIdeBreakpoint.setCondition(serverBreakpoint.getCondition());
                    }
                    if (serverBreakpoint.getExpressions() != null && !serverBreakpoint.getExpressions().isEmpty()) {
                        ((CloudLineBreakpointProperties)newXIdeBreakpoint.getProperties()).setWatchExpressions(serverBreakpoint.getExpressions().toArray(new String[serverBreakpoint.getExpressions().size()]));
                    }
                    ((CloudLineBreakpointProperties)newXIdeBreakpoint.getProperties()).setCreatedByServer(false);
                    Breakpoint cloudIdeBreakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)newXIdeBreakpoint);
                    if (cloudIdeBreakpoint instanceof CloudLineBreakpointType.CloudLineBreakpoint) {
                        CloudLineBreakpointType.CloudLineBreakpoint cloudIdeLineBreakpoint = (CloudLineBreakpointType.CloudLineBreakpoint)cloudIdeBreakpoint;
                        cloudIdeLineBreakpoint.setVerified(true);
                        cloudIdeLineBreakpoint.setErrorMessage(null);
                        cloudIdeLineBreakpoint.updateUI();
                    }
                }
            });
        }
        if (addedBreakpoint) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    CloudBreakpointHandler.this.myProcess.fireBreakpointsChanged();
                }
            });
        }
    }

    public void deleteBreakpoint(@NotNull com.google.api.services.debugger.model.Breakpoint serverBreakpoint) {
        if (serverBreakpoint.getIsFinalState() != Boolean.TRUE) {
            this.setStateToDisabled(serverBreakpoint);
        }
        this.myProcess.getStateController().deleteBreakpoint(serverBreakpoint.getId());
    }

    @Nullable
    public XBreakpoint getEnabledXBreakpoint(@NotNull com.google.api.services.debugger.model.Breakpoint serverBreakpoint) {
        XBreakpoint xIdeBreakpoint = this.getXBreakpoint(serverBreakpoint);
        return xIdeBreakpoint == null || !xIdeBreakpoint.isEnabled() ? null : xIdeBreakpoint;
    }

    @Nullable
    public XBreakpoint getXBreakpoint(@Nullable com.google.api.services.debugger.model.Breakpoint serverBreakpoint) {
        if (serverBreakpoint == null) {
            return null;
        }
        return this.myIdeBreakpoints.get(serverBreakpoint.getId());
    }

    public void navigateTo(@NotNull com.google.api.services.debugger.model.Breakpoint serverBreakpoint) {
        XBreakpoint xIdeBreakpoint = this.myIdeBreakpoints.get(serverBreakpoint.getId());
        if (xIdeBreakpoint != null && xIdeBreakpoint.getSourcePosition() != null && this.myProcess.getXDebugSession() != null) {
            xIdeBreakpoint.getSourcePosition().createNavigatable(this.myProcess.getXDebugSession().getProject()).navigate(true);
        }
    }

    public void registerBreakpoint(@NotNull XLineBreakpoint<CloudLineBreakpointProperties> xIdeBreakpoint) {
        String id;
        List<String> watches;
        if (xIdeBreakpoint.getSourcePosition() == null || !xIdeBreakpoint.isEnabled() || !(xIdeBreakpoint.getType() instanceof CloudLineBreakpointType)) {
            return;
        }
        Breakpoint cloudIdeBreakpoint = BreakpointManager.getJavaBreakpoint(xIdeBreakpoint);
        if (!(cloudIdeBreakpoint instanceof CloudLineBreakpointType.CloudLineBreakpoint)) {
            LOG.error("breakpoint was not of the correct type to create on the cloud.  It was not a CloudLineBreakpoint");
            return;
        }
        final CloudLineBreakpointType.CloudLineBreakpoint cloudIdeLineBreakpoint = (CloudLineBreakpointType.CloudLineBreakpoint)cloudIdeBreakpoint;
        if (((CloudLineBreakpointProperties)xIdeBreakpoint.getProperties()).isCreatedByServer()) {
            return;
        }
        PsiFile javaFile = this.myPsiManager.findFile(xIdeBreakpoint.getSourcePosition().getFile());
        if (!(javaFile instanceof PsiJavaFile)) {
            return;
        }
        SourceLocation location = new SourceLocation();
        location.setPath(JavaUtil.getCloudPathFromJavaFile((PsiJavaFile)javaFile));
        location.setLine(Integer.valueOf(xIdeBreakpoint.getSourcePosition().getLine() + 1));
        com.google.api.services.debugger.model.Breakpoint serverNewBreakpoint = new com.google.api.services.debugger.model.Breakpoint();
        serverNewBreakpoint.setLocation(location);
        if (xIdeBreakpoint.getConditionExpression() != null) {
            serverNewBreakpoint.setCondition(xIdeBreakpoint.getConditionExpression().getExpression());
        }
        if ((watches = cloudIdeLineBreakpoint.getWatchExpressions()) != null) {
            serverNewBreakpoint.setExpressions(watches);
        }
        if (!Strings.isNullOrEmpty((String)(id = this.myProcess.getStateController().setBreakpoint(serverNewBreakpoint, new CloudDebugProcessStateController.BreakpointErrorHandler(){

            @Override
            public void handleError(String errorMessage) {
                cloudIdeLineBreakpoint.setErrorMessage(errorMessage);
            }
        })))) {
            cloudIdeLineBreakpoint.setVerified(true);
            cloudIdeLineBreakpoint.setErrorMessage(null);
        } else {
            cloudIdeLineBreakpoint.setErrorMessage(GctBundle.getString("clouddebug.errorset", new Object[0]));
        }
        cloudIdeLineBreakpoint.updateUI();
        if (!Strings.isNullOrEmpty((String)id)) {
            ((CloudLineBreakpointProperties)xIdeBreakpoint.getProperties()).setDisabledByServer(false);
            String oldId = (String)xIdeBreakpoint.getUserData(CLOUD_ID);
            if (!Strings.isNullOrEmpty((String)oldId)) {
                this.myIdeBreakpoints.remove(oldId);
            }
            xIdeBreakpoint.putUserData(CLOUD_ID, (Object)id);
            this.myIdeBreakpoints.put(id, (XBreakpoint)xIdeBreakpoint);
        }
    }

    void setPsiManager(PsiManager psiManager) {
        this.myPsiManager = psiManager;
    }

    public void setStateToDisabled(@NotNull com.google.api.services.debugger.model.Breakpoint serverBreakpoint) {
        final XBreakpoint xIdeBreakpoint = this.myIdeBreakpoints.get(serverBreakpoint.getId());
        if (xIdeBreakpoint != null && xIdeBreakpoint.getProperties() instanceof CloudLineBreakpointProperties) {
            CloudLineBreakpointProperties properties = (CloudLineBreakpointProperties)xIdeBreakpoint.getProperties();
            properties.setDisabledByServer(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    xIdeBreakpoint.setEnabled(false);
                }
            });
        }
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<CloudLineBreakpointProperties> xIdeBreakpoint, boolean temporary) {
        if (((CloudLineBreakpointProperties)xIdeBreakpoint.getProperties()).isDisabledByServer()) {
            return;
        }
        String breakpointId = (String)xIdeBreakpoint.getUserData(CLOUD_ID);
        if (!Strings.isNullOrEmpty((String)breakpointId)) {
            assert (breakpointId != null);
            this.myProcess.getStateController().deleteBreakpoint(breakpointId);
        } else {
            LOG.warn("could not delete breakpoint because it was not added through the cloud handler.");
        }
    }
}

