/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.services.debugger.model.StatusMessage;
import com.google.gct.idea.util.GctBundle;
import org.jetbrains.annotations.Nullable;

public class BreakpointUtil {
    @Nullable
    public static String getUserErrorMessage(@Nullable StatusMessage statusMessage) {
        if (statusMessage == null || statusMessage.getIsError() != Boolean.TRUE) {
            return null;
        }
        Object errorDescription = GctBundle.getString("clouddebug.fallbackerrormessage", new Object[0]);
        if (statusMessage.getDescription() != null) {
            String formatString = statusMessage.getDescription().getFormat();
            Integer i = 0;
            String argString = "$" + i.toString();
            while (formatString.contains(argString)) {
                formatString = formatString.replace(argString, "%s");
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
                argString = "$" + i.toString();
            }
            errorDescription = String.format(formatString, statusMessage.getDescription().getParameters());
        }
        if (!Strings.isNullOrEmpty((String)statusMessage.getRefersTo())) {
            errorDescription = (String)errorDescription + " in " + statusMessage.getRefersTo();
        }
        return errorDescription;
    }
}

