/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageClassesAnnotator;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.rt.coverage.data.BranchData;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.SaveHook;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;

public final class PackageAnnotator {
    private static final Logger LOG = Logger.getInstance(PackageAnnotator.class);
    @NonNls
    private static final String DEFAULT_CONSTRUCTOR_NAME_SIGNATURE = "<init>()V";
    private final CoverageSuitesBundle mySuite;
    private final Project myProject;
    private final ProjectData myProjectData;
    private final JavaCoverageClassesAnnotator myAnnotator;
    private final boolean myIgnoreEmptyPrivateConstructors;
    private final boolean myIgnoreImplicitConstructor;
    private final ProjectData myUnloadedClassesProjectData = new ProjectData();

    public PackageAnnotator(CoverageSuitesBundle suite, Project project, ProjectData projectData, JavaCoverageClassesAnnotator annotator, boolean ignoreEmptyPrivateConstructors, boolean ignoreImplicitConstructor) {
        this.mySuite = suite;
        this.myProject = project;
        this.myProjectData = projectData;
        this.myAnnotator = annotator;
        this.myIgnoreEmptyPrivateConstructors = ignoreEmptyPrivateConstructors;
        this.myIgnoreImplicitConstructor = ignoreImplicitConstructor;
    }

    @NotNull
    public static File findRelativeFile(@NotNull String rootPackageVMName, File outputRoot) {
        outputRoot = rootPackageVMName.length() > 0 ? new File(outputRoot, FileUtil.toSystemDependentName((String)rootPackageVMName)) : outputRoot;
        return outputRoot;
    }

    public ClassCoverageInfo visitClass(PsiClass psiClass) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module != null) {
            File outputPath;
            boolean isInTests = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().isInTestSourceContent(psiClass.getContainingFile().getVirtualFile());
            CompilerModuleExtension moduleExtension = CompilerModuleExtension.getInstance((Module)module);
            if (moduleExtension == null) {
                return null;
            }
            String outputPathUrl = isInTests ? moduleExtension.getCompilerOutputUrlForTests() : moduleExtension.getCompilerOutputUrl();
            File file = outputPath = outputPathUrl != null ? new File(VfsUtilCore.urlToPath((String)outputPathUrl)) : null;
            if (outputPath != null) {
                File[] files;
                String qualifiedName2 = psiClass.getQualifiedName();
                if (qualifiedName2 == null) {
                    return null;
                }
                String packageVMName = StringUtil.getPackageName((String)qualifiedName2).replace('.', '/');
                File packageRoot = PackageAnnotator.findRelativeFile(packageVMName, outputPath);
                if (packageRoot.exists() && (files = packageRoot.listFiles()) != null) {
                    ClassCoverageInfo result = new ClassCoverageInfo();
                    for (File child : files) {
                        String className;
                        ClassCoverageInfo coverageInfo;
                        if (!PackageAnnotator.isClassFile(child)) continue;
                        String childName = PackageAnnotator.getClassName(child);
                        Object classFqVMName = packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
                        String toplevelClassSrcFQName = PackageAnnotator.getSourceToplevelFQName((String)classFqVMName);
                        if (!toplevelClassSrcFQName.equals(qualifiedName2) || (coverageInfo = this.collectClassCoverageInformation(child, psiClass, className = ((String)classFqVMName).replace('/', '.'))) == null) continue;
                        result.append(coverageInfo);
                    }
                    return result;
                }
            }
        }
        return null;
    }

    public void visitFiles(String toplevelClassSrcFQName, List<File> files, String packageVMName, GlobalSearchScope scope) {
        Ref containingFileRef = new Ref();
        Ref psiClassRef = new Ref();
        Boolean isInSource = (Boolean)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> {
            if (this.myProject.isDisposed()) {
                return null;
            }
            PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(toplevelClassSrcFQName, scope);
            if (aClass == null || !aClass.isValid()) {
                return Boolean.FALSE;
            }
            psiClassRef.set((Object)aClass);
            PsiElement element = aClass.getNavigationElement();
            containingFileRef.set((Object)PsiUtilCore.getVirtualFile((PsiElement)element));
            if (containingFileRef.isNull()) {
                LOG.info("No virtual file found for: " + aClass);
                return null;
            }
            return this.mySuite.getCoverageEngine().acceptedByFilters(element.getContainingFile(), this.mySuite);
        });
        if (isInSource == null || !isInSource.booleanValue()) {
            return;
        }
        VirtualFile virtualFile = (VirtualFile)containingFileRef.get();
        ClassCoverageInfo topLevelClassCoverageInfo = new ClassCoverageInfo();
        VirtualFile parent = null;
        for (File file : files) {
            if (virtualFile == null && !ContainerUtil.exists((Object[])((JavaCoverageEngineExtension[])JavaCoverageEngineExtension.EP_NAME.getExtensions()), extension -> extension.keepCoverageInfoForClassWithoutSource(this.mySuite, file))) {
                return;
            }
            parent = virtualFile == null ? null : virtualFile.getParent();
            String childName = PackageAnnotator.getClassName(file);
            String classFqVMName = packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
            ClassCoverageInfo info = this.collectClassCoverageInformation(file, (PsiClass)psiClassRef.get(), classFqVMName.replace('/', '.'));
            if (info == null) continue;
            topLevelClassCoverageInfo.append(info);
        }
        this.myAnnotator.annotateClass(toplevelClassSrcFQName, topLevelClassCoverageInfo, packageVMName, parent);
    }

    @Nullable
    public ClassCoverageInfo collectClassCoverageInformation(File classFile, @Nullable PsiClass psiClass, String className) {
        ClassCoverageInfo info = new ClassCoverageInfo();
        ClassData classData = this.myProjectData.getClassData(className);
        if (classData == null || classData.getLines() == null) {
            classData = this.collectNonCoveredClassInfo(classFile, className, this.myUnloadedClassesProjectData);
        }
        if (classData != null && classData.getLines() != null) {
            Object[] lines;
            boolean isDefaultConstructorGenerated = false;
            Collection methodSigs = classData.getMethodSigs();
            for (String nameAndSig : methodSigs) {
                if (this.myIgnoreImplicitConstructor && PackageAnnotator.isGeneratedDefaultConstructor(psiClass, nameAndSig)) {
                    isDefaultConstructorGenerated = true;
                    continue;
                }
                if (classData.getStatus(nameAndSig) != 0) {
                    ++info.coveredMethodCount;
                }
                ++info.totalMethodCount;
            }
            for (Object l : lines = classData.getLines()) {
                if (!(l instanceof LineData)) continue;
                LineData lineData = (LineData)l;
                if (lineData.getStatus() == 2) {
                    ++info.fullyCoveredLineCount;
                } else if (lineData.getStatus() == 1) {
                    ++info.partiallyCoveredLineCount;
                } else if (this.myIgnoreImplicitConstructor && isDefaultConstructorGenerated && PackageAnnotator.isDefaultConstructor(lineData.getMethodSignature())) continue;
                ++info.totalLineCount;
                BranchData branchData = lineData.getBranchData();
                if (branchData == null) continue;
                info.totalBranchCount += branchData.getTotalBranches();
                info.coveredBranchCount += branchData.getCoveredBranches();
            }
            if (!methodSigs.isEmpty()) {
                info.totalClassCount = 1;
                if (info.getCoveredLineCount() > 0) {
                    info.coveredClassCount = 1;
                }
            }
        } else {
            return null;
        }
        return info;
    }

    public static boolean isClassFile(@NotNull File classFile) {
        return classFile.getPath().endsWith(".class");
    }

    public static String getClassName(File classFile) {
        return StringUtil.trimEnd((String)classFile.getName(), (String)".class");
    }

    public static boolean isGeneratedDefaultConstructor(@Nullable PsiClass aClass, String nameAndSig) {
        if (aClass == null) {
            return false;
        }
        if (PackageAnnotator.isDefaultConstructor(nameAndSig)) {
            return PackageAnnotator.hasGeneratedConstructor(aClass);
        }
        return false;
    }

    public static boolean isDefaultConstructor(String nameAndSig) {
        return DEFAULT_CONSTRUCTOR_NAME_SIGNATURE.equals(nameAndSig);
    }

    private static boolean hasGeneratedConstructor(@NotNull PsiClass aClass) {
        return aClass.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && (Boolean)ReadAction.compute(() -> {
            if (!aClass.isValid()) {
                return false;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            return constructors.length == 0;
        }) != false;
    }

    public static String getSourceToplevelFQName(String classFQVMName) {
        int index = classFQVMName.indexOf(36);
        if (index > 0) {
            classFQVMName = classFQVMName.substring(0, index);
        }
        classFQVMName = StringUtil.trimStart((String)classFQVMName, (String)"/");
        return classFQVMName.replace('/', '.');
    }

    @Nullable
    private ClassData collectNonCoveredClassInfo(File classFile, String className, ProjectData projectData) {
        byte[] content;
        try {
            content = FileUtil.loadFileBytes((File)classFile);
        }
        catch (IOException e) {
            return null;
        }
        SaveHook.appendUnloadedClass((ProjectData)projectData, (String)className, (ClassReader)new ClassReader(content), (!this.mySuite.isTracingEnabled() ? 1 : 0) != 0, (boolean)false, (boolean)this.myIgnoreEmptyPrivateConstructors);
        return projectData.getClassData(className);
    }

    public static class AtomicPackageCoverageInfo {
        private final AtomicInteger myTotalClassCount = new AtomicInteger(0);
        private final AtomicInteger myCoveredClassCount = new AtomicInteger(0);
        private final AtomicInteger myTotalMethodCount = new AtomicInteger(0);
        private final AtomicInteger myCoveredMethodCount = new AtomicInteger(0);
        private final AtomicInteger myTotalLineCount = new AtomicInteger(0);
        private final AtomicInteger myCoveredLineCount = new AtomicInteger(0);
        private final AtomicInteger myTotalBranchCount = new AtomicInteger(0);
        private final AtomicInteger myCoveredBranchCount = new AtomicInteger(0);

        public void append(SummaryCoverageInfo info) {
            this.myTotalClassCount.addAndGet(info.totalClassCount);
            this.myCoveredClassCount.addAndGet(info.coveredClassCount);
            this.myTotalMethodCount.addAndGet(info.totalMethodCount);
            this.myCoveredMethodCount.addAndGet(info.coveredMethodCount);
            this.myTotalLineCount.addAndGet(info.totalLineCount);
            this.myCoveredLineCount.addAndGet(info.getCoveredLineCount());
            this.myTotalBranchCount.addAndGet(info.totalBranchCount);
            this.myCoveredBranchCount.addAndGet(info.coveredBranchCount);
        }

        public PackageCoverageInfo toPackageCoverageInfo() {
            PackageCoverageInfo info = new PackageCoverageInfo();
            info.totalClassCount = this.myTotalClassCount.get();
            info.coveredClassCount = this.myCoveredClassCount.get();
            info.totalMethodCount = this.myTotalMethodCount.get();
            info.coveredMethodCount = this.myCoveredMethodCount.get();
            info.totalLineCount = this.myTotalLineCount.get();
            info.coveredLineCount = this.myCoveredLineCount.get();
            info.totalBranchCount = this.myTotalBranchCount.get();
            info.coveredBranchCount = this.myCoveredBranchCount.get();
            return info;
        }
    }

    public static class DirCoverageInfo
    extends PackageCoverageInfo {
        public VirtualFile sourceRoot;

        public DirCoverageInfo(VirtualFile sourceRoot) {
            this.sourceRoot = sourceRoot;
        }
    }

    public static class PackageCoverageInfo
    extends SummaryCoverageInfo {
        public int coveredLineCount;

        @Override
        public int getCoveredLineCount() {
            return this.coveredLineCount;
        }

        public void append(SummaryCoverageInfo info) {
            this.totalClassCount += info.totalClassCount;
            this.totalLineCount += info.totalLineCount;
            this.coveredClassCount += info.coveredClassCount;
            this.coveredLineCount += info.getCoveredLineCount();
            this.coveredMethodCount += info.coveredMethodCount;
            this.totalMethodCount += info.totalMethodCount;
            this.totalBranchCount += info.totalBranchCount;
            this.coveredBranchCount += info.coveredBranchCount;
        }
    }

    public static class ClassCoverageInfo
    extends SummaryCoverageInfo {
        public int fullyCoveredLineCount;
        public int partiallyCoveredLineCount;

        public void append(ClassCoverageInfo info) {
            this.totalClassCount += info.totalClassCount;
            this.coveredClassCount += info.coveredClassCount;
            this.totalLineCount += info.totalLineCount;
            this.fullyCoveredLineCount += info.fullyCoveredLineCount;
            this.partiallyCoveredLineCount += info.partiallyCoveredLineCount;
            this.totalMethodCount += info.totalMethodCount;
            this.coveredMethodCount += info.coveredMethodCount;
            this.totalBranchCount += info.totalBranchCount;
            this.coveredBranchCount += info.coveredBranchCount;
        }

        @Override
        public int getCoveredLineCount() {
            return this.fullyCoveredLineCount + this.partiallyCoveredLineCount;
        }
    }

    public static abstract class SummaryCoverageInfo {
        public int totalClassCount;
        public int coveredClassCount;
        public int totalMethodCount;
        public int coveredMethodCount;
        public int totalLineCount;
        public int coveredBranchCount;
        public int totalBranchCount;

        public abstract int getCoveredLineCount();
    }

    public static interface Annotator {
        default public void annotateSourceDirectory(VirtualFile virtualFile, PackageCoverageInfo packageCoverageInfo, Module module) {
        }

        default public void annotateTestDirectory(VirtualFile virtualFile, PackageCoverageInfo packageCoverageInfo, Module module) {
        }

        default public void annotatePackage(String packageQualifiedName, PackageCoverageInfo packageCoverageInfo) {
        }

        default public void annotatePackage(String packageQualifiedName, PackageCoverageInfo packageCoverageInfo, boolean flatten) {
        }

        default public void annotateClass(String classQualifiedName, ClassCoverageInfo classCoverageInfo) {
        }
    }
}

