/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.IDEACoverageRunner;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaCoverageSuite
extends BaseCoverageSuite {
    private String[] myFilters;
    private String mySuiteToMerge;
    @NonNls
    private static final String FILTER = "FILTER";
    @NonNls
    private static final String EXCLUDED_FILTER = "EXCLUDED_FILTER";
    @NonNls
    private static final String MERGE_SUITE = "MERGE_SUITE";
    @NonNls
    private static final String COVERAGE_RUNNER = "RUNNER";
    private String[] myExcludePatterns;
    private final CoverageEngine myCoverageEngine;

    public JavaCoverageSuite(@NotNull JavaCoverageEngine coverageSupportProvider) {
        this.myCoverageEngine = coverageSupportProvider;
    }

    public JavaCoverageSuite(String name, CoverageFileProvider coverageDataFileProvider, String[] filters, String[] excludePatterns, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, CoverageRunner coverageRunner, @NotNull JavaCoverageEngine coverageSupportProvider, Project project) {
        super(name, coverageDataFileProvider, lastCoverageTimeStamp, coverageByTestEnabled, tracingEnabled, trackTestFolders, coverageRunner != null ? coverageRunner : CoverageRunner.getInstance(IDEACoverageRunner.class), project);
        this.myFilters = filters;
        this.myExcludePatterns = excludePatterns;
        this.myCoverageEngine = coverageSupportProvider;
    }

    public String @NotNull [] getFilteredPackageNames() {
        return JavaCoverageSuite.getPackageNames(this.myFilters);
    }

    public String @NotNull [] getExcludedPackageNames() {
        return JavaCoverageSuite.getPackageNames(this.myExcludePatterns);
    }

    private static String[] getPackageNames(String[] filters) {
        if (filters == null || filters.length == 0) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String filter : filters) {
            if (filter.equals("*")) {
                result.add("");
                continue;
            }
            if (!filter.endsWith(".*")) continue;
            result.add(filter.substring(0, filter.length() - 2));
        }
        return ArrayUtilRt.toStringArray(result);
    }

    public String @NotNull [] getFilteredClassNames() {
        return JavaCoverageSuite.getClassNames(this.myFilters);
    }

    public String @NotNull [] getExcludedClassNames() {
        return JavaCoverageSuite.getClassNames(this.myExcludePatterns);
    }

    private static String @NotNull [] getClassNames(String[] filters) {
        if (filters == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String filter : filters) {
            if (filter.equals("*") || filter.endsWith(".*")) continue;
            result.add(filter);
        }
        return ArrayUtilRt.toStringArray(result);
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myFilters = JavaCoverageSuite.readFilters(element, FILTER);
        this.myExcludePatterns = JavaCoverageSuite.readFilters(element, EXCLUDED_FILTER);
        this.mySuiteToMerge = element.getAttributeValue(MERGE_SUITE);
        if (this.getRunner() == null) {
            this.setRunner(CoverageRunner.getInstance(IDEACoverageRunner.class));
        }
    }

    private static String[] readFilters(Element element, String tagName) {
        List children = element.getChildren(tagName);
        ArrayList<String> filters = new ArrayList<String>();
        for (Element child : children) {
            filters.add(child.getValue());
        }
        return filters.isEmpty() ? null : ArrayUtilRt.toStringArray(filters);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.mySuiteToMerge != null) {
            element.setAttribute(MERGE_SUITE, this.mySuiteToMerge);
        }
        JavaCoverageSuite.writeFilters(element, this.myFilters, FILTER);
        JavaCoverageSuite.writeFilters(element, this.myExcludePatterns, EXCLUDED_FILTER);
        CoverageRunner coverageRunner = this.getRunner();
        element.setAttribute(COVERAGE_RUNNER, coverageRunner != null ? coverageRunner.getId() : "emma");
    }

    private static void writeFilters(Element element, String[] filters, String tagName) {
        if (filters != null) {
            for (String filter : filters) {
                Element filterElement = new Element(tagName);
                filterElement.setText(filter);
                element.addContent(filterElement);
            }
        }
    }

    @Nullable
    public ProjectData getCoverageData(CoverageDataManager coverageDataManager) {
        ProjectData data = this.getCoverageData();
        if (data != null) {
            return data;
        }
        ProjectData map = this.loadProjectInfo();
        if (this.mySuiteToMerge != null) {
            CoverageSuite[] suites;
            JavaCoverageSuite toMerge = null;
            for (CoverageSuite suite : suites = coverageDataManager.getSuites()) {
                if (!Comparing.strEqual((String)suite.getPresentableName(), (String)this.mySuiteToMerge)) continue;
                if (Comparing.strEqual((String)((JavaCoverageSuite)suite).getSuiteToMerge(), (String)this.getPresentableName())) break;
                toMerge = (JavaCoverageSuite)suite;
                break;
            }
            if (toMerge != null) {
                ProjectData projectInfo = toMerge.getCoverageData(coverageDataManager);
                if (map != null) {
                    map.merge((CoverageData)projectInfo);
                } else {
                    map = projectInfo;
                }
            }
        }
        this.setCoverageData(map);
        return map;
    }

    @NotNull
    public CoverageEngine getCoverageEngine() {
        return this.myCoverageEngine;
    }

    @Nullable
    public String getSuiteToMerge() {
        return this.mySuiteToMerge;
    }

    public boolean isClassFiltered(String classFQName) {
        return this.isClassFiltered(classFQName, this.getFilteredClassNames());
    }

    public boolean isClassFiltered(String classFQName, String[] classPatterns) {
        for (String className : classPatterns) {
            if (!className.equals(classFQName) && (!classFQName.startsWith(className) || classFQName.charAt(className.length()) != '$')) continue;
            return true;
        }
        return false;
    }

    public boolean isPackageFiltered(String packageFQName) {
        String[] filteredPackageNames;
        for (String name : this.getExcludedPackageNames()) {
            if (!packageFQName.equals(name) && !packageFQName.startsWith(name + ".")) continue;
            return false;
        }
        for (String packName : filteredPackageNames = this.getFilteredPackageNames()) {
            if (!PsiNameHelper.isSubpackageOf((String)packageFQName, (String)packName)) continue;
            return true;
        }
        return filteredPackageNames.length == 0 && this.getFilteredClassNames().length == 0;
    }

    @NotNull
    public List<PsiPackage> getCurrentSuitePackages(Project project) {
        return (List)ReadAction.compute(() -> {
            ArrayList<PsiPackage> packages = new ArrayList<PsiPackage>();
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            String[] filters = this.getFilteredPackageNames();
            if (filters.length == 0) {
                if (this.getFilteredClassNames().length > 0) {
                    return Collections.emptyList();
                }
                PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage("");
                if (defaultPackage != null) {
                    packages.add(defaultPackage);
                }
            } else {
                ArrayList<String> nonInherited = new ArrayList<String>();
                for (String filter : filters) {
                    if (JavaCoverageSuite.isSubPackage(filters, filter)) continue;
                    nonInherited.add(filter);
                }
                for (String filter : nonInherited) {
                    PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(filter);
                    if (psiPackage == null) continue;
                    packages.add(psiPackage);
                }
            }
            return packages;
        });
    }

    private static boolean isSubPackage(String[] filters, String filter) {
        for (String supPackageFilter : filters) {
            if (!filter.startsWith(supPackageFilter + ".")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<PsiClass> getCurrentSuiteClasses(Project project) {
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
        String[] classNames = this.getFilteredClassNames();
        if (classNames.length > 0) {
            DumbService dumbService = DumbService.getInstance((Project)project);
            for (String className : classNames) {
                ThrowableComputable computable = () -> {
                    Module module;
                    GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
                    RunConfigurationBase configuration = this.getConfiguration();
                    if (configuration instanceof ModuleBasedConfiguration && (module = ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule()) != null) {
                        searchScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)this.isTrackTestFolders());
                    }
                    return JavaPsiFacade.getInstance((Project)project).findClass(className.replace("$", "."), searchScope);
                };
                PsiClass aClass = (PsiClass)ReadAction.compute(() -> (PsiClass)dumbService.computeWithAlternativeResolveEnabled(computable));
                if (aClass == null) continue;
                classes.add(aClass);
            }
        }
        return classes;
    }
}

