/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.PackageAnnotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.ClassUtil;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="JavaCoverageOptionsProvider", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class JavaCoverageOptionsProvider
implements PersistentStateComponent<State> {
    private final State myState = new State();
    private final Project myProject;

    public JavaCoverageOptionsProvider(Project project) {
        this.myProject = project;
    }

    public boolean ignoreImplicitConstructors() {
        return this.myState.myIgnoreImplicitConstructors;
    }

    public static JavaCoverageOptionsProvider getInstance(Project project) {
        return (JavaCoverageOptionsProvider)project.getService(JavaCoverageOptionsProvider.class);
    }

    public void setIgnoreImplicitConstructors(boolean state) {
        this.myState.myIgnoreImplicitConstructors = state;
    }

    public void setIgnoreEmptyPrivateConstructors(boolean state) {
        this.myState.myIgnoreEmptyPrivateConstructors = state;
    }

    public boolean ignoreEmptyPrivateConstructors() {
        return this.myState.myIgnoreEmptyPrivateConstructors;
    }

    public boolean isGeneratedConstructor(String qualifiedName2, String methodSignature) {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (this.myState.myIgnoreImplicitConstructors) {
            PsiClass psiClass = (PsiClass)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)qualifiedName2));
            return PackageAnnotator.isGeneratedDefaultConstructor(psiClass, methodSignature);
        }
        return false;
    }

    public @NotNull State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState.myIgnoreEmptyPrivateConstructors = state.myIgnoreEmptyPrivateConstructors;
        this.myState.myIgnoreImplicitConstructors = state.myIgnoreImplicitConstructors;
    }

    public static class State {
        public boolean myIgnoreEmptyPrivateConstructors = true;
        public boolean myIgnoreImplicitConstructors = true;
    }
}

