/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u0019*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0019B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017J\u0013\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00028\u00000\tj\b\u0012\u0004\u0012\u00028\u0000`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/util/ListenerCollection;", "T", "", "myExecutor", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/Executor;)V", "myListenerSetCopy", "Lcom/google/common/collect/ImmutableSet;", "myListenersSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "myLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "add", "", "listener", "(Ljava/lang/Object;)Z", "clear", "", "forEach", "Lcom/google/common/util/concurrent/ListenableFuture;", "Ljava/lang/Void;", "runOnListener", "Ljava/util/function/Consumer;", "remove", "Companion", "intellij.android.common"})
public final class ListenerCollection<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Executor myExecutor;
    @NotNull
    private final ReentrantReadWriteLock myLock;
    @NotNull
    private final HashSet<T> myListenersSet;
    @Nullable
    private ImmutableSet<T> myListenerSetCopy;

    private ListenerCollection(Executor myExecutor) {
        this.myExecutor = myExecutor;
        this.myLock = new ReentrantReadWriteLock();
        this.myListenersSet = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean add(T listener) {
        boolean bl;
        ReentrantReadWriteLock reentrantReadWriteLock = this.myLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl2 = false;
            this.myListenerSetCopy = null;
            bl = this.myListenersSet.add(listener);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(T listener) {
        boolean bl;
        ReentrantReadWriteLock reentrantReadWriteLock = this.myLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl2 = false;
            this.myListenerSetCopy = null;
            bl = this.myListenersSet.remove(listener);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.myLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.myListenerSetCopy = ImmutableSet.of();
            this.myListenersSet.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ListenableFuture<Void> forEach(@NotNull Consumer<T> runOnListener) {
        ImmutableSet<T> immutableSet;
        Intrinsics.checkNotNullParameter(runOnListener, (String)"runOnListener");
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            if (this.myListenerSetCopy == null) {
                ReentrantReadWriteLock reentrantReadWriteLock = this.myLock;
                ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
                int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                for (int i = 0; i < n; ++i) {
                    readLock2.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    boolean bl2 = false;
                    if (this.myListenerSetCopy == null) {
                        this.myListenerSetCopy = ImmutableSet.copyOf((Collection)this.myListenersSet);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    for (int i = 0; i < n; ++i) {
                        readLock2.lock();
                    }
                    writeLock.unlock();
                }
            }
            ImmutableSet<T> immutableSet2 = this.myListenerSetCopy;
            Intrinsics.checkNotNull(immutableSet2);
            immutableSet = immutableSet2;
        }
        finally {
            readLock.unlock();
        }
        Set listeners = (Set)immutableSet;
        if (listeners.isEmpty()) {
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(null)");
            return listenableFuture;
        }
        SettableFuture future = SettableFuture.create();
        this.myExecutor.execute(new Runnable(listeners, runOnListener, (SettableFuture<Void>)future){
            final /* synthetic */ Set<T> $listeners;
            final /* synthetic */ Consumer<T> $runOnListener;
            final /* synthetic */ SettableFuture<Void> $future;
            {
                this.$listeners = $listeners;
                this.$runOnListener = $runOnListener;
                this.$future = $future;
            }

            public final void run() {
                this.$listeners.forEach(this.$runOnListener);
                this.$future.set(null);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"future");
        return (ListenableFuture)future;
    }

    @JvmStatic
    @NotNull
    public static final <T> ListenerCollection<T> createWithDirectExecutor() {
        return Companion.createWithDirectExecutor();
    }

    @JvmStatic
    @NotNull
    public static final <T> ListenerCollection<T> createWithExecutor(@NotNull Executor executor) {
        return Companion.createWithExecutor(executor);
    }

    public /* synthetic */ ListenerCollection(Executor myExecutor, DefaultConstructorMarker $constructor_marker) {
        this(myExecutor);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u0005H\u0007J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/util/ListenerCollection$Companion;", "", "()V", "createWithDirectExecutor", "Lcom/android/tools/idea/util/ListenerCollection;", "T", "createWithExecutor", "executor", "Ljava/util/concurrent/Executor;", "intellij.android.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> ListenerCollection<T> createWithDirectExecutor() {
            Executor executor = MoreExecutors.directExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"directExecutor()");
            return this.createWithExecutor(executor);
        }

        @JvmStatic
        @NotNull
        public final <T> ListenerCollection<T> createWithExecutor(@NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            return new ListenerCollection(executor, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

