/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.prefs.AndroidLocationsException;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.AvdManagerCache;
import com.android.tools.idea.sdk.DeviceManagerCache;
import com.android.utils.ILogger;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/sdk/AvdManagerCacheImpl;", "Lcom/android/tools/idea/sdk/AvdManagerCache;", "logger", "Lcom/android/utils/ILogger;", "deviceManagerCache", "Lcom/android/tools/idea/sdk/DeviceManagerCache;", "(Lcom/android/utils/ILogger;Lcom/android/tools/idea/sdk/DeviceManagerCache;)V", "avdManagers", "", "Lcom/android/tools/idea/sdk/AvdManagerCacheImpl$AvdManagerCacheKey;", "Lcom/android/sdklib/internal/avd/AvdManager;", "getAvdManager", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "avdHomeDir", "Ljava/nio/file/Path;", "AvdManagerCacheKey", "intellij.android.common"})
public final class AvdManagerCacheImpl
implements AvdManagerCache {
    @NotNull
    private final ILogger logger;
    @NotNull
    private final DeviceManagerCache deviceManagerCache;
    @NotNull
    private final Map<AvdManagerCacheKey, AvdManager> avdManagers;

    public AvdManagerCacheImpl(@NotNull ILogger logger, @NotNull DeviceManagerCache deviceManagerCache) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)deviceManagerCache, (String)"deviceManagerCache");
        this.logger = logger;
        this.deviceManagerCache = deviceManagerCache;
        this.avdManagers = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public AvdManager getAvdManager(@NotNull AndroidSdkHandler sdkHandler, @NotNull Path avdHomeDir) throws AndroidLocationsException {
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        Intrinsics.checkNotNullParameter((Object)avdHomeDir, (String)"avdHomeDir");
        Map<AvdManagerCacheKey, AvdManager> map = this.avdManagers;
        synchronized (map) {
            boolean bl = false;
            AvdManagerCacheKey key = new AvdManagerCacheKey(sdkHandler, avdHomeDir);
            AvdManager avdManager = this.avdManagers.get(key);
            if (avdManager != null) return avdManager;
            try {
                avdManager = AvdManager.createInstance((AndroidSdkHandler)key.getSdkHandler(), (Path)key.getAvdHomeDir(), (DeviceManager)this.deviceManagerCache.getDeviceManager(key.getSdkHandler()), (ILogger)this.logger);
                this.avdManagers.put(key, avdManager);
            }
            catch (AndroidLocationsException e) {
                throw e;
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, "Exception during AvdManager initialization", new Object[0]);
                return null;
            }
            return avdManager;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/sdk/AvdManagerCacheImpl$AvdManagerCacheKey;", "", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "avdHomeDir", "Ljava/nio/file/Path;", "(Lcom/android/sdklib/repository/AndroidSdkHandler;Ljava/nio/file/Path;)V", "getAvdHomeDir", "()Ljava/nio/file/Path;", "getSdkHandler", "()Lcom/android/sdklib/repository/AndroidSdkHandler;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.common"})
    private static final class AvdManagerCacheKey {
        @NotNull
        private final AndroidSdkHandler sdkHandler;
        @NotNull
        private final Path avdHomeDir;

        public AvdManagerCacheKey(@NotNull AndroidSdkHandler sdkHandler, @NotNull Path avdHomeDir) {
            Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
            Intrinsics.checkNotNullParameter((Object)avdHomeDir, (String)"avdHomeDir");
            this.sdkHandler = sdkHandler;
            this.avdHomeDir = avdHomeDir;
        }

        @NotNull
        public final AndroidSdkHandler getSdkHandler() {
            return this.sdkHandler;
        }

        @NotNull
        public final Path getAvdHomeDir() {
            return this.avdHomeDir;
        }

        @NotNull
        public final AndroidSdkHandler component1() {
            return this.sdkHandler;
        }

        @NotNull
        public final Path component2() {
            return this.avdHomeDir;
        }

        @NotNull
        public final AvdManagerCacheKey copy(@NotNull AndroidSdkHandler sdkHandler, @NotNull Path avdHomeDir) {
            Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
            Intrinsics.checkNotNullParameter((Object)avdHomeDir, (String)"avdHomeDir");
            return new AvdManagerCacheKey(sdkHandler, avdHomeDir);
        }

        public static /* synthetic */ AvdManagerCacheKey copy$default(AvdManagerCacheKey avdManagerCacheKey, AndroidSdkHandler androidSdkHandler, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                androidSdkHandler = avdManagerCacheKey.sdkHandler;
            }
            if ((n & 2) != 0) {
                path = avdManagerCacheKey.avdHomeDir;
            }
            return avdManagerCacheKey.copy(androidSdkHandler, path);
        }

        @NotNull
        public String toString() {
            return "AvdManagerCacheKey(sdkHandler=" + this.sdkHandler + ", avdHomeDir=" + this.avdHomeDir + ")";
        }

        public int hashCode() {
            int result = this.sdkHandler.hashCode();
            result = result * 31 + ((Object)this.avdHomeDir).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AvdManagerCacheKey)) {
                return false;
            }
            AvdManagerCacheKey avdManagerCacheKey = (AvdManagerCacheKey)other;
            if (!Intrinsics.areEqual((Object)this.sdkHandler, (Object)avdManagerCacheKey.sdkHandler)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.avdHomeDir, (Object)avdManagerCacheKey.avdHomeDir);
        }
    }
}

