/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.io;

import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.google.common.base.MoreObjects;
import com.intellij.openapi.util.io.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class BufferingFileWrapper
implements IAbstractFile {
    private final File myFile;

    public BufferingFileWrapper(@NotNull File file) {
        this.myFile = file;
    }

    public InputStream getContents() throws StreamException {
        try {
            byte[] content = this.readFile();
            return new ByteArrayInputStream(content);
        }
        catch (IOException e) {
            throw new StreamException((Exception)e, (IAbstractFile)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile() throws IOException {
        try (DataInputStream is = new DataInputStream(new FileInputStream(this.myFile));){
            byte[] data = new byte[(int)this.myFile.length()];
            is.readFully(data);
            byte[] byArray = data;
            return byArray;
        }
    }

    @NotNull
    public File getFile() {
        return this.myFile;
    }

    public void setContents(InputStream source) throws StreamException {
        throw new UnsupportedOperationException();
    }

    public OutputStream getOutputStream() throws StreamException {
        throw new UnsupportedOperationException();
    }

    public String getOsLocation() {
        return this.myFile.getAbsolutePath();
    }

    public boolean exists() {
        return this.myFile.isFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferingFileWrapper wrapper = (BufferingFileWrapper)o;
        return FileUtil.filesEqual((File)this.myFile, (File)wrapper.myFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.myFile);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("file", (Object)this.myFile).toString();
    }
}

