/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.concurrency;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.idea.concurrency.Computation;
import com.android.utils.concurrency.AsyncSupplier;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042\u00020\u0005B@\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012#\b\u0001\u0010\b\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J(\u0010\u001c\u001a\u00020\u001d2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00162\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0016H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0016J\b\u0010\"\u001a\u00020\u001dH\u0016J\b\u0010#\u001a\u00020\u001fH\u0002R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\u0004\u0018\u00018\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/concurrency/ThrottlingAsyncSupplier;", "V", "", "Lcom/android/utils/concurrency/AsyncSupplier;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/util/ModificationTracker;", "compute", "Lkotlin/Function0;", "isUpToDate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "", "mergingPeriod", "Ljava/time/Duration;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Ljava/time/Duration;)V", "alarm", "Lcom/intellij/util/Alarm;", "Lorg/jetbrains/annotations/NotNull;", "lastFailedComputation", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/tools/idea/concurrency/Computation;", "lastSuccessfulComputation", "now", "getNow", "()Ljava/lang/Object;", "scheduledComputation", "determineDelay", "", "dispose", "", "get", "Lcom/google/common/util/concurrent/ListenableFuture;", "getModificationCount", "runScheduledComputation", "intellij.android.common"})
public final class ThrottlingAsyncSupplier<V>
implements AsyncSupplier<V>,
Disposable,
ModificationTracker {
    @NotNull
    private final Function0<V> compute;
    @NotNull
    private final Function1<V, Boolean> isUpToDate;
    @NotNull
    private final Duration mergingPeriod;
    @NotNull
    private final Alarm alarm;
    @NotNull
    private final AtomicReference<Computation<V>> scheduledComputation;
    @NotNull
    private final AtomicReference<Computation<V>> lastSuccessfulComputation;
    @NotNull
    private final AtomicReference<Computation<V>> lastFailedComputation;

    public ThrottlingAsyncSupplier(@NotNull Function0<? extends V> compute, @AnyThread @NotNull Function1<? super V, Boolean> isUpToDate, @NotNull Duration mergingPeriod) {
        Intrinsics.checkNotNullParameter(compute, (String)"compute");
        Intrinsics.checkNotNullParameter(isUpToDate, (String)"isUpToDate");
        Intrinsics.checkNotNullParameter((Object)mergingPeriod, (String)"mergingPeriod");
        this.compute = compute;
        this.isUpToDate = isUpToDate;
        this.mergingPeriod = mergingPeriod;
        Alarm alarm = AlarmFactory.getInstance().create(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)alarm, (String)"getInstance().create(POOLED_THREAD, this)");
        this.alarm = alarm;
        this.scheduledComputation = new AtomicReference<Object>(null);
        this.lastSuccessfulComputation = new AtomicReference<Object>(null);
        this.lastFailedComputation = new AtomicReference<Object>(null);
    }

    public void dispose() {
    }

    public long getModificationCount() {
        long l;
        Computation<V> computation = this.lastSuccessfulComputation.get();
        if (computation != null) {
            Computation<V> it = computation;
            boolean bl = false;
            l = it.getModificationCountWhenScheduled() + 1L;
        } else {
            l = -1L;
        }
        return l;
    }

    @Nullable
    public V getNow() {
        Computation<V> computation = this.lastSuccessfulComputation.get();
        return (V)(computation != null ? computation.getResultNow() : null);
    }

    @NotNull
    public ListenableFuture<V> get() {
        V cachedValue;
        Computation<V> cachedComputation;
        Computation<V> computation = cachedComputation = this.lastSuccessfulComputation.get();
        Object object = cachedValue = computation != null ? computation.getResultNow() : null;
        if (cachedValue != null && ((Boolean)this.isUpToDate.invoke(cachedValue)).booleanValue()) {
            ListenableFuture listenableFuture = Futures.immediateFuture(cachedValue);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(cachedValue)");
            return listenableFuture;
        }
        Computation computation2 = new Computation(this.getModificationCount());
        Computation scheduled = this.scheduledComputation.compareAndExchange(null, computation2);
        if (scheduled == null) {
            this.alarm.addRequest(new Runnable(this){
                final /* synthetic */ ThrottlingAsyncSupplier<V> $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void run() {
                    ThrottlingAsyncSupplier.access$runScheduledComputation(this.$tmp0);
                }
            }, this.determineDelay(cachedComputation, this.lastFailedComputation.get()));
            return computation2.getResult();
        }
        return scheduled.getResult();
    }

    private final void runScheduledComputation() {
        Object v0 = this.scheduledComputation.getAndSet(null);
        Intrinsics.checkNotNull(v0);
        Computation computation = v0;
        Computation<V> cachedComputation = this.lastSuccessfulComputation.get();
        if (cachedComputation != null && cachedComputation.getModificationCountWhenScheduled() == computation.getModificationCountWhenScheduled() && ((Boolean)this.isUpToDate.invoke(cachedComputation.getResultNow())).booleanValue()) {
            computation.complete(cachedComputation.getResultNow());
            computation.broadcastResult();
            return;
        }
        Object result = null;
        try {
            result = this.compute.invoke();
        }
        catch (Throwable t) {
            computation.completeExceptionally(t);
            this.lastFailedComputation.set(computation);
            computation.broadcastResult();
            return;
        }
        computation.complete(result);
        this.lastSuccessfulComputation.set(computation);
        computation.broadcastResult();
    }

    private final long determineDelay(Computation<V> lastSuccessfulComputation, Computation<V> lastFailedComputation) {
        Computation<V> computation = lastSuccessfulComputation;
        long l = computation != null ? computation.getCompletionTimestamp() : -1L;
        Computation<V> computation2 = lastFailedComputation;
        long l2 = computation2 != null ? computation2.getCompletionTimestamp() : -1L;
        long lastComputationTime = Math.max(l, l2);
        if (lastComputationTime < 0L) {
            return this.mergingPeriod.toMillis();
        }
        long timeSinceLastComputation = System.currentTimeMillis() - lastComputationTime;
        return RangesKt.coerceAtLeast((long)(this.mergingPeriod.toMillis() - timeSinceLastComputation), (long)0L);
    }

    public static final /* synthetic */ void access$runScheduledComputation(ThrottlingAsyncSupplier $this) {
        $this.runScheduledComputation();
    }
}

