/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.copyright.CopyrightBundle;
import com.intellij.copyright.CopyrightManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.scopeChooser.PackageSetChooserCombo;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.ui.CopyrightProfilesPanel;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSettingsPanel {
    private final Project myProject;
    private final CopyrightProfilesPanel myProfilesModel;
    private final CopyrightManager myManager;
    private final TableView<ScopeSetting> myScopeMappingTable;
    private final ListTableModel<ScopeSetting> myScopeMappingModel;
    private final JComboBox<CopyrightProfile> myProfilesComboBox = new ComboBox();
    private final HyperlinkLabel myScopesLink = new HyperlinkLabel();

    public ProjectSettingsPanel(Project project, CopyrightProfilesPanel profilesModel) {
        this.myProject = project;
        this.myProfilesModel = profilesModel;
        this.myProfilesModel.addItemsChangeListener(new Runnable(){

            @Override
            public void run() {
                Object selectedItem = ProjectSettingsPanel.this.myProfilesComboBox.getSelectedItem();
                ProjectSettingsPanel.this.reloadCopyrightProfiles();
                ProjectSettingsPanel.this.myProfilesComboBox.setSelectedItem(selectedItem);
                ArrayList<ScopeSetting> toRemove = new ArrayList<ScopeSetting>();
                for (ScopeSetting setting : ProjectSettingsPanel.this.myScopeMappingModel.getItems()) {
                    if (setting.getProfile() != null) continue;
                    toRemove.add(setting);
                }
                for (ScopeSetting setting : toRemove) {
                    ProjectSettingsPanel.this.myScopeMappingModel.removeRow(ProjectSettingsPanel.this.myScopeMappingModel.indexOf((Object)setting));
                }
            }
        });
        this.myManager = CopyrightManager.getInstance(project);
        ColumnInfo[] columns = new ColumnInfo[]{new ScopeColumn(), new SettingColumn()};
        this.myScopeMappingModel = new ListTableModel(columns, new ArrayList(), 0);
        this.myScopeMappingTable = new TableView(this.myScopeMappingModel);
        this.myScopeMappingTable.setShowGrid(false);
        this.reloadCopyrightProfiles();
        this.myProfilesComboBox.setRenderer((ListCellRenderer<CopyrightProfile>)SimpleListCellRenderer.create((String)CopyrightBundle.message("copyright.no.text", new Object[0]), CopyrightProfile::getName));
        this.myScopesLink.setVisible(!this.myProject.isDefault());
        this.myScopesLink.setHyperlinkText(CopyrightBundle.message("copyright.select.scopes.label", new Object[0]));
        this.myScopesLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                Settings settings;
                DataContext context;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (context = (DataContext)DataManager.getInstance().getDataContextFromFocus().getResult()) != null && (settings = (Settings)Settings.KEY.getData(context)) != null) {
                    settings.select(settings.find("project.scopes"));
                }
            }
        });
    }

    public void reloadCopyrightProfiles() {
        DefaultComboBoxModel boxModel = (DefaultComboBoxModel)this.myProfilesComboBox.getModel();
        boxModel.removeAllElements();
        boxModel.addElement(null);
        for (CopyrightProfile profile : this.myProfilesModel.getAllProfiles().values()) {
            boxModel.addElement(profile);
        }
    }

    public JComponent getMainComponent() {
        LabeledComponent component = new LabeledComponent();
        component.setText(CopyrightBundle.message("copyright.default.project.copyright", new Object[0]));
        component.setLabelLocation("West");
        component.setComponent(this.myProfilesComboBox);
        ElementProducer<ScopeSetting> producer = new ElementProducer<ScopeSetting>(){

            public ScopeSetting createElement() {
                return new ScopeSetting(CustomScopesProviderEx.getAllScope(), ProjectSettingsPanel.this.myProfilesModel.getAllProfiles().values().iterator().next());
            }

            public boolean canCreateElement() {
                return true;
            }
        };
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myScopeMappingTable, (ElementProducer)producer).setAddActionUpdater(e -> !this.myProfilesModel.getAllProfiles().isEmpty());
        return JBUI.Panels.simplePanel((int)0, (int)10).addToTop((Component)component).addToCenter((Component)decorator.createPanel()).addToBottom((Component)this.myScopesLink);
    }

    public boolean isModified() {
        Object selected;
        CopyrightProfile defaultCopyright = this.myManager.getDefaultCopyright();
        if (!(defaultCopyright == (selected = this.myProfilesComboBox.getSelectedItem()) || selected != null && defaultCopyright != null && defaultCopyright.equals(selected))) {
            return true;
        }
        LinkedHashMap<String, String> map = this.myManager.getScopeToCopyright();
        if (map.size() != this.myScopeMappingModel.getItems().size()) {
            return true;
        }
        Iterator iterator = map.keySet().iterator();
        for (ScopeSetting setting : this.myScopeMappingModel.getItems()) {
            NamedScope scope = setting.getScope();
            if (!iterator.hasNext()) {
                return true;
            }
            String scopeName = (String)iterator.next();
            if (scope == null || !Comparing.strEqual((String)scopeName, (String)scope.getScopeId())) {
                return true;
            }
            String profileName = (String)map.get(scope.getScopeId());
            if (profileName == null) {
                return true;
            }
            if (profileName.equals(setting.getProfileName())) continue;
            return true;
        }
        return false;
    }

    public void apply() {
        this.myManager.setDefaultCopyright((CopyrightProfile)((Object)this.myProfilesComboBox.getSelectedItem()));
        this.myManager.clearMappings();
        for (ScopeSetting scopeSetting : this.myScopeMappingModel.getItems()) {
            this.myManager.mapCopyright(scopeSetting.getScope().getScopeId(), scopeSetting.getProfileName());
        }
    }

    public void reset() {
        this.myProfilesComboBox.setSelectedItem((Object)this.myManager.getDefaultCopyright());
        ArrayList<ScopeSetting> mappings = new ArrayList<ScopeSetting>();
        LinkedHashMap<String, String> copyrights = this.myManager.getScopeToCopyright();
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)this.myProject);
        HashSet<String> scopes2Unmap = new HashSet<String>();
        for (String scopeName : copyrights.keySet()) {
            NamedScope scope = manager.getScope(scopeName);
            if (scope != null) {
                mappings.add(new ScopeSetting(scope, (String)copyrights.get(scopeName)));
                continue;
            }
            scopes2Unmap.add(scopeName);
        }
        for (String scopeName : scopes2Unmap) {
            this.myManager.unmapCopyright(scopeName);
        }
        this.myScopeMappingModel.setItems(mappings);
    }

    public boolean hasAnyCopyrights() {
        return this.myProfilesComboBox.getSelectedItem() != null || !this.myScopeMappingModel.getItems().isEmpty();
    }

    private static abstract class MyColumnInfo<T>
    extends ColumnInfo<ScopeSetting, T> {
        protected MyColumnInfo(@NlsContexts.ColumnName String name) {
            super(name);
        }

        public boolean isCellEditable(ScopeSetting item) {
            return true;
        }
    }

    private final class ScopeColumn
    extends MyColumnInfo<NamedScope> {
        private ScopeColumn() {
            super(CopyrightBundle.message("copyright.scope.column", new Object[0]));
        }

        public TableCellRenderer getRenderer(ScopeSetting mapping) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (value == null) {
                        this.setText("");
                    } else {
                        NamedScope scope;
                        String scopeId = ((NamedScope)value).getScopeId();
                        if (!isSelected && (scope = NamedScopesHolder.getScope((Project)ProjectSettingsPanel.this.myProject, (String)scopeId)) == null) {
                            this.setForeground((Color)JBColor.RED);
                        }
                        this.setText(((NamedScope)value).getPresentableName());
                    }
                    return this;
                }
            };
        }

        public TableCellEditor getEditor(ScopeSetting mapping) {
            return new AbstractTableCellEditor(){
                private PackageSetChooserCombo myScopeChooser;

                @Nullable
                public Object getCellEditorValue() {
                    return this.myScopeChooser.getSelectedScope();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    this.myScopeChooser = new PackageSetChooserCombo(ProjectSettingsPanel.this.myProject, value == null ? null : ((NamedScope)value).getScopeId(), false, false){

                        protected NamedScope[] createModel() {
                            NamedScope[] model = super.createModel();
                            ArrayList<NamedScope> filteredScopes = new ArrayList<NamedScope>(Arrays.asList(model));
                            CustomScopesProviderEx.filterNoSettingsScopes((Project)ProjectSettingsPanel.this.myProject, filteredScopes);
                            return filteredScopes.toArray(NamedScope.EMPTY_ARRAY);
                        }
                    };
                    ((JBComboBoxTableCellEditorComponent)this.myScopeChooser.getChildComponent()).setCell(table, row, column);
                    return this.myScopeChooser;
                }
            };
        }

        public NamedScope valueOf(ScopeSetting mapping) {
            return mapping.getScope();
        }

        public void setValue(ScopeSetting mapping, NamedScope set) {
            mapping.setScope(set);
        }
    }

    private final class SettingColumn
    extends MyColumnInfo<CopyrightProfile> {
        private SettingColumn() {
            super(CopyrightBundle.message("copyright.copyright.column", new Object[0]));
        }

        public TableCellRenderer getRenderer(final ScopeSetting scopeSetting) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (!isSelected) {
                        CopyrightProfile profile = ProjectSettingsPanel.this.myProfilesModel.getAllProfiles().get(scopeSetting.getProfileName());
                        this.setForeground((Color)(profile == null ? JBColor.RED : UIUtil.getTableForeground()));
                    }
                    this.setText(scopeSetting.getProfileName());
                    return rendererComponent;
                }
            };
        }

        public TableCellEditor getEditor(final ScopeSetting scopeSetting) {
            return new AbstractTableCellEditor(){
                private final JBComboBoxTableCellEditorComponent myProfilesChooser = new JBComboBoxTableCellEditorComponent();

                public Object getCellEditorValue() {
                    return this.myProfilesChooser.getEditorValue();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    ArrayList<CopyrightProfile> copyrights = new ArrayList<CopyrightProfile>(ProjectSettingsPanel.this.myProfilesModel.getAllProfiles().values());
                    copyrights.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
                    this.myProfilesChooser.setCell(table, row, column);
                    this.myProfilesChooser.setOptions(copyrights.toArray());
                    this.myProfilesChooser.setDefaultValue((Object)scopeSetting.getProfile());
                    this.myProfilesChooser.setToString(o -> ((CopyrightProfile)((Object)((Object)o))).getName());
                    return this.myProfilesChooser;
                }
            };
        }

        public CopyrightProfile valueOf(ScopeSetting object) {
            return object.getProfile();
        }

        public void setValue(ScopeSetting scopeSetting, CopyrightProfile copyrightProfile) {
            if (copyrightProfile != null) {
                scopeSetting.setProfile(copyrightProfile);
            }
        }
    }

    private class ScopeSetting {
        private NamedScope myScope;
        private CopyrightProfile myProfile;
        private String myProfileName;

        private ScopeSetting(NamedScope scope, CopyrightProfile profile) {
            this.myScope = scope;
            this.myProfile = profile;
            if (this.myProfile != null) {
                this.myProfileName = this.myProfile.getName();
            }
        }

        ScopeSetting(NamedScope scope, String profile) {
            this.myScope = scope;
            this.myProfileName = profile;
        }

        public CopyrightProfile getProfile() {
            if (this.myProfileName != null) {
                this.myProfile = ProjectSettingsPanel.this.myProfilesModel.getAllProfiles().get(this.getProfileName());
            }
            return this.myProfile;
        }

        public void setProfile(@NotNull CopyrightProfile profile) {
            this.myProfile = profile;
            this.myProfileName = profile.getName();
        }

        public NamedScope getScope() {
            return this.myScope;
        }

        public void setScope(NamedScope scope) {
            this.myScope = scope;
        }

        @NlsSafe
        public String getProfileName() {
            return this.myProfile != null ? this.myProfile.getName() : this.myProfileName;
        }
    }
}

