/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.copyright.CopyrightBundle;
import com.intellij.copyright.CopyrightManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.actions.AbstractFileProcessor;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightFactory;
import com.maddyhome.idea.copyright.psi.UpdatePsiFileCopyright;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UpdateCopyrightProcessor
extends AbstractFileProcessor {
    public static final @NotNull Supplier<@Nls String> TITLE = CopyrightBundle.messagePointer("update.copyright.progress.title", new Object[0]);
    public static final @NotNull Supplier<@Nls String> MESSAGE = CopyrightBundle.messagePointer("updating.copyrights.progress.message", new Object[0]);
    private Project project;
    private Module module;
    private static final Logger logger = Logger.getInstance((String)UpdateCopyrightProcessor.class.getName());

    public UpdateCopyrightProcessor(@NotNull Project project, Module module, @NotNull PsiFile file) {
        super(project, file, TITLE.get(), MESSAGE.get());
        this.setup(project, module);
    }

    public UpdateCopyrightProcessor(@NotNull Project project, Module module, PsiFile @NotNull [] files) {
        super(project, files, TITLE.get(), MESSAGE.get());
        this.setup(project, module);
    }

    @Override
    protected Runnable preprocessFile(PsiFile file, boolean allowReplacement) throws IncorrectOperationException {
        VirtualFile vfile = file.getVirtualFile();
        if (vfile == null) {
            return EmptyRunnable.getInstance();
        }
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText2(vfile.getPresentableUrl());
        }
        Module mod = this.module;
        if (this.module == null) {
            mod = ProjectRootManager.getInstance((Project)this.project).getFileIndex().getModuleForFile(vfile);
        }
        if (mod == null) {
            return EmptyRunnable.getInstance();
        }
        CopyrightProfile opts = CopyrightManager.getInstance(this.project).getCopyrightOptions(file);
        if (opts != null && FileTypeUtil.isSupportedFile(file)) {
            logger.debug("process " + file);
            UpdateCopyright update = UpdateCopyrightFactory.createUpdateCopyright(this.project, mod, file, opts);
            if (update == null) {
                return EmptyRunnable.getInstance();
            }
            update.prepare();
            if (update instanceof UpdatePsiFileCopyright && !((UpdatePsiFileCopyright)update).hasUpdates()) {
                return EmptyRunnable.getInstance();
            }
            return () -> {
                try {
                    if (update instanceof UpdatePsiFileCopyright) {
                        ((UpdatePsiFileCopyright)update).complete(allowReplacement);
                    } else {
                        update.complete();
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            };
        }
        return EmptyRunnable.getInstance();
    }

    private void setup(Project project, Module module) {
        this.project = project;
        this.module = module;
    }
}

