/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.copyright.CopyrightBundle;
import com.intellij.copyright.CopyrightManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightAdditionalUi;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightProcessor;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class UpdateCopyrightAction
extends BaseAnalysisAction {
    public static final String UPDATE_EXISTING_COPYRIGHTS = "update.existing.copyrights";
    private UpdateCopyrightAdditionalUi myUi;

    private UpdateCopyrightAction() {
        super(UpdateCopyrightProcessor.TITLE, UpdateCopyrightProcessor.TITLE);
    }

    public void update(@NotNull AnActionEvent event) {
        boolean enabled = UpdateCopyrightAction.isEnabled(event);
        event.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            event.getPresentation().setVisible(enabled);
        }
    }

    private static boolean isEnabled(AnActionEvent e) {
        PsiElement[] elems;
        DataContext context = e.getDataContext();
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        if (!CopyrightManager.getInstance(project).hasAnyCopyrights()) {
            return false;
        }
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            return FileTypeUtil.isSupportedFile(file);
        }
        if (files != null && UpdateCopyrightAction.areFiles(files)) {
            boolean copyrightEnabled = false;
            for (VirtualFile vfile : files) {
                if (vfile == null || !FileTypeUtil.isSupportedFile(vfile)) continue;
                copyrightEnabled = true;
                break;
            }
            return copyrightEnabled;
        }
        if ((files == null || files.length != 1) && LangDataKeys.MODULE_CONTEXT.getData(context) == null && LangDataKeys.MODULE_CONTEXT_ARRAY.getData(context) == null && PlatformCoreDataKeys.PROJECT_CONTEXT.getData(context) == null && (elems = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context)) != null) {
            boolean copyrightEnabled = false;
            for (PsiElement elem : elems) {
                PsiFile file;
                if (elem instanceof PsiDirectory || (file = elem.getContainingFile()) != null && FileTypeUtil.isSupportedFile(file.getVirtualFile())) continue;
                copyrightEnabled = true;
                break;
            }
            return copyrightEnabled;
        }
        return true;
    }

    @NotNull
    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog) {
        this.myUi = new UpdateCopyrightAdditionalUi();
        this.myUi.getUpdateExistingCopyrightsCb().setSelected(PropertiesComponent.getInstance().getBoolean(UPDATE_EXISTING_COPYRIGHTS, true));
        return this.myUi.getPanel();
    }

    protected void analyze(@NotNull Project project, @NotNull AnalysisScope scope) {
        PropertiesComponent.getInstance().setValue(UPDATE_EXISTING_COPYRIGHTS, String.valueOf(this.myUi.getUpdateExistingCopyrightsCb().isSelected()), "true");
        UpdateCopyrightTask task = new UpdateCopyrightTask(project, scope, this.myUi.getUpdateExistingCopyrightsCb().isSelected(), PerformInBackgroundOption.ALWAYS_BACKGROUND);
        ProgressManager.getInstance().run((Task)task);
    }

    private static boolean areFiles(VirtualFile @NotNull [] files) {
        if (files.length < 2) {
            return false;
        }
        for (VirtualFile file : files) {
            if (!file.isDirectory()) continue;
            return false;
        }
        return true;
    }

    public static class UpdateCopyrightTask
    extends Task.ConditionalModal {
        private final Map<PsiFile, Runnable> preparations = new LinkedHashMap<PsiFile, Runnable>();
        @NotNull
        private final AnalysisScope myScope;
        private final boolean myAllowReplacement;

        public UpdateCopyrightTask(@NotNull Project project, @NotNull AnalysisScope scope, boolean allowReplacement, @NotNull PerformInBackgroundOption options) {
            super(project, CopyrightBundle.message("task.title.prepare.copyright", new Object[0]), true, options);
            this.myScope = scope;
            this.myAllowReplacement = allowReplacement;
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            this.myScope.accept(new PsiElementVisitor(){

                public void visitFile(@NotNull PsiFile file) {
                    if (indicator.isCanceled()) {
                        return;
                    }
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
                    UpdateCopyrightProcessor processor = new UpdateCopyrightProcessor(file.getProject(), module, file);
                    Runnable runnable = processor.preprocessFile(file, myAllowReplacement);
                    if (runnable != EmptyRunnable.getInstance()) {
                        preparations.put(file, runnable);
                    }
                }
            });
        }

        public void onSuccess() {
            if (!this.preparations.isEmpty()) {
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(this.preparations.keySet())) {
                    return;
                }
                SequentialModalProgressTask progressTask = new SequentialModalProgressTask(this.myProject, UpdateCopyrightProcessor.TITLE.get(), true);
                progressTask.setMinIterationTime(200L);
                progressTask.setTask((SequentialTask)new UpdateCopyrightSequentialTask(this.preparations, progressTask));
                CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
                    ProgressManager.getInstance().run((Task)progressTask);
                }, UpdateCopyrightProcessor.TITLE.get(), null);
            }
        }
    }

    private static final class UpdateCopyrightSequentialTask
    implements SequentialTask {
        private final int mySize;
        private final Iterator<Runnable> myRunnables;
        private final SequentialModalProgressTask myProgressTask;
        private int myIdx;

        private UpdateCopyrightSequentialTask(Map<PsiFile, Runnable> runnables, SequentialModalProgressTask progressTask) {
            this.myRunnables = runnables.values().iterator();
            this.myProgressTask = progressTask;
            this.mySize = runnables.size();
        }

        public boolean isDone() {
            return this.myIdx > this.mySize - 1;
        }

        public boolean iteration() {
            ProgressIndicator indicator = this.myProgressTask.getIndicator();
            if (indicator != null) {
                indicator.setFraction((double)this.myIdx / (double)this.mySize);
            }
            this.myRunnables.next().run();
            ++this.myIdx;
            return true;
        }

        public void stop() {
            this.myIdx = this.mySize;
        }
    }
}

