/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.copyright.CopyrightManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFileProcessor {
    private static final Logger LOG = Logger.getInstance((String)AbstractFileProcessor.class.getName());
    private final Project myProject;
    private final Module myModule;
    private final PsiFile file;
    private final PsiFile[] files;
    private final @NlsContexts.ProgressText String message;
    private final @NlsContexts.ProgressTitle String title;

    protected abstract Runnable preprocessFile(PsiFile var1, boolean var2) throws IncorrectOperationException;

    protected AbstractFileProcessor(@NotNull Project project, @NotNull PsiFile file, @NotNull @NlsContexts.ProgressTitle String title, @NotNull @NlsContexts.ProgressText String message) {
        this.myProject = project;
        this.myModule = null;
        this.file = file;
        this.files = null;
        this.message = message;
        this.title = title;
    }

    protected AbstractFileProcessor(@NotNull Project project, PsiFile @NotNull [] files, @NotNull @NlsContexts.ProgressTitle String title, @NotNull @NlsContexts.ProgressText String message) {
        this.myProject = project;
        this.myModule = null;
        this.file = null;
        this.files = files;
        this.message = message;
        this.title = title;
    }

    public void run() {
        if (this.files != null) {
            this.process(this.files);
        } else if (this.file != null) {
            this.process(this.file);
        } else if (this.myModule != null) {
            this.process(this.myModule);
        } else {
            this.process(this.myProject);
        }
    }

    private void process(@NotNull PsiFile file) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file)) {
            return;
        }
        Runnable[] resultRunnable = new Runnable[1];
        this.execute(() -> {
            try {
                resultRunnable[0] = this.preprocessFile(file, true);
            }
            catch (IncorrectOperationException incorrectoperationexception) {
                LOG.error((Throwable)incorrectoperationexception);
            }
        }, () -> {
            if (resultRunnable[0] != null) {
                resultRunnable[0].run();
            }
        });
    }

    private Runnable prepareFiles(@NotNull List<? extends PsiFile> files) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        String msg = null;
        double fraction = 0.0;
        if (indicator != null) {
            msg = indicator.getText();
            fraction = indicator.getFraction();
            indicator.setText(this.message);
        }
        Runnable[] runnables = new Runnable[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            PsiFile pfile = files.get(i);
            if (pfile == null) {
                LOG.debug("Unexpected null file at " + i);
                continue;
            }
            if (indicator != null) {
                if (indicator.isCanceled()) {
                    return null;
                }
                indicator.setFraction((double)i / (double)files.size());
            }
            if (pfile.isWritable()) {
                try {
                    runnables[i] = this.preprocessFile(pfile, true);
                }
                catch (IncorrectOperationException incorrectoperationexception) {
                    LOG.error((Throwable)incorrectoperationexception);
                }
            }
            files.set(i, null);
        }
        if (indicator != null) {
            indicator.setText(msg);
            indicator.setFraction(fraction);
        }
        return () -> {
            ProgressIndicator indicator1 = ProgressManager.getInstance().getProgressIndicator();
            String msg1 = null;
            double fraction1 = 0.0;
            if (indicator1 != null) {
                msg1 = indicator1.getText();
                fraction1 = indicator1.getFraction();
                indicator1.setText(this.message);
            }
            for (int j = 0; j < runnables.length; ++j) {
                Runnable runnable;
                if (indicator1 != null) {
                    if (indicator1.isCanceled()) {
                        return;
                    }
                    indicator1.setFraction((double)j / (double)runnables.length);
                }
                if ((runnable = runnables[j]) != null) {
                    runnable.run();
                }
                runnables[j] = null;
            }
            if (indicator1 != null) {
                indicator1.setText(msg1);
                indicator1.setFraction(fraction1);
            }
        };
    }

    private void process(PsiFile @NotNull [] files) {
        Runnable[] resultRunnable = new Runnable[1];
        this.execute(() -> {
            resultRunnable[0] = this.prepareFiles(new ArrayList<PsiFile>(Arrays.asList(files)));
        }, () -> {
            if (resultRunnable[0] != null) {
                resultRunnable[0].run();
            }
        });
    }

    private void process(@NotNull Project project) {
        ArrayList pfiles = new ArrayList();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> AbstractFileProcessor.findFiles(project, (List<? super PsiFile>)pfiles), this.title, true, project);
        this.handleFiles(pfiles);
    }

    private void process(@NotNull Module module) {
        ArrayList pfiles = new ArrayList();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> AbstractFileProcessor.findFiles(module, (List<? super PsiFile>)pfiles), this.title, true, this.myProject);
        this.handleFiles(pfiles);
    }

    private static void findFiles(@NotNull Project project, List<? super PsiFile> files) {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            AbstractFileProcessor.findFiles(module, files);
        }
    }

    private static void findFiles(@NotNull Module module, @NotNull List<? super PsiFile> files) {
        VirtualFile[] roots;
        ModuleFileIndex idx = ModuleRootManager.getInstance((Module)module).getFileIndex();
        for (VirtualFile root : roots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            ApplicationManager.getApplication().runReadAction(() -> idx.iterateContentUnderDirectory(root, dir -> {
                PsiDirectory psiDir;
                if (dir.isDirectory() && (psiDir = PsiManager.getInstance((Project)module.getProject()).findDirectory(dir)) != null) {
                    AbstractFileProcessor.findFiles(files, psiDir, false);
                }
                return true;
            }));
        }
    }

    private void handleFiles(@NotNull List<? extends PsiFile> files) {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        for (PsiFile psiFile : files) {
            list.add(psiFile.getVirtualFile());
        }
        if (!ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(list).hasReadonlyFiles() && !files.isEmpty()) {
            Runnable[] resultRunnable = new Runnable[1];
            this.execute(() -> {
                resultRunnable[0] = this.prepareFiles(files);
            }, () -> {
                if (resultRunnable[0] != null) {
                    resultRunnable[0].run();
                }
            });
        }
    }

    private static void findFiles(@NotNull List<? super PsiFile> files, @NotNull PsiDirectory directory, boolean subdirs) {
        PsiFile[] locals;
        Project project = directory.getProject();
        for (PsiFile psiFile : locals = directory.getFiles()) {
            CopyrightProfile opts = CopyrightManager.getInstance(project).getCopyrightOptions(psiFile);
            if (opts == null || !FileTypeUtil.isSupportedFile(psiFile)) continue;
            files.add((PsiFile)psiFile);
        }
        if (subdirs) {
            for (PsiFile psiFile : directory.getSubdirectories()) {
                AbstractFileProcessor.findFiles(files, (PsiDirectory)psiFile, true);
            }
        }
    }

    private void execute(@NotNull Runnable readAction, @NotNull Runnable writeAction) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(readAction), this.title, true, this.myProject);
        WriteCommandAction.writeCommandAction((Project)this.myProject).withName(this.title).run(() -> writeAction.run());
    }
}

