/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.game;

import com.android.tools.game.AdbPath;
import com.android.tools.game.FakeToolWindow;
import com.android.tools.game.NoopToolWindowWrapper;
import com.android.tools.game.ProfilerService;
import com.android.tools.game.ProfilerServiceKt;
import com.android.tools.game.ProjectWrapper;
import com.android.tools.game.WindowWrapper;
import com.android.tools.game.protos.StartProfilingRequest;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.io.grpc.Status;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.profilers.AndroidProfilerService;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.PreferredProcessInfo;
import com.android.tools.idea.profilers.ToolWindowWrapper;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/game/ProfilerServiceImpl;", "Lcom/android/tools/game/ProfilerService;", "()V", "androidProfilers", "", "", "Lcom/android/tools/idea/profilers/AndroidProfilerToolWindow;", "initialized", "", "profilerWindowIcons", "", "Ljava/awt/Image;", "profilerWindows", "Lcom/android/tools/game/WindowWrapper;", "createProfilerWindow", "project", "Lcom/android/tools/game/ProjectWrapper;", "onWindowClose", "Lkotlin/Function2;", "", "getDeviceTimeNs", "", "deviceId", "startProfiler", "request", "Lcom/android/tools/game/protos/StartProfilingRequest;", "tryInitializeProfilerServices", "android.game-tools.main"})
public final class ProfilerServiceImpl
implements ProfilerService {
    @NotNull
    private final Map<String, WindowWrapper> profilerWindows = new HashMap();
    @NotNull
    private final Map<String, AndroidProfilerToolWindow> androidProfilers = new HashMap();
    @NotNull
    private final List<Image> profilerWindowIcons;
    private boolean initialized;

    public ProfilerServiceImpl() {
        Icon icon = StudioIcons.Shell.Toolbar.PROFILER;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PROFILER");
        int[] nArray = new int[]{16, 32, 64, 256, 512};
        this.profilerWindowIcons = ProfilerServiceKt.iconToImages(icon, nArray);
    }

    @Override
    @NotNull
    public WindowWrapper createProfilerWindow(@NotNull ProjectWrapper project, @NotNull Function2<? super ProjectWrapper, ? super WindowWrapper, Unit> onWindowClose) {
        WindowWrapper windowWrapper;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onWindowClose, (String)"onWindowClose");
        this.tryInitializeProfilerServices();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String windowId = string;
        Ref.ObjectRef window = new Ref.ObjectRef();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(this, project, (Ref.ObjectRef<WindowWrapper>)window, windowId, onWindowClose){
            final /* synthetic */ ProfilerServiceImpl this$0;
            final /* synthetic */ ProjectWrapper $project;
            final /* synthetic */ Ref.ObjectRef<WindowWrapper> $window;
            final /* synthetic */ String $windowId;
            final /* synthetic */ Function2<ProjectWrapper, WindowWrapper, Unit> $onWindowClose;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$window = $window;
                this.$windowId = $windowId;
                this.$onWindowClose = $onWindowClose;
            }

            public final void run() {
                WindowWrapper windowWrapper;
                V v = ProfilerServiceImpl.access$getAndroidProfilers$p(this.this$0).computeIfAbsent(this.$project.getId(), new Function(this.$project){
                    final /* synthetic */ ProjectWrapper $project;
                    {
                        this.$project = $project;
                    }

                    @NotNull
                    public final AndroidProfilerToolWindow apply(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return new AndroidProfilerToolWindow((ToolWindowWrapper)new NoopToolWindowWrapper(false, null, null, 7, null), this.$project.asIdeaProject());
                    }
                });
                Intrinsics.checkNotNullExpressionValue(v, (String)"project: ProjectWrapper,\u2026.asIdeaProject())\n      }");
                AndroidProfilerToolWindow profilerToolWindow2 = (AndroidProfilerToolWindow)v;
                FakeToolWindow fakeToolWindow = new FakeToolWindow(this.$project.asIdeaProject());
                ProfilerServiceImpl profilerServiceImpl = this.this$0;
                FakeToolWindow $this$run_u24lambda_u2d0 = fakeToolWindow;
                boolean bl = false;
                $this$run_u24lambda_u2d0.setTitle("Android Studio Profiler");
                $this$run_u24lambda_u2d0.setIconImages(ProfilerServiceImpl.access$getProfilerWindowIcons$p(profilerServiceImpl));
                $this$run_u24lambda_u2d0.setDefaultCloseOperation(2);
                $this$run_u24lambda_u2d0.setGlassPane((Component)new IdeGlassPaneImpl($this$run_u24lambda_u2d0.getRootPane()));
                $this$run_u24lambda_u2d0.add(profilerToolWindow2.getComponent());
                $this$run_u24lambda_u2d0.setSize(new Dimension(800, 600));
                $this$run_u24lambda_u2d0.setUndecorated(false);
                $this$run_u24lambda_u2d0.setVisible(true);
                FakeToolWindow frame = fakeToolWindow;
                AndroidNotification.setFallbackNotificationDestination((Project)this.$project.asIdeaProject(), (JFrame)frame);
                frame.addWindowListener(new WindowAdapter(this.this$0, this.$windowId, this.$onWindowClose, this.$project, this.$window){
                    final /* synthetic */ ProfilerServiceImpl this$0;
                    final /* synthetic */ String $windowId;
                    final /* synthetic */ Function2<ProjectWrapper, WindowWrapper, Unit> $onWindowClose;
                    final /* synthetic */ ProjectWrapper $project;
                    final /* synthetic */ Ref.ObjectRef<WindowWrapper> $window;
                    {
                        this.this$0 = $receiver;
                        this.$windowId = $windowId;
                        this.$onWindowClose = $onWindowClose;
                        this.$project = $project;
                        this.$window = $window;
                    }

                    public void windowClosing(@NotNull WindowEvent windowEvent) {
                        WindowWrapper windowWrapper;
                        Intrinsics.checkNotNullParameter((Object)windowEvent, (String)"windowEvent");
                        ProfilerServiceImpl.access$getProfilerWindows$p(this.this$0).remove(this.$windowId);
                        if (this.$window.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"window");
                            windowWrapper = null;
                        } else {
                            windowWrapper = (WindowWrapper)this.$window.element;
                        }
                        this.$onWindowClose.invoke((Object)this.$project, (Object)windowWrapper);
                    }
                });
                this.$window.element = new WindowWrapper(this.$windowId, profilerToolWindow2, frame);
                Map map = ProfilerServiceImpl.access$getProfilerWindows$p(this.this$0);
                if (this.$window.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"window");
                    windowWrapper = null;
                } else {
                    windowWrapper = (WindowWrapper)this.$window.element;
                }
                map.put(this.$windowId, windowWrapper);
            }
        });
        if (window.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"window");
            windowWrapper = null;
        } else {
            windowWrapper = (WindowWrapper)window.element;
        }
        return windowWrapper;
    }

    @Override
    public void startProfiler(@NotNull StartProfilingRequest request) {
        Object v5;
        WindowWrapper window;
        block4: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.tryInitializeProfilerServices();
            WindowWrapper windowWrapper = this.profilerWindows.get(request.getWindowId());
            if (windowWrapper == null) {
                StatusRuntimeException statusRuntimeException = Status.INVALID_ARGUMENT.withDescription("Window '" + request.getWindowId() + "' cannot be found.").asRuntimeException();
                Intrinsics.checkNotNullExpressionValue((Object)statusRuntimeException, (String)"INVALID_ARGUMENT.withDes\u2026d.\").asRuntimeException()");
                throw (Throwable)statusRuntimeException;
            }
            window = windowWrapper;
            StudioProfilers studioProfilers = window.getProfilerToolWindow().getProfilers();
            if (studioProfilers == null) {
                StatusRuntimeException statusRuntimeException = Status.INTERNAL.withDescription("Cannot initialize profilers.").asRuntimeException();
                Intrinsics.checkNotNullExpressionValue((Object)statusRuntimeException, (String)"INTERNAL.withDescription\u2026s.\").asRuntimeException()");
                throw (Throwable)statusRuntimeException;
            }
            StudioProfilers studioProfilers2 = studioProfilers;
            List list = studioProfilers2.getDevices();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"studioProfilers.devices");
            Iterable iterable = list;
            for (Object t : iterable) {
                Common.Device it = (Common.Device)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSerial(), (Object)request.getSerialNumber())) continue;
                v5 = t;
                break block4;
            }
            v5 = null;
        }
        Common.Device device = v5;
        if (device == null) {
            StatusRuntimeException statusRuntimeException = Status.INVALID_ARGUMENT.withDescription("Device " + request.getSerialNumber() + " cannot be found.").asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)statusRuntimeException, (String)"INVALID_ARGUMENT.withDes\u2026d.\").asRuntimeException()");
            throw (Throwable)statusRuntimeException;
        }
        Common.Device device2 = device;
        long deviceTimeNs = this.getDeviceTimeNs(device2.getDeviceId());
        long systemTimeMs = System.currentTimeMillis();
        long processLaunchTimeMinBoundNs = Duration.ofMillis(request.getStartLaterThanMs() - systemTimeMs).toNanos() + deviceTimeNs;
        String string = AndroidProfilerToolWindow.getDeviceDisplayName((String)device2.getManufacturer(), (String)device2.getModel(), (String)device2.getSerial());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDeviceDisplayName(dev\u2026ice.model, device.serial)");
        PreferredProcessInfo preferredProcessInfo2 = new PreferredProcessInfo(string, request.getApplicationId(), (Function1)new Function1<Common.Process, Boolean>(processLaunchTimeMinBoundNs){
            final /* synthetic */ long $processLaunchTimeMinBoundNs;
            {
                this.$processLaunchTimeMinBoundNs = $processLaunchTimeMinBoundNs;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Common.Process it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getStartTimestampNs() >= this.$processLaunchTimeMinBoundNs;
            }
        });
        StudioProfilers studioProfilers = window.getProfilerToolWindow().getProfilers();
        Intrinsics.checkNotNull((Object)studioProfilers);
        studioProfilers.getDeviceProcessMap().clear();
        window.getProfilerToolWindow().profile(preferredProcessInfo2);
    }

    private final long getDeviceTimeNs(long deviceId) {
        ProfilerClient client = new ProfilerClient(TransportService.Companion.getChannelName());
        try {
            Transport.TimeResponse timeResponse = client.getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(deviceId).build());
            return timeResponse.getTimestampNs();
        }
        catch (StatusRuntimeException exception) {
            StatusRuntimeException statusRuntimeException = Status.INTERNAL.withCause((Throwable)exception).asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)statusRuntimeException), (String)"INTERNAL.withCause(exception).asRuntimeException()");
            throw (Throwable)statusRuntimeException;
        }
    }

    private final void tryInitializeProfilerServices() {
        if (this.initialized) {
            return;
        }
        File adbPath = AdbPath.INSTANCE.get();
        try {
            AdbService.getInstance().getDebugBridge(adbPath).get();
            AndroidProfilerService.getInstance();
        }
        catch (Exception e) {
            StatusRuntimeException statusRuntimeException = Status.UNKNOWN.withDescription("Failed to start profiler: " + e.getMessage()).asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)statusRuntimeException), (String)"UNKNOWN\n        .withDes\u2026    .asRuntimeException()");
            throw (Throwable)statusRuntimeException;
        }
        this.initialized = true;
    }

    public static final /* synthetic */ Map access$getAndroidProfilers$p(ProfilerServiceImpl $this) {
        return $this.androidProfilers;
    }

    public static final /* synthetic */ Map access$getProfilerWindows$p(ProfilerServiceImpl $this) {
        return $this.profilerWindows;
    }

    public static final /* synthetic */ List access$getProfilerWindowIcons$p(ProfilerServiceImpl $this) {
        return $this.profilerWindowIcons;
    }
}

