/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.game;

import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.game.ArgumentParser;
import com.android.tools.game.AvdManagerServiceImpl;
import com.android.tools.game.AvdManagerWindowWrapper;
import com.android.tools.game.DeviceFileExplorerServiceImpl;
import com.android.tools.game.DeviceFileExplorerWindowWrapper;
import com.android.tools.game.GameToolsServer;
import com.android.tools.game.GameToolsStarter;
import com.android.tools.game.LogcatServiceImpl;
import com.android.tools.game.ProfilerServiceImpl;
import com.android.tools.game.ProjectServiceImpl;
import com.android.tools.game.ProjectWrapper;
import com.android.tools.game.SdkManagerServiceImpl;
import com.android.tools.game.WindowWrapper;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.analytics.AndroidStudioAnalytics;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.util.SystemProperties;
import java.awt.Font;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u001b\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0010H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/game/GameToolsStarter;", "Lcom/intellij/openapi/application/ApplicationStarter;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "fatal", "", "mode", "Lcom/android/tools/game/GameToolsStarter$Mode;", "message", "", "getCommandName", "getRequiredModality", "", "initializeSdk", "", "sdkPath", "Ljava/io/File;", "isHeadless", "", "main", "args", "", "([Ljava/lang/String;)V", "startAvdManagerApp", "Lcom/android/tools/game/AvdManagerWindowWrapper;", "startDeviceFileExplorerApp", "Lcom/android/tools/game/DeviceFileExplorerWindowWrapper;", "startLogcat", "Ljavax/swing/JFrame;", "startProfilerApp", "Lcom/android/tools/game/WindowWrapper;", "startSdkManagerApp", "AppWindow", "Mode", "android.game-tools.main"})
public final class GameToolsStarter
implements ApplicationStarter {
    @NotNull
    private final Logger logger;

    public GameToolsStarter() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GameToolsStarter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.logger = logger;
    }

    @NotNull
    public String getCommandName() {
        return "game-tools";
    }

    /*
     * WARNING - void declaration
     */
    public void main(@NotNull String[] args) {
        block33: {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            ArgumentParser params = new ArgumentParser().parse(args);
            try {
                File sdkPath;
                File file;
                Keymap keymap;
                AppWindow appWindow;
                Mode mode;
                Integer port;
                block32: {
                    Keymap sdkPathOptions2;
                    AppWindow appWindow2;
                    int n;
                    Mode mode2;
                    Keymap it;
                    String string = params.getPort();
                    port = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
                    Keymap keymap2 = params.getMode();
                    if (keymap2 != null) {
                        it = keymap2;
                        boolean bl = false;
                        mode2 = Mode.valueOf((String)it);
                    } else {
                        mode2 = null;
                    }
                    mode = mode2;
                    String string2 = params.getAppWindow();
                    if (string2 != null) {
                        String it2 = string2;
                        n = 0;
                        appWindow2 = AppWindow.valueOf(it2);
                    } else {
                        appWindow2 = null;
                    }
                    appWindow = appWindow2;
                    it = new Keymap[]{(Function0)new Function0<File>(params){
                        final /* synthetic */ ArgumentParser $params;
                        {
                            this.$params = $params;
                            super(0);
                        }

                        @Nullable
                        public final File invoke() {
                            File file;
                            String string = this.$params.getSdkPath();
                            if (string != null) {
                                String it = string;
                                boolean bl = false;
                                file = new File(it);
                            } else {
                                file = null;
                            }
                            return file;
                        }
                    }, main.sdkPathOptions.2.INSTANCE, main.sdkPathOptions.3.INSTANCE, main.sdkPathOptions.4.INSTANCE};
                    keymap = sdkPathOptions2 = it;
                    int n2 = ((Function0[])keymap).length;
                    for (n = 0; n < n2; ++n) {
                        Function0 it3 = keymap[n];
                        boolean bl = false;
                        file = (File)it3.invoke();
                        if (file == null) {
                            continue;
                        }
                        break block32;
                    }
                    file = null;
                }
                if ((sdkPath = file) == null) {
                    this.fatal(mode, "Cannot find Android SDK on your system. Please install the Android SDK and set the 'ANDROID_SDK_ROOT' environment variable.");
                    throw new KotlinNothingValueException();
                }
                this.initializeSdk(sdkPath);
                AndroidStudioAnalytics.getInstance().initializeAndroidStudioUsageTrackerAndPublisher();
                Runtime.getRuntime().addShutdownHook(new Thread(main.1.INSTANCE));
                Runnable runnable = SplashManager.getHideTask();
                if (runnable != null) {
                    runnable.run();
                }
                Keymap $this$main_u24lambda_u2d3 = keymap = KeymapManager.getInstance().getActiveKeymap();
                boolean bl = false;
                $this$main_u24lambda_u2d3.removeAllActionShortcuts("GotoAction");
                $this$main_u24lambda_u2d3.removeAllActionShortcuts("ShowSettings");
                AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.GAME_TOOLS_PING).setProductDetails(AndroidStudioUsageTracker.getProductDetails()).setMachineDetails(AndroidStudioUsageTracker.getMachineDetails((File)new File(PathManager.getHomePath()))).setJvmDetails(CommonMetricsData.getJvmDetails());
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()\n          .\u2026onMetricsData.jvmDetails)");
                UsageTracker.log((AndroidStudioEvent.Builder)builder);
                Mode mode3 = mode;
                switch (mode3 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[mode3.ordinal()]) {
                    case 1: {
                        if (port == null) {
                            this.fatal(mode, "You must specify a port with '--port' in SERVER mode.");
                            throw new KotlinNothingValueException();
                        }
                        new GameToolsServer(port, null, null, null, null, null, null, 126, null).start();
                        break;
                    }
                    case 2: {
                        AppWindow appWindow3 = appWindow;
                        switch (appWindow3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[appWindow3.ordinal()]) {
                            case 1: {
                                this.startProfilerApp();
                                break block33;
                            }
                            case 2: {
                                this.startSdkManagerApp();
                                break block33;
                            }
                            case 3: {
                                this.startAvdManagerApp();
                                break block33;
                            }
                            case 4: {
                                this.startDeviceFileExplorerApp();
                                break block33;
                            }
                            case 5: {
                                this.startLogcat();
                                break block33;
                            }
                            default: {
                                void $this$mapTo$iv$iv;
                                AppWindow[] $this$map$iv = AppWindow.values();
                                boolean $i$f$map = false;
                                AppWindow[] appWindowArray = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                                boolean $i$f$mapTo = false;
                                int n = ((void)$this$mapTo$iv$iv).length;
                                for (int i = 0; i < n; ++i) {
                                    void it;
                                    void item$iv$iv;
                                    void var21_36 = item$iv$iv = $this$mapTo$iv$iv[i];
                                    Collection collection = destination$iv$iv;
                                    boolean bl2 = false;
                                    collection.add(it.toString());
                                }
                                List options = (List)destination$iv$iv;
                                this.fatal(mode, "You must specify a valid window to open with '--app-window [" + CollectionsKt.joinToString$default((Iterable)options, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + "] in APP mode.");
                                throw new KotlinNothingValueException();
                            }
                        }
                    }
                    case 3: {
                        GameToolsServer gameToolsServer = new GameToolsServer(0, null, null, null, null, null, null, 126, null);
                        gameToolsServer.start();
                        gameToolsServer.shutdown();
                        AppWindow appWindow4 = appWindow;
                        switch (appWindow4 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[appWindow4.ordinal()]) {
                            case 1: {
                                this.startProfilerApp().closeWindow();
                                break block33;
                            }
                            case 2: {
                                this.fatal(mode, "VERIFY mode does not support using --app-window SDK_MANAGER");
                                throw new KotlinNothingValueException();
                            }
                            case 3: {
                                this.startAvdManagerApp().closeWindow();
                                break block33;
                            }
                            case 4: {
                                this.startDeviceFileExplorerApp().closeWindow();
                                break block33;
                            }
                            case 5: {
                                JFrame window = this.startLogcat();
                                window.dispatchEvent(new WindowEvent(window, 201));
                                break block33;
                            }
                            default: {
                                void $this$mapTo$iv$iv;
                                AppWindow[] $this$map$iv = AppWindow.values();
                                boolean $i$f$map = false;
                                AppWindow[] destination$iv$iv = $this$map$iv;
                                Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
                                boolean $i$f$mapTo = false;
                                int n = ((void)$this$mapTo$iv$iv).length;
                                for (int i = 0; i < n; ++i) {
                                    void it;
                                    void item$iv$iv;
                                    void bl2 = item$iv$iv = $this$mapTo$iv$iv[i];
                                    Collection collection = destination$iv$iv2;
                                    boolean bl3 = false;
                                    collection.add(it.toString());
                                }
                                List options = (List)destination$iv$iv2;
                                this.fatal(mode, "You must specify a valid window to open with '--app-window [" + CollectionsKt.joinToString$default((Iterable)options, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + "] in VERIFY mode.");
                                throw new KotlinNothingValueException();
                            }
                        }
                    }
                    default: {
                        this.fatal(mode, "You must specify a mode with '--mode [APP|SERVER|VERIFY]'.");
                        throw new KotlinNothingValueException();
                    }
                }
            }
            catch (Throwable e) {
                this.logger.error("GameToolsServer crashed!", e);
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Void fatal(Mode mode, String message) {
        try {
            File ideaLog = new File(PathManager.getLogPath(), "idea.log");
            if (mode == Mode.SERVER || mode == Mode.VERIFY) {
                this.logger.error(message + " For more details, see " + ideaLog);
            }
            Font $this$fatal_u24lambda_u2d6 = new JLabel().getFont();
            boolean bl = false;
            String style = StringsKt.trimIndent((String)("\n          font-family:" + $this$fatal_u24lambda_u2d6.getFamily() + ";\n          font-weight:" + ($this$fatal_u24lambda_u2d6.isBold() ? "bold" : "normal") + ";\n          font-size:" + $this$fatal_u24lambda_u2d6.getSize() + "pt;\n        "));
            JEditorPane messagePane = new JEditorPane("text/html", StringsKt.trimIndent((String)("\n          <html>\n            <body style=\"" + style + "\">\n              " + message + "\n              <br>\n              For more details, see the <a href=\"#placeholder\">idea.log</a>.\n            </body>\n          </html>\n          ")));
            messagePane.addHyperlinkListener(new HyperlinkListener(ideaLog){
                final /* synthetic */ File $ideaLog;
                {
                    this.$ideaLog = $ideaLog;
                }

                public final void hyperlinkUpdate(HyperlinkEvent e) {
                    if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                        RevealFileAction.openFile((File)this.$ideaLog);
                    }
                }
            });
            messagePane.setEditable(false);
            messagePane.setBackground(new JLabel().getBackground());
            JOptionPane.showMessageDialog(null, messagePane, "Error", 0);
        }
        finally {
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final WindowWrapper startProfilerApp() {
        ProjectServiceImpl projectServiceImpl = new ProjectServiceImpl();
        Path path = Paths.get(SystemProperties.getUserHome(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(SystemProperties.getUserHome())");
        ProjectWrapper project = projectServiceImpl.createProject("Empty Project", path);
        return new ProfilerServiceImpl().createProfilerWindow(project, (Function2<? super ProjectWrapper, ? super WindowWrapper, Unit>)((Function2)startProfilerApp.1.INSTANCE));
    }

    private final void startSdkManagerApp() {
        new SdkManagerServiceImpl().createSdkManagerWindow((Function0<Unit>)((Function0)startSdkManagerApp.1.INSTANCE));
    }

    private final AvdManagerWindowWrapper startAvdManagerApp() {
        return new AvdManagerServiceImpl().createAvdManagerWindow((Function0<Unit>)((Function0)startAvdManagerApp.1.INSTANCE));
    }

    private final DeviceFileExplorerWindowWrapper startDeviceFileExplorerApp() {
        ProjectServiceImpl projectServiceImpl = new ProjectServiceImpl();
        Path path = Paths.get(SystemProperties.getUserHome(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(SystemProperties.getUserHome())");
        ProjectWrapper project = projectServiceImpl.createProject("Empty Project", path);
        return new DeviceFileExplorerServiceImpl().createDeviceExplorerWindow(project, (Function1<? super ProjectWrapper, Unit>)((Function1)startDeviceFileExplorerApp.1.INSTANCE));
    }

    private final JFrame startLogcat() {
        ProjectServiceImpl projectServiceImpl = new ProjectServiceImpl();
        Path path = Paths.get(SystemProperties.getUserHome(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(SystemProperties.getUserHome())");
        ProjectWrapper project = projectServiceImpl.createProject("Empty Project", path);
        return new LogcatServiceImpl().createWindow(project, (Function0<Unit>)((Function0)startLogcat.1.INSTANCE));
    }

    public boolean isHeadless() {
        return false;
    }

    public int getRequiredModality() {
        return 2;
    }

    private final void initializeSdk(File sdkPath) {
        block3: {
            block2: {
                new File(sdkPath, "platforms").mkdirs();
                ApplicationManager.getApplication().runWriteAction(new Runnable(sdkPath){
                    final /* synthetic */ File $sdkPath;
                    {
                        this.$sdkPath = $sdkPath;
                    }

                    public final void run() {
                        IdeSdks.getInstance().setAndroidSdkPath(this.$sdkPath, null);
                    }
                });
                if (IdeSdks.getInstance().getAndroidSdkPath() == null) break block2;
                File file = IdeSdks.getInstance().getAndroidSdkPath();
                Intrinsics.checkNotNull((Object)file);
                if (file.exists()) break block3;
            }
            this.fatal(null, "Cannot set Android SDK path");
            throw new KotlinNothingValueException();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/game/GameToolsStarter$Mode;", "", "(Ljava/lang/String;I)V", "SERVER", "APP", "VERIFY", "android.game-tools.main"})
    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode SERVER = new Mode();
        public static final /* enum */ Mode APP = new Mode();
        public static final /* enum */ Mode VERIFY = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.SERVER, Mode.APP, Mode.VERIFY};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/game/GameToolsStarter$AppWindow;", "", "(Ljava/lang/String;I)V", "PROFILER", "SDK_MANAGER", "AVD_MANAGER", "DEVICE_FILE_EXPLORER", "LOGCAT", "android.game-tools.main"})
    private static final class AppWindow
    extends Enum<AppWindow> {
        public static final /* enum */ AppWindow PROFILER = new AppWindow();
        public static final /* enum */ AppWindow SDK_MANAGER = new AppWindow();
        public static final /* enum */ AppWindow AVD_MANAGER = new AppWindow();
        public static final /* enum */ AppWindow DEVICE_FILE_EXPLORER = new AppWindow();
        public static final /* enum */ AppWindow LOGCAT = new AppWindow();
        private static final /* synthetic */ AppWindow[] $VALUES;

        public static AppWindow[] values() {
            return (AppWindow[])$VALUES.clone();
        }

        public static AppWindow valueOf(String value) {
            return Enum.valueOf(AppWindow.class, value);
        }

        static {
            $VALUES = appWindowArray = new AppWindow[]{AppWindow.PROFILER, AppWindow.SDK_MANAGER, AppWindow.AVD_MANAGER, AppWindow.DEVICE_FILE_EXPLORER, AppWindow.LOGCAT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AppWindow.values().length];
            nArray[AppWindow.PROFILER.ordinal()] = 1;
            nArray[AppWindow.SDK_MANAGER.ordinal()] = 2;
            nArray[AppWindow.AVD_MANAGER.ordinal()] = 3;
            nArray[AppWindow.DEVICE_FILE_EXPLORER.ordinal()] = 4;
            nArray[AppWindow.LOGCAT.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Mode.values().length];
            nArray[Mode.SERVER.ordinal()] = 1;
            nArray[Mode.APP.ordinal()] = 2;
            nArray[Mode.VERIFY.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

