/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.game;

import com.android.tools.game.AvdManagerService;
import com.android.tools.game.AvdManagerServiceImpl;
import com.android.tools.game.DeviceFileExplorerService;
import com.android.tools.game.DeviceFileExplorerServiceImpl;
import com.android.tools.game.GameToolsServer;
import com.android.tools.game.LogcatService;
import com.android.tools.game.LogcatServiceImpl;
import com.android.tools.game.ProfilerService;
import com.android.tools.game.ProfilerServiceImpl;
import com.android.tools.game.ProjectService;
import com.android.tools.game.ProjectServiceImpl;
import com.android.tools.game.ProjectWrapper;
import com.android.tools.game.SdkManagerService;
import com.android.tools.game.SdkManagerServiceImpl;
import com.android.tools.game.WindowWrapper;
import com.android.tools.game.protos.CreateProjectRequest;
import com.android.tools.game.protos.CreateWindowRequest;
import com.android.tools.game.protos.GameToolsGrpc;
import com.android.tools.game.protos.Project;
import com.android.tools.game.protos.StartProfilingRequest;
import com.android.tools.game.protos.StartProfilingResponse;
import com.android.tools.game.protos.Window;
import com.android.tools.idea.io.grpc.BindableService;
import com.android.tools.idea.io.grpc.Server;
import com.android.tools.idea.io.grpc.Status;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.io.grpc.netty.NettyServerBuilder;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.io.grpc.util.TransmitStatusRuntimeExceptionInterceptor;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u001e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001c2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019H\u0016J\u0006\u0010\u001e\u001a\u00020\u0015J\u0006\u0010\u001f\u001a\u00020\u0015J\u001e\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020!2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\"0\u0019H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/game/GameToolsServer;", "Lcom/android/tools/game/protos/GameToolsGrpc$GameToolsImplBase;", "port", "", "projectService", "Lcom/android/tools/game/ProjectService;", "profilerService", "Lcom/android/tools/game/ProfilerService;", "sdkManagerService", "Lcom/android/tools/game/SdkManagerService;", "avdManagerService", "Lcom/android/tools/game/AvdManagerService;", "deviceFileExplorerService", "Lcom/android/tools/game/DeviceFileExplorerService;", "logcatService", "Lcom/android/tools/game/LogcatService;", "(ILcom/android/tools/game/ProjectService;Lcom/android/tools/game/ProfilerService;Lcom/android/tools/game/SdkManagerService;Lcom/android/tools/game/AvdManagerService;Lcom/android/tools/game/DeviceFileExplorerService;Lcom/android/tools/game/LogcatService;)V", "server", "Lcom/android/tools/idea/io/grpc/Server;", "kotlin.jvm.PlatformType", "createProject", "", "request", "Lcom/android/tools/game/protos/CreateProjectRequest;", "responseObserver", "Lcom/android/tools/idea/io/grpc/stub/StreamObserver;", "Lcom/android/tools/game/protos/Project;", "createWindow", "Lcom/android/tools/game/protos/CreateWindowRequest;", "Lcom/android/tools/game/protos/Window;", "shutdown", "start", "startProfiling", "Lcom/android/tools/game/protos/StartProfilingRequest;", "Lcom/android/tools/game/protos/StartProfilingResponse;", "android.game-tools.main"})
public final class GameToolsServer
extends GameToolsGrpc.GameToolsImplBase {
    @NotNull
    private final ProjectService projectService;
    @NotNull
    private final ProfilerService profilerService;
    @NotNull
    private final SdkManagerService sdkManagerService;
    @NotNull
    private final AvdManagerService avdManagerService;
    @NotNull
    private final DeviceFileExplorerService deviceFileExplorerService;
    @NotNull
    private final LogcatService logcatService;
    private final Server server;

    public GameToolsServer(int port, @NotNull ProjectService projectService, @NotNull ProfilerService profilerService, @NotNull SdkManagerService sdkManagerService, @NotNull AvdManagerService avdManagerService, @NotNull DeviceFileExplorerService deviceFileExplorerService, @NotNull LogcatService logcatService) {
        Intrinsics.checkNotNullParameter((Object)projectService, (String)"projectService");
        Intrinsics.checkNotNullParameter((Object)profilerService, (String)"profilerService");
        Intrinsics.checkNotNullParameter((Object)sdkManagerService, (String)"sdkManagerService");
        Intrinsics.checkNotNullParameter((Object)avdManagerService, (String)"avdManagerService");
        Intrinsics.checkNotNullParameter((Object)deviceFileExplorerService, (String)"deviceFileExplorerService");
        Intrinsics.checkNotNullParameter((Object)logcatService, (String)"logcatService");
        this.projectService = projectService;
        this.profilerService = profilerService;
        this.sdkManagerService = sdkManagerService;
        this.avdManagerService = avdManagerService;
        this.deviceFileExplorerService = deviceFileExplorerService;
        this.logcatService = logcatService;
        this.server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)port).addService((BindableService)this)).intercept(TransmitStatusRuntimeExceptionInterceptor.instance())).build();
    }

    public /* synthetic */ GameToolsServer(int n, ProjectService projectService, ProfilerService profilerService, SdkManagerService sdkManagerService, AvdManagerService avdManagerService, DeviceFileExplorerService deviceFileExplorerService, LogcatService logcatService, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            projectService = new ProjectServiceImpl();
        }
        if ((n2 & 4) != 0) {
            profilerService = new ProfilerServiceImpl();
        }
        if ((n2 & 8) != 0) {
            sdkManagerService = new SdkManagerServiceImpl();
        }
        if ((n2 & 0x10) != 0) {
            avdManagerService = new AvdManagerServiceImpl();
        }
        if ((n2 & 0x20) != 0) {
            deviceFileExplorerService = new DeviceFileExplorerServiceImpl();
        }
        if ((n2 & 0x40) != 0) {
            logcatService = new LogcatServiceImpl();
        }
        this(n, projectService, profilerService, sdkManagerService, avdManagerService, deviceFileExplorerService, logcatService);
    }

    public final void start() {
        this.server.start();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GameToolsServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        logger.info("GameToolsServer started at port " + this.server.getPort());
    }

    public final void shutdown() {
        this.server.shutdown();
        this.server.awaitTermination(1L, TimeUnit.MINUTES);
    }

    public void createProject(@NotNull CreateProjectRequest request, @NotNull StreamObserver<Project> responseObserver) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        Project project = request.getProject();
        String it = string2 = project.getName();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        String string3 = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
        if (string3 == null) {
            StatusRuntimeException statusRuntimeException = Status.INVALID_ARGUMENT.withDescription("'project.name' field is required.").asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)statusRuntimeException, (String)"INVALID_ARGUMENT.withDes\u2026d.\").asRuntimeException()");
            throw (Throwable)statusRuntimeException;
        }
        String name = string3;
        String it2 = string = project.getPath();
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
        String string4 = !StringsKt.isBlank((CharSequence)it2) ? string : null;
        if (string4 == null) {
            StatusRuntimeException statusRuntimeException = Status.INVALID_ARGUMENT.withDescription("'project.path' field is required.").asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)statusRuntimeException, (String)"INVALID_ARGUMENT.withDes\u2026d.\").asRuntimeException()");
            throw (Throwable)statusRuntimeException;
        }
        String path = string4;
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
        ProjectWrapper createdProject = this.projectService.createProject(name, path2);
        responseObserver.onNext((Object)createdProject.asGrpcProject());
        responseObserver.onCompleted();
    }

    public void createWindow(@NotNull CreateWindowRequest request, @NotNull StreamObserver<Window> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        Window.WindowType windowType = request.getWindow().getType();
        switch (windowType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[windowType.ordinal()]) {
            case 1: {
                String string = request.getProjectId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.projectId");
                ProjectWrapper project = this.projectService.getProject(string);
                WindowWrapper window = ProfilerService.createProfilerWindow$default(this.profilerService, project, null, 2, null);
                responseObserver.onNext((Object)window.asGrpcWindow());
                responseObserver.onCompleted();
                break;
            }
            case 2: {
                SdkManagerService.createSdkManagerWindow$default(this.sdkManagerService, null, 1, null);
                String string = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
                String windowId = string;
                Window window = Window.newBuilder().setWindowId(windowId).setType(Window.WindowType.SDK_MANAGER).build();
                responseObserver.onNext((Object)window);
                responseObserver.onCompleted();
                break;
            }
            case 3: {
                AvdManagerService.createAvdManagerWindow$default(this.avdManagerService, null, 1, null);
                String string = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
                String windowId = string;
                Window window = Window.newBuilder().setWindowId(windowId).setType(Window.WindowType.AVD_MANAGER).build();
                responseObserver.onNext((Object)window);
                responseObserver.onCompleted();
                break;
            }
            case 4: {
                String string = request.getProjectId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.projectId");
                ProjectWrapper project = this.projectService.getProject(string);
                DeviceFileExplorerService.createDeviceExplorerWindow$default(this.deviceFileExplorerService, project, null, 2, null);
                String string2 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
                String windowId = string2;
                Window window = Window.newBuilder().setWindowId(windowId).setType(Window.WindowType.DEVICE_FILE_EXPLORER).build();
                responseObserver.onNext((Object)window);
                responseObserver.onCompleted();
                break;
            }
            case 5: {
                String string = request.getProjectId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.projectId");
                ProjectWrapper project = this.projectService.getProject(string);
                this.logcatService.createWindow(project, (Function0<Unit>)((Function0)createWindow.1.INSTANCE));
                String string3 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"randomUUID().toString()");
                String windowId = string3;
                Window window = Window.newBuilder().setWindowId(windowId).setType(Window.WindowType.LOGCAT).build();
                responseObserver.onNext((Object)window);
                responseObserver.onCompleted();
                break;
            }
            default: {
                StatusRuntimeException statusRuntimeException = Status.INVALID_ARGUMENT.withDescription("Unknown window type '" + request.getWindow().getType() + "'.").asRuntimeException();
                Intrinsics.checkNotNullExpressionValue((Object)statusRuntimeException, (String)"INVALID_ARGUMENT.withDes\u2026'.\").asRuntimeException()");
                throw (Throwable)statusRuntimeException;
            }
        }
    }

    public void startProfiling(@NotNull StartProfilingRequest request, @NotNull StreamObserver<StartProfilingResponse> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        this.profilerService.startProfiler(request);
        responseObserver.onNext((Object)StartProfilingResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Window.WindowType.values().length];
            nArray[Window.WindowType.PROFILER.ordinal()] = 1;
            nArray[Window.WindowType.SDK_MANAGER.ordinal()] = 2;
            nArray[Window.WindowType.AVD_MANAGER.ordinal()] = 3;
            nArray[Window.WindowType.DEVICE_FILE_EXPLORER.ordinal()] = 4;
            nArray[Window.WindowType.LOGCAT.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

