/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.game;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.game.AdbPath;
import com.android.tools.game.DeviceFileExplorerService;
import com.android.tools.game.DeviceFileExplorerServiceImpl;
import com.android.tools.game.DeviceFileExplorerWindowWrapper;
import com.android.tools.game.FakeToolWindow;
import com.android.tools.game.ProfilerServiceKt;
import com.android.tools.game.ProjectWrapper;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.file.explorer.toolwindow.DeviceExplorerController;
import com.android.tools.idea.file.explorer.toolwindow.DeviceExplorerFileManager;
import com.android.tools.idea.file.explorer.toolwindow.DeviceExplorerModel;
import com.android.tools.idea.file.explorer.toolwindow.DeviceExplorerView;
import com.android.tools.idea.file.explorer.toolwindow.adbimpl.AdbDeviceFileSystemRenderer;
import com.android.tools.idea.file.explorer.toolwindow.adbimpl.AdbDeviceFileSystemService;
import com.android.tools.idea.file.explorer.toolwindow.fs.DeviceFileSystemRenderer;
import com.android.tools.idea.file.explorer.toolwindow.fs.DeviceFileSystemService;
import com.android.tools.idea.file.explorer.toolwindow.ui.DeviceExplorerViewImpl;
import com.android.tools.idea.io.grpc.Status;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.util.ThrowableRunnable;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/game/DeviceFileExplorerServiceImpl;", "Lcom/android/tools/game/DeviceFileExplorerService;", "()V", "windowIcons", "", "Ljava/awt/Image;", "createDeviceExplorerWindow", "Lcom/android/tools/game/DeviceFileExplorerWindowWrapper;", "project", "Lcom/android/tools/game/ProjectWrapper;", "onWindowClose", "Lkotlin/Function1;", "", "initializeServices", "Lcom/intellij/openapi/project/Project;", "android.game-tools.main"})
public final class DeviceFileExplorerServiceImpl
implements DeviceFileExplorerService {
    @NotNull
    private final List<Image> windowIcons;

    public DeviceFileExplorerServiceImpl() {
        Icon icon = StudioIcons.Shell.ToolWindows.DEVICE_EXPLORER;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"DEVICE_EXPLORER");
        int[] nArray = new int[]{16, 32, 64, 256, 512};
        this.windowIcons = ProfilerServiceKt.iconToImages(icon, nArray);
    }

    @Override
    @NotNull
    public DeviceFileExplorerWindowWrapper createDeviceExplorerWindow(@NotNull ProjectWrapper project, @NotNull Function1<? super ProjectWrapper, Unit> onWindowClose) {
        JFrame jFrame;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onWindowClose, (String)"onWindowClose");
        this.initializeServices(project.asIdeaProject());
        Ref.ObjectRef frame = new Ref.ObjectRef();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(project, (Ref.ObjectRef<JFrame>)frame, this, onWindowClose){
            final /* synthetic */ ProjectWrapper $project;
            final /* synthetic */ Ref.ObjectRef<JFrame> $frame;
            final /* synthetic */ DeviceFileExplorerServiceImpl this$0;
            final /* synthetic */ Function1<ProjectWrapper, Unit> $onWindowClose;
            {
                this.$project = $project;
                this.$frame = $frame;
                this.this$0 = $receiver;
                this.$onWindowClose = $onWindowClose;
            }

            /*
             * WARNING - void declaration
             */
            public final void run() {
                JFrame jFrame;
                JFrame jFrame2;
                void $this$run_u24lambda_u2d0;
                AdbDeviceFileSystemService adbService = (AdbDeviceFileSystemService)this.$project.asIdeaProject().getService(AdbDeviceFileSystemService.class);
                DeviceExplorerFileManager fileManager = (DeviceExplorerFileManager)this.$project.asIdeaProject().getService(DeviceExplorerFileManager.class);
                DeviceExplorerModel model = new DeviceExplorerModel();
                DeviceExplorerViewImpl view = new DeviceExplorerViewImpl(this.$project.asIdeaProject(), (DeviceFileSystemRenderer)new AdbDeviceFileSystemRenderer(), model);
                DeviceExplorerController.FileOpener fileOpener2 = new DeviceExplorerController.FileOpener(){

                    @UiThread
                    @Nullable
                    public Object openFile(@NotNull Path localPath, @NotNull Continuation<? super Unit> $completion) {
                        RevealFileAction.openFile((File)localPath.toFile());
                        return Unit.INSTANCE;
                    }
                };
                Project project = this.$project.asIdeaProject();
                DeviceExplorerView deviceExplorerView = (DeviceExplorerView)view;
                Intrinsics.checkNotNullExpressionValue((Object)adbService, (String)"adbService");
                DeviceFileSystemService deviceFileSystemService = (DeviceFileSystemService)adbService;
                Intrinsics.checkNotNullExpressionValue((Object)fileManager, (String)"fileManager");
                DeviceExplorerController controller = new DeviceExplorerController(project, model, deviceExplorerView, deviceFileSystemService, fileManager, fileOpener2);
                controller.setup();
                FakeToolWindow fakeToolWindow = new FakeToolWindow(this.$project.asIdeaProject());
                DeviceFileExplorerServiceImpl deviceFileExplorerServiceImpl = this.this$0;
                FakeToolWindow fakeToolWindow2 = fakeToolWindow;
                Ref.ObjectRef<JFrame> objectRef = this.$frame;
                boolean bl = false;
                $this$run_u24lambda_u2d0.setTitle("Android Device Explorer");
                $this$run_u24lambda_u2d0.setIconImages(DeviceFileExplorerServiceImpl.access$getWindowIcons$p(deviceFileExplorerServiceImpl));
                $this$run_u24lambda_u2d0.setDefaultCloseOperation(2);
                $this$run_u24lambda_u2d0.setGlassPane((Component)new IdeGlassPaneImpl($this$run_u24lambda_u2d0.getRootPane()));
                $this$run_u24lambda_u2d0.add(view.getComponent());
                $this$run_u24lambda_u2d0.setSize(new Dimension(800, 600));
                $this$run_u24lambda_u2d0.setUndecorated(false);
                $this$run_u24lambda_u2d0.setVisible(true);
                objectRef.element = fakeToolWindow;
                Project project2 = this.$project.asIdeaProject();
                if (this.$frame.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"frame");
                    jFrame2 = null;
                } else {
                    jFrame2 = (JFrame)this.$frame.element;
                }
                AndroidNotification.setFallbackNotificationDestination((Project)project2, (JFrame)jFrame2);
                if (this.$frame.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"frame");
                    jFrame = null;
                } else {
                    jFrame = (JFrame)this.$frame.element;
                }
                jFrame.addWindowListener(new WindowAdapter(this.$onWindowClose, this.$project){
                    final /* synthetic */ Function1<ProjectWrapper, Unit> $onWindowClose;
                    final /* synthetic */ ProjectWrapper $project;
                    {
                        this.$onWindowClose = $onWindowClose;
                        this.$project = $project;
                    }

                    public void windowClosing(@NotNull WindowEvent windowEvent) {
                        Intrinsics.checkNotNullParameter((Object)windowEvent, (String)"windowEvent");
                        this.$onWindowClose.invoke((Object)this.$project);
                    }
                });
            }
        });
        if (frame.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"frame");
            jFrame = null;
        } else {
            jFrame = (JFrame)frame.element;
        }
        return new DeviceFileExplorerWindowWrapper(jFrame);
    }

    private final void initializeServices(Project project) {
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        List list = AndroidSdks.getInstance().getAllAndroidSdks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInstance().allAndroidSdks");
        List sdks = list;
        if (sdks.isEmpty()) {
            StatusRuntimeException statusRuntimeException = Status.INTERNAL.withDescription("Failed to find valid a valid Android SDK").asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)statusRuntimeException, (String)"INTERNAL\n        .withDe\u2026    .asRuntimeException()");
            throw (Throwable)statusRuntimeException;
        }
        WriteAction.runAndWait((ThrowableRunnable)new ThrowableRunnable(projectRootManager, sdks){
            final /* synthetic */ ProjectRootManager $projectRootManager;
            final /* synthetic */ List<Sdk> $sdks;
            {
                this.$projectRootManager = $projectRootManager;
                this.$sdks = $sdks;
            }

            public final void run() {
                this.$projectRootManager.setProjectSdk(this.$sdks.get(0));
            }
        });
        Future future = ApplicationManager.getApplication().executeOnPooledThread((Runnable)initializeServices.result.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"getApplication().execute\u2026nager.getInstance()\n    }");
        Future result2 = future;
        result2.get();
        File adbFile = AdbPath.INSTANCE.get();
        AdbService.getInstance().getDebugBridge(adbFile).get();
    }

    public static final /* synthetic */ List access$getWindowIcons$p(DeviceFileExplorerServiceImpl $this) {
        return $this.windowIcons;
    }
}

