/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangQuickFixFactoryKt;
import com.jetbrains.cidr.lang.inspections.IfToTernary;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCEmptyStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n\u001a\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\t\u001a\u00020\u0016\u001a\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\nH\u0002\u001a\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n\u001a\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0018\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0007\u001a\u001c\u0010#\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006$"}, d2={"binaryExpr", "Lcom/jetbrains/cidr/lang/psi/OCExpression;", "left", "right", "operator", "Lcom/jetbrains/cidr/lang/parser/OCElementType;", "createEmptyStatement", "Lcom/jetbrains/cidr/lang/psi/OCStatement;", "kotlin.jvm.PlatformType", "context", "Lcom/intellij/psi/PsiElement;", "ensureIsBoolean", "expr", "defaultTypeValue", "", "getSimplifyFix", "Lcom/intellij/codeInsight/intention/IntentionAction;", "element", "simplified", "getSimplifyQuickFix", "params", "", "Lcom/jetbrains/cidr/lang/symbols/OCResolveContext;", "getStatementName", "isSafeToSimplify", "", "negateExpr", "operand", "parenthesize", "expression", "parentPrecedence", "", "simplifyStatementWithConstCondition", "conditionValue", "statement", "tryGetSimplifyFix", "intellij.c.clangdBridge"})
public final class SimplifyInspectionKt {
    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final IntentionAction getSimplifyFix(@NotNull PsiElement element, @NotNull PsiElement simplified) {
        block5: {
            block4: {
                subject = SimplifyInspectionKt.getStatementName(element);
                if (!(element instanceof OCStatement) || !(element.getParent() instanceof OCBlockStatement) || !(simplified instanceof OCBlockStatement)) break block4;
                $this$map$iv /* !! */  = ((OCBlockStatement)simplified).getNode().getChildren(null);
                $i$f$map = false;
                var6_5 = $this$map$iv /* !! */ ;
                destination$iv$iv = new ArrayList<E>($this$map$iv /* !! */ .length);
                $i$f$mapTo = false;
                var10_10 = ((void)$this$mapTo$iv$iv).length;
                for (var9_8 = 0; var9_8 < var10_10; ++var9_8) {
                    var12_13 = item$iv$iv = $this$mapTo$iv$iv[var9_8];
                    var16_17 = destination$iv$iv;
                    $i$a$-map-SimplifyInspectionKt$getSimplifyFix$children$1 = false;
                    var17_18 = it.getPsi();
                    var16_17.add(var17_18);
                }
                $this$map$iv /* !! */  = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (PsiElement)element$iv$iv;
                    $i$a$-filter-SimplifyInspectionKt$getSimplifyFix$children$2 = false;
                    if (PsiTreeUtilKt.getElementType((PsiElement)it) == null) ** GOTO lbl-1000
                    it = var13_16;
                    $i$a$-let-SimplifyInspectionKt$getSimplifyFix$children$2$1 = false;
                    if (OCTokenTypes.WHITESPACES.contains(it)) ** GOTO lbl-1000
                    if (Intrinsics.areEqual((Object)it, (Object)((OCBlockStatement)simplified).getOpeningBrace()) ^ true && Intrinsics.areEqual((Object)it, (Object)((OCBlockStatement)simplified).getClosingBrace()) ^ true) {
                        v0 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        v0 = false;
                    }
                    if (!v0) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                children = (List)destination$iv$iv;
                v1 = (IntentionAction)new OCChangeElementIntentionAction(element, children, OCInspectionsBundle.message((String)"intention.family.name.simplify", (Object[])new Object[]{subject}));
                break block5;
            }
            v1 = simplified instanceof OCEmptyStatement != false ? (IntentionAction)new OCRemoveElementsIntentionAction(element, CommonQuickFixBundle.message((String)"fix.remove.title", (Object[])new Object[]{subject})) : (simplified instanceof OCExpression != false && element instanceof OCIfStatement != false ? (IntentionAction)new IfToTernary(subject, element, simplified) : (element instanceof OCExpression != false ? (IntentionAction)new OCChangeElementIntentionAction((PsiElement)OCParenthesesUtils.topmostParenthesized((OCExpression)((OCExpression)element)), simplified, OCInspectionsBundle.message((String)"intention.family.name.simplify.expression", (Object[])new Object[0])) : (IntentionAction)new OCChangeElementIntentionAction(element, simplified, OCInspectionsBundle.message((String)"intention.family.name.simplify", (Object[])new Object[]{subject}))));
        }
        return v1;
    }

    private static final String getStatementName(PsiElement element) {
        PsiElement psiElement = element;
        return psiElement instanceof OCIfStatement ? "'if' statement" : (psiElement instanceof OCWhileStatement ? "'while' statement" : (psiElement instanceof OCDoWhileStatement ? "'do-while' statement" : (psiElement instanceof OCForStatement ? "'for' statement" : "statement")));
    }

    @Nullable
    public static final OCStatement simplifyStatementWithConstCondition(boolean conditionValue, @NotNull OCStatement statement) {
        Object object;
        OCStatement oCStatement = statement;
        if (oCStatement instanceof OCIfStatement) {
            OCStatement thenBranch = ((OCIfStatement)statement).getThenBranch();
            OCStatement elseBranch = ((OCIfStatement)statement).getElseBranch();
            if (conditionValue) {
                object = thenBranch;
            } else {
                object = elseBranch;
                if (object == null) {
                    object = SimplifyInspectionKt.createEmptyStatement((PsiElement)statement);
                }
            }
        } else if (oCStatement instanceof OCWhileStatement) {
            object = conditionValue ? null : SimplifyInspectionKt.createEmptyStatement((PsiElement)statement);
        } else if (oCStatement instanceof OCDoWhileStatement) {
            object = conditionValue ? null : ((OCDoWhileStatement)statement).getBody();
        } else if (oCStatement instanceof OCForStatement) {
            OCStatement initializer = ((OCForStatement)statement).getInitializer();
            if (conditionValue) {
                object = null;
            } else {
                object = initializer;
                if (object == null) {
                    object = SimplifyInspectionKt.createEmptyStatement((PsiElement)statement);
                }
            }
        } else {
            OCLog.LOG.info("Unsupported element in simplify condition: " + statement.getClass().getCanonicalName());
            object = null;
        }
        return object;
    }

    private static final OCStatement createEmptyStatement(PsiElement context) {
        return OCElementFactory.statementFromText((String)";", (PsiElement)context);
    }

    public static final boolean isSafeToSimplify(@NotNull PsiElement element, @NotNull PsiElement simplified) {
        if (element instanceof OCDoWhileStatement) {
            Collection statements = PsiTreeUtil.findChildrenOfAnyType((PsiElement)simplified, (Class[])new Class[]{OCBreakStatement.class, OCContinueStatement.class});
            for (OCStatement statement : statements) {
                PsiElement parentElement = statement instanceof OCBreakStatement ? PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)statement), (Class[])new Class[]{OCSwitchStatement.class, OCLoopStatement.class}) : PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)statement), OCLoopStatement.class);
                if (parentElement != element) continue;
                return false;
            }
        }
        return true;
    }

    private static final IntentionAction tryGetSimplifyFix(PsiElement element, PsiElement simplified) {
        return simplified != null && SimplifyInspectionKt.isSafeToSimplify(element, simplified) ? SimplifyInspectionKt.getSimplifyFix(element, simplified) : null;
    }

    @Nullable
    public static final IntentionAction getSimplifyQuickFix(@NotNull List<String> params, @NotNull OCResolveContext context) {
        String fixitId = params.get(0);
        if (Intrinsics.areEqual((Object)fixitId, (Object)"cond-stmt") && params.size() == 3) {
            PsiElement psiElement = ClangQuickFixFactoryKt.locatePsiElement(params.get(2), context.getProject());
            if (!(psiElement instanceof OCStatement)) {
                psiElement = null;
            }
            OCStatement oCStatement = (OCStatement)psiElement;
            if (oCStatement == null) {
                return null;
            }
            OCStatement stmt = oCStatement;
            boolean condition = Intrinsics.areEqual((Object)params.get(1), (Object)"true");
            return SimplifyInspectionKt.tryGetSimplifyFix((PsiElement)stmt, (PsiElement)SimplifyInspectionKt.simplifyStatementWithConstCondition(condition, stmt));
        }
        if (Intrinsics.areEqual((Object)fixitId, (Object)"const-cond") && params.size() == 3) {
            PsiElement parent;
            boolean bl;
            PsiElement psiElement = ClangQuickFixFactoryKt.locatePsiElement(params.get(2), context.getProject());
            if (!(psiElement instanceof OCExpression)) {
                psiElement = null;
            }
            OCExpression oCExpression = (OCExpression)psiElement;
            if (oCExpression == null) {
                return null;
            }
            OCExpression cond = oCExpression;
            switch (params.get(1)) {
                case "true": {
                    bl = true;
                    break;
                }
                case "false": {
                    bl = false;
                    break;
                }
                default: {
                    return null;
                }
            }
            boolean condition = bl;
            OCExpression oCExpression2 = OCParenthesesUtils.topmostParenthesized((OCExpression)cond);
            PsiElement psiElement2 = oCExpression2 != null && (oCExpression2 = oCExpression2.getParent()) != null ? oCExpression2.getParent() : (parent = null);
            if (parent instanceof OCIfStatement || parent instanceof OCLoopStatement) {
                return SimplifyInspectionKt.tryGetSimplifyFix(parent, (PsiElement)SimplifyInspectionKt.simplifyStatementWithConstCondition(condition, (OCStatement)parent));
            }
            return SimplifyInspectionKt.tryGetSimplifyFix((PsiElement)cond, (PsiElement)OCElementFactory.booleanConstant((boolean)condition, (OCResolveContext)context));
        }
        if (Intrinsics.areEqual((Object)fixitId, (Object)"expr") && params.size() == 4) {
            OCExpression oCExpression = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)ClangQuickFixFactoryKt.locatePsiElement(params.get(1), context.getProject()), OCExpression.class, (boolean)false);
            if (oCExpression == null) {
                return null;
            }
            OCExpression operand = oCExpression;
            String defaultTypeValue = params.get(2);
            PsiElement psiElement = ClangQuickFixFactoryKt.locatePsiElement(params.get(3), context.getProject());
            if (psiElement == null) {
                return null;
            }
            PsiElement element = psiElement;
            return SimplifyInspectionKt.tryGetSimplifyFix(element, (PsiElement)SimplifyInspectionKt.ensureIsBoolean(operand, defaultTypeValue));
        }
        if (Intrinsics.areEqual((Object)fixitId, (Object)"negate") && params.size() == 4) {
            OCExpression oCExpression = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)ClangQuickFixFactoryKt.locatePsiElement(params.get(1), context.getProject()), OCExpression.class, (boolean)false);
            if (oCExpression == null) {
                return null;
            }
            OCExpression operand = oCExpression;
            String defaultTypeValue = params.get(2);
            PsiElement psiElement = ClangQuickFixFactoryKt.locatePsiElement(params.get(3), context.getProject());
            if (psiElement == null) {
                return null;
            }
            PsiElement element = psiElement;
            return SimplifyInspectionKt.tryGetSimplifyFix(element, (PsiElement)SimplifyInspectionKt.negateExpr(SimplifyInspectionKt.ensureIsBoolean(operand, defaultTypeValue)));
        }
        if (Intrinsics.areEqual((Object)fixitId, (Object)"binary") && params.size() == 6) {
            OCPunctuatorElementType oCPunctuatorElementType;
            OCExpression oCExpression = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)ClangQuickFixFactoryKt.locatePsiElement(params.get(1), context.getProject()), OCExpression.class, (boolean)false);
            if (oCExpression == null) {
                return null;
            }
            OCExpression left = oCExpression;
            String defaultTypeValue = params.get(2);
            String operatorStr = params.get(3);
            OCExpression oCExpression3 = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)ClangQuickFixFactoryKt.locatePsiElement(params.get(4), context.getProject()), OCExpression.class, (boolean)false);
            if (oCExpression3 == null) {
                return null;
            }
            OCExpression right = oCExpression3;
            PsiElement psiElement = ClangQuickFixFactoryKt.locatePsiElement(params.get(5), context.getProject());
            if (psiElement == null) {
                return null;
            }
            PsiElement element = psiElement;
            left = SimplifyInspectionKt.ensureIsBoolean(left, defaultTypeValue);
            if (StringsKt.startsWith$default((String)operatorStr, (String)"!", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)operatorStr, (Object)"!=") ^ true) {
                left = SimplifyInspectionKt.negateExpr(left);
                String string = operatorStr;
                int n = 1;
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                operatorStr = string2;
            }
            switch (operatorStr) {
                case "||": {
                    oCPunctuatorElementType = OCTokenTypes.OROR;
                    break;
                }
                case "&&": {
                    oCPunctuatorElementType = OCTokenTypes.ANDAND;
                    break;
                }
                case ">": {
                    oCPunctuatorElementType = OCTokenTypes.GT;
                    break;
                }
                case "<": {
                    oCPunctuatorElementType = OCTokenTypes.LT;
                    break;
                }
                case ">=": {
                    oCPunctuatorElementType = OCTokenTypes.GTEQ;
                    break;
                }
                case "<=": {
                    oCPunctuatorElementType = OCTokenTypes.LTEQ;
                    break;
                }
                case "==": {
                    oCPunctuatorElementType = OCTokenTypes.EQEQ;
                    break;
                }
                case "!=": {
                    oCPunctuatorElementType = OCTokenTypes.EXCLEQ;
                    break;
                }
                default: {
                    return null;
                }
            }
            OCPunctuatorElementType operator = oCPunctuatorElementType;
            return SimplifyInspectionKt.tryGetSimplifyFix(element, (PsiElement)SimplifyInspectionKt.binaryExpr(left, right, (OCElementType)operator));
        }
        throw (Throwable)new IllegalArgumentException("Unknown clang fixit " + fixitId);
    }

    private static final OCExpression parenthesize(OCExpression expression, int parentPrecedence) {
        if (OCElementUtil.isPartOfMacroSubstitution((PsiElement)((PsiElement)expression))) {
            return expression;
        }
        return OCParenthesesUtils.getPrecedence((OCExpression)expression, (boolean)false) > parentPrecedence ? (OCExpression)OCParenthesesUtils.appendParentheses((OCExpression)expression) : expression;
    }

    private static final OCExpression ensureIsBoolean(OCExpression expr, String defaultTypeValue) {
        OCExpression oCExpression;
        if (Intrinsics.areEqual((Object)defaultTypeValue, (Object)"false")) {
            oCExpression = expr;
        } else {
            OCExpression oCExpression2 = OCElementFactory.expressionFromText((String)defaultTypeValue, (PsiElement)((PsiElement)expr), (boolean)false);
            Intrinsics.checkNotNull((Object)oCExpression2);
            oCExpression = SimplifyInspectionKt.binaryExpr(expr, oCExpression2, (OCElementType)OCTokenTypes.EXCLEQ);
        }
        return oCExpression;
    }

    private static final OCExpression binaryExpr(OCExpression left, OCExpression right, OCElementType operator) {
        int precedence = OCParenthesesUtils.getPrecedence((OCElementType)operator);
        return (OCExpression)OCElementFactory.binaryExpression((PsiElement)((PsiElement)SimplifyInspectionKt.parenthesize(left, precedence)), (PsiElement)((PsiElement)SimplifyInspectionKt.parenthesize(right, precedence)), (OCElementType)operator);
    }

    private static final OCExpression negateExpr(OCExpression operand) {
        return (OCExpression)OCElementFactory.unaryExpression((PsiElement)((PsiElement)SimplifyInspectionKt.parenthesize(operand, OCParenthesesUtils.getPrecedence((OCElementType)((OCElementType)OCTokenTypes.EXCL)))), (OCElementType)((OCElementType)OCTokenTypes.EXCL));
    }
}

