/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.contextSensitive;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Alarm;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingDeclaration;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingList;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDFAUtils {
    public static final Key<Integer> DFA_TIME_LIMIT = Key.create((String)"DFA_TIME_LIMIT");
    public static final int DEFAULT_TIME_LIMIT_IN_SEC = 5;
    private static final Logger LOG = Logger.getInstance((String)OCDFAUtils.class.getName());

    public static String getTypeConstant(OCType type, Number value, @NotNull OCResolveContext context, @NotNull PsiFile file) {
        if (type instanceof OCIntType) {
            if (value instanceof Double) {
                return Double.toString((Double)value);
            }
            OCIntType intType = (OCIntType)type;
            int intValue = (Integer)value;
            if (OCIntType.isBool((OCType)type, (OCResolveContext)context)) {
                return intType.getValue(intValue != 0, context);
            }
            if (intType.isChar() && !Character.isISOControl((char)intValue) && intValue >= 0) {
                return "'" + (char)intValue + "'";
            }
        } else if (type instanceof OCStructType && ((OCStructType)type).isEnum()) {
            OCDeclaratorSymbol field = OCDFAUtils.getEnumField((OCStructType)type, value, file);
            if (field != null) {
                return "'" + field.getName() + "'";
            }
        } else {
            if (type.isPointer() && value instanceof Integer && (Integer)value == 0) {
                return type.getDefaultValue(context);
            }
            if (type instanceof OCRealType) {
                if (value instanceof Double) {
                    return Double.toString((Double)value);
                }
                if (value instanceof Integer) {
                    return Double.toString(((Integer)value).intValue());
                }
            }
        }
        return value.toString();
    }

    @Nullable
    public static OCDeclaratorSymbol getEnumField(OCStructType enumType, Number value, PsiFile file) {
        for (OCDeclaratorSymbol field : enumType.getFields()) {
            if (field.getKind() != OCSymbolKind.ENUM_CONST || !value.equals(OCExpressionEvaluator.evaluateEnumConst((OCSymbol)field, (PsiFile)file))) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static PsiElement getBindingDeclaration(@NotNull PsiElement el) {
        return PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)el, OCStructuredBindingList.class), OCStructuredBindingDeclaration.class);
    }

    public static long getTimeLimit(@NotNull PsiFile file) {
        try {
            Integer forcedTimeLimit = (Integer)file.getUserData(DFA_TIME_LIMIT);
            if (forcedTimeLimit != null && forcedTimeLimit > 0) {
                return Math.multiplyExact(forcedTimeLimit, 1000);
            }
            forcedTimeLimit = (Integer)file.getProject().getUserData(DFA_TIME_LIMIT);
            if (forcedTimeLimit != null && forcedTimeLimit > 0) {
                return Math.multiplyExact(forcedTimeLimit, 1000);
            }
            int timeLimitFromRegistry = Registry.get((String)"cidr.inspection.dfa.timeout.in.sec").asInteger();
            if (timeLimitFromRegistry > 0) {
                return Math.multiplyExact(timeLimitFromRegistry, 1000);
            }
        }
        catch (ArithmeticException e) {
            LOG.debug("Cannot use preferred TIME_LIMIT. Default one will be used:" + e.getMessage());
            return 5000L;
        }
        LOG.debug("Using default TIME_LIMIT for DFA");
        return 5000L;
    }

    public static class WorkingTimeMeasurer
    implements Disposable {
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        private volatile boolean myTimedOut = false;
        private volatile boolean myCanceled = false;

        public WorkingTimeMeasurer(long timeoutInMilliseconds) {
            this.myAlarm.addRequest(() -> {
                this.myTimedOut = true;
            }, timeoutInMilliseconds);
        }

        public void cancel() {
            this.myCanceled = true;
        }

        public boolean isTimeOver() {
            return this.myTimedOut;
        }

        public boolean isCanceled() {
            return this.myCanceled;
        }

        public void dispose() {
        }
    }
}

