/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.contextSensitive;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangQuickFixFactoryKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.RMLLogPanel;
import com.jetbrains.cidr.lang.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCLocalDefinitionsSearcher;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCDFAUtils;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCSourceGliderService;
import com.jetbrains.cidr.lang.dfa.contextSensitive.analyzes.MayPointsToAnalysisKt;
import com.jetbrains.cidr.lang.dfa.contextSensitive.valueProvider.OCDFAValuesAggregator;
import com.jetbrains.cidr.lang.dfa.contextSensitive.valueProvider.OCDfaResultProvider;
import com.jetbrains.cidr.lang.inspections.DFARunner;
import com.jetbrains.cidr.lang.inspections.OCDFAInspection;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.inspections.SimplifyInspectionKt;
import com.jetbrains.cidr.lang.legacy.inspections.OCSimplifyInspectionLegacy;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCoyieldStatement;
import com.jetbrains.cidr.lang.psi.OCCppCoawaitExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingDeclaration;
import com.jetbrains.cidr.lang.psi.impl.OCCppCoreturnStatementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeGCCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCInlineParameterFix;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationButInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveInitializerIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.bdd.BDDMemoryOverflowException;
import com.jetbrains.sourceglider.contextSensitive.DFAException;
import com.jetbrains.sourceglider.contextSensitive.DFATuple;
import com.jetbrains.sourceglider.contextSensitive.DFATuplesConsumer;
import com.jetbrains.sourceglider.contextSensitive.OCContextSensitiveBuilder;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.repositories.RelationsRepository;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.ui.DummyThreadCallback;
import com.jetbrains.sourceglider.ui.Task;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.console.Console;
import com.jetbrains.sourceglider.ui.console.RelationsConsole;
import com.jetbrains.sourceglider.ui.console.StringConsole;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDFAInspectionRunner
implements DFARunner {
    private static final Logger LOG = Logger.getInstance((String)OCDFAInspectionRunner.class.getName());
    private static final Boolean ENABLE_RML_PROFILING = false;
    private static final Boolean ENABLE_BDD_PROFILING = false;
    private static final Boolean ENABLE_RELATIONS_PROFILING = false;
    public static final Key<Boolean> CONTEXT_SENSITIVITY = Key.create((String)"CONTEXT_SENSITIVITY");
    public static final Key<ProblemsHolder> TEST_PROBLEMS_HOLDER = Key.create((String)"TEST_PROBLEMS_HOLDER");

    public boolean canRun(@NotNull PsiFile file) {
        if (!ClangUtils.isClangdOn((Project)file.getProject()) || !ClangUtils.isClangdShowErrors((Project)file.getProject())) {
            return false;
        }
        if (file instanceof OCFile && ((OCFile)file).getKind().isObjC()) {
            return ApplicationManager.getApplication().isUnitTestMode();
        }
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder) {
        return new PsiElementVisitor(){};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(@NotNull OCFile file, @NotNull ProblemsHolder problemsHolder, @NotNull OCDFAInspection inspection) {
        List dfaInput;
        HashMap<Object, Comparable<Boolean>> options = new HashMap<Object, Comparable<Boolean>>();
        boolean contextSensitivity = file.getUserData(CONTEXT_SENSITIVITY) != Boolean.FALSE;
        Project project = file.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        ClangLanguageService languageService = ClangLanguageServiceProvider.getIfStarted((Project)file.getProject());
        SimpleOpenRequestId openRequestId = null;
        if (!problemsHolder.isOnTheFly()) {
            openRequestId = new SimpleOpenRequestId(this.getClass(), virtualFile.getPath() + " opened for analysis in batch mode");
            languageService.notifyDocumentOpened(virtualFile, (OpenRequestId)openRequestId);
        }
        long timeStart = System.currentTimeMillis();
        try {
            dfaInput = (List)languageService.computeWithParsed(virtualFile, response -> {
                if (response == null) {
                    return null;
                }
                CompletableFuture dfaInputFuture = response.getDFAInput();
                ClangUtils.warnClangd((Logger)LOG, (String)("Starting clangd DFA: " + file.getName()));
                Supplier result2 = (Supplier)CidrConcurrentUtilsKt.waitCancelAware((Future)dfaInputFuture, (long)Long.MAX_VALUE, (String)"dfaInput");
                return result2 != null ? (List)result2.get() : null;
            });
        }
        catch (TimeoutException e) {
            dfaInput = null;
            ClangUtils.warnClangd((Logger)LOG, (String)("clangd DFA timeout: " + file.getName()));
        }
        catch (ExecutionException e) {
            dfaInput = null;
            ClangUtils.logServerException((Logger)LOG, (String)e.getMessage(), (ExecutionException)e);
        }
        catch (Exception e) {
            dfaInput = null;
            if (!(e instanceof ControlFlowException)) {
                ClangUtils.warnClangd((Logger)LOG, (Throwable)e);
            }
        }
        finally {
            if (openRequestId != null) {
                languageService.notifyDocumentClosed(virtualFile, (OpenRequestId)openRequestId);
            }
        }
        if (dfaInput == null) {
            return;
        }
        long timeEnd = System.currentTimeMillis();
        ClangUtils.warnClangd((Logger)LOG, (String)("clangd DFA input builder finished: " + file.getName() + " - " + (double)(timeEnd - timeStart) / 1000.0 + " sec"));
        if (ENABLE_RML_PROFILING.booleanValue()) {
            options.put(ProfileManager.class, Boolean.valueOf(true));
        }
        if (OCSourceGliderService.logEnabled()) {
            options.put("STORE_TEMP_RELATIONS", Boolean.TRUE);
        }
        options.put("GlobalMode", Integer.valueOf(OCSourceGliderService.isGlobalMode((PsiFile)file) ? 1 : 0));
        options.put("CollectResultForQuickDoc", Integer.valueOf(OCSourceGliderService.isCollectResultForQuickDoc() ? 1 : 0));
        ProblemsHolder testProblemsHolder = (ProblemsHolder)file.getUserData(TEST_PROBLEMS_HOLDER);
        ProblemsHolder holder = testProblemsHolder != null ? testProblemsHolder : problemsHolder;
        ArrayList<String[]> conditions = new ArrayList<String[]>();
        ArrayList<String[]> implicitReads = new ArrayList<String[]>();
        Class<OCDFAInspectionRunner> clazz = OCDFAInspectionRunner.class;
        synchronized (OCDFAInspectionRunner.class) {
            List<String[]> unreadVariables;
            List<String[]> unusedVariables;
            List<String[]> unusedValues;
            List<String[]> infiniteRecursions;
            List<String[]> endlessLoops;
            List<String[]> unreachableFunctionCalls;
            List<String[]> unreachableStmts;
            List<String[]> arrayIndexOutOfBounds;
            List<String[]> constantFunctionResults;
            List<String[]> constantParameters;
            List<String[]> escapedObjects;
            List<String[]> invalidatedPointerUsages;
            List<String[]> outOfScopePointerUsages;
            List<String[]> deletedPointerUsages;
            List<String[]> loopConditionNotUpdatedStmts;
            List<String[]> alwaysFalseWhenReachedStmts;
            List<String[]> alwaysTrueWhenReachedStmts;
            List<String[]> nullDereferences;
            List<String[]> alwaysFalseStmts;
            List<String[]> alwaysTrueStmts;
            file.pushAnnotationSession(new AnnotationSession((PsiFile)file));
            try {
                Ref contextSensitiveResult = Ref.create();
                Ref contextInsensitiveResult = Ref.create();
                long timeLimit = OCDFAUtils.getTimeLimit((PsiFile)file);
                OCDFAUtils.WorkingTimeMeasurer measurer = new OCDFAUtils.WorkingTimeMeasurer(timeLimit);
                try {
                    if (contextSensitivity) {
                        OCDFAInspectionRunner.runAnalysisInParallel((PsiFile)file, new HashMap<Object, Object>(options), true, measurer, (Ref<Result>)contextSensitiveResult, dfaInput);
                    }
                    OCDFAInspectionRunner.runAnalysisInParallel((PsiFile)file, new HashMap<Object, Object>(options), false, measurer, (Ref<Result>)contextInsensitiveResult, dfaInput);
                    Class<Result> clazz2 = Result.class;
                    synchronized (Result.class) {
                        while (contextSensitivity && contextSensitiveResult.isNull() || contextInsensitiveResult.isNull()) {
                            Result.class.wait();
                        }
                        // ** MonitorExit[var45_27] (shouldn't be in output)
                    }
                }
                catch (ProcessCanceledException e) {
                    measurer.cancel();
                    throw e;
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    file.popAnnotationSession();
                    OCSourceGliderService.getInstance().clearVisitorRunners();
                    // ** MonitorExit[var39_22] (shouldn't be in output)
                    return;
                }
                finally {
                    Disposer.dispose((Disposable)measurer);
                    Iterator iterator = OCSourceGliderService.getInstance().getAllProviders().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                        }
                        ManagerInstancesProvider provider = (ManagerInstancesProvider)iterator.next();
                        provider.disposeResources();
                    }
                }
                {
                    ManagerInstancesProvider provider;
                    if (contextSensitivity && ((Result)contextSensitiveResult.get()).isFinishedSuccessfully()) {
                        provider = ((Result)contextSensitiveResult.get()).getProvider();
                    } else if (((Result)contextInsensitiveResult.get()).isFinishedSuccessfully()) {
                        provider = ((Result)contextInsensitiveResult.get()).getProvider();
                        if (contextSensitivity) {
                            ReadAction.run(() -> OCDFAInspectionRunner.reportTimeOverWarning(holder, file, OCInspectionsBundle.message((String)"inspection.message.file.too.complex.to.perform.context.sensitive.data.flow.analysis", (Object[])new Object[0])));
                        }
                    } else {
                        ReadAction.run(() -> OCDFAInspectionRunner.reportTimeOverWarning(holder, file, OCInspectionsBundle.message((String)"inspection.message.file.too.complex.to.perform.data.flow.analysis", (Object[])new Object[0])));
                        // ** MonitorExit[var39_22] (shouldn't be in output)
                        return;
                    }
                    conditions.addAll(OCDFAInspectionRunner.getTuples(provider, "AlwaysTrueStatement", 1));
                    conditions.addAll(OCDFAInspectionRunner.getTuples(provider, "AlwaysFalseStatement", 1));
                    conditions.addAll(OCDFAInspectionRunner.getTuples(provider, "AlwaysTrueWhenReachedStatement", 1));
                    conditions.addAll(OCDFAInspectionRunner.getTuples(provider, "AlwaysFalseWhenReachedStatement", 1));
                    implicitReads.addAll(OCDFAInspectionRunner.getTuples(provider, "ImplicitRead", 1));
                    alwaysTrueStmts = OCDFAInspectionRunner.getTuples(provider, "AlwaysTrueStatement", 1);
                    alwaysFalseStmts = OCDFAInspectionRunner.getTuples(provider, "AlwaysFalseStatement", 1);
                    nullDereferences = OCDFAInspectionRunner.getTuples(provider, "NullDereference", 1);
                    alwaysTrueWhenReachedStmts = OCDFAInspectionRunner.getTuples(provider, "AlwaysTrueWhenReachedStatement", 1);
                    alwaysFalseWhenReachedStmts = OCDFAInspectionRunner.getTuples(provider, "AlwaysFalseWhenReachedStatement", 1);
                    loopConditionNotUpdatedStmts = OCDFAInspectionRunner.getTuples(provider, "LoopConditionNotUpdated", 2);
                    deletedPointerUsages = OCDFAInspectionRunner.getTuples(provider, "DeletedPointerUsage", 2);
                    outOfScopePointerUsages = OCDFAInspectionRunner.getTuples(provider, "OutOfScopePointerUsage", 2);
                    invalidatedPointerUsages = OCDFAInspectionRunner.getTuples(provider, "InvalidatedPointerUsage", 2);
                    escapedObjects = OCDFAInspectionRunner.getTuples(provider, "EscapedObject", 1);
                    constantParameters = OCDFAInspectionRunner.getTuples(provider, "ConstantParameter", 2);
                    constantFunctionResults = OCDFAInspectionRunner.getTuples(provider, "ConstantFunctionResult", 2);
                    arrayIndexOutOfBounds = OCDFAInspectionRunner.getTuples(provider, "ArrayIndexOutOfBounds", 2);
                    arrayIndexOutOfBounds.addAll(OCDFAInspectionRunner.getTuples(provider, "ArraySomeIndexOutOfBounds", 1));
                    unreachableStmts = OCDFAInspectionRunner.getTuples(provider, "UnreachableRange", 1);
                    unreachableFunctionCalls = OCDFAInspectionRunner.getTuples(provider, "FunctionCallsUnreachable", 1);
                    endlessLoops = OCDFAInspectionRunner.getTuples(provider, "EndlessLoop", 1);
                    infiniteRecursions = OCDFAInspectionRunner.getTuples(provider, "InfiniteRecursion", 1);
                    unusedValues = OCDFAInspectionRunner.getTuples(provider, "UnusedValue", 1);
                    unusedVariables = OCDFAInspectionRunner.getTuples(provider, "UnusedVariable", 1);
                    unreadVariables = OCDFAInspectionRunner.getTuples(provider, "VariableNotRead", 1);
                    if (ENABLE_BDD_PROFILING.booleanValue()) {
                        provider.getUIInstancesProvider().getConsoleCommandProcessor().run(8, ArrayUtil.EMPTY_STRING_ARRAY, null);
                    }
                    if (ENABLE_RELATIONS_PROFILING.booleanValue()) {
                        provider.getUIInstancesProvider().getConsoleCommandProcessor().run(9, ArrayUtil.EMPTY_STRING_ARRAY, null);
                    }
                    if (OCSourceGliderService.isCollectResultForQuickDoc()) {
                        ReadAction.run(() -> this.updateVarPointsToVal(provider, (PsiFile)file));
                    }
                }
            }
            finally {
                file.popAnnotationSession();
                OCSourceGliderService.getInstance().clearVisitorRunners();
            }
            {
                // ** MonitorExit[var39_22] (shouldn't be in output)
                ReadAction.run(() -> {
                    Set<PsiElement> parents = OCDFAInspectionRunner.getParents(OCDFAInspectionRunner.getElements(conditions, (PsiFile)file));
                    OCDFAInspectionRunner.registerWarnings(holder, alwaysTrueStmts, (PsiFile)file, parents, OCInspectionsBundle.message((String)"inspection.message.condition.always.true", (Object[])new Object[0]), OCInspections.ConstantConditionsOC.class, OCDFAInspectionRunner.getSimplifyFixes(file, true));
                    OCDFAInspectionRunner.registerWarnings(holder, alwaysFalseStmts, (PsiFile)file, parents, OCInspectionsBundle.message((String)"inspection.message.condition.always.false", (Object[])new Object[0]), OCInspections.ConstantConditionsOC.class, OCDFAInspectionRunner.getSimplifyFixes(file, false));
                    OCDFAInspectionRunner.registerWarnings(holder, alwaysTrueWhenReachedStmts, (PsiFile)file, parents, OCInspectionsBundle.message((String)"inspection.message.condition.always.true.when.reached", (Object[])new Object[0]), OCInspections.ConstantConditionsOC.class, OCDFAInspectionRunner.getSimplifyFixes(file, true));
                    OCDFAInspectionRunner.registerWarnings(holder, alwaysFalseWhenReachedStmts, (PsiFile)file, parents, OCInspectionsBundle.message((String)"inspection.message.condition.always.false.when.reached", (Object[])new Object[0]), OCInspections.ConstantConditionsOC.class, OCDFAInspectionRunner.getSimplifyFixes(file, false));
                    OCDFAInspectionRunner.registerWarnings(holder, nullDereferences, (PsiFile)file, null, OCInspectionsBundle.message((String)"inspection.message.reference.may.be.choice.null", (Object[])new Object[]{file.getKind().isObjC() ? 0 : 1}), OCInspections.NullDereference.class, OCDFAInspectionRunner.getInitializeFix());
                    OCDFAInspectionRunner.registerWarnings(holder, loopConditionNotUpdatedStmts, (PsiFile)file, (PsiElement e) -> false, OCDFAInspectionRunner.message(1, "inspection.message.not.updated.in.loop", true), OCInspections.LoopDoesntUseConditionVariableInspection.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
                    OCDFAInspectionRunner.registerWarnings(holder, deletedPointerUsages, (PsiFile)file, (PsiElement e) -> false, OCDFAInspectionRunner.message(1, "inspection.message.may.point.to.deallocated.memory", true), OCInspections.DanglingPointer.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
                    OCDFAInspectionRunner.registerWarnings(holder, outOfScopePointerUsages, (PsiFile)file, (PsiElement e) -> false, OCDFAInspectionRunner.message(1, "inspection.message.may.point.to.out.of.scope.memory", true), OCInspections.LocalValueEscapesScope.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
                    OCDFAInspectionRunner.registerWarnings(holder, invalidatedPointerUsages, (PsiFile)file, (PsiElement e) -> false, OCDFAInspectionRunner.message(1, "inspection.message.may.point.to.invalidated.memory", true), OCInspections.LocalValueEscapesScope.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
                    OCDFAInspectionRunner.registerWarnings(holder, escapedObjects, (PsiFile)file, null, OCInspectionsBundle.message((String)"inspection.message.address.local.variable.may.escape.function", (Object[])new Object[0]), OCInspections.LocalValueEscapesScope.class, null);
                    OCDFAInspectionRunner.registerWarnings(holder, constantParameters, (PsiFile)file, (PsiElement e) -> false, OCDFAInspectionRunner.constantParameterMessage(), OCInspections.ConstantParameter.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, OCDFAInspectionRunner.getConstantParameterFix());
                    OCDFAInspectionRunner.registerWarnings(holder, constantFunctionResults, (PsiFile)file, OCDFAInspectionRunner.excludeConstFunctionResult(), OCDFAInspectionRunner.constantFunctionResultMessage(), OCInspections.ConstantFunctionResult.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
                    OCDFAInspectionRunner.registerWarnings(holder, arrayIndexOutOfBounds, (PsiFile)file, (PsiElement e) -> false, OCDFAInspectionRunner.arrayIndexOutOfBoundsMessage(), OCInspections.ArrayIndexOutOfBounds.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
                    if (project.getUserData(OCFile.DFA_UNREACHABLE_CODE) != Boolean.FALSE) {
                        List unreachableRanges = ContainerUtil.filter(OCDFAInspectionRunner.getElementRanges(unreachableStmts, (PsiFile)file), this.excludeUnreachableCode());
                        OCDFAInspectionRunner.registerWarnings(holder, OCInspectionsBundle.message((String)"inspection.message.unreachable.code", (Object[])new Object[0]), OCInspections.UnreachableCode.class, unreachableRanges, ProblemHighlightType.LIKE_UNUSED_SYMBOL, null);
                        Function<Object[], String> message = OCDFAInspectionRunner.message(0, OCSymbolKind.FUNCTION_DECLARATION, "inspection.message.calls.unreachable", false, true);
                        OCDFAInspectionRunner.registerWarnings(holder, unreachableFunctionCalls, (PsiFile)file, OCDFAInspectionRunner.excludeUnreachableFunctionCalls(), message, OCInspections.UnreachableCallsOfFunction.class, ProblemHighlightType.LIKE_UNUSED_SYMBOL, null);
                    }
                    List endlessRanges = ContainerUtil.filter(OCDFAInspectionRunner.getElementRanges(endlessLoops, (PsiFile)file), this.excludeEndlessLoops());
                    OCDFAInspectionRunner.registerWarnings(holder, OCInspectionsBundle.message((String)"inspection.message.endless.loop", (Object[])new Object[0]), OCInspections.EndlessLoop.class, endlessRanges, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, OCDFAInspectionRunner.getMarkNoreturnFix());
                    OCDFAInspectionRunner.registerWarnings(holder, infiniteRecursions, (PsiFile)file, null, OCInspectionsBundle.message((String)"inspection.message.infinite.recursion", (Object[])new Object[0]), OCInspections.InfiniteRecursion.class, null);
                    if (project.getUserData(OCFile.DFA_UNUSED_CHECKS) != OCFile.UnusedChecksMode.DISABLED) {
                        Predicate<PsiElement> excludeUnused = OCDFAInspectionRunner.excludeUnusedElement(OCDFAInspectionRunner.getElements(implicitReads, (PsiFile)file));
                        OCDFAInspectionRunner.registerWarnings(holder, unusedValues, (PsiFile)file, excludeUnused, (Function<Object[], String>)((Function)e -> OCInspectionsBundle.message((String)"inspection.message.value.never.used", (Object[])new Object[0])), OCInspections.UnusedValue.class, ProblemHighlightType.LIKE_UNUSED_SYMBOL, OCDFAInspectionRunner.getRemoveValueFix());
                        OCDFAInspectionRunner.registerWarnings(holder, unusedVariables, (PsiFile)file, excludeUnused, OCDFAInspectionRunner.message(0, "inspection.message.is.never.used", false), OCDFAInspectionRunner.unusedInspectionClass(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, OCDFAInspectionRunner.getRemoveVariableFix());
                        OCDFAInspectionRunner.registerWarnings(holder, unreadVariables, (PsiFile)file, excludeUnused, OCDFAInspectionRunner.message(0, "inspection.message.only.assigned.but.never.accessed", false), OCDFAInspectionRunner.unusedInspectionClass(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, OCDFAInspectionRunner.getRemoveVariableFix());
                    }
                });
                return;
            }
        }
    }

    private void updateVarPointsToVal(ManagerInstancesProvider provider, PsiFile file) {
        OCDfaResultProvider service = (OCDfaResultProvider)ApplicationManager.getApplication().getService(OCDfaResultProvider.class);
        List<String[]> tuples = OCDFAInspectionRunner.getTuples(provider, MayPointsToAnalysisKt.getReadValue().getName(), 3);
        OCDFAValuesAggregator aggregator = new OCDFAValuesAggregator(file);
        for (String[] tuple : tuples) {
            PsiElement declaration = ClangQuickFixFactoryKt.locatePsiElement(tuple[0], file.getProject());
            PsiElement useSite = ClangQuickFixFactoryKt.locatePsiElement(tuple[1], file.getProject());
            String constant = tuple[2];
            if (declaration == null || useSite == null || constant == null) continue;
            aggregator.add(declaration, useSite, constant);
        }
        service.storeValues(aggregator.build(), file);
    }

    public static void printRelationsToLog(ManagerInstancesProvider provider) {
        OCDFAInspectionRunner.printRelations(provider, (s1, s2) -> RMLLogPanel.Companion.log(s1, s2), true);
    }

    public static void printRelations(ManagerInstancesProvider provider, BiConsumer<@NonNls String, @NonNls String> log, boolean printBddNodes) {
        RelationsRepository repository = provider.getRelationsRepository();
        for (String relationName : ContainerUtil.sorted(Arrays.asList(repository.getAvailableRelations()))) {
            StringConsole stringConsole = new StringConsole();
            RelationsConsole console = new RelationsConsole((Console)stringConsole);
            IRelation relation = repository.getRelation(relationName);
            int domainsCnt = relation.getDomainTypes().length;
            int[] permutation = new int[domainsCnt];
            for (int i = 0; i < domainsCnt; ++i) {
                permutation[i] = i;
            }
            console.print(relation, relationName, -1, permutation, provider.getSymbolTable(), printBddNodes);
            log.accept(relationName, stringConsole.getContent());
            log.accept(" (" + relation.getNumOfTuples() + " " + StringUtil.pluralize((String)"tuple") + ")\n", null);
        }
    }

    public static String getRelationsProfile(ManagerInstancesProvider provider) {
        RelationsRepository repository = provider.getRelationsRepository();
        HashMap<CallSite, Long> relationProfiles = new HashMap<CallSite, Long>();
        for (String relationName : ContainerUtil.sorted(Arrays.asList(repository.getAvailableRelations()))) {
            IRelation relation = repository.getRelation(relationName);
            String profile = relationName + " (" + relation.getNumOfBDDNodes() + " bdd " + StringUtil.pluralize((String)"node") + ", " + relation.getNumOfTuples() + " " + StringUtil.pluralize((String)"tuple") + ")\n";
            relationProfiles.put((CallSite)((Object)profile), relation.getNumOfBDDNodes());
        }
        ArrayList list = new ArrayList(relationProfiles.keySet());
        Collections.sort(list, Comparator.comparing(p -> -((Long)relationProfiles.get(p)).longValue()));
        return StringUtil.join(list, (String)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runAnalysisInParallel(PsiFile file, Map<Object, Object> options, boolean contextSensitive, OCDFAUtils.WorkingTimeMeasurer measurer, Ref<Result> result2, @NotNull List<DFATuple> input) {
        boolean legacy = false;
        OCSourceGliderService sourceGliderComponent = OCSourceGliderService.getInstance();
        ManagerInstancesProvider provider = sourceGliderComponent.getProvider(false, contextSensitive);
        DFATuplesConsumer tuplesConsumer = (signature, attributes) -> sourceGliderComponent.getVisitor(false, contextSensitive).addTuple(signature, attributes);
        sourceGliderComponent.addVisitorRunner(false, contextSensitive, (options1, threadCallback) -> new OCContextSensitiveBuilder(provider.getSymbolTable(), tuplesConsumer, contextSensitive, threadCallback).processTuples(input));
        provider.init();
        List<String> outputRelations = OCDFAInspectionRunner.getOutputRelations(provider);
        List plan = provider.getHypoteticRepository().getRelationBuildPlan(ArrayUtil.toStringArray(outputRelations), options);
        if (plan == null || plan.isEmpty()) {
            Class<Result> clazz = Result.class;
            synchronized (Result.class) {
                result2.set((Object)new Result(provider, false));
                Result.class.notifyAll();
                // ** MonitorExit[var12_12] (shouldn't be in output)
                return;
            }
        }
        ProgressIndicator indicator = OCDFAInspectionRunner.createIndicator();
        Runnable runnable = () -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            boolean success = false;
            try {
                for (Task task2 : plan) {
                    if (OCDFAInspectionRunner.runTask(file, measurer, contextSensitive, task2)) continue;
                    return;
                }
                if (contextSensitive) {
                    OCDFAInspectionRunner.printRelationsToLog(provider);
                }
                success = true;
            }
            finally {
                Class<Result> clazz = Result.class;
                synchronized (Result.class) {
                    result2.set((Object)new Result(provider, success));
                    Result.class.notifyAll();
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                }
            }
        }, indicator);
        if (contextSensitive) {
            ApplicationManager.getApplication().executeOnPooledThread(runnable);
        } else {
            runnable.run();
        }
    }

    @NotNull
    private static List<String> getOutputRelations(ManagerInstancesProvider provider) {
        return Arrays.stream(provider.getScriptManager().getAvailableScripts()).flatMap(script -> Arrays.stream(script.getOutputRelations()).map(signature -> signature.getName())).collect(Collectors.toList());
    }

    private static ProgressIndicator createIndicator() {
        ProgressIndicator mainIndicator = ProgressManager.getInstance().getProgressIndicator();
        return mainIndicator != null ? new SensitiveProgressWrapper(mainIndicator) : new ProgressIndicatorBase();
    }

    private static boolean runTask(PsiFile file, final OCDFAUtils.WorkingTimeMeasurer measurer, final boolean contextSensitive, Task task2) {
        long timeStart = System.currentTimeMillis();
        try {
            task2.run((ThreadCallback)new DummyThreadCallback(){

                public boolean checkCancelled() {
                    ProgressManager.checkCanceled();
                    if (measurer.isTimeOver()) {
                        throw new DFAException("DFA time is over" + (contextSensitive ? " (context-sensitive)" : ""));
                    }
                    if (measurer.isCanceled()) {
                        throw new DFAException("DFA is cancelled" + (contextSensitive ? " (context-sensitive)" : ""));
                    }
                    return false;
                }
            });
        }
        catch (BDDMemoryOverflowException e) {
            OCLog.LOG.warn(file.getName() + ": " + e.getMessage());
            return false;
        }
        catch (DFAException e) {
            String message = file.getName() + ": " + e.getMessage();
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() || app.isInternal()) {
                OCLog.LOG.warn(message);
            } else {
                OCLog.LOG.info(message);
            }
            return false;
        }
        long timeEnd = System.currentTimeMillis();
        ClangUtils.warnClangd((Logger)LOG, (String)("DFA task \"" + task2.getName() + "\" finished: " + file.getName() + " - " + (double)(timeEnd - timeStart) / 1000.0 + " sec"));
        return true;
    }

    private static void reportTimeOverWarning(ProblemsHolder problemsHolder, OCFile file, @InspectionMessage String message) {
        final Ref elementRef = new Ref();
        file.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)dcl.getNameIdentifier());
                }
            }

            public void visitStruct(OCStruct struct) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)struct.getNameIdentifier());
                }
            }

            public void visitFunctionDefinition(OCFunctionDefinition functionDefinition) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)functionDefinition.getNameIdentifier());
                }
            }
        });
        if (!elementRef.isNull()) {
            OCInspection.registerProblem((ProblemsHolder)problemsHolder, null, null, (boolean)problemsHolder.isOnTheFly(), (PsiElement)((PsiElement)elementRef.get()), (String)message, (String)"CIDR", (ProblemHighlightType)ProblemHighlightType.WEAK_WARNING, OCDFAInspection.class, (IntentionAction[])new IntentionAction[0]);
        }
    }

    @NotNull
    private static List<String[]> getTuples(ManagerInstancesProvider provider, String relationName, int elementsInTuple) {
        if (!provider.getRelationsRepository().containsRelation(relationName)) {
            return Collections.emptyList();
        }
        ArrayList<String[]> tuples = new ArrayList<String[]>();
        IRelation relation = provider.getRelationsRepository().getRelation(relationName);
        for (Attribute[] attributes : relation.getAttributes(provider.getSymbolTable())) {
            String[] tuple = new String[elementsInTuple];
            tuples.add(tuple);
            for (int i = 0; i < elementsInTuple; ++i) {
                tuple[i] = attributes[i].getKey();
            }
        }
        return tuples;
    }

    private static void processTuples(List<String[]> attrsList, Consumer<Object[]> consumer, PsiFile file) {
        for (String[] attributes : attrsList) {
            int prefixLen = attributes.length;
            Object[] tuple = new Object[prefixLen];
            for (int i = 0; i < prefixLen; ++i) {
                String key = attributes[i];
                if (key == null) continue;
                try {
                    tuple[i] = Integer.parseInt(key);
                    continue;
                }
                catch (NumberFormatException e2) {
                    try {
                        tuple[i] = Double.parseDouble(key);
                        continue;
                    }
                    catch (NumberFormatException e22) {
                        tuple[i] = ClangQuickFixFactoryKt.locatePsiElement(key, file.getProject());
                    }
                }
            }
            if (!ContainerUtil.and((Object[])tuple, e -> e != null)) continue;
            consumer.consume((Object)tuple);
        }
    }

    private static Set<Object> getElements(List<String[]> attrsList, PsiFile file) {
        HashSet<Object> result2 = new HashSet<Object>();
        OCDFAInspectionRunner.processTuples(attrsList, (Consumer<Object[]>)((Consumer)tuple -> result2.add(tuple[0])), file);
        return result2;
    }

    private static List<OCElementsRange> getElementRanges(List<String[]> attrsList, PsiFile file) {
        ArrayList<OCElementsRange> ranges = new ArrayList<OCElementsRange>();
        OCDFAInspectionRunner.processTuples(attrsList, (Consumer<Object[]>)((Consumer)tuple -> {
            PsiElement element = (PsiElement)tuple[0];
            OCElementsRange range = new OCElementsRange(element, element);
            range.setContainsCompositeElement(true);
            ranges.add(range.expand());
        }), file);
        return ranges;
    }

    @NotNull
    private static Set<PsiElement> getParents(Set<Object> elements) {
        HashSet<PsiElement> parents = new HashSet<PsiElement>();
        for (Object element : elements) {
            for (PsiElement parent = ((PsiElement)element).getParent(); parent != null; parent = parent.getParent()) {
                parents.add(parent);
            }
        }
        return parents;
    }

    private static void registerWarnings(ProblemsHolder problemsHolder, @NotNull List<String[]> attrs, PsiFile file, @Nullable Set<PsiElement> excludeElements, @InspectionMessage String message, Class<? extends OCInspection> inspection, @Nullable ElementFix fixes) {
        OCDFAInspectionRunner.registerWarnings(problemsHolder, attrs, file, (PsiElement element) -> excludeElements != null && excludeElements.contains(element), (Function<Object[], String>)((Function)element -> message), inspection, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
    }

    private static void registerWarnings(ProblemsHolder problemsHolder, @NotNull List<String[]> attrs, PsiFile file, Predicate<PsiElement> excludeElement, Function<Object[], @InspectionMessage String> messageFun, Class<? extends OCInspection> inspection, ProblemHighlightType highlightType, @Nullable ElementFix fixes) {
        OCDFAInspectionRunner.registerWarnings(problemsHolder, attrs, file, excludeElement, messageFun, (Function<Object[], Class<? extends OCInspection>>)((Function)element -> inspection), highlightType, fixes);
    }

    private static void registerWarnings(ProblemsHolder problemsHolder, @NotNull List<String[]> attrs, PsiFile file, Predicate<PsiElement> excludeElement, Function<Object[], @InspectionMessage String> messageFun, Function<Object[], Class<? extends OCInspection>> inspectionFun, ProblemHighlightType highlightType, @Nullable ElementFix fixes) {
        HashSet<Object[]> tuples = new HashSet<Object[]>();
        OCDFAInspectionRunner.processTuples(attrs, (Consumer<Object[]>)((Consumer)tuples::add), file);
        tuples.removeIf(tuple -> ContainerUtil.exists((Object[])tuple, el -> el instanceof PsiElement && excludeElement.test((PsiElement)el)));
        ArrayList sorted = new ArrayList(tuples);
        ContainerUtil.sort(sorted, Comparator.comparing(tuple -> {
            Object element = tuple[((Object[])tuple).length - 1];
            return element instanceof PsiElement ? (double)((PsiElement)element).getTextOffset() : Double.parseDouble(element.toString());
        }));
        for (Object[] tuple2 : sorted) {
            List<IntentionAction> fixesList;
            PsiElement element = (PsiElement)tuple2[0];
            if (element.getContainingFile() != file) continue;
            List<Object> list = fixesList = fixes != null ? fixes.getFixes(tuple2) : Collections.emptyList();
            String message = (String)messageFun.fun((Object)tuple2);
            if (message == null) continue;
            OCInspection.registerProblem((ProblemsHolder)problemsHolder, null, null, (boolean)problemsHolder.isOnTheFly(), (PsiElement)element, (String)message, (String)"CIDR", (ProblemHighlightType)highlightType, (Class)((Class)inspectionFun.fun((Object)tuple2)), (IntentionAction[])fixesList.toArray(IntentionAction.EMPTY_ARRAY));
        }
    }

    private static void registerWarnings(ProblemsHolder problemsHolder, @InspectionMessage String message, Class<? extends OCInspection> inspection, List<OCElementsRange> ranges, ProblemHighlightType highlightType, @Nullable ElementFix fixes) {
        for (OCElementsRange range : OCElementsRange.mergeRanges(ranges, (boolean)false, (inspection != OCInspections.UnreachableCode.class ? 1 : 0) != 0)) {
            PsiElement startElement = range.getFirstElement();
            PsiElement endElement = range.getLastElement();
            while (startElement instanceof OCMacroForeignLeafElement) {
                startElement = startElement.getParent();
            }
            while (endElement instanceof OCMacroForeignLeafElement) {
                endElement = endElement.getParent();
            }
            range = new OCElementsRange(startElement, endElement);
            OCElementsRange trimmedRange = range.trim(TokenSet.orSet((TokenSet[])new TokenSet[]{OCElementsRange.NON_IMPORTANT_TOKENS, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.SEMICOLON})}));
            if (trimmedRange == null || trimmedRange.isEmpty()) continue;
            OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)startElement, OCCallable.class);
            List<IntentionAction> fixesList = fixes != null ? fixes.getFixes(new Object[]{callable}) : Collections.emptyList();
            OCInspection.registerProblem((ProblemsHolder)problemsHolder, null, null, (boolean)problemsHolder.isOnTheFly(), (OCElementsRange)range, (String)message, (String)"CIDR", (ProblemHighlightType)highlightType, inspection, (IntentionAction[])fixesList.toArray(IntentionAction.EMPTY_ARRAY));
        }
    }

    private static ElementFix getSimplifyFixes(final OCFile file, final boolean constantCondition) {
        return new ElementFix(){

            public List<IntentionAction> getFixes(@NotNull Object[] tuple) {
                PsiElement element = (PsiElement)tuple[0];
                ArrayList<IntentionAction> fixes = new ArrayList<IntentionAction>();
                OCResolveContext context = OCResolveContext.forPsi((PsiElement)element);
                String constant = OCDFAUtils.getTypeConstant((OCType)OCIntType.getAppropriateBool((PsiElement)file), constantCondition ? 1 : 0, context, element.getContainingFile());
                OCExpression newElement = OCElementFactory.expressionFromText((String)constant, (PsiElement)element, (boolean)false);
                fixes.add((IntentionAction)new OCChangeElementIntentionAction(element, (PsiElement)newElement, OCInspectionsBundle.message((String)"intention.family.name.simplify.condition", (Object[])new Object[]{constant})));
                OCElement parent = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCIfStatement.class, OCLoopStatement.class, OCBinaryExpression.class, OCConditionalExpression.class});
                OCStatement simplified = null;
                if (parent instanceof OCStatement) {
                    simplified = SimplifyInspectionKt.simplifyStatementWithConstCondition(constantCondition, (OCStatement)parent);
                } else if (parent instanceof OCBinaryExpression) {
                    simplified = OCSimplifyInspectionLegacy.simplifyLogicExpression((boolean)constantCondition, (OCBinaryExpression)((OCBinaryExpression)parent), (PsiElement)element);
                }
                if (simplified != null && SimplifyInspectionKt.isSafeToSimplify((PsiElement)parent, (PsiElement)simplified)) {
                    fixes.add(SimplifyInspectionKt.getSimplifyFix((PsiElement)parent, (PsiElement)simplified));
                }
                return fixes;
            }
        };
    }

    private static ElementFix getInitializeFix() {
        return new ElementFix(){

            @Override
            public List<? extends IntentionAction> getFixes(Object[] tuple) {
                PsiElement element = (PsiElement)tuple[0];
                OCSymbol symbol = element instanceof OCReferenceElement ? ((OCReferenceElement)element).resolveToSymbol() : null;
                OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
                if (symbol != null && callable != null) {
                    OCInstruction instruction;
                    OCControlFlowGraph graph = new OCControlFlowGraph((PsiElement)callable, null);
                    OCControlFlowBuilder builder = new OCControlFlowBuilder(null, graph, null);
                    builder.processFirstCodeFragment((PsiElement)callable);
                    OCLocalDefinitionsSearcher defSearcher = new OCLocalDefinitionsSearcher(graph, symbol, element.getParent(), false, true, true);
                    defSearcher.process();
                    Collection declarators = defSearcher.getInstructionsOfKind(OCInstruction.InstructionKind.DECLARATOR);
                    if (!declarators.isEmpty() && (instruction = (OCInstruction)declarators.iterator().next()).getRValue() instanceof OCDeclarator) {
                        return Collections.singletonList(new OCAddInitializerIntentionAction((OCDeclarator)instruction.getRValue(), symbol));
                    }
                }
                return Collections.emptyList();
            }
        };
    }

    private static ElementFix getMarkNoreturnFix() {
        return new ElementFix(){

            @Override
            public List<? extends IntentionAction> getFixes(Object[] tuple) {
                OCSymbolWithQualifiedName symbol;
                PsiElement callable = (PsiElement)tuple[0];
                if (!(!(callable instanceof OCFunctionDeclaration) || (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)callable).getSymbol()) == null || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isMainFunction())) {
                    return Collections.singletonList(OCChangeGCCAttributeIntentionAction.noreturn((OCSymbol)symbol, (PsiFile)callable.getContainingFile()));
                }
                return Collections.emptyList();
            }
        };
    }

    private static ElementFix getRemoveValueFix() {
        return new ElementFix(){

            @Override
            public List<? extends IntentionAction> getFixes(Object[] tuple) {
                PsiElement element = (PsiElement)tuple[0];
                PsiElement expr = PsiTreeUtil.getParentOfType((PsiElement)element, OCExpression.class, (boolean)false);
                if (expr == null) {
                    return Collections.emptyList();
                }
                PsiElement parent = expr.getParent();
                ArrayList<Object> fixes = new ArrayList<Object>();
                IElementType type = OCElementUtil.getElementType((PsiElement)element);
                if (type == OCTokenTypes.PLUSPLUS || type == OCTokenTypes.MINUSMINUS) {
                    if (expr instanceof OCPrefixExpression) {
                        fixes.add(new OCChangeElementIntentionAction(expr, (PsiElement)((OCPrefixExpression)expr).getOperand(), OCInspectionsBundle.message((String)"intentions.remove.subj", (Object[])new Object[]{element.getText()})));
                    } else if (expr instanceof OCPostfixExpression) {
                        fixes.add(new OCChangeElementIntentionAction(expr, (PsiElement)((OCPostfixExpression)expr).getOperand(), OCInspectionsBundle.message((String)"intentions.remove.subj", (Object[])new Object[]{element.getText()})));
                    }
                    return fixes;
                }
                if (parent instanceof OCCompoundInitializer) {
                    parent = parent.getParent();
                }
                if (parent instanceof OCDeclarator) {
                    fixes.add(new OCRemoveInitializerIntentionAction((OCDeclarator)parent));
                } else {
                    fixes.add(new OCRemoveDeclarationIntentionAction("statement", parent, element.getProject()));
                    fixes.add(new OCRemoveDeclarationButInitializerIntentionAction("statement", parent, element.getProject()));
                }
                return fixes;
            }
        };
    }

    private static ElementFix getRemoveVariableFix() {
        return new ElementFix(){

            @Override
            public List<? extends IntentionAction> getFixes(Object[] tuple) {
                PsiElement element = (PsiElement)tuple[0];
                OCSymbol symbol = element.getParent() instanceof OCDeclarator ? ((OCDeclarator)element.getParent()).getSymbol() : null;
                ArrayList<Object> fixes = new ArrayList<Object>();
                PsiElement maybeSBD = OCDFAUtils.getBindingDeclaration(element);
                if (maybeSBD != null) {
                    fixes.add(new OCRemoveDeclarationIntentionAction("structured binding", maybeSBD, element.getProject()));
                    fixes.add(new OCRemoveDeclarationButInitializerIntentionAction("structured binding", maybeSBD, element.getProject()));
                    if (symbol != null) {
                        fixes.add(OCChangeGCCAttributeIntentionAction.unused((OCSymbol)symbol, (String)"structured binding", (PsiFile)element.getContainingFile()));
                    }
                } else if (symbol != null) {
                    if (!(symbol instanceof OCSymbolWithParent && ((OCSymbolWithParent)symbol).getParent() instanceof OCFunctionSymbol && ((OCFunctionSymbol)((OCSymbolWithParent)symbol).getParent()).isMainFunction())) {
                        fixes.add(new OCRemoveDeclarationIntentionAction(symbol, element.getProject()));
                        fixes.add(new OCRemoveDeclarationButInitializerIntentionAction(symbol, element.getProject()));
                    }
                    fixes.add(OCChangeGCCAttributeIntentionAction.unused((OCSymbol)symbol, (PsiFile)element.getContainingFile()));
                }
                return fixes;
            }
        };
    }

    private static ElementFix getConstantParameterFix() {
        return new ElementFix(){

            @Override
            public List<? extends IntentionAction> getFixes(Object[] tuple) {
                OCSymbol symbol;
                PsiElement element = (PsiElement)tuple[0];
                Object constant = tuple[1];
                if (!(constant instanceof Number)) {
                    return null;
                }
                PsiElement parent = element.getParent();
                OCSymbol oCSymbol = symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
                if (symbol instanceof OCDeclaratorSymbol) {
                    return Collections.singletonList(new OCInlineParameterFix((OCDeclarator)parent, (OCDeclaratorSymbol)symbol, constant.toString()));
                }
                return Collections.emptyList();
            }
        };
    }

    private static Function<Object[], String> message(int index, OCSymbolKind kind, String key, boolean subjectIsFirst, boolean showName) {
        return elements -> {
            String subject;
            PsiElement parent = ((PsiElement)elements[index]).getParent();
            OCSymbol symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            OCResolveContext context = OCResolveContext.forPsi((PsiElement)parent);
            if (symbol != null && showName) {
                subject = subjectIsFirst ? symbol.getNameWithKindUppercase((OCCompilationContext)context) : symbol.getNameWithKindLowercase((OCCompilationContext)context);
            } else {
                OCSymbolKind curKind = symbol != null ? symbol.getKind() : kind;
                subject = subjectIsFirst ? curKind.getNameUppercase() : curKind.getNameLowercase();
            }
            return OCInspectionsBundle.message((String)key, (Object[])new Object[]{subject});
        };
    }

    private static Function<Object[], String> message(int index, String key, boolean showName) {
        return OCDFAInspectionRunner.message(index, OCSymbolKind.LOCAL_VARIABLE, key, true, showName);
    }

    private static Function<Object[], String> constantParameterMessage() {
        return elements -> {
            PsiElement parent = ((PsiElement)elements[0]).getParent();
            OCSymbol symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            Object constant = elements[1];
            if (!(constant instanceof Number)) {
                return null;
            }
            OCResolveContext context = OCResolveContext.forPsi((PsiElement)parent);
            if (symbol != null) {
                constant = OCDFAUtils.getTypeConstant(symbol.getResolvedType(context), (Number)constant, context, parent.getContainingFile());
            }
            return (symbol != null ? symbol.getNameWithKindUppercase((OCCompilationContext)context) : "Parameter") + " always equals to " + constant;
        };
    }

    private static Function<Object[], String> constantFunctionResultMessage() {
        return elements -> {
            PsiElement parent = ((PsiElement)elements[0]).getParent();
            OCSymbol symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            Object constant = elements[1];
            if (!(constant instanceof Number)) {
                return null;
            }
            OCResolveContext context = OCResolveContext.forPsi((PsiElement)parent);
            if (symbol instanceof OCFunctionSymbol) {
                constant = OCDFAUtils.getTypeConstant(((OCFunctionSymbol)symbol).getType().getReturnType().resolve(context), (Number)constant, context, parent.getContainingFile());
            }
            return (symbol != null ? symbol.getNameWithKindUppercase((OCCompilationContext)context) : "Function") + " always returns " + constant;
        };
    }

    private static Function<Object[], String> arrayIndexOutOfBoundsMessage() {
        return elements -> {
            if (((Object[])elements).length == 1) {
                return "Index may be out of bounds";
            }
            Object constant = elements[1];
            if (!(constant instanceof Number)) {
                return null;
            }
            return "Index may have a value of '" + constant + "' which is out of bounds";
        };
    }

    private static Predicate<PsiElement> excludeConstFunctionResult() {
        return element -> {
            PsiElement parent = element.getParent();
            OCSymbol symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            return symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isMainFunction();
        };
    }

    private static Predicate<PsiElement> excludeUnusedElement(Set<Object> implicitReads) {
        return element -> {
            OCSymbol symbol;
            OCSymbol callableSymbol;
            PsiElement callable;
            OCDeclarator declarator;
            if (OCElementUtil.getElementType((PsiElement)element) == OCTokenTypes.COLON) {
                return true;
            }
            if (!OCInspections.UnusedValue.sharedShowUnusedInitializers && (element == (declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarator.class, (boolean)false)) || declarator != null && ContainerUtil.exists((Iterable)declarator.getInitializers(), i -> PsiTreeUtil.isAncestor((PsiElement)i, (PsiElement)element, (boolean)false)))) {
                return true;
            }
            OCParameterList parameterList = (OCParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, OCParameterList.class);
            PsiElement psiElement = callable = parameterList != null ? parameterList.getParent() : null;
            if (callable instanceof OCDeclarator) {
                callable = callable.getParent();
            }
            OCSymbol oCSymbol = callableSymbol = callable instanceof OCCallable ? ((OCCallable)callable).getSymbol() : null;
            if (callableSymbol != null) {
                if (callableSymbol.getKind() == OCSymbolKind.BLOCK || callableSymbol.getKind() == OCSymbolKind.LAMBDA) {
                    return true;
                }
                if (callableSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)callableSymbol).isWinMainFunction()) {
                    return true;
                }
            }
            if (element instanceof OCDeclarator) {
                symbol = ((OCDeclarator)element).getSymbol();
            } else if (element.getParent() instanceof OCDeclarator) {
                symbol = ((OCDeclarator)element.getParent()).getSymbol();
            } else if (element instanceof OCConstructorFieldInitializer) {
                OCReferenceElement referenceElement = ((OCConstructorFieldInitializer)element).getReferenceElement();
                symbol = referenceElement != null ? referenceElement.resolveToSymbol() : null;
            } else {
                return false;
            }
            if (symbol != null && symbol.isUnused()) {
                return true;
            }
            if (implicitReads.contains(element)) {
                return false;
            }
            if (OCDFAUtils.getBindingDeclaration(element) instanceof OCStructuredBindingDeclaration) {
                return false;
            }
            if (symbol instanceof OCDeclaratorSymbol) {
                boolean isLocalVariable = symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE;
                boolean isStructField = symbol.getKind() == OCSymbolKind.STRUCT_FIELD;
                OCResolveContext context = OCResolveContext.forPsi((PsiElement)element);
                OCType declaratorType = symbol.getType().resolve(context);
                if (declaratorType instanceof OCStructType) {
                    OCStructSymbol structSymbol = ((OCStructType)declaratorType).getSymbol();
                    return structSymbol.isUnused() || (isLocalVariable || isStructField) && !structSymbol.hasTrivialDestructor(context);
                }
                return isLocalVariable && declaratorType instanceof OCTypeParameterType;
            }
            return false;
        };
    }

    private static Predicate<PsiElement> excludeUnreachableFunctionCalls() {
        return element -> !(element.getParent().getParent() instanceof OCFunctionDefinition);
    }

    @NotNull
    private Condition<OCElementsRange> excludeUnreachableCode() {
        return r -> r.getFirstElement() != r.getLastElement() || OCElementUtil.getElementType((PsiElement)r.getFirstElement()) != OCLexerTokenTypes.COLON;
    }

    @NotNull
    private Condition<OCElementsRange> excludeEndlessLoops() {
        return r -> {
            OCLoopStatement loop = (OCLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)r.getFirstElement(), OCLoopStatement.class, (boolean)false);
            return PsiTreeUtil.findChildOfAnyType((PsiElement)loop, (Class[])new Class[]{OCCppCoawaitExpression.class, OCCoyieldStatement.class, OCCppCoreturnStatementImpl.class}) == null;
        };
    }

    private static Function<Object[], Class<? extends OCInspection>> unusedInspectionClass() {
        return elements -> {
            OCSymbol symbol;
            PsiElement parent = ((PsiElement)elements[0]).getParent();
            OCSymbol oCSymbol = symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            if (symbol != null && symbol.getKind() == OCSymbolKind.PARAMETER) {
                return OCInspections.UnusedParameter.class;
            }
            return OCInspections.UnusedLocalVariable.class;
        };
    }

    @NotNull
    private static List<DFATuple> readTuplesFromJson(String inputPath) throws IOException {
        String json = FileUtil.loadFile((File)new File(inputPath));
        JsonObject rootObject = JsonParser.parseString((String)json).getAsJsonObject();
        JsonObject params = rootObject.get("params").getAsJsonObject();
        JsonArray tuplesObj = params.get("tuples").getAsJsonArray();
        return ContainerUtil.map((Iterable)tuplesObj, element -> {
            JsonObject object = element.getAsJsonObject();
            String relation = object.get("relation").getAsString();
            List attributes = ContainerUtil.map((Iterable)object.get("attributes").getAsJsonArray(), JsonElement::getAsString);
            return new DFATuple(relation, attributes);
        });
    }

    public static String runStandalone(String inputPath, HashMap<Object, Object> options, boolean logEnabled, boolean printBddNodes, boolean relationsProfile, boolean contextSensitivity) throws IOException {
        long start = System.currentTimeMillis();
        List<DFATuple> tuples = OCDFAInspectionRunner.readTuplesFromJson(inputPath);
        DummyThreadCallback threadCallback = new DummyThreadCallback();
        ManagerInstancesProvider provider = OCSourceGliderService.createProvider((boolean)false, (boolean)logEnabled, (symbolTable, visitor, options1, threadCallback1) -> new OCContextSensitiveBuilder(symbolTable, (signature, attributes) -> visitor.addTuple(signature, attributes), contextSensitivity, threadCallback1).processTuples(tuples), new ArrayList(), options);
        List<String> outputRelations = OCDFAInspectionRunner.getOutputRelations(provider);
        List plan = provider.getHypoteticRepository().getRelationBuildPlan(ArrayUtil.toStringArray(outputRelations), options);
        provider.init();
        for (Task task2 : plan) {
            task2.run((ThreadCallback)threadCallback);
        }
        String[] bddInfo = provider.getBDDManager().getInfo();
        options.put("BDDStatistics", bddInfo);
        StringBuilder result2 = new StringBuilder();
        System.out.println("Running time: " + (System.currentTimeMillis() - start));
        if (relationsProfile) {
            System.out.println(StringUtil.join((String[])bddInfo, (String)"\n"));
            System.out.println();
            System.out.println(OCDFAInspectionRunner.getRelationsProfile(provider));
        }
        OCDFAInspectionRunner.printRelations(provider, (s1, s2) -> result2.append((String)s1).append("\n").append((String)s2).append("\n"), printBddNodes);
        return result2.toString();
    }

    public static void main(String[] args) throws IOException {
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put(ProfileManager.class, new ProfileManager());
        options.put(ProfileManager.JSON_FILE, OCDFAInspectionRunner.class.getResource("profile.json").getPath());
        options.put("STORE_TEMP_RELATIONS", Boolean.TRUE);
        options.put("GlobalMode", 1);
        String path = OCDFAInspectionRunner.class.getResource("profile-sample.txt").getPath();
        System.out.println(OCDFAInspectionRunner.runStandalone(path, options, true, true, true, true));
    }

    private static interface ElementFix {
        public List<? extends IntentionAction> getFixes(Object[] var1);
    }

    private static class Result {
        private final ManagerInstancesProvider myProvider;
        private final boolean myFinishedSuccessfully;

        Result(ManagerInstancesProvider myProvider, boolean finishedSuccessfully) {
            this.myProvider = myProvider;
            this.myFinishedSuccessfully = finishedSuccessfully;
        }

        public ManagerInstancesProvider getProvider() {
            return this.myProvider;
        }

        public boolean isFinishedSuccessfully() {
            return this.myFinishedSuccessfully;
        }
    }

    static class DomainC {
        private final Type type;
        private final PsiElement element;
        private final Number number;

        Type getType() {
            return this.type;
        }

        PsiElement getElement() {
            return this.element;
        }

        Number getNumber() {
            return this.number;
        }

        DomainC(Number x) {
            this.type = Type.NUMBER;
            this.number = x;
            this.element = null;
        }

        DomainC(PsiElement elem) {
            this.type = Type.PSI;
            this.number = null;
            this.element = elem;
        }

        static enum Type {
            NUMBER,
            PSI;

        }
    }
}

